@extends($_viewFrame)

@section('pageTitleMain'){{$record['_item']['title']}}@endsection
@section('pageKeywords'){{$record['_item']['title']}}@endsection
@section('pageDescription'){{$record['summary']}}@endsection

@section('bodyContent')

    {!! \ModStart\ModStart::css('vendor/CourseVideo/style/video.css') !!}

    <div class="ub-video-container margin-bottom">
        <div class="ub-container">
            <div class="ub-video">
                <div class="main">
                    <div class="player-box">
                        @if(!empty($record['_item']['_playUrl']))
                            @if(in_array($record['_item']['videoType'],[\Module\CourseVideo\Type\VideoItemVideoType::UPLOAD,\Module\CourseVideo\Type\VideoItemVideoType::CLOUD]))
                                {!! \ModStart\ModStart::js('asset/vendor/xgplayer.js') !!}
                                <div id="player" class="player body-scroll-lock-hide"></div>
                                <script>
                                    $(function () {
                                        new Player({
                                            id: 'player',
                                            width: '100%',
                                            height: '100%',
                                            fitVideoSize: 'fixed',
                                            videoFillMode: 'contain',
                                            url: '{{$record['_item']['_playUrl']}}',
                                            'x5-video-player-type': 'h5',
                                            playsinline: false,
                                            autoplay: true,
                                            playbackRate: [0.5, 0.75, 1, 1.5, 2],
                                            defaultPlaybackRate: 1.0
                                        });
                                    });
                                </script>
                            @elseif($record['_item']['videoType']==\Module\CourseVideo\Type\VideoItemVideoType::IFRAME)
                                <div class="player">
                                    <div class="player-iframe-mask">
                                        <iframe class="iframe" src="{{$record['_item']['videoIframeUrl']}}" frameborder="0"></iframe>
                                    </div>
                                </div>
                                @include('module::CourseVideo.View.pc.courseVideo.showItemAdaptIframe')
                            @endif
                        @else
                            <div class="player-info">
                                <div class="player-info-body">
                                    暂无播放内容
                                </div>
                            </div>
                        @endif
                    </div>
                    <div class="tool-box">
                        <a class="item ub-display-none-sm" href="javascript:;"
                           onclick="$(this).closest('.ub-video').toggleClass('full-page');"
                        >
                            <i class="iconfont icon-desktop"></i>
                            剧场模式
                        </a>
                    </div>
                </div>
                <div class="side ub-scroll-bar-mini tw-p-3">
                    <div class="margin-bottom tw-font-bold">
                        课程章节
                    </div>
                    @foreach($record['_chapters'] as $chapter)
                        <div class="tw-font-bold">
                            {{$chapter['title']}}
                        </div>
                        <div class="tw-py-2">
                            @foreach($record['_items'] as $item)
                                @if($item['chapterId']==$chapter['id'])
                                    <div class="tw-p-2">
                                        <div class="tw-float-right">
                                            {{\ModStart\Core\Util\TimeUtil::formatTimeLength($item['videoLength'])}}
                                        </div>
                                        @if($record['_member'])
                                            <a href="{{modstart_web_url('course_video/show/'.$record['id'].'/'.$item['id'])}}"
                                               class="hover:tw-text-white tw-text-gray-600 @if($item['id']===$record['_item']['id']) ub-text-white @endif">
                                                <i class="iconfont icon-play"></i>
                                                {{$item['title']}}
                                            </a>
                                        @else
                                            <a href="javascript:;" onclick="MS.dialog.tipError('请先订购此课程');"
                                               class="tw-text-gray-600">
                                                <i class="iconfont icon-play"></i>
                                                {{$item['title']}}
                                            </a>
                                        @endif
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    <div class="ub-container">
        <div class="ub-breadcrumb">
            <a href="{{modstart_web_url('course_video')}}">视频点播课</a>
            <a href="{{modstart_web_url('course_video/show/'.$record['id'])}}">{{$record['title']}}</a>
            <a class="active"
               href="{{modstart_web_url('course_video/show/'.$record['id'].'/'.$record['_item']['id'])}}">{{$record['_item']['title']}}</a>
        </div>
    </div>

    <div class="ub-container margin-bottom">
        <div class="ub-content-box">
            <h1 class="ub-text-lg margin-bottom-remove">
                {{ $record['_item']['title'] }}
            </h1>
        </div>
    </div>

    <div class="ub-container">
        <script>
            $(function () {
                var $tabs = $('.ub-nav-tab a');
                $tabs.on('click', function () {
                    var index = $tabs.index(this);
                    $tabs.removeClass('active').eq(index).addClass('active');
                    $('.pb-tab-content .content-item').addClass('tw-hidden').eq(index).removeClass('tw-hidden');
                });
            });
        </script>
        <div class="ub-nav-tab margin-top">
            <a href="javascript:;" class="active">视频介绍</a>
            <a href="javascript:;">课程介绍</a>
            <a href="javascript:;">课程附件</a>
        </div>
        <div class="pb-tab-content tw-bg-white tw-p-4">
            <div class="content-item">
                @if(empty($record['_item']['content']))
                    <div class="ub-empty">
                        <div class="icon">
                            <i class="iconfont icon-empty-box"></i>
                        </div>
                        <div class="text">
                            暂无介绍
                        </div>
                    </div>
                @else
                    <div class="ub-html lg">
                        {!! $record['_item']['content'] !!}
                    </div>
                @endif
            </div>
            <div class="content-item tw-hidden">
                <div class="ub-html lg">
                    {!! $record['content'] !!}
                </div>
            </div>
            <div class="content-item tw-hidden">
                <div>
                    @foreach($record['_files'] as $file)
                        <div class="hover:tw-bg-gray-100 tw-p-2 tw-rounded">
                            @if($record['_member'])
                                <a href="{{modstart_web_url('course_video/download_file/'.$file['id'])}}"
                                   target="_blank" class="tw-text-gray-600">
                                    <i class="iconfont icon-file"></i>
                                    {{$file['title']}}
                                </a>
                            @else
                                <a href="javascript:;" onclick="MS.dialog.tipError('请先订购此课程');"
                                   class="tw-text-gray-600">
                                    <i class="iconfont icon-file"></i>
                                    {{$file['title']}}
                                </a>
                            @endif
                        </div>
                    @endforeach
                </div>
            </div>
        </div>


    </div>

@endsection
