@extends($_viewFrame)

@section('pageTitleMain'){{$record['title']}}@endsection
@section('pageKeywords'){{$record['title']}}@endsection
@section('pageDescription'){{$record['summary']}}@endsection

@section('bodyContent')

    <div class="ub-container">

        <div class="ub-breadcrumb">
            <a href="{{modstart_web_url('course_video')}}">视频点播课</a>
            <a class="active" href="{{modstart_web_url('course_video/show/'.$record['id'])}}">{{$record['title']}}</a>
        </div>

        <div class="ub-article-a">
            <div class="row">
                <div class="col-md-4">
                    <img src="{{\ModStart\Core\Assets\AssetsUtil::fix($record['cover'])}}" class="tw-rounded-lg tw-w-full" />
                </div>
                <div class="col-md-8">
                    <div class="content">
                        <h1>{{$record['title']}}</h1>
                        <div class="tw-py-2">
                            <div class="ub-pair">
                                <div class="name tw-leading-8">价格：</div>
                                <div class="value tw-text-xl ub-text-danger">
                                    ￥{{$record['price']}}
                                </div>
                            </div>
                        </div>
                        <div class="tw-text-gray-400 tw-py-4">
                            {!! $record['summary'] !!}
                        </div>
                        <div class="tw-pt-6">
                            <div>
                                @if($record['_member'])
                                    <a class="btn btn-round btn-lg disabled" href="javascript:;">
                                        <i class="iconfont icon-cart"></i>
                                        已购买过课程
                                    </a>
                                    <a class="btn btn-round btn-lg btn-primary" href="{{modstart_web_url('course_video/learn/'.$record['id'])}}">
                                        <i class="iconfont icon-cart"></i>
                                        进入学习
                                    </a>
                                @else
                                    @if($record['price']>0)
                                        <a class="btn btn-round btn-primary btn-lg" href="{{modstart_web_url('course_video/buy/'.$record['id'])}}">
                                            <i class="iconfont icon-cart"></i>
                                            购买课程
                                        </a>
                                    @else
                                        <a class="btn btn-round btn-lg btn-primary" href="{{modstart_web_url('course_video/buy/'.$record['id'])}}">
                                            <i class="iconfont icon-cart"></i>
                                            立即订购免费课程
                                        </a>
                                    @endif
                                @endif
                            </div>
                            <div class="tw-pt-4 ub-text-muted tw-pl-4">
                                有{{$record['buyCount']}}人已订购
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <script>
            $(function(){
                var $tabs = $('.ub-nav-tab a');
                $tabs.on('click',function(){
                    var index = $tabs.index(this);
                    $tabs.removeClass('active').eq(index).addClass('active');
                    $('.pb-tab-content .content-item').addClass('tw-hidden').eq(index).removeClass('tw-hidden');
                });
            });
        </script>
        <div class="ub-nav-tab margin-top">
            <a href="javascript:;" class="active">课程章节</a>
            <a href="javascript:;">课程介绍</a>
            <a href="javascript:;">课程附件</a>
        </div>
        <div class="pb-tab-content tw-bg-white tw-p-4">
            <div class="content-item">
                <div>
                    @foreach($record['_chapters'] as $chapter)
                        <div class="tw-text-gray-800 tw-font-bold">
                            {{$chapter['title']}}
                        </div>
                        <div class="tw-py-4">
                            @foreach($record['_items'] as $item)
                                @if($item['chapterId']==$chapter['id'])
                                    <div class="hover:tw-bg-gray-100 tw-p-2 tw-rounded">
                                        <div class="tw-float-right tw-text-gray-300">
                                            {{\ModStart\Core\Util\TimeUtil::formatTimeLength($item['videoLength'])}}
                                        </div>
                                        @if($record['_member'])
                                            <a href="{{modstart_web_url('course_video/show/'.$record['id'].'/'.$item['id'])}}" class="tw-text-gray-600">
                                                <i class="iconfont icon-play"></i>
                                                {{$item['title']}}
                                            </a>
                                        @else
                                            <a href="javascript:;" onclick="MS.dialog.tipError('请先订购此课程');" class="tw-text-gray-600">
                                                <i class="iconfont icon-play"></i>
                                                {{$item['title']}}
                                            </a>
                                        @endif
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    @endforeach
                </div>
            </div>
            <div class="content-item tw-hidden">
                <div class="ub-html lg">
                    {!! $record['content'] !!}
                </div>
            </div>
            <div class="content-item tw-hidden">
                <div>
                    @foreach($record['_files'] as $file)
                        <div class="hover:tw-bg-gray-100 tw-p-2 tw-rounded">
                            @if($record['_member'])
                                <a href="{{modstart_web_url('course_video/download_file/'.$file['id'])}}" target="_blank" class="tw-text-gray-600">
                                    <i class="iconfont icon-file"></i>
                                    {{$file['title']}}
                                </a>
                            @else
                                <a href="javascript:;" onclick="MS.dialog.tipError('请先订购此课程');" class="tw-text-gray-600">
                                    <i class="iconfont icon-file"></i>
                                    {{$file['title']}}
                                </a>
                            @endif
                        </div>
                    @endforeach
                </div>
            </div>
        </div>


    </div>

@endsection
