@if(empty($records))
    <div class="ub-empty" style="padding:5rem 0;">
        <div class="icon">
            <i class="iconfont icon-empty-box"></i>
        </div>
        <div class="text">
            暂无记录
        </div>
    </div>
@else
    <div class="row ub-list-items">
        @foreach($records as $record)
            <div class="col-md-3 col-6">
                <div class="item-video-cover">
                    <a class="cover" href="{{modstart_web_url('course_video/show/'.$record['id'])}}" style="margin:-0.5rem -0.5rem 0 -0.5rem;border-radius:0.5rem 0.5rem 0 0;background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($record['cover'])}});"></a>
                    <a class="title" href="{{modstart_web_url('course_video/show/'.$record['id'])}}">
                        {{$record['title']}}
                    </a>
                    <div class="category">
                        <div class="stat">
                            <a href="{{modstart_web_url('course_video/show/'.$record['id'])}}">
                                {{ empty($record['buyCount']) ? '0' : $record['buyCount'] }}
                                人已订购
                            </a>
                        </div>
                        @if($record['price']>0)
                            <span class="ub-text-danger tw-text-lg">
                                ￥{{$record['price']}}
                            </span>
                        @else
                            <span class="ub-text-success">免费</span>
                        @endif
                    </div>
                </div>
            </div>
        @endforeach
    </div>
@endif
