// Copyright 2022 Teamgram Authors
//  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Author: teamgramio (teamgram.io@gmail.com)
//

package imaging

import (
	"image"
	"io"

	"github.com/disintegration/imaging"
)

var (
	JpegHeader = []byte{
		0xFF, 0xD8, 0xFF, 0xE0, 0x00, 0x10, 0x4A,
		0x46, 0x49, 0x46, 0x00, 0x01, 0x01, 0x00,
		0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0xFF,
		0xDB, 0x00, 0x43, 0x00, 0x28, 0x1C, 0x1E,
		0x23, 0x1E, 0x19, 0x28, 0x23, 0x21, 0x23,
		0x2D, 0x2B, 0x28, 0x30, 0x3C, 0x64, 0x41,
		0x3C, 0x37, 0x37, 0x3C, 0x7B, 0x58, 0x5D,
		0x49, 0x64, 0x91, 0x80, 0x99, 0x96, 0x8F,
		0x80, 0x8C, 0x8A, 0xA0, 0xB4, 0xE6, 0xC3,
		0xA0, 0xAA, 0xDA, 0xAD, 0x8A, 0x8C, 0xC8,
		0xFF, 0xCB, 0xDA, 0xEE, 0xF5, 0xFF, 0xFF,
		0xFF, 0x9B, 0xC1, 0xFF, 0xFF, 0xFF, 0xFA,
		0xFF, 0xE6, 0xFD, 0xFF, 0xF8, 0xFF, 0xDB,
		0x00, 0x43, 0x01, 0x2B, 0x2D, 0x2D, 0x3C,
		0x35, 0x3C, 0x76, 0x41, 0x41, 0x76, 0xF8,
		0xA5, 0x8C, 0xA5, 0xF8, 0xF8, 0xF8, 0xF8,
		0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8,
		0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8,
		0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8,
		0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8,
		0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8,
		0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8,
		0xF8, 0xF8, 0xF8, 0xF8, 0xFF, 0xC0, 0x00,
		0x11, 0x08, 0x00, 0x1E, 0x00, 0x28, 0x03,
		0x01, 0x22, 0x00, 0x02, 0x11, 0x01, 0x03,
		0x11, 0x01, 0xFF, 0xC4, 0x00, 0x1F, 0x00,
		0x00, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01,
		0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04,
		0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B,
		0xFF, 0xC4, 0x00, 0xB5, 0x10, 0x00, 0x02,
		0x01, 0x03, 0x03, 0x02, 0x04, 0x03, 0x05,
		0x05, 0x04, 0x04, 0x00, 0x00, 0x01, 0x7D,
		0x01, 0x02, 0x03, 0x00, 0x04, 0x11, 0x05,
		0x12, 0x21, 0x31, 0x41, 0x06, 0x13, 0x51,
		0x61, 0x07, 0x22, 0x71, 0x14, 0x32, 0x81,
		0x91, 0xA1, 0x08, 0x23, 0x42, 0xB1, 0xC1,
		0x15, 0x52, 0xD1, 0xF0, 0x24, 0x33, 0x62,
		0x72, 0x82, 0x09, 0x0A, 0x16, 0x17, 0x18,
		0x19, 0x1A, 0x25, 0x26, 0x27, 0x28, 0x29,
		0x2A, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
		0x3A, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
		0x49, 0x4A, 0x53, 0x54, 0x55, 0x56, 0x57,
		0x58, 0x59, 0x5A, 0x63, 0x64, 0x65, 0x66,
		0x67, 0x68, 0x69, 0x6A, 0x73, 0x74, 0x75,
		0x76, 0x77, 0x78, 0x79, 0x7A, 0x83, 0x84,
		0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x92,
		0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99,
		0x9A, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7,
		0xA8, 0xA9, 0xAA, 0xB2, 0xB3, 0xB4, 0xB5,
		0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xC2, 0xC3,
		0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA,
		0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8,
		0xD9, 0xDA, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5,
		0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xF1, 0xF2,
		0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9,
		0xFA, 0xFF, 0xC4, 0x00, 0x1F, 0x01, 0x00,
		0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
		0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05,
		0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0xFF,
		0xC4, 0x00, 0xB5, 0x11, 0x00, 0x02, 0x01,
		0x02, 0x04, 0x04, 0x03, 0x04, 0x07, 0x05,
		0x04, 0x04, 0x00, 0x01, 0x02, 0x77, 0x00,
		0x01, 0x02, 0x03, 0x11, 0x04, 0x05, 0x21,
		0x31, 0x06, 0x12, 0x41, 0x51, 0x07, 0x61,
		0x71, 0x13, 0x22, 0x32, 0x81, 0x08, 0x14,
		0x42, 0x91, 0xA1, 0xB1, 0xC1, 0x09, 0x23,
		0x33, 0x52, 0xF0, 0x15, 0x62, 0x72, 0xD1,
		0x0A, 0x16, 0x24, 0x34, 0xE1, 0x25, 0xF1,
		0x17, 0x18, 0x19, 0x1A, 0x26, 0x27, 0x28,
		0x29, 0x2A, 0x35, 0x36, 0x37, 0x38, 0x39,
		0x3A, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
		0x49, 0x4A, 0x53, 0x54, 0x55, 0x56, 0x57,
		0x58, 0x59, 0x5A, 0x63, 0x64, 0x65, 0x66,
		0x67, 0x68, 0x69, 0x6A, 0x73, 0x74, 0x75,
		0x76, 0x77, 0x78, 0x79, 0x7A, 0x82, 0x83,
		0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A,
		0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98,
		0x99, 0x9A, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6,
		0xA7, 0xA8, 0xA9, 0xAA, 0xB2, 0xB3, 0xB4,
		0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xC2,
		0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9,
		0xCA, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7,
		0xD8, 0xD9, 0xDA, 0xE2, 0xE3, 0xE4, 0xE5,
		0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xF2, 0xF3,
		0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA,
		0xFF, 0xDA, 0x00, 0x0C, 0x03, 0x01, 0x00,
		0x02, 0x11, 0x03, 0x11, 0x00, 0x3F, 0x00,
	}

	JpegFooter = []byte{
		0xFF,
		0xD9,
	}
)

func Open(filename string) (image.Image, error) {
	return imaging.Open(filename)
}

func Decode(r io.Reader, opts ...imaging.DecodeOption) (image.Image, error) {
	return imaging.Decode(r, opts...)
}

func Resize(img image.Image, width, height int) *image.NRGBA {
	return imaging.Resize(img, width, height, imaging.Lanczos)
}

func EncodeJpeg(w io.Writer, img image.Image) error {
	return imaging.Encode(w, img, imaging.JPEG)
}

func Fill(img image.Image, width, height int) *image.NRGBA {
	return imaging.Fill(img, width, height, imaging.Center, imaging.Lanczos)
}
