/*
 * Created from 'scheme.tl' by 'mtprotoc'
 *
 * Copyright (c) 2021-present,  Teamgram Studio (https://teamgram.io).
 *  All rights reserved.
 *
 * Author: teamgramio (teamgram.io@gmail.com)
 */

package core

import (
	"github.com/teamgram/proto/mtproto"
	"github.com/teamgram/teamgram-server/app/service/biz/user/user"
)

// UserChangePhone
// user.changePhone user_id:int phone:string = Bool;
func (c *UserCore) UserChangePhone(in *user.TLUserChangePhone) (*mtproto.Bool, error) {
	err := c.svcCtx.Dao.UpdatePhoneNumber(c.ctx, in.UserId, in.Phone)
	if err != nil {
		c.Logger.Errorf("user.changePhone - error: %v", err)
		return nil, err
	}

	return mtproto.BoolTrue, nil
}
