import {FC, memo} from 'react';

import Icon, {IconProps} from './Icon';

const DribbbleIcon: FC<IconProps> = memo(props => (
  <Icon {...props}>
    <path
      d="M61.1649 49.3018C54.0405 36.6965 46.4259 26.0712 44.8926 23.9633C32.6427 29.8077 23.4717 41.0853 20.5277 54.656C20.6516 54.656 20.7946 54.656 20.962 54.656C25.0594 54.656 42.0412 54.3265 61.1649 49.3018Z"
      fill="currentColor"
    />
    <path
      d="M71.7249 71.6664C47.36 80.143 38.1386 96.753 36.8667 99.2436C44.3847 105.036 53.7927 108.492 64 108.492C70.0882 108.492 75.8904 107.261 81.1806 105.04C80.4712 100.905 77.8771 87.5561 71.7753 71.65C71.7576 71.6541 71.7426 71.6609 71.7249 71.6664Z"
      fill="currentColor"
    />
    <path
      d="M93.3052 30.6819C85.474 23.8162 75.215 19.648 64 19.648C60.5494 19.648 57.1928 20.0456 53.9683 20.7946C55.7767 23.2375 63.3872 33.7512 70.3333 46.4545C85.3406 40.7762 92.066 32.3758 93.3052 30.6819Z"
      fill="currentColor"
    />
    <path
      d="M67.0448 64.2042C67.5336 64.049 68.0293 63.9006 68.5249 63.7603C67.4669 61.3842 66.3231 59.0053 65.1248 56.6591C45.3801 62.5212 26.2182 62.9801 20.702 62.9801C20.1913 62.9801 19.8019 62.976 19.5363 62.9705C19.5254 63.3368 19.5159 63.7018 19.5159 64.0681C19.5173 75.3498 23.7522 85.6565 30.7146 93.4999C32.5937 90.3966 44.8163 71.3886 67.0448 64.2042Z"
      fill="currentColor"
    />
    <path
      d="M121.191 0H6.80851C3.04885 0 0 3.04749 0 6.80851V121.191C0 124.953 3.04885 128 6.80851 128H121.191C124.953 128 128 124.953 128 121.191V6.80851C128 3.04749 124.953 0 121.191 0ZM64 116.582C34.9658 116.582 11.3484 92.9947 11.3484 64C11.3484 35.0053 34.9658 11.4192 64 11.4179C93.0315 11.4192 116.652 35.0053 116.652 64C116.652 92.9947 93.0315 116.582 64 116.582Z"
      fill="currentColor"
    />
    <path
      d="M80.6645 69.4686C86.1957 84.7265 88.5951 97.2392 89.1915 100.66C98.9304 93.9493 105.871 83.4669 107.881 71.3464C106.19 70.8303 98.9181 68.7959 89.6231 68.7986C86.7894 68.7946 83.7719 68.9866 80.6645 69.4686Z"
      fill="currentColor"
    />
    <path
      d="M74.0112 53.5653C75.008 55.616 75.9694 57.6994 76.8626 59.7991C77.1677 60.5086 77.4604 61.2167 77.7505 61.922C81.1942 61.4985 84.6284 61.3324 87.8911 61.3324C98.0058 61.3324 106.473 62.9161 108.469 63.3205C108.299 53.0832 104.645 43.6793 98.6403 36.2376C97.088 38.2516 89.5741 47.1517 74.0112 53.5653Z"
      fill="currentColor"
    />
  </Icon>
));

export default DribbbleIcon;
