# Contributing to ChatCraft.org

Thank you for considering contributing to ChatCraft.org! This document outlines the guidelines and steps to contribute to the project.

## Table of Contents

- [Contributing to ChatCraft.org](#contributing-to-chatcraftorg)
  - [Table of Contents](#table-of-contents)
  - [Getting Started](#getting-started)
  - [Development Setup](#development-setup)
  - [Running the App](#running-the-app)
  - [Running the App with Backend](#running-the-app-with-backend)
  - [Submitting Changes](#submitting-changes)
  - [Code Style](#code-style)
  - [Secrets](#secrets)
  - [Documentation](#documentation)
  - [Issue and Pull Request Guidelines](#issue-and-pull-request-guidelines)
  - [Community](#community)
  - [License](#license)

## Getting Started

To get started with contributing to ChatCraft.org, please make sure you have the following:

- [pnpm](https://pnpm.io) package manager installed globally
- [Node.js](https://nodejs.org) installed (via pnpm) on your machine

## Development Setup

1. Fork the repository on GitHub.
2. Clone your forked repository to your local machine.
3. Navigate to the project's root directory.
4. Install the project dependencies by running the following command:

```bash
pnpm install
```

## Running the App

To run the ChatCraft.org site locally, use the following command:

```bash
pnpm dev
```

This command will start the development server and open the site in your default browser. Any changes you make to the source code will automatically trigger a rebuild and refresh the browser.

## Running the App with Backend

ChatCraft uses [CloudFlare Pages Functions](https://developers.cloudflare.com/pages/platform/functions/), [R2 Buckets](https://developers.cloudflare.com/r2/), GitHub OAuth, etc. to provide various APIs.

Running a local version of these backend services is possible using the following command:

```bash
pnpm dev-functions
```

This will start the app as well as a local version of CloudFlare (via [wrangler](https://developers.cloudflare.com/workers/wrangler/)), which will proxy everything at <http://localhost:9339/>

## Submitting Changes

When you're ready to submit your changes, please follow these steps:

1. Commit your changes to your local repository.
2. Push your changes to your forked repository on GitHub.
3. Open a pull request against the main repository.

## Code Style

We follow a specific code style to maintain consistency throughout the project. Please make sure your code adheres to the following guidelines:

- Use consistent indentation (preferably 2 spaces).
- Follow the naming conventions used in the existing codebase.
- Write clear and concise comments when necessary.
- Keep lines of code within 80 characters.
- use `prettier` via VSCode or run the `prettier` script to auto-format. We also format on commit with Husky.

## Secrets

See [README.sops.md](./README.sops.md) for details regarding how we encrypt and share secrets.

## Documentation

If you make a change, please record a video or describe feature in a blog post.

## Issue and Pull Request Guidelines

When creating an issue or pull request, please provide as much detail as possible. This includes a clear description of the problem or proposed change, steps to reproduce (if applicable), and any relevant code or screenshots.

## Community

We welcome contributions from everyone in the community. If you have any questions, suggestions, or need assistance, please feel free to reach out to us on our [official Discord server](https://discord.gg/A3gmeJY9).

## License

By contributing to ChatCraft.org, you agree that your contributions will be licensed under the [MIT License](https://opensource.org/licenses/MIT).
