package jp.aonir.fuzzyxml.util;

import java.util.ArrayList;
import java.util.List;

import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;

/**
 * m[hI邽߂̃[eBeB\bh񋟂܂B
 */
public class NodeSelectUtil {
	
	/**
	 * qm[h̒tB^Ƀ}b`̂zŕԋp܂B
	 * Ώۂ͈œnvf̒̃m[ĥ݂łB
	 * 
	 * @param element Ώۂ̗vf
	 * @param filter tB^
	 * @return tB^Ƀ}b`vf̔z
	 */
	public static FuzzyXMLNode[] getChildren(FuzzyXMLElement element, NodeFilter filter){
		ArrayList result = new ArrayList();
		FuzzyXMLNode[] children = element.getChildren();
		for(int i=0;i<children.length;i++){
			if(filter.filter((FuzzyXMLNode)children[i])){
				result.add((FuzzyXMLNode)children[i]);
			}
		}
		return (FuzzyXMLNode[])result.toArray(new FuzzyXMLNode[result.size()]);
	}
	
	/**
	 * q̃m[h̒tB^Ƀ}b`̂zŕԋp܂B
	 * œnvfċAIɌs܂B
	 * 
	 * @param element Ώۂ̗vf
	 * @param filter tB^
	 * @return tB^Ƀ}b`vf̔z
	 */
	public static FuzzyXMLNode[] getNodeByFilter(FuzzyXMLElement element, NodeFilter filter){
		ArrayList result = new ArrayList();
		if(filter.filter(element)){
			result.add(element);
		}
		searchNodeByFilter(element, filter, result);
		return (FuzzyXMLElement[])result.toArray(new FuzzyXMLElement[result.size()]);
	}
	
	private static void searchNodeByFilter(FuzzyXMLElement element, NodeFilter filter,List result){
		FuzzyXMLNode[] children = element.getChildren();
		for(int i=0;i<children.length;i++){
			if(filter.filter(children[i])){
				result.add(children[i]);
			}
			if(children[i] instanceof FuzzyXMLElement){
				searchNodeByFilter((FuzzyXMLElement)children[i], filter, result);
			}
		}
	}
	
	/**
	 * œnvfċAIɌAid}b`vfԋp܂B
	 * vfȂꍇnullԋp܂B
	 * ܂Aidvf݂ꍇ͍ŏɔvfԋp܂B
	 * 
	 * @param element Ώۂ̗vf
	 * @param id id̒l
	 * @return id̒l}b`vf
	 */
	public static FuzzyXMLElement getElementById(FuzzyXMLElement element, String id){
		FuzzyXMLElement[] elements = getElementByAttribute(element, "id", id);
		if(elements.length==0){
			return null;
		} else {
			return elements[0];
		}
	}
	
	/**
	 * œnvfċAIɌA}b`vfԋp܂B
	 * 
	 * @param element Ώۂ̗vf
	 * @param name 鑮
	 * @param value 鑮l
	 * @return Ƒl}b`vf̔z
	 */
	public static FuzzyXMLElement[] getElementByAttribute(FuzzyXMLElement element, String name, String value){
		ArrayList result = new ArrayList();
		searchElementByAttribute(element, name, value, result);
		return (FuzzyXMLElement[])result.toArray(new FuzzyXMLElement[result.size()]);
	}
	
	private static void searchElementByAttribute(FuzzyXMLElement element, String name, String value, List result){
		if(value.equals(element.getAttributeValue(name))){
			result.add(element);
		}
		FuzzyXMLNode[] children = element.getChildren();
		for(int i=0;i<children.length;i++){
			if(children[i] instanceof FuzzyXMLElement){
				searchElementByAttribute(element, name, value, result);
			}
		}
	}
	
	/**
	 * œnvfċAIɌA^O}b`vfԋp܂B
	 * 
	 * @param element Ώۂ̗vf
	 * @param name ^O
	 * @return ^O}b`vf̔z
	 */
	public static FuzzyXMLElement[] getElementByTagName(FuzzyXMLElement element, String name){
		ArrayList result = new ArrayList();
		searchElementByTagName(element, name, result);
		return (FuzzyXMLElement[])result.toArray(new FuzzyXMLElement[result.size()]);
	}
	
	private static void searchElementByTagName(FuzzyXMLElement element, String name, List result){
		if(element.getName().equals(name)){
			result.add(element);
		}
		FuzzyXMLNode[] children = element.getChildren();
		for(int i=0;i<children.length;i++){
			if(children[i] instanceof FuzzyXMLElement){
				searchElementByTagName(element, name, result);
			}
		}
	}

}
