/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.webservices;

import com.egen.develop.webservices.WebServicesParameter;
import java.util.ArrayList;

public class WebServices {
    private int id;
    private String name;
    private String description;
    private ArrayList parameters = new ArrayList();

    public String toXml(int ID) {
        StringBuffer txt = new StringBuffer("");
        txt.append("<class>" + this.getClass().getName() + "</class>\n");
        txt.append("<id>" + ID + "</id>\n");
        if (this.name != null && this.name.length() > 0) {
            txt.append("<name>" + this.name + "</name>\n");
        } else {
            txt.append("<name></name>\n");
        }
        if (this.description != null && this.description.length() > 0) {
            txt.append("<description>" + this.description + "</description>\n");
        } else {
            txt.append("<description></description>\n");
        }
        if (this.parameters != null && this.parameters.size() > 0) {
            txt.append("<parameters>\n");
            for (int i = 0; i < this.parameters.size(); ++i) {
                WebServicesParameter parameter = (WebServicesParameter)this.parameters.get(i);
                txt.append("<parameters_item>\n");
                txt.append(parameter.toXml(i));
                txt.append("</parameters_item>\n");
            }
            txt.append("</parameters>\n");
        } else {
            txt.append("<parameters></parameters>\n");
        }
        return txt.toString();
    }

    public String getName() {
        return this.name;
    }

    public ArrayList getParameters() {
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                WebServicesParameter parameter = (WebServicesParameter)this.parameters.get(i);
                parameter.setParameterId(i);
            }
        }
        return this.parameters;
    }

    public void addParameter(WebServicesParameter parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(parameter);
    }

    public WebServicesParameter getParameter(String Name) {
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                WebServicesParameter parameter = (WebServicesParameter)this.parameters.get(i);
                parameter.setParameterId(i);
                if (!parameter.getName().equals(Name)) continue;
                return (WebServicesParameter)this.parameters.get(i);
            }
        }
        return null;
    }

    public WebServicesParameter getParameter(int i) {
        if (this.parameters != null && this.parameters.size() > 0) {
            return (WebServicesParameter)this.parameters.get(i);
        }
        return null;
    }

    public void setParameter(WebServicesParameter item) {
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                WebServicesParameter parameter = (WebServicesParameter)this.parameters.get(i);
                if (!parameter.getName().equals(item.getName())) continue;
                this.parameters.set(i, item);
            }
        }
    }

    public void setParameter(WebServicesParameter item, int i) {
        if (this.parameters != null && this.parameters.size() > 0) {
            this.parameters.set(i, item);
        }
    }

    public void removeParameter(WebServicesParameter item) {
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                WebServicesParameter parameter = (WebServicesParameter)this.parameters.get(i);
                if (!parameter.getName().equals(item.getName())) continue;
                this.parameters.remove(i);
            }
        }
    }

    public void removeParameter(int i) {
        if (this.parameters != null) {
            this.parameters.remove(i);
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setParameters(ArrayList list) {
        this.parameters = list;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int i) {
        this.id = i;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

