/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.webservices;

import com.egen.develop.resource.Project;
import com.egen.develop.util.IOHelper;
import com.egen.develop.webservices.WebServices;
import com.egen.util.io.FileIo;
import com.egen.util.io.Xml;
import com.egen.util.logger.Logging;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;

public class ApplicationWebServices {
    private ArrayList webservices = new ArrayList();

    public String toXml() {
        StringBuffer txt = new StringBuffer("");
        if (this.webservices != null && this.webservices.size() > 0) {
            txt.append("<webservices>\n");
            for (int i = 0; i < this.webservices.size(); ++i) {
                WebServices webservice = (WebServices)this.webservices.get(i);
                txt.append("<webservices_item>\n");
                txt.append(webservice.toXml(i));
                txt.append("</webservices_item>\n");
            }
            txt.append("</webservices>\n");
        } else {
            txt.append("<webservices></webservices>\n");
        }
        return txt.toString();
    }

    public void writeXml(String file_path) throws IOException, Exception {
        BufferedWriter buf = FileIo.getBuffer((String)file_path);
        StringBuffer xml_file = new StringBuffer("");
        xml_file.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        xml_file.append("<ApplicationWebServices>\n");
        xml_file.append(this.toXml());
        xml_file.append("</ApplicationWebServices>\n");
        buf.write(xml_file.toString());
        buf.close();
    }

    public ArrayList getWebServices() {
        if (this.webservices != null) {
            for (int i = 0; i < this.webservices.size(); ++i) {
                WebServices webs = (WebServices)this.webservices.get(i);
                webs.setId(i);
                this.webservices.set(i, webs);
            }
        }
        return this.webservices;
    }

    public void setWebservices(ArrayList list) {
        this.webservices = list;
    }

    public void addWebservices(WebServices process) {
        this.webservices.add(process);
    }

    public WebServices getWebservices(String name) {
        if (this.webservices != null) {
            for (int i = 0; i < this.webservices.size(); ++i) {
                WebServices webs = (WebServices)this.webservices.get(i);
                if (!webs.getName().equals(name)) continue;
                webs.setId(i);
                return (WebServices)this.webservices.get(i);
            }
        }
        return null;
    }

    public WebServices getWebservices(int i) {
        if (this.webservices != null && this.webservices.size() > i) {
            return (WebServices)this.webservices.get(i);
        }
        return null;
    }

    public void setWebservices(WebServices item) {
        if (this.webservices != null) {
            for (int i = 0; i < this.webservices.size(); ++i) {
                WebServices webs = (WebServices)this.webservices.get(i);
                if (!webs.getName().equals(item.getName())) continue;
                this.webservices.set(i, item);
            }
        }
    }

    public void setWebservices(int i, WebServices item) {
        if (this.webservices != null && this.webservices.size() > i) {
            this.webservices.set(i, item);
        }
    }

    public void removeWebservices(WebServices item) {
        if (this.webservices != null) {
            for (int i = 0; i < this.webservices.size(); ++i) {
                WebServices webs = (WebServices)this.webservices.get(i);
                if (!webs.getName().equals(item.getName())) continue;
                this.webservices.remove(i);
            }
        }
    }

    public void removeWebservices(int i) {
        if (this.webservices != null && this.webservices.size() > i) {
            this.webservices.remove(i);
        }
    }

    public static ApplicationWebServices getInstance(Project project) throws Exception {
        ApplicationWebServices applicationWebServices;
        block5: {
            applicationWebServices = new ApplicationWebServices();
            if (project != null) {
                String fileName = project.getEgen_source_path();
                fileName = IOHelper.correctFileSeparator(fileName);
                fileName = fileName + "application_webservices.xml";
                try {
                    File file = new File(fileName);
                    if (file.exists()) {
                        String xml = FileIo.read((String)fileName);
                        applicationWebServices = (ApplicationWebServices)Xml.readXml((Object)applicationWebServices, (String)xml);
                        break block5;
                    }
                    applicationWebServices = new ApplicationWebServices();
                    applicationWebServices.writeXml(fileName);
                }
                catch (Exception e) {
                    Logging.log((String)"com.egen.develop.generator.process", (Level)Level.INFO, (String)(ApplicationWebServices.class.getName() + ".getInstance()[171]."), (Throwable)e);
                }
            } else {
                throw new Exception("NoProjectInSession");
            }
        }
        return applicationWebServices;
    }

    public void save(ApplicationWebServices applicationProcess, Project project) throws Exception {
        if (project != null) {
            String fileName = project.getEgen_source_path();
            fileName = IOHelper.correctFileSeparator(fileName);
            fileName = fileName + "application_webservices.xml";
            applicationProcess.writeXml(fileName);
        }
    }
}

