/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.util.jstyle;

import com.egen.develop.util.jstyle.JSBeautifier;
import com.egen.develop.util.jstyle.JSLineBreaker;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Stack;

public class JSFormatter {
    private static String[] headers = new String[]{"if", "else", "for", "while", "do", "try", "catch", "finally", "synchronized", "switch", "static"};
    private static String[] parenHeaders = new String[]{"if", "for", "while", "catch", "synchronized", "switch"};
    private static String[] nonParenHeaders = new String[]{"else", "do", "try", "static", "finally"};
    private static String[] statementHeaders = new String[]{"class", "interface", "throws"};
    private static String[] longOperators = new String[]{"==", "!=", ">=", "<=", "+=", "-=", "*=", "/=", "%=", "^=", "|=", "&=", "++", "--", "&&", "||", ".*"};
    private static Hashtable closingHeaders = new Hashtable();
    public JSBeautifier beautifier = new JSBeautifier();
    private JSLineBreaker lineBreaker = new JSLineBreaker();
    private StringBuffer outBuffer;
    private String tempLine = "";
    private Stack openingStack;
    private Stack parenDepthsStack;
    private Stack bracketBlockStateStack;
    private char quoteChar;
    private int parenDepth;
    private int leadingWhiteSpaces;
    private String currentHeader;
    private boolean isInHeader;
    private boolean isSpecialChar;
    private boolean isInQuote;
    private boolean isInComment;
    private boolean isBlockNeeded;
    private boolean isSpecialBlock;
    private boolean isCloseSpecialBlock;
    private boolean isParenNeeded;
    private boolean isNewLineNeeded;
    private boolean checkBlockOpen;
    private boolean checkBlockClose;
    private boolean checkIf;
    private boolean checkClosingHeader;
    private boolean foundOrigLineBreak;
    private boolean isInQuestion;
    private boolean isSummerized;
    private boolean isInBracketOpen;
    private boolean isInBracketClose;
    private boolean isInClassStatement;
    private boolean bracketBreak = false;
    private char prevNonSpaceCh;
    private char currentNonSpaceCh;

    public JSFormatter() {
        this.init();
    }

    public void init() {
        this.beautifier.init();
        this.lineBreaker.init();
        this.outBuffer = new StringBuffer();
        this.openingStack = new Stack();
        this.parenDepthsStack = new Stack();
        this.bracketBlockStateStack = new Stack();
        this.bracketBlockStateStack.push(new Boolean(true));
        this.tempLine = "";
        this.parenDepth = 0;
        this.isSpecialChar = false;
        this.isInQuote = false;
        this.isInComment = false;
        this.isBlockNeeded = false;
        this.isParenNeeded = false;
        this.isSpecialBlock = false;
        this.isCloseSpecialBlock = false;
        this.isNewLineNeeded = false;
        this.checkIf = false;
        this.checkBlockOpen = false;
        this.checkClosingHeader = false;
        this.checkBlockClose = false;
        this.foundOrigLineBreak = false;
        this.isInQuestion = false;
        this.isSummerized = false;
        this.isInBracketOpen = false;
        this.isInBracketClose = false;
        this.leadingWhiteSpaces = 0;
        this.isInHeader = false;
        this.isInClassStatement = false;
        this.prevNonSpaceCh = (char)123;
        this.currentNonSpaceCh = (char)123;
    }

    /*
     * Unable to fully structure code
     */
    public void format(BufferedReader inReader, PrintWriter outWriter) throws IOException {
        line = null;
        this.init();
        try {
            block2: while (true) {
                if (!this.hasMoreFormattedLines()) {
                    line = inReader.readLine();
                    if (line == null) {
                        throw new NullPointerException();
                    }
                    this.formatLine(line);
                    continue;
                }
                while (true) {
                    if (this.hasMoreFormattedLines()) ** break;
                    continue block2;
                    outWriter.println(this.nextFormattedLine());
                }
                break;
            }
        }
        catch (NullPointerException e) {
            this.summerize();
            while (this.hasMoreFormattedLines()) {
                outWriter.println(this.nextFormattedLine());
            }
            return;
        }
    }

    public boolean hasMoreFormattedLines() {
        if (this.lineBreaker.hasMoreBrokenLines()) {
            return true;
        }
        while (!this.isSummerized && !this.isNewLineRequested() || this.isSummerized && this.hasMoreSummerizedLines()) {
            String formatResult = this.format(null);
            if (formatResult == null) continue;
            this.lineBreaker.breakLine(formatResult);
            return true;
        }
        return false;
    }

    public void formatLine(String line) {
        String formatResult = this.format(line);
        if (formatResult != null) {
            this.lineBreaker.breakLine(formatResult);
        }
    }

    public String nextFormattedLine() {
        return this.lineBreaker.nextBrokenLine();
    }

    public void summerize() {
        this.formatLine("");
        this.isSummerized = true;
    }

    public void setBracketBreak(boolean br) {
        this.bracketBreak = br;
    }

    public void setBracketIndent(boolean state) {
        this.beautifier.setBracketIndent(state);
    }

    public void setSwitchIndent(boolean state) {
        this.beautifier.setSwitchIndent(state);
    }

    public void setPreferredLineLength(int length) {
        this.lineBreaker.setPreferredLineLength(length);
    }

    public void setLineLengthDeviation(int dev) {
        this.lineBreaker.setLineLengthDeviation(dev);
    }

    public void setNestedConnection(boolean nest) {
        this.lineBreaker.setNestedConnection(nest);
    }

    private boolean isNewLineRequested() {
        return this.tempLine.indexOf("//") == -1 && this.tempLine.indexOf("/*") == -1 && this.tempLine.indexOf("*/") == -1;
    }

    private boolean hasMoreSummerizedLines() {
        return this.tempLine.length() != 0 && (this.tempLine.length() != 2 || this.tempLine.charAt(0) != '\r' || this.tempLine.charAt(1) != '\n');
    }

    public String format(String line) {
        int i;
        boolean isLineComment = false;
        char ch = ' ';
        char prevCh = ' ';
        String outString = null;
        boolean shouldPublish = false;
        boolean isBreakCalled = false;
        this.currentHeader = null;
        if (line == null) {
            line = "";
        } else {
            if (!this.isInComment) {
                this.leadingWhiteSpaces = 0;
                while (this.leadingWhiteSpaces < line.length() && (line.charAt(this.leadingWhiteSpaces) == ' ' || line.charAt(this.leadingWhiteSpaces) == '\t')) {
                    ++this.leadingWhiteSpaces;
                }
                line = line.trim();
            } else {
                int trimSize;
                for (trimSize = 0; trimSize < line.length() && trimSize < this.leadingWhiteSpaces && (line.charAt(trimSize) == ' ' || line.charAt(trimSize) == '\t'); ++trimSize) {
                }
                line = line.substring(trimSize);
            }
            if ("".equals(line)) {
                line = "\n";
            }
        }
        line = this.tempLine + " \r" + line;
        for (i = 0; i < line.length(); ++i) {
            prevCh = ch;
            ch = line.charAt(i);
            if (!this.isInComment && !isLineComment && ch == '\t') {
                ch = ' ';
            }
            if (ch == '\n') {
                isBreakCalled = true;
                break;
            }
            if (ch == '\r') {
                ch = ' ';
                if (isBreakCalled) break;
                if (this.checkBlockClose) {
                    this.checkBlockClose = false;
                    isBreakCalled = true;
                    break;
                }
                this.foundOrigLineBreak = true;
                continue;
            }
            if (!(ch == ' ' || ch == '\t' || this.isInComment || isLineComment || this.isInQuote || line.regionMatches(false, i, "//", 0, 2) || line.regionMatches(false, i, "/*", 0, 2))) {
                this.prevNonSpaceCh = this.currentNonSpaceCh;
                this.currentNonSpaceCh = ch;
            }
            if (!(this.isInComment || isLineComment || this.isInQuote || ch != ' ')) {
                if (this.currentNonSpaceCh == '(' || this.currentNonSpaceCh == ')' || this.currentNonSpaceCh == '[' || this.currentNonSpaceCh == ']') continue;
                this.appendSpace(this.outBuffer);
                continue;
            }
            shouldPublish = false;
            if (this.checkBlockClose) {
                this.checkBlockClose = false;
                if (ch != '}') {
                    isBreakCalled = true;
                }
            }
            if (!this.isInQuote && !this.isInComment && !isLineComment && line.regionMatches(false, i, "//", 0, 2)) {
                if (this.foundOrigLineBreak) {
                    this.foundOrigLineBreak = false;
                    if (this.checkClosingHeader) {
                        this.checkClosingHeader = false;
                        --i;
                        isBreakCalled = true;
                        break;
                    }
                }
                isLineComment = true;
                this.checkClosingHeader = false;
                this.outBuffer.append("//");
                ++i;
                continue;
            }
            if (!this.isInQuote && !this.isInComment && !isLineComment && line.regionMatches(false, i, "/*", 0, 2)) {
                if (this.foundOrigLineBreak) {
                    this.foundOrigLineBreak = false;
                    if (this.checkClosingHeader) {
                        this.checkClosingHeader = false;
                        --i;
                        isBreakCalled = true;
                        break;
                    }
                }
                this.isInComment = true;
                this.outBuffer.append("/*");
                ++i;
                continue;
            }
            if (!this.isInQuote && (this.isInComment || isLineComment) && line.regionMatches(false, i, "*/", 0, 2)) {
                this.isInComment = false;
                this.outBuffer.append("*/");
                shouldPublish = true;
                ++i;
                continue;
            }
            if (this.isInComment || isLineComment) {
                this.outBuffer.append(ch);
                continue;
            }
            if (this.isInHeader) {
                this.isInHeader = false;
                this.currentHeader = (String)this.openingStack.peek();
            } else {
                this.currentHeader = null;
            }
            this.foundOrigLineBreak = false;
            if (isBreakCalled) {
                --i;
                break;
            }
            if (this.checkClosingHeader) {
                this.checkClosingHeader = false;
                if (this.bracketBreak) {
                    if (ch != ';') {
                        --i;
                        isBreakCalled = true;
                        break;
                    }
                    --i;
                    continue;
                }
                while (!"{".equals(this.openingStack.pop())) {
                }
                if (!this.openingStack.isEmpty()) {
                    String openingHeader = (String)this.openingStack.peek();
                    String closingHeader = (String)closingHeaders.get(openingHeader);
                    if (closingHeader == null || !line.regionMatches(false, --i + 1, closingHeader, 0, closingHeader.length())) {
                        if (ch != ';') {
                            outString = this.outBuffer.toString();
                            this.outBuffer.setLength(0);
                            break;
                        }
                        ++i;
                    } else {
                        int lastBufCharPlace = this.outBuffer.length() - 1;
                        if (lastBufCharPlace >= 0 && this.outBuffer.charAt(lastBufCharPlace) != ' ') {
                            this.appendSpace(this.outBuffer);
                        }
                        ch = ' ';
                        this.openingStack.pop();
                        continue;
                    }
                }
            }
            if (this.checkIf) {
                this.checkIf = false;
                if (line.regionMatches(false, i, "if", 0, 2)) {
                    this.isNewLineNeeded = false;
                }
            }
            if (!this.isParenNeeded && this.checkBlockOpen) {
                this.checkBlockOpen = false;
                if (ch == '{' || "static".equals(this.currentHeader)) {
                    this.isNewLineNeeded = false;
                }
            }
            if (this.isNewLineNeeded && !this.isParenNeeded) {
                this.isNewLineNeeded = false;
                --i;
                isBreakCalled = true;
                continue;
            }
            if (this.isSpecialChar) {
                this.outBuffer.append(ch);
                this.isSpecialChar = false;
                continue;
            }
            if (!this.isInComment && !isLineComment && line.regionMatches(false, i, "\\\\", 0, 2)) {
                this.outBuffer.append("\\\\");
                ++i;
                continue;
            }
            if (!this.isInComment && !isLineComment && ch == '\\') {
                this.isSpecialChar = true;
                this.outBuffer.append(ch);
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                if (!this.isInQuote) {
                    this.quoteChar = ch;
                    this.isInQuote = true;
                } else if (this.quoteChar == ch) {
                    this.isInQuote = false;
                    this.outBuffer.append(ch);
                    continue;
                }
            }
            if (this.isInQuote) {
                this.outBuffer.append(ch);
                continue;
            }
            if (ch == '(' || ch == '[' || ch == ')' || ch == ']') {
                if (ch == '(' || ch == '[') {
                    ++this.parenDepth;
                } else if (ch == ')' || ch == ']') {
                    --this.parenDepth;
                }
                if (this.parenDepth == 0 && this.isParenNeeded) {
                    this.isParenNeeded = false;
                    this.checkBlockOpen = true;
                }
            }
            if (prevCh == ' ') {
                boolean foundHeader = false;
                block6: for (int h = 0; h < headers.length; ++h) {
                    if (!line.regionMatches(false, i, headers[h], 0, headers[h].length())) continue;
                    int lineLength = line.length();
                    int headerEnd = i + headers[h].length();
                    char endCh = '\u0000';
                    if (headerEnd < lineLength) {
                        endCh = line.charAt(headerEnd);
                    }
                    if (headerEnd > lineLength || endCh >= 'a' && endCh <= 'z' || endCh >= 'A' && endCh <= 'Z' || endCh >= '0' && endCh <= '9') break;
                    foundHeader = true;
                    this.outBuffer.append(headers[h]);
                    i += headers[h].length() - 1;
                    if ("else".equals(headers[h])) {
                        this.checkIf = true;
                    }
                    this.checkBlockOpen = true;
                    this.isNewLineNeeded = true;
                    this.isBlockNeeded = false;
                    this.openingStack.push(headers[h]);
                    this.appendSpace(this.outBuffer);
                    ch = ' ';
                    for (int p = 0; p < parenHeaders.length; ++p) {
                        if (!headers[h].equals(parenHeaders[p])) continue;
                        this.isParenNeeded = true;
                        break block6;
                    }
                    break;
                }
                if (foundHeader) {
                    this.isInHeader = true;
                    continue;
                }
            }
            if (ch == '?') {
                this.isInQuestion = true;
            }
            if (ch == ':') {
                if (this.isInQuestion) {
                    this.isInQuestion = false;
                } else {
                    this.outBuffer.append(ch);
                    isBreakCalled = true;
                    continue;
                }
            }
            if (ch == ';' && this.parenDepth == 0) {
                this.outBuffer.append(ch);
                isBreakCalled = true;
                continue;
            }
            if (ch == '{') {
                if (!this.bracketBreak || !this.isInBracketOpen) {
                    boolean isBlockOpener = false;
                    isBlockOpener |= this.prevNonSpaceCh == '{' && (Boolean)this.bracketBlockStateStack.peek() != false;
                    isBlockOpener |= this.prevNonSpaceCh == ')' || this.prevNonSpaceCh == ';';
                    isBlockOpener |= this.isInClassStatement;
                    boolean bl = this.prevNonSpaceCh == ':' && !this.isInQuestion;
                    this.isInClassStatement = false;
                    if (!(isBlockOpener |= bl) && this.currentHeader != null) {
                        for (int n = 0; n < nonParenHeaders.length; ++n) {
                            if (!this.currentHeader.equals(nonParenHeaders[n])) continue;
                            isBlockOpener = true;
                            break;
                        }
                    }
                    this.bracketBlockStateStack.push(new Boolean(isBlockOpener));
                    if (!isBlockOpener) {
                        this.outBuffer.append('{');
                        continue;
                    }
                }
                if (this.bracketBreak) {
                    if (this.isInBracketOpen) {
                        this.isInBracketOpen = false;
                    } else {
                        this.isInBracketOpen = true;
                        isBreakCalled = true;
                        --i;
                        break;
                    }
                }
                this.checkBlockClose = true;
                int lastBufCharPlace = this.outBuffer.length() - 1;
                if (lastBufCharPlace >= 0 && this.outBuffer.charAt(lastBufCharPlace) != ' ') {
                    this.appendSpace(this.outBuffer);
                }
                this.outBuffer.append('{');
                this.openingStack.push("{");
                this.parenDepthsStack.push(new Integer(this.parenDepth));
                this.parenDepth = 0;
                continue;
            }
            if (ch == '}') {
                if (!((Boolean)this.bracketBlockStateStack.pop()).booleanValue()) {
                    this.outBuffer.append(ch);
                    continue;
                }
                if (!this.parenDepthsStack.isEmpty()) {
                    this.parenDepth = (Integer)this.parenDepthsStack.pop();
                }
                this.outBuffer.append(ch);
                this.checkClosingHeader = true;
                continue;
            }
            if (prevCh == ' ') {
                for (int h = 0; h < statementHeaders.length; ++h) {
                    if (!line.regionMatches(false, i, statementHeaders[h], 0, statementHeaders[h].length())) continue;
                    int lineLength = line.length();
                    int headerEnd = i + statementHeaders[h].length();
                    char endCh = '\u0000';
                    if (headerEnd < lineLength) {
                        endCh = line.charAt(headerEnd);
                    }
                    if (headerEnd > lineLength || endCh >= 'a' && endCh <= 'z' || endCh >= 'A' && endCh <= 'Z' || endCh >= '0' && endCh <= '9') break;
                    this.isInClassStatement = true;
                    break;
                }
            }
            if (prevCh == ' ' && line.regionMatches(false, i, "return", 0, 6)) {
                int lineLength = line.length();
                int headerEnd = i + 6;
                char endCh = '\u0000';
                if (headerEnd < lineLength) {
                    endCh = line.charAt(headerEnd);
                }
                if (!(headerEnd > lineLength || endCh >= 'a' && endCh <= 'z' || endCh >= 'A' && endCh <= 'Z' || endCh >= '0' && endCh <= '9')) {
                    this.outBuffer.append("return");
                    i += 5;
                    this.currentNonSpaceCh = (char)45;
                    continue;
                }
            }
            if ((this.prevNonSpaceCh == ')' || this.prevNonSpaceCh == ']') && Character.isLetterOrDigit(ch) && ch != '.' && ch != '_' && ch != '$' && ch != '(' && ch != '[' && ch != ')' && ch != ']') {
                this.appendSpace(this.outBuffer);
            }
            if (!Character.isLetterOrDigit(ch) && ch != '.' && ch != '_' && ch != '$' && ch != '(' && ch != '[' && ch != ')' && ch != ']' && (Character.isLetterOrDigit(this.prevNonSpaceCh) || this.prevNonSpaceCh == '.' || this.prevNonSpaceCh == '_' || this.prevNonSpaceCh == '$' || this.prevNonSpaceCh == ')' || this.prevNonSpaceCh == ']')) {
                boolean isLongOperator = false;
                String longOperator = null;
                for (int l = 0; l < longOperators.length; ++l) {
                    if (!line.regionMatches(false, i, longOperators[l], 0, longOperators[l].length())) continue;
                    isLongOperator = true;
                    longOperator = longOperators[l];
                    break;
                }
                if (isLongOperator) {
                    if (!("--".equals(longOperator) || "++".equals(longOperator) || ".*".equals(longOperator))) {
                        this.appendSpace(this.outBuffer);
                        this.outBuffer.append(longOperator);
                        this.appendSpace(this.outBuffer);
                        ch = ' ';
                    } else {
                        this.outBuffer.append(longOperator);
                        this.currentNonSpaceCh = (char)48;
                    }
                    ++i;
                    continue;
                }
                if (ch != '*' || this.prevNonSpaceCh != '.') {
                    if (ch != ',' && ch != ';') {
                        this.appendSpace(this.outBuffer);
                    }
                    this.outBuffer.append(ch);
                    this.appendSpace(this.outBuffer);
                    ch = ' ';
                    continue;
                }
                this.outBuffer.append(ch);
                continue;
            }
            if (ch == ')' || ch == ']') {
                this.clearPaddingSpace(this.outBuffer);
            }
            this.outBuffer.append(ch);
        }
        try {
            this.tempLine = line.substring(i + (i < line.length() ? 1 : 0));
        }
        catch (Exception e) {
            this.tempLine = "";
        }
        if (isBreakCalled || this.isInComment || isLineComment || shouldPublish) {
            outString = this.outBuffer.toString();
            this.outBuffer.setLength(0);
        }
        if (outString != null && !"".equals(outString)) {
            outString = this.beautifier.beautify(outString);
        } else if (ch != '[' && ch != ']' && ch != '(' && ch != ')' && ch != '.' && ch != '_' && ch != '$') {
            this.appendSpace(this.outBuffer);
        }
        return outString;
    }

    private void appendSpace(StringBuffer buf) {
        if (buf.length() == 0 || buf.charAt(buf.length() - 1) != ' ') {
            buf.append(' ');
        }
    }

    private void clearPaddingSpace(StringBuffer buf) {
        int bufLength = buf.length();
        if (bufLength != 0 && buf.charAt(bufLength - 1) == ' ') {
            buf.setLength(bufLength - 1);
        }
    }

    static {
        closingHeaders.put("if", "else");
        closingHeaders.put("do", "while");
        closingHeaders.put("try", "catch");
        closingHeaders.put("catch", "finally");
    }
}

