/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.util.jstyle;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Stack;

public class JSBeautifier {
    private static String[] headers = new String[]{"if", "else", "for", "while", "do", "try", "catch", "finally", "synchronized", "switch", "case", "default", "static"};
    private static String[] nonParenHeaders = new String[]{"else", "do", "try", "static", "finally"};
    private static String[] preBlockStatements = new String[]{"class", "interface", "throws"};
    private static String[] assignmentOperators = new String[]{"=", "+=", "-=", "*=", "/=", "%=", "|=", "&=", "return"};
    private static String[] nonAssignmentOperators = new String[]{"==", "++", "--", "!="};
    private Stack headerStack;
    private Stack tempStacks;
    private Stack blockParenDepthStack;
    private Stack blockStatementStack;
    private Stack parenStatementStack;
    private Stack inStatementIndentStack;
    private Stack inStatementIndentStackSizeStack;
    private Stack parenIndentStack;
    private Stack bracketBlockStateStack;
    private boolean isSpecialChar;
    private boolean isInQuote;
    private boolean isInComment;
    private boolean isInCase;
    private boolean isInQuestion;
    private boolean isInStatement;
    private boolean isInClassHeader;
    private boolean isInClassHeaderTab;
    private boolean switchIndent;
    private boolean bracketIndent;
    private char quoteChar;
    private int commentIndent = 1;
    private int parenDepth;
    private String indentString;
    private int indentLength;
    private int blockTabCount;
    private int statementTabCount;
    private int leadingWhiteSpaces;
    private int maxInStatementIndent;
    private char prevNonSpaceCh;
    private char currentNonSpaceCh;
    private String currentHeader;
    private boolean isInHeader;
    private String immediatelyPreviousAssignmentOp;

    public void beautifyReader(BufferedReader inReader, PrintWriter outWriter) throws IOException {
        String line = null;
        try {
            while ((line = inReader.readLine()) != null) {
                outWriter.println(this.beautify(line));
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public JSBeautifier() {
        this.init();
        this.setSpaceIndentation(4);
        this.setMaxInStatementIndetation(40);
        this.setBracketIndent(false);
        this.setSwitchIndent(true);
    }

    public void init() {
        this.headerStack = new Stack();
        this.tempStacks = new Stack();
        this.tempStacks.push(new Stack());
        this.blockParenDepthStack = new Stack();
        this.blockStatementStack = new Stack();
        this.parenStatementStack = new Stack();
        this.bracketBlockStateStack = new Stack();
        this.bracketBlockStateStack.push(new Boolean(true));
        this.inStatementIndentStack = new Stack();
        this.inStatementIndentStackSizeStack = new Stack();
        this.inStatementIndentStackSizeStack.push(new Integer(0));
        this.parenIndentStack = new Stack();
        this.isSpecialChar = false;
        this.isInQuote = false;
        this.isInComment = false;
        this.isInStatement = false;
        this.isInCase = false;
        this.isInQuestion = false;
        this.isInClassHeader = false;
        this.isInClassHeaderTab = false;
        this.isInHeader = false;
        this.immediatelyPreviousAssignmentOp = null;
        this.parenDepth = 0;
        this.blockTabCount = 0;
        this.statementTabCount = -1;
        this.leadingWhiteSpaces = 0;
        this.prevNonSpaceCh = (char)123;
        this.currentNonSpaceCh = (char)123;
    }

    public void setTabIndentation() {
        this.indentString = "\t";
        this.indentLength = 4;
    }

    public void setSpaceIndentation(int length) {
        char[] spaces = new char[length];
        for (int i = 0; i < length; ++i) {
            spaces[i] = 32;
        }
        this.indentString = new String(spaces);
        this.indentLength = length;
    }

    public void setMaxInStatementIndetation(int max) {
        this.maxInStatementIndent = max;
    }

    public void setBracketIndent(boolean state) {
        this.bracketIndent = state;
    }

    public void setSwitchIndent(boolean state) {
        this.switchIndent = state;
    }

    public String beautify(String line) {
        int i;
        boolean isInLineComment = false;
        boolean isInSwitch = false;
        char ch = ' ';
        StringBuffer outBuffer = new StringBuffer();
        int tabCount = 0;
        String lastLineHeader = null;
        boolean closingBracketReached = false;
        int spaceTabCount = 0;
        int headerStackSize = this.headerStack.size();
        boolean isLineInStatement = this.isInStatement;
        boolean shouldIndentBrackettedLine = true;
        this.currentHeader = null;
        if (!this.isInComment) {
            this.leadingWhiteSpaces = 0;
            while (this.leadingWhiteSpaces < line.length() && (line.charAt(this.leadingWhiteSpaces) == ' ' || line.charAt(this.leadingWhiteSpaces) == '\t')) {
                ++this.leadingWhiteSpaces;
            }
            line = line.trim();
        } else {
            int trimSize;
            for (trimSize = 0; trimSize < line.length() && trimSize < this.leadingWhiteSpaces && (line.charAt(trimSize) == ' ' || line.charAt(trimSize) == '\t'); ++trimSize) {
            }
            line = line.substring(trimSize);
        }
        if (line.length() == 0) {
            return line;
        }
        if (!this.inStatementIndentStack.isEmpty()) {
            spaceTabCount = (Integer)this.inStatementIndentStack.peek();
        }
        for (i = 0; i < headerStackSize; ++i) {
            if (i <= 0 || "{".equals(this.headerStack.elementAt(i - 1)) || !"{".equals(this.headerStack.elementAt(i))) {
                ++tabCount;
            }
            if (!this.switchIndent || i <= 1 || !"switch".equals(this.headerStack.elementAt(i - 1)) || !"{".equals(this.headerStack.elementAt(i))) continue;
            ++tabCount;
            isInSwitch = true;
        }
        if (isInSwitch && this.switchIndent && headerStackSize >= 2 && "switch".equals(this.headerStack.elementAt(headerStackSize - 2)) && "{".equals(this.headerStack.elementAt(headerStackSize - 1)) && line.charAt(0) == '}') {
            --tabCount;
        }
        if (this.isInClassHeader) {
            this.isInClassHeaderTab = true;
            tabCount += 2;
        }
        for (i = 0; i < line.length(); ++i) {
            int headerNum;
            int previousIndentStackSize;
            char prevCh = ch;
            ch = line.charAt(i);
            if (ch == '\n' || ch == '\r') continue;
            outBuffer.append(ch);
            if (ch == 32 || ch == '\t') continue;
            if (this.isSpecialChar) {
                this.isSpecialChar = false;
                continue;
            }
            if (!this.isInComment && !isInLineComment && line.regionMatches(false, i, "\\\\", 0, 2)) {
                outBuffer.append('\\');
                ++i;
                continue;
            }
            if (!this.isInComment && !isInLineComment && ch == '\\') {
                this.isSpecialChar = true;
                continue;
            }
            if (!(this.isInComment || isInLineComment || ch != '\"' && ch != '\'')) {
                if (!this.isInQuote) {
                    this.quoteChar = ch;
                    this.isInQuote = true;
                } else if (this.quoteChar == ch) {
                    this.isInQuote = false;
                    this.isInStatement = true;
                    continue;
                }
            }
            if (this.isInQuote) continue;
            if (!this.isInComment && !isInLineComment && line.regionMatches(false, i, "//", 0, 2)) {
                isInLineComment = true;
                outBuffer.append("/");
                ++i;
                continue;
            }
            if (!this.isInComment && !isInLineComment && line.regionMatches(false, i, "/*", 0, 2)) {
                this.isInComment = true;
                outBuffer.append("*");
                ++i;
                continue;
            }
            if ((this.isInComment || isInLineComment) && line.regionMatches(false, i, "*/", 0, 2)) {
                this.isInComment = false;
                outBuffer.append("/");
                ++i;
                continue;
            }
            if (this.isInComment || isInLineComment) continue;
            this.prevNonSpaceCh = this.currentNonSpaceCh;
            this.currentNonSpaceCh = ch;
            if (this.isInHeader) {
                this.isInHeader = false;
                this.currentHeader = (String)this.headerStack.peek();
            } else {
                this.currentHeader = null;
            }
            if (ch == '(' || ch == '[' || ch == ')' || ch == ']') {
                if (ch == '(' || ch == '[') {
                    if (this.parenDepth == 0) {
                        this.parenStatementStack.push(new Boolean(this.isInStatement));
                        this.isInStatement = true;
                    }
                    ++this.parenDepth;
                    this.inStatementIndentStackSizeStack.push(new Integer(this.inStatementIndentStack.size()));
                    if (this.currentHeader != null) {
                        this.inStatementIndentStack.push(new Integer(this.indentLength * 2 + spaceTabCount));
                        this.parenIndentStack.push(new Integer(this.indentLength * 2 + spaceTabCount));
                        continue;
                    }
                    this.registerInStatementIndent(line, i, spaceTabCount, isLineInStatement, true);
                    continue;
                }
                if (ch != ')' && ch != ']') continue;
                --this.parenDepth;
                if (this.parenDepth == 0) {
                    this.isInStatement = (Boolean)this.parenStatementStack.pop();
                    ch = ' ';
                }
                if (this.inStatementIndentStackSizeStack.isEmpty()) continue;
                previousIndentStackSize = (Integer)this.inStatementIndentStackSizeStack.pop();
                while (previousIndentStackSize < this.inStatementIndentStack.size()) {
                    this.inStatementIndentStack.pop();
                }
                if (this.parenIndentStack.isEmpty()) continue;
                Object poppedIndent = this.parenIndentStack.pop();
                if (i != 0) continue;
                spaceTabCount = (Integer)poppedIndent;
                continue;
            }
            if (ch == '{') {
                boolean isBlockOpener = false;
                isBlockOpener |= this.prevNonSpaceCh == '{' && (Boolean)this.bracketBlockStateStack.peek() != false;
                isBlockOpener |= this.prevNonSpaceCh == ')' || this.prevNonSpaceCh == ';';
                this.isInClassHeader = false;
                if (!(isBlockOpener |= this.isInClassHeader) && this.currentHeader != null) {
                    for (int n = 0; n < nonParenHeaders.length; ++n) {
                        if (!this.currentHeader.equals(nonParenHeaders[n])) continue;
                        isBlockOpener = true;
                        break;
                    }
                }
                this.bracketBlockStateStack.push(new Boolean(isBlockOpener));
                if (!isBlockOpener) {
                    if (line.length() - i == this.getNextProgramCharDistance(line, i) && this.immediatelyPreviousAssignmentOp != null) {
                        this.inStatementIndentStack.pop();
                    }
                    this.inStatementIndentStackSizeStack.push(new Integer(this.inStatementIndentStack.size()));
                    this.registerInStatementIndent(line, i, spaceTabCount, isLineInStatement, true);
                    ++this.parenDepth;
                    if (i != 0) continue;
                    shouldIndentBrackettedLine = false;
                    continue;
                }
                if (this.isInClassHeader) {
                    this.isInClassHeader = false;
                }
                if (this.isInClassHeaderTab) {
                    this.isInClassHeaderTab = false;
                    tabCount -= 2;
                }
                this.blockParenDepthStack.push(new Integer(this.parenDepth));
                this.blockStatementStack.push(new Boolean(this.isInStatement));
                this.inStatementIndentStackSizeStack.push(new Integer(this.inStatementIndentStack.size()));
                this.blockTabCount += this.isInStatement ? 1 : 0;
                this.parenDepth = 0;
                this.isInStatement = false;
                this.tempStacks.push(new Stack());
                this.headerStack.push("{");
                lastLineHeader = "{";
                continue;
            }
            if (prevCh == ' ') {
                boolean isDoubleHeader = false;
                int h = this.findLegalHeader(line, i, headers);
                if (h > -1) {
                    int indexOfTry;
                    int r;
                    int restackSize;
                    this.isInHeader = true;
                    Stack lastTempStack = (Stack)this.tempStacks.peek();
                    if ("if".equals(headers[h]) && "else".equals(lastLineHeader)) {
                        this.headerStack.pop();
                    } else if ("else".equals(headers[h])) {
                        int indexOfIf;
                        if (lastTempStack != null && (indexOfIf = lastTempStack.indexOf("if")) != -1) {
                            restackSize = lastTempStack.size() - indexOfIf - 1;
                            for (r = 0; r < restackSize; ++r) {
                                this.headerStack.push(lastTempStack.pop());
                            }
                            if (!closingBracketReached) {
                                tabCount += restackSize;
                            }
                        }
                    } else if ("while".equals(headers[h])) {
                        int indexOfDo;
                        if (lastTempStack != null && (indexOfDo = lastTempStack.indexOf("do")) != -1) {
                            restackSize = lastTempStack.size() - indexOfDo - 1;
                            for (r = 0; r < restackSize; ++r) {
                                this.headerStack.push(lastTempStack.pop());
                            }
                            if (!closingBracketReached) {
                                tabCount += restackSize;
                            }
                        }
                    } else if ("catch".equals(headers[h])) {
                        if (lastTempStack != null) {
                            indexOfTry = lastTempStack.indexOf("try");
                            if (indexOfTry == -1) {
                                indexOfTry = lastTempStack.indexOf("catch");
                            }
                            if (indexOfTry != -1) {
                                restackSize = lastTempStack.size() - indexOfTry - 1;
                                for (r = 0; r < restackSize; ++r) {
                                    this.headerStack.push(lastTempStack.pop());
                                }
                                if (!closingBracketReached) {
                                    tabCount += restackSize;
                                }
                            }
                        }
                    } else if ("finally".equals(headers[h])) {
                        if (lastTempStack != null) {
                            indexOfTry = lastTempStack.indexOf("try");
                            if (indexOfTry == -1) {
                                indexOfTry = lastTempStack.indexOf("catch");
                            }
                            if (indexOfTry == -1) {
                                indexOfTry = lastTempStack.indexOf("finally");
                            }
                            if (indexOfTry != -1) {
                                restackSize = lastTempStack.size() - indexOfTry - 1;
                                for (r = 0; r < restackSize; ++r) {
                                    this.headerStack.push(lastTempStack.pop());
                                }
                                if (!closingBracketReached) {
                                    tabCount += restackSize;
                                }
                            }
                        }
                    } else if ("case".equals(headers[h]) || "default".equals(headers[h])) {
                        this.isInCase = true;
                        --tabCount;
                    } else if (("static".equals(headers[h]) || "synchronized".equals(headers[h])) && !this.headerStack.isEmpty() && ("static".equals(this.headerStack.lastElement()) || "synchronized".equals(this.headerStack.lastElement()))) {
                        isDoubleHeader = true;
                    }
                    if (!isDoubleHeader) {
                        spaceTabCount -= this.indentLength;
                        this.headerStack.push(headers[h]);
                    }
                    lastLineHeader = headers[h];
                    outBuffer.append(headers[h].substring(1));
                    i += headers[h].length() - 1;
                    this.isInStatement = false;
                }
            }
            if (ch == '?') {
                this.isInQuestion = true;
            }
            if (ch == ':') {
                if (this.isInQuestion) {
                    this.isInQuestion = false;
                } else {
                    this.currentNonSpaceCh = (char)59;
                    if (this.isInCase) {
                        this.isInCase = false;
                        ch = ';';
                    }
                }
            }
            if (!(ch != ';' && ch != ',' || this.inStatementIndentStackSizeStack.isEmpty())) {
                while ((Integer)this.inStatementIndentStackSizeStack.peek() + (this.parenDepth > 0 ? 1 : 0) < this.inStatementIndentStack.size()) {
                    this.inStatementIndentStack.pop();
                }
            }
            if (ch == ';' && this.parenDepth == 0 || ch == '}' || ch == ',' && this.parenDepth == 0) {
                if (ch == '}') {
                    if (!this.bracketBlockStateStack.isEmpty() && !((Boolean)this.bracketBlockStateStack.pop()).booleanValue()) {
                        if (this.inStatementIndentStackSizeStack.isEmpty()) continue;
                        previousIndentStackSize = (Integer)this.inStatementIndentStackSizeStack.pop();
                        while (previousIndentStackSize < this.inStatementIndentStack.size()) {
                            this.inStatementIndentStack.pop();
                        }
                        --this.parenDepth;
                        if (i == 0) {
                            shouldIndentBrackettedLine = false;
                        }
                        if (this.parenIndentStack.isEmpty()) continue;
                        Object poppedIndent = this.parenIndentStack.pop();
                        if (i != 0) continue;
                        spaceTabCount = (Integer)poppedIndent;
                        continue;
                    }
                    if (!this.inStatementIndentStackSizeStack.isEmpty()) {
                        this.inStatementIndentStackSizeStack.pop();
                    }
                    if (!this.blockParenDepthStack.isEmpty()) {
                        this.parenDepth = (Integer)this.blockParenDepthStack.pop();
                        this.isInStatement = (Boolean)this.blockStatementStack.pop();
                        if (this.isInStatement) {
                            --this.blockTabCount;
                        }
                    }
                    closingBracketReached = true;
                    int headerPlace = this.headerStack.search("{");
                    if (headerPlace != -1) {
                        while (!"{".equals(this.headerStack.pop())) {
                        }
                        if (!this.tempStacks.isEmpty()) {
                            this.tempStacks.pop();
                        }
                    }
                    ch = ' ';
                }
                if (!((Stack)this.tempStacks.peek()).isEmpty()) {
                    ((Stack)this.tempStacks.peek()).removeAllElements();
                }
                while (!this.headerStack.isEmpty() && !"{".equals(this.headerStack.peek())) {
                    ((Stack)this.tempStacks.peek()).push(this.headerStack.pop());
                }
                if (this.parenDepth != 0 || ch != 59) continue;
                this.isInStatement = false;
                continue;
            }
            if (prevCh == ' ' && (headerNum = this.findLegalHeader(line, i, preBlockStatements)) > -1) {
                this.isInClassHeader = true;
                outBuffer.append(preBlockStatements[headerNum].substring(1));
                i += preBlockStatements[headerNum].length() - 1;
            }
            this.immediatelyPreviousAssignmentOp = null;
            boolean isNonAssingmentOperator = false;
            for (int n = 0; n < nonAssignmentOperators.length; ++n) {
                if (!line.regionMatches(false, i, nonAssignmentOperators[n], 0, nonAssignmentOperators[n].length())) continue;
                outBuffer.append(nonAssignmentOperators[n].substring(1));
                ++i;
                isNonAssingmentOperator = true;
                break;
            }
            if (!isNonAssingmentOperator) {
                for (int a = 0; a < assignmentOperators.length; ++a) {
                    if (!line.regionMatches(false, i, assignmentOperators[a], 0, assignmentOperators[a].length())) continue;
                    if (assignmentOperators[a].length() > 1) {
                        outBuffer.append(assignmentOperators[a].substring(1));
                        i += assignmentOperators[a].length() - 1;
                    }
                    this.registerInStatementIndent(line, i, spaceTabCount, isLineInStatement, false);
                    this.immediatelyPreviousAssignmentOp = assignmentOperators[a];
                    break;
                }
            }
            if (this.parenDepth <= 0 && (this.isLegalNameChar(ch) || ch == 58)) continue;
            this.isInStatement = true;
        }
        if (outBuffer.length() > 0 && outBuffer.charAt(0) == '{' && (this.headerStack.size() <= 1 || !"{".equals(this.headerStack.elementAt(this.headerStack.size() - 2))) && shouldIndentBrackettedLine) {
            --tabCount;
        } else if (outBuffer.length() > 0 && outBuffer.charAt(0) == '}' && shouldIndentBrackettedLine) {
            --tabCount;
        }
        if (tabCount < 0) {
            tabCount = 0;
        }
        if (this.bracketIndent && outBuffer.length() > 0 && shouldIndentBrackettedLine && (outBuffer.charAt(0) == '{' || outBuffer.charAt(0) == '}')) {
            ++tabCount;
        }
        for (i = 0; i < tabCount; ++i) {
            outBuffer.insert(0, this.indentString);
        }
        while (spaceTabCount-- > 0) {
            outBuffer.insert(0, ' ');
        }
        if (!this.inStatementIndentStack.isEmpty()) {
            if (this.statementTabCount < 0) {
                this.statementTabCount = tabCount;
            }
        } else {
            this.statementTabCount = -1;
        }
        return outBuffer.toString();
    }

    private void registerInStatementIndent(String line, int i, int spaceTabCount, boolean isLineInStatement, boolean updateParenStack) {
        int remainingCharNum = line.length() - i;
        int nextNonWSChar = 1;
        nextNonWSChar = this.getNextProgramCharDistance(line, i);
        if (nextNonWSChar == remainingCharNum) {
            int previousIndent = spaceTabCount;
            if (!this.inStatementIndentStack.isEmpty()) {
                previousIndent = (Integer)this.inStatementIndentStack.peek();
            }
            this.inStatementIndentStack.push(new Integer(2 + previousIndent));
            if (updateParenStack) {
                this.parenIndentStack.push(new Integer(previousIndent));
            }
            return;
        }
        if (updateParenStack) {
            this.parenIndentStack.push(new Integer(i + spaceTabCount));
        }
        int inStatementIndent = i + nextNonWSChar + spaceTabCount;
        if (i + nextNonWSChar > this.maxInStatementIndent) {
            inStatementIndent = this.indentLength * 2 + spaceTabCount;
        }
        if (!this.inStatementIndentStack.isEmpty() && inStatementIndent < (Integer)this.inStatementIndentStack.peek()) {
            inStatementIndent = (Integer)this.inStatementIndentStack.peek();
        }
        this.inStatementIndentStack.push(new Integer(inStatementIndent));
    }

    private int getNextProgramCharDistance(String line, int i) {
        boolean inComment = false;
        int remainingCharNum = line.length() - i;
        int charDistance = 1;
        for (charDistance = 1; charDistance < remainingCharNum; ++charDistance) {
            char ch = line.charAt(i + charDistance);
            if (inComment) {
                if (!line.regionMatches(false, i + charDistance, "*/", 0, 2)) continue;
                ++charDistance;
                inComment = false;
                continue;
            }
            if (ch == ' ' || ch == '\t') continue;
            if (ch == '/') {
                if (line.regionMatches(false, i + charDistance, "//", 0, 2)) {
                    return remainingCharNum;
                }
                if (!line.regionMatches(false, i + charDistance, "/*", 0, 2)) continue;
                ++charDistance;
                inComment = true;
                continue;
            }
            return charDistance;
        }
        return charDistance;
    }

    private boolean isLegalNameChar(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '.' || ch == '_' || ch == '$';
    }

    private int findLegalHeader(String line, int i, String[] possibleHeaders) {
        int maxHeaders = possibleHeaders.length;
        for (int p = 0; p < maxHeaders; ++p) {
            if (!line.regionMatches(false, i, possibleHeaders[p], 0, possibleHeaders[p].length())) continue;
            int lineLength = line.length();
            int headerEnd = i + possibleHeaders[p].length();
            char endCh = '\u0000';
            if (headerEnd < lineLength) {
                endCh = line.charAt(headerEnd);
            }
            if (headerEnd >= lineLength || !this.isLegalNameChar(endCh)) {
                return p;
            }
            return -1;
        }
        return -1;
    }
}

