/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.util.jspFormatter;

import com.egen.develop.util.jspFormatter.IntStack;
import com.egen.develop.util.jspFormatter.Options;
import com.egen.develop.util.jspFormatter.TagStack;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.EmptyStackException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class JSPFormatter {
    public static final int TEXT_MODE = 0;
    public static final int TAG_MODE = 1;
    public static final int HTML_START_TAG_MODE = 2;
    public static final int HTML_END_TAG_MODE = 3;
    public static final int HTML_COMMENT_MODE = 4;
    public static final int JSP_COMMENT_MODE = 5;
    public static final int JAVA_MODE = 6;
    public static final int JAVA_INLINE_MODE = 7;
    public static final int JAVA_DECL_MODE = 8;
    public static final int JAVASCRIPT_MODE = 9;
    private static final String escOpAngle = "\\<";
    private static final String escSlash = "\\/";
    private static final char TAB = '\t';
    private StringBuffer writer = new StringBuffer();
    private Options opts;
    private String inFilename;
    private String outFilename;
    private String inText;
    private String outText;

    public JSPFormatter(String inFilename, String outFilename, Options opts) {
        this.inFilename = inFilename;
        this.outFilename = outFilename;
        this.opts = opts;
    }

    public JSPFormatter(String inText, int ident, int LineLength) {
        this.inText = inText;
        this.opts = new Options();
        this.opts.numSpaces = ident;
        this.opts.lineLength = LineLength;
    }

    private StringBuffer indent(int indentLevel) {
        StringBuffer retVal = new StringBuffer(0);
        if (this.opts.spaces) {
            for (int i = 0; i < this.opts.numSpaces * indentLevel; ++i) {
                retVal.append(" ");
            }
        } else {
            for (int i = 0; i < indentLevel; ++i) {
                retVal.append('\t');
            }
        }
        return retVal;
    }

    private void formatText(int indentLevel, StringBuffer text) throws IOException {
        this.formatText(indentLevel, text.toString());
    }

    private int indentLength(int indentLevel) {
        if (this.opts.spaces) {
            return indentLevel * this.opts.numSpaces;
        }
        return indentLevel * this.opts.tabSize;
    }

    private int indentLength(int indentLevel, String text) {
        return this.indentLength(indentLevel) + text.length();
    }

    private void formatText(int indentLevel, String text) throws IOException {
        if (text.trim().length() == 0) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(text, "\t \r\n", false);
        StringBuffer output = this.indent(indentLevel);
        String last = "";
        boolean firstToken = true;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!firstToken) {
                output.append(" ");
            }
            output.append(token);
            firstToken = false;
            boolean overLineLength = false;
            if (this.opts.spaces && output.length() > this.opts.lineLength) {
                overLineLength = true;
            }
            if (!this.opts.spaces && output.length() + indentLevel * (this.opts.tabSize - 1) > this.opts.lineLength) {
                overLineLength = true;
            }
            if (overLineLength) {
                this.writer.append(last);
                this.writer.append("\n");
                output = new StringBuffer(this.indent(indentLevel) + token);
            }
            last = output.toString();
        }
        if (output.length() > 0) {
            this.writer.append(output.toString());
            this.writer.append("\n");
        }
    }

    private void formatHTMLComment(int indentLevel, String comment) throws IOException {
        this.formatLine(indentLevel, "<!--");
        this.formatText(indentLevel + 1, comment.substring(4, comment.length() - 3));
        this.formatLine(indentLevel, "-->");
    }

    private void formatTag(int indentLevel, String tag) throws IOException {
        if (this.indentLength(indentLevel, tag) <= this.opts.lineLength) {
            this.formatLine(indentLevel, tag);
        } else {
            int currCharNum;
            for (currCharNum = 0; currCharNum < tag.length() && !Character.isWhitespace(tag.charAt(currCharNum)); ++currCharNum) {
            }
            if (++currCharNum >= tag.length()) {
                return;
            }
            this.formatLine(indentLevel, tag.substring(0, currCharNum));
            StringBuffer attributeAndValue = new StringBuffer();
            char insideQuote = '\u0000';
            while (currCharNum < tag.length()) {
                char currChar = tag.charAt(currCharNum);
                if (Character.isWhitespace(currChar) && insideQuote == '\u0000' && attributeAndValue.length() != 0) {
                    this.formatLine(indentLevel + 2, attributeAndValue.toString());
                    attributeAndValue = new StringBuffer();
                } else if ((currChar == '\'' || currChar == '\"') && insideQuote == '\u0000') {
                    insideQuote = currChar;
                    attributeAndValue.append(currChar);
                } else if (currChar == insideQuote) {
                    attributeAndValue.append(currChar);
                    insideQuote = '\u0000';
                } else {
                    attributeAndValue.append(currChar);
                }
                ++currCharNum;
            }
            String lastAttribute = attributeAndValue.toString();
            if (lastAttribute.length() > 0) {
                if (lastAttribute.equals(">") || lastAttribute.equals("/>")) {
                    this.formatLine(indentLevel, lastAttribute);
                } else {
                    this.formatLine(indentLevel + 2, lastAttribute);
                }
            }
            if (!lastAttribute.endsWith("/>")) {
                this.writer.append("\n");
            }
        }
    }

    private void formatLine(int indentLevel, String line) throws IOException {
        if (line.trim().length() != 0) {
            StringBuffer output = this.indent(indentLevel);
            output.append(line);
            this.writer.append(output.toString());
        }
        this.writer.append("\n");
    }

    private int formatCode(int mode, int inIndentLevel, String inJavaCode) throws IOException {
        String javaCode;
        int indentLevel = inIndentLevel;
        if (mode == 8) {
            this.formatText(inIndentLevel, "<%!");
            javaCode = inJavaCode.substring(3, inJavaCode.length() - 2).trim();
        } else if (mode == 6) {
            this.formatText(inIndentLevel, "<%");
            javaCode = inJavaCode.substring(2, inJavaCode.length() - 2).trim();
        } else {
            javaCode = inJavaCode.trim();
        }
        while (javaCode.length() > 0) {
            int index = javaCode.indexOf(10);
            String line = index == -1 ? javaCode.trim() : javaCode.substring(0, index).trim();
            if (line.equals("// -->")) {
                this.formatLine(indentLevel - 1, line);
            } else {
                if (line.endsWith("}")) {
                    --indentLevel;
                }
                if (line.startsWith("}") && line.endsWith("{")) {
                    this.formatLine(indentLevel - 1, line);
                    --indentLevel;
                } else {
                    this.formatLine(indentLevel, line);
                }
                if (line.endsWith("{")) {
                    ++indentLevel;
                }
            }
            if (index == -1) break;
            javaCode = javaCode.substring(index + 1);
        }
        if (mode == 8 || mode == 6) {
            this.formatText(indentLevel, "%>");
        }
        return indentLevel;
    }

    public int findClosingAngle(String line) {
        int balance = 1;
        if (line.startsWith("<")) {
            for (int i = 1; i < line.length(); ++i) {
                char c = line.charAt(i);
                if (c == '<') {
                    ++balance;
                } else if (c == '>') {
                    --balance;
                }
                if (balance != 0) continue;
                return i;
            }
        } else {
            throw new IllegalArgumentException(line);
        }
        return -1;
    }

    public int findClosingHTMLComment(String line) {
        if (line.startsWith("<!--")) {
            return line.indexOf("-->");
        }
        throw new IllegalArgumentException(line);
    }

    public int findClosingJSPComment(String line) {
        return line.indexOf("--%>");
    }

    public int findClosingJavaAngle(String line) {
        if (line.equals("<%")) {
            line = "<% ";
        }
        if (line.startsWith("<%")) {
            char insideQuote = '\u0000';
            for (int i = 0; i < line.length(); ++i) {
                char currChar = line.charAt(i);
                if (currChar == '%' && insideQuote == '\u0000') {
                    if (line.charAt(i + 1) != '>') continue;
                    return i;
                }
                if ((currChar == '\'' || currChar == '\"') && insideQuote == '\u0000') {
                    insideQuote = currChar;
                    continue;
                }
                if (currChar == '\\') {
                    i += 2;
                    continue;
                }
                if (currChar != insideQuote) continue;
                insideQuote = '\u0000';
            }
            return -1;
        }
        throw new IllegalArgumentException(line);
    }

    private int safePop(IntStack modeStack) {
        try {
            return modeStack.pop();
        }
        catch (EmptyStackException ese) {
            return 0;
        }
    }

    private String safePop(TagStack tagStack) {
        try {
            return tagStack.pop();
        }
        catch (EmptyStackException ese) {
            return "";
        }
    }

    public String format() throws FileNotFoundException, IOException {
        Pattern scriptPattern = Pattern.compile("^\\<SCRIPT.*", 2);
        Pattern endScriptPattern = Pattern.compile(".*\\<\\/SCRIPT>.*", 2);
        BufferedReader reader = null;
        reader = new BufferedReader(new StringReader(this.inText));
        String startTag = "";
        String endTag = "";
        String line = "";
        String javaCode = "";
        String htmlComment = "";
        String tagName = "";
        int lines = 0;
        int mode = 0;
        int indentLevel = 0;
        IntStack modeStack = new IntStack();
        TagStack tagStack = new TagStack();
        String lineSep = System.getProperty("line.separator");
        StringBuffer text = new StringBuffer(0);
        while (true) {
            if (line.length() == 0) {
                String newLine = reader.readLine();
                ++lines;
                if (newLine == null) break;
                if (newLine.trim().length() == 0 && mode == 0) {
                    this.writer.append("\n");
                    continue;
                }
                line = newLine;
            }
            switch (mode) {
                case 0: {
                    int index = line.indexOf("<");
                    if (index > -1) {
                        modeStack.push(mode);
                        mode = 1;
                        text.append(line.substring(0, index));
                        this.formatText(indentLevel, text);
                        text = new StringBuffer(0);
                        line = line.substring(index);
                        break;
                    }
                    text.append(line + " ");
                    line = "";
                    break;
                }
                case 1: {
                    if (line.startsWith("<% ") || line.startsWith("<%\t") || line.trim().equals("<%")) {
                        mode = 6;
                        break;
                    }
                    if (line.startsWith("<!--")) {
                        if (modeStack.peek() != 9) {
                            mode = 4;
                            break;
                        }
                        this.formatLine(indentLevel - 1, line);
                        line = "";
                        mode = modeStack.pop();
                        break;
                    }
                    if (line.startsWith("<%--")) {
                        mode = 5;
                        break;
                    }
                    if (line.startsWith("<%! ") || line.endsWith("<%!")) {
                        mode = 8;
                        break;
                    }
                    if (line.startsWith("<%=") || line.startsWith("<%@")) {
                        mode = 7;
                        break;
                    }
                    if (line.startsWith("</")) {
                        mode = 3;
                        break;
                    }
                    mode = 2;
                }
                case 2: {
                    int index;
                    if (startTag.length() == 0) {
                        startTag = line.trim();
                        index = this.findClosingAngle(startTag);
                        int index2 = startTag.indexOf(" ");
                        tagName = index > -1 && index2 > -1 ? (index < index2 ? startTag.substring(1, index).toLowerCase() : startTag.substring(1, index2).toLowerCase()) : (index > -1 ? startTag.substring(1, index).toLowerCase() : (index2 > -1 ? startTag.substring(1, index2).toLowerCase() : startTag.substring(1).toLowerCase()));
                    } else {
                        startTag = startTag + " " + line.trim();
                    }
                    index = this.findClosingAngle(startTag);
                    if (index > -1) {
                        this.formatTag(indentLevel, startTag.substring(0, index + 1));
                        if (!startTag.startsWith("<?") && !startTag.substring(0, index + 1).endsWith("/>") && this.opts.hasEndTag(tagName)) {
                            tagStack.push(tagName);
                            ++indentLevel;
                        }
                        mode = scriptPattern.matcher(startTag).matches() ? 9 : this.safePop(modeStack);
                        line = startTag.substring(index + 1);
                        startTag = "";
                        tagName = "";
                        break;
                    }
                    line = "";
                    break;
                }
                case 3: {
                    endTag = endTag + line + " ";
                    int index = this.findClosingAngle(endTag);
                    if (index > -1) {
                        if (--indentLevel < 0) {
                            indentLevel = 0;
                        }
                        endTag = endTag.substring(0, index + 1);
                        this.formatTag(indentLevel, endTag);
                        endTag = endTag.substring(2, endTag.length() - 1);
                        startTag = "";
                        while (!(startTag = this.safePop(tagStack)).equals("") && !startTag.equalsIgnoreCase(endTag)) {
                        }
                        startTag = "";
                        endTag = "";
                        mode = this.safePop(modeStack);
                        if (mode == 9 && endScriptPattern.matcher(line.substring(0, index + 1)).matches()) {
                            mode = this.safePop(modeStack);
                        }
                        line = line.substring(index + 1);
                        break;
                    }
                    line = "";
                    break;
                }
                case 4: {
                    int index;
                    if (htmlComment.length() == 0) {
                        index = this.findClosingHTMLComment(line);
                        if (index > -1) {
                            htmlComment = line.substring(0, index + 3);
                            if (this.indentLength(indentLevel, htmlComment) <= this.opts.lineLength) {
                                this.formatLine(indentLevel, htmlComment);
                            } else {
                                this.formatHTMLComment(indentLevel, htmlComment);
                            }
                            htmlComment = "";
                            line = line.substring(index + 3);
                            mode = this.safePop(modeStack);
                            break;
                        }
                        htmlComment = line;
                        line = "";
                        break;
                    }
                    index = this.findClosingHTMLComment(htmlComment = htmlComment + line + lineSep);
                    if (index > -1) {
                        htmlComment = htmlComment.substring(0, htmlComment.length() - lineSep.length());
                        this.formatHTMLComment(indentLevel, htmlComment);
                        line = htmlComment.substring(index + 3);
                        htmlComment = "";
                        mode = this.safePop(modeStack);
                        break;
                    }
                    line = "";
                    break;
                }
                case 5: {
                    int index = this.findClosingJSPComment(line);
                    if (index > -1) {
                        this.formatLine(indentLevel, line.substring(0, index + 4));
                        mode = this.safePop(modeStack);
                        line = line.substring(index + 4);
                        break;
                    }
                    this.writer.append(line);
                    this.writer.append("\n");
                    line = "";
                    break;
                }
                case 6: 
                case 8: {
                    javaCode = javaCode.length() == 0 ? line : javaCode + lineSep + line;
                    int index = this.findClosingJavaAngle(javaCode);
                    if (index > -1) {
                        indentLevel = this.formatCode(mode, indentLevel, javaCode.substring(0, index + 2));
                        line = line.substring(line.length() - (javaCode.length() - index) + 2);
                        mode = this.safePop(modeStack);
                        javaCode = "";
                        break;
                    }
                    line = "";
                    break;
                }
                case 9: {
                    int index;
                    javaCode = javaCode.length() == 0 ? line : javaCode + lineSep + line;
                    if (line.equalsIgnoreCase("</script>")) {
                        line = "</script>";
                    }
                    if ((index = line.indexOf("</script>")) > -1) {
                        int javaCodeIndex = javaCode.length() - (line.length() - index);
                        int indexSpace = javaCode.indexOf(" ", javaCodeIndex + 1);
                        int indexColon = javaCode.indexOf(":", javaCodeIndex + 1);
                        if (line.indexOf("alert") == -1 && indexColon > -1 && indexSpace > -1 && indexColon < indexSpace || javaCode.substring(javaCodeIndex).toLowerCase().startsWith("</") || javaCode.substring(javaCodeIndex).startsWith("<!--") || javaCode.substring(javaCodeIndex).startsWith("<%")) {
                            indentLevel = this.formatCode(mode, indentLevel, javaCode.substring(0, javaCodeIndex));
                            line = javaCode.substring(javaCodeIndex);
                            modeStack.push(mode);
                            mode = 1;
                            javaCode = "";
                            break;
                        }
                        int index3 = line.indexOf("<", index + 1);
                        if (index3 > -1) {
                            int javaCodeIndex2 = javaCode.length() - (line.length() - index3);
                            javaCode = javaCode.substring(0, javaCodeIndex2);
                            line = line.substring(index3);
                            break;
                        }
                        line = "";
                        break;
                    }
                    line = "";
                    break;
                }
                case 7: {
                    javaCode = javaCode.length() == 0 ? line.trim() : javaCode + " " + line.trim();
                    int index = this.findClosingJavaAngle(javaCode);
                    if (index > -1) {
                        this.formatLine(indentLevel, javaCode.substring(0, index + 2));
                        line = line.substring(line.length() - (javaCode.length() - index) + 2);
                        mode = this.safePop(modeStack);
                        javaCode = "";
                        break;
                    }
                    line = "";
                }
            }
        }
        switch (mode) {
            case 0: {
                if (text.toString().trim().length() == 0) break;
                this.formatText(indentLevel, text);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.writer.append(startTag);
                this.writer.append("\n");
                break;
            }
            case 3: {
                this.writer.append(endTag);
                this.writer.append("\n");
                break;
            }
            case 4: {
                this.writer.append(htmlComment.trim());
                this.writer.append("\n");
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.writer.append(javaCode);
                this.writer.append("\n");
                break;
            }
            case 9: {
                this.writer.append(javaCode);
                this.writer.append("\n");
            }
        }
        return this.writer.toString();
    }
}

