/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.util;

import com.egen.develop.util.IOHelper;
import com.egen.util.io.FileIo;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

public class PropertyHelper {
    private static String propertyFile(String FOLDER, String FILE) throws Exception {
        String os = System.getProperty("os.name");
        if (!(os != null && os.toUpperCase().startsWith("W") || FOLDER == null || FOLDER.startsWith("/"))) {
            FOLDER = "/" + FOLDER;
        }
        String completePath = FOLDER + FILE;
        File file = new File(completePath);
        String fileText = FileIo.read((String)completePath);
        return fileText;
    }

    public static ArrayList propertyFileList(String FOLDER, String EXTENSION) throws Exception {
        ArrayList files = IOHelper.retrieveFileList(FOLDER, null, EXTENSION, null, true);
        return files;
    }

    public static ArrayList propertyFileList(String FOLDER) throws Exception {
        ArrayList files = PropertyHelper.propertyFileList(FOLDER, "properties");
        return files;
    }

    public static ArrayList[] propertyList(String FOLDER, String FILE) throws Exception {
        String[] split;
        String fileText = PropertyHelper.propertyFile(FOLDER, FILE);
        ArrayList[] valuesLabels = null;
        if (fileText != null && fileText.length() > 0 && (split = fileText.split("\\n")) != null) {
            valuesLabels = new ArrayList[split.length == 1 ? 2 : split.length];
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < split.length; ++i) {
                if (split[i] == null || split[i].length() <= 0) continue;
                String[] parts = split[i].split("=", 2);
                String key = "";
                String value = "";
                if (parts.length > 0) {
                    key = parts[0];
                }
                if (parts.length > 1) {
                    value = parts[1];
                }
                keys.add(key);
                values.add(value);
            }
            valuesLabels[0] = keys;
            valuesLabels[1] = values;
        }
        return valuesLabels;
    }

    public static ArrayList[] propertyListWithNull(String FOLDER, String FILE) throws Exception {
        ArrayList[] valuesLabels = PropertyHelper.propertyList(FOLDER, FILE);
        if (valuesLabels != null && valuesLabels.length > 1) {
            ArrayList keys = valuesLabels[0];
            ArrayList labels = valuesLabels[1];
            keys.add(0, "");
            labels.add(0, "");
        }
        return valuesLabels;
    }

    public static Vector[] propertiesVector(String FOLDER, String FILE) throws Exception {
        String[] split;
        String fileText = PropertyHelper.propertyFile(FOLDER, FILE);
        Vector[] valuesLabels = null;
        if (fileText != null && fileText.length() > 0 && (split = fileText.split("\\n")) != null) {
            valuesLabels = new Vector[split.length];
            Vector<String> keys = new Vector<String>();
            Vector<String> values = new Vector<String>();
            for (int i = 0; i < split.length; ++i) {
                if (split[i] == null || split[i].length() <= 0) continue;
                String[] parts = split[i].split("=", 2);
                String key = "";
                String value = "";
                if (parts.length > 0 && parts[0] != null) {
                    key = parts[0];
                }
                if (parts.length > 1 && parts[1] != null) {
                    value = parts[1];
                }
                keys.add(key);
                values.add(value);
            }
            valuesLabels[0] = keys;
            valuesLabels[1] = values;
        }
        return valuesLabels;
    }

    public static void save(ArrayList[] PROPERTIES, String FOLDER, String FILE) throws Exception {
        StringBuffer txt = new StringBuffer();
        if (PROPERTIES != null && PROPERTIES.length > 1) {
            ArrayList keys = PROPERTIES[0];
            ArrayList values = PROPERTIES[1];
            if (keys != null && values != null) {
                for (int i = 0; i < keys.size(); ++i) {
                    txt.append(keys.get(i) + "=" + values.get(i) + "\n");
                }
            }
        }
        if (!FOLDER.endsWith("/") && !FOLDER.endsWith("\\")) {
            FOLDER = FOLDER + "/";
        }
        String filePath = FOLDER + FILE;
        filePath = IOHelper.correctFileSeparator(filePath);
        File file = new File(filePath);
        FileIo.write((String)filePath, (String)txt.toString());
    }

    public static void addProperty(String KEY, String VALUE, ArrayList[] PROPERTIES) throws Exception {
        if (PROPERTIES != null && PROPERTIES.length > 1) {
            ArrayList<String> keys = PROPERTIES[0];
            ArrayList<String> values = PROPERTIES[1];
            if (keys == null) {
                keys = new ArrayList<String>();
                values = new ArrayList<String>();
            }
            keys.add(KEY);
            values.add(VALUE);
        }
    }

    public static void addProperty(String KEY, String VALUE, int POSITION, ArrayList[] PROPERTIES) throws Exception {
        if (PROPERTIES != null && PROPERTIES.length > 1) {
            ArrayList<String> keys = PROPERTIES[0];
            ArrayList<String> values = PROPERTIES[1];
            if (keys == null) {
                keys = new ArrayList<String>();
                values = new ArrayList<String>();
            }
            if (keys.size() > POSITION) {
                keys.add(POSITION, KEY);
                values.add(POSITION, VALUE);
            }
        }
    }

    public static void deleteProperty(String KEY, ArrayList[] PROPERTIES) throws Exception {
        if (PROPERTIES != null && PROPERTIES.length > 1) {
            ArrayList keys = PROPERTIES[0];
            ArrayList values = PROPERTIES[1];
            if (keys != null && values != null) {
                for (int i = 0; i < keys.size(); ++i) {
                    String key = (String)keys.get(i);
                    if (!key.equals(KEY)) continue;
                    keys.remove(i);
                    values.remove(i);
                    break;
                }
            }
        }
    }

    public static void editProperty(String KEY, String VALUE, ArrayList[] PROPERTIES) throws Exception {
        if (PROPERTIES != null && PROPERTIES.length > 1) {
            ArrayList keys = PROPERTIES[0];
            ArrayList values = PROPERTIES[1];
            if (keys != null && values != null) {
                for (int i = 0; i < keys.size(); ++i) {
                    String key = (String)keys.get(i);
                    if (!key.equals(KEY)) continue;
                    keys.set(i, KEY);
                    values.set(i, VALUE);
                    break;
                }
            }
        }
    }

    public static void shiftProperty(int INITIAL_POSITION, int FINAL_POSITION, ArrayList[] PROPERTIES) throws Exception {
        if (PROPERTIES != null && PROPERTIES.length > 1) {
            ArrayList keys = PROPERTIES[0];
            ArrayList values = PROPERTIES[1];
            if (keys != null && values != null && keys.size() > INITIAL_POSITION && keys.size() > FINAL_POSITION) {
                String key = (String)keys.get(INITIAL_POSITION);
                String value = (String)values.get(INITIAL_POSITION);
                keys.remove(INITIAL_POSITION);
                values.remove(INITIAL_POSITION);
                keys.add(FINAL_POSITION, key);
                values.add(FINAL_POSITION, value);
            }
        }
    }
}

