/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.util;

import com.egen.develop.util.GeneratorReportHelper;
import com.egen.util.logger.Logging;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;

public class IOHelper {
    public static ArrayList retrieveFileList(String PATH, String SUB_DIR, String TYPE, String FILTER, boolean showPath) {
        String[] list_table;
        ArrayList list = new ArrayList();
        if (PATH == null) {
            return list;
        }
        String path = PATH;
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = path + "/";
        }
        String sub_dir = "";
        if (SUB_DIR != null && SUB_DIR.length() > 0) {
            sub_dir = SUB_DIR;
        }
        if (!(path = path + sub_dir).endsWith("/") && !path.endsWith("\\")) {
            path = path + "/";
        }
        path = IOHelper.correctFileSeparator(path);
        File dir = null;
        try {
            dir = new File(path);
        }
        catch (Exception e) {
            Logging.log((String)"com.egen.develop.util", (Level)Level.INFO, (String)(IOHelper.class.getName() + ".retrieveFileList()[366]."), (Throwable)e);
        }
        if (dir != null && (list_table = dir.list()) != null) {
            for (int i = 0; i < list_table.length; ++i) {
                if (list_table[i] == null || list_table[i].length() <= 0) continue;
                if (list_table[i].indexOf(".") == -1) {
                    String module = list_table[i];
                    ArrayList sub_list = IOHelper.retrieveFileList(path, module, TYPE, FILTER, showPath);
                    for (int j = 0; j < sub_list.size(); ++j) {
                        list.add(sub_list.get(j));
                    }
                    continue;
                }
                if (TYPE != null && TYPE.length() > 0 && !list_table[i].toLowerCase().endsWith(TYPE.toLowerCase())) continue;
                if (FILTER != null && FILTER.length() > 0) {
                    try {
                        if (!GeneratorReportHelper.checkNameFilter(FILTER, list_table[i])) {
                            continue;
                        }
                    }
                    catch (Exception e) {
                        Logging.log((String)"com.egen.develop.util", (Level)Level.INFO, (String)((class$com$egen$develop$util$IOHelper == null ? IOHelper.class$("com.egen.develop.util.IOHelper") : class$com$egen$develop$util$IOHelper).getName() + ".retrieveFileList()."), (Throwable)e);
                    }
                }
                if (showPath) {
                    list.add(path + list_table[i]);
                    continue;
                }
                list.add(list_table[i]);
            }
            Collections.sort(list);
        }
        return list;
    }

    public static ArrayList retrieveDirList(String PATH) {
        ArrayList<String> list = new ArrayList<String>();
        if (PATH != null && PATH.length() > 0) {
            String[] list_table;
            String file_path = IOHelper.correctFileSeparator(PATH);
            File dir = null;
            try {
                dir = new File(file_path);
            }
            catch (Exception e) {
                Logging.log((String)"com.egen.develop.util", (Level)Level.INFO, (String)(IOHelper.class.getName() + ".retrieveDirList()."), (Throwable)e);
            }
            if (dir != null && (list_table = dir.list()) != null) {
                for (int i = 0; i < list_table.length; ++i) {
                    list.add(list_table[i]);
                }
                Collections.sort(list);
            }
        }
        return list;
    }

    public static String correctFileSeparator(String PATH) {
        if (PATH == null || PATH.length() == 0) {
            return PATH;
        }
        char slash = "/".charAt(0);
        char backSlash = "\\".charAt(0);
        String new_path = PATH;
        String os = System.getProperty("os.name");
        new_path = os != null && os.toUpperCase().startsWith("WINDOWS") ? new_path.replace(slash, backSlash) : new_path.replace(backSlash, slash);
        return new_path;
    }

    public static String correctFileSeparatorForPackages(String PATH) {
        if (PATH == null || PATH.length() == 0) {
            return PATH;
        }
        char slash = "/".charAt(0);
        char backSlash = "\\".charAt(0);
        char point = ".".charAt(0);
        String new_path = PATH;
        String os = System.getProperty("os.name");
        if (os != null && os.toUpperCase().startsWith("WINDOWS")) {
            new_path = new_path.replace(slash, backSlash);
            new_path = new_path.replace(point, backSlash);
        } else {
            new_path = new_path.replace(backSlash, slash);
            new_path = new_path.replace(point, slash);
        }
        return new_path;
    }

    public static String replaceFileSeparatorByPoints(String PATH) {
        if (PATH == null || PATH.length() == 0) {
            return PATH;
        }
        char slash = "/".charAt(0);
        char backSlash = "\\".charAt(0);
        char point = ".".charAt(0);
        String new_path = PATH;
        new_path = new_path.replace(slash, point);
        new_path = new_path.replace(backSlash, point);
        return new_path;
    }

    public static String removePathInformation(String filePath) {
        if (filePath != null && filePath.indexOf(File.separator) != -1) {
            filePath = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
        }
        return filePath;
    }

    public static ArrayList removePathInformation(ArrayList list) {
        ArrayList<String> newList = new ArrayList<String>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String path = (String)list.get(i);
                path = IOHelper.removePathInformation(path);
                newList.add(path);
            }
        }
        return newList;
    }
}

