/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.util;

import com.egen.develop.generator.Block;
import com.egen.develop.generator.Generator;
import com.egen.develop.generator.chart.BlockChart;
import com.egen.develop.generator.chart.Chart;
import com.egen.develop.generator.form.BaseButton;
import com.egen.develop.generator.form.BaseHtmlField;
import com.egen.develop.generator.form.BlockForm;
import com.egen.develop.generator.form.Field;
import com.egen.develop.generator.form.FieldRelation;
import com.egen.develop.generator.form.Free;
import com.egen.develop.generator.form.Lov;
import com.egen.develop.generator.form.Options;
import com.egen.develop.generator.form.Select;
import com.egen.develop.generator.form.Submit;
import com.egen.develop.generator.menu.BlockMenu;
import com.egen.develop.generator.report.BlockReport;
import com.egen.develop.generator.report.Column;
import com.egen.develop.generator.report.ColumnRelation;
import com.egen.develop.resource.Project;
import com.egen.develop.util.GeneratorReportHelper;
import com.egen.util.system.Menu;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;

public class GeneratorCustomizationHelper {
    public static Menu reportCustomizations(Project project, String[] moduleFilter, String nameFilter, int level) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu customizations = new Menu();
        customizations.setName(bundle.getString("jsp.project"));
        customizations.setLabel(bundle.getString("jsp.project") + ": " + project.getName());
        if (project != null) {
            ArrayList modules = GeneratorReportHelper.retrieveModuleList(project);
            for (int i = 0; i < modules.size(); ++i) {
                String module = (String)modules.get(i);
                if (module == null || module.length() <= 0 || !GeneratorReportHelper.checkModuleFilter(moduleFilter, module)) continue;
                ArrayList metaFiles = GeneratorReportHelper.retrieveMetaFileList(project, module);
                for (int a = 0; a < metaFiles.size(); ++a) {
                    Menu menu;
                    String fileName;
                    String metaFile = (String)metaFiles.get(a);
                    Generator generator = GeneratorReportHelper.retrieveGenerator(metaFile, project);
                    if (generator == null || !GeneratorReportHelper.checkNameFilter(nameFilter, fileName = generator.getFile_name()) || (menu = GeneratorCustomizationHelper.generatorCustomizations(generator, level)) == null) continue;
                    customizations.addSub_menu(menu);
                }
            }
        }
        if (customizations.getSub_menus() == null || customizations.getSub_menus().size() == 0) {
            customizations = null;
        }
        return customizations;
    }

    public static Menu generatorCustomizations(Generator generator, int level) throws Exception {
        Menu customizations = new Menu();
        customizations.setLabel(generator.getModule() + " - " + generator.getFile_name());
        if (generator != null) {
            Menu blocksCust;
            Vector blocks;
            Menu propertiesCustomizations = GeneratorCustomizationHelper.propertiesCustomizations(generator, level);
            if (propertiesCustomizations != null) {
                customizations.addSub_menu(propertiesCustomizations);
            }
            if ((level == 0 || level > 1) && (blocks = generator.getBlocks()) != null && blocks.size() > 0 && (blocksCust = GeneratorCustomizationHelper.blocksCustomizations(blocks, level)) != null) {
                customizations.addSub_menu(blocksCust);
            }
            if (customizations.getSub_menus() == null || customizations.getSub_menus().size() == 0) {
                customizations = null;
            }
        }
        return customizations;
    }

    public static Menu propertiesCustomizations(Generator generator, int level) throws Exception {
        Menu submenu;
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu propCust = new Menu();
        propCust.setLabel(bundle.getString("jsp.properties"));
        if ((generator.getJspTemplate() == null || generator.getJspTemplate().length() == 0) && generator.getJspCode() != null && generator.getJspCode().length() > 0) {
            submenu = new Menu();
            submenu.setLabel("JSP");
            propCust.addSub_menu(submenu);
        }
        if ((generator.getActionTemplate() == null || generator.getActionTemplate().length() == 0) && generator.getActionCode() != null && generator.getActionCode().length() > 0) {
            submenu = new Menu();
            submenu.setLabel("Action");
            propCust.addSub_menu(submenu);
        }
        if ((generator.getActionFormTemplate() == null || generator.getActionFormTemplate().length() == 0) && generator.getActionFormCode() != null && generator.getActionFormCode().length() > 0) {
            submenu = new Menu();
            submenu.setLabel("ActionForm");
            propCust.addSub_menu(submenu);
        }
        if (propCust.getSub_menus() == null || propCust.getSub_menus().size() == 0) {
            propCust = null;
        }
        return propCust;
    }

    public static Menu blocksCustomizations(Generator generator, int level) throws Exception {
        Menu submenu;
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu propCust = new Menu();
        propCust.setLabel(bundle.getString("jsp.properties"));
        if ((generator.getJspTemplate() == null || generator.getJspTemplate().length() == 0) && generator.getJspCode() != null && generator.getJspCode().length() > 0) {
            submenu = new Menu();
            submenu.setLabel("JSP");
            propCust.addSub_menu(submenu);
        }
        if ((generator.getActionTemplate() == null || generator.getActionTemplate().length() == 0) && generator.getActionCode() != null && generator.getActionCode().length() > 0) {
            submenu = new Menu();
            submenu.setLabel("Action");
            propCust.addSub_menu(submenu);
        }
        if ((generator.getActionFormTemplate() == null || generator.getActionFormTemplate().length() == 0) && generator.getActionFormCode() != null && generator.getActionFormCode().length() > 0) {
            submenu = new Menu();
            submenu.setLabel("ActionForm");
            propCust.addSub_menu(submenu);
        }
        if (propCust.getSub_menus() == null || propCust.getSub_menus().size() == 0) {
            propCust = null;
        }
        return propCust;
    }

    public static Menu blocksCustomizations(Vector blocks, int level) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailCustomizations = new Menu();
        detailCustomizations.setLabel(bundle.getString("menu.generator.blocks"));
        for (int i = 0; i < blocks.size(); ++i) {
            Menu blockCustomizations;
            Block block = (Block)blocks.elementAt(i);
            if (block instanceof BlockForm) {
                blockCustomizations = GeneratorCustomizationHelper.blockCustomizations((BlockForm)block, level);
                if (blockCustomizations == null) continue;
                detailCustomizations.addSub_menu(blockCustomizations);
                continue;
            }
            if (block instanceof BlockReport) {
                blockCustomizations = GeneratorCustomizationHelper.blockCustomizations((BlockReport)block, level);
                if (blockCustomizations == null) continue;
                detailCustomizations.addSub_menu(blockCustomizations);
                continue;
            }
            if (block instanceof BlockMenu) {
                blockCustomizations = GeneratorCustomizationHelper.blockCustomizations((BlockMenu)block, level);
                if (blockCustomizations == null) continue;
                detailCustomizations.addSub_menu(blockCustomizations);
                continue;
            }
            if (!(block instanceof BlockChart) || (blockCustomizations = GeneratorCustomizationHelper.blockCustomizations((BlockChart)block, level)) == null) continue;
            detailCustomizations.addSub_menu(blockCustomizations);
        }
        if (detailCustomizations.getSub_menus() == null || detailCustomizations.getSub_menus().size() == 0) {
            detailCustomizations = null;
        }
        return detailCustomizations;
    }

    public static Menu blockCustomizations(Block block, int level) throws Exception {
        Menu detailCustomizations = null;
        if (block instanceof BlockForm) {
            detailCustomizations = GeneratorCustomizationHelper.blockCustomizations((BlockForm)block, level);
        } else if (block instanceof BlockReport) {
            detailCustomizations = GeneratorCustomizationHelper.blockCustomizations((BlockReport)block, level);
        } else if (block instanceof BlockMenu) {
            detailCustomizations = GeneratorCustomizationHelper.blockCustomizations((BlockMenu)block, level);
        } else if (block instanceof BlockChart) {
            detailCustomizations = GeneratorCustomizationHelper.blockCustomizations((BlockChart)block, level);
        }
        return detailCustomizations;
    }

    public static Menu generalBlockCustomizations(Block block, int level) throws Exception {
        Menu itemCustomizations;
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailCustomizations = new Menu();
        detailCustomizations.setLabel(bundle.getString("jsp.general"));
        if (block.getMessage_text() != null && block.getMessage_text().length() > 0) {
            itemCustomizations = new Menu();
            itemCustomizations.setLabel(bundle.getString("jsp.message"));
            detailCustomizations.addSub_menu(itemCustomizations);
        }
        if ((block.getScript_template() == null || block.getScript_template().length() == 0) && block.getScript_block() != null && block.getScript_block().length() > 0) {
            itemCustomizations = new Menu();
            itemCustomizations.setLabel(bundle.getString("jsp.script"));
            detailCustomizations.addSub_menu(itemCustomizations);
        }
        if (detailCustomizations.getSub_menus() == null || detailCustomizations.getSub_menus().size() == 0) {
            detailCustomizations = null;
        }
        return detailCustomizations;
    }

    public static Menu blockCustomizations(BlockForm block, int level) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailCustomizations = new Menu();
        detailCustomizations.setLabel(bundle.getString("jsp.form") + ": " + block.getName());
        Menu blockCustomizations = GeneratorCustomizationHelper.generalBlockCustomizations(block, level);
        if (blockCustomizations != null) {
            detailCustomizations.addSub_menu(blockCustomizations);
        }
        if ((block.getFormTemplate() == null || block.getFormTemplate().length() == 0) && block.getForm_code() != null && block.getForm_code().length() > 0) {
            Menu itemCustomizations = new Menu();
            itemCustomizations.setLabel(bundle.getString("jsp.code"));
            detailCustomizations.addSub_menu(itemCustomizations);
        }
        if (level == 0 || level > 2) {
            Menu itemCustomizations;
            Vector buttons;
            Menu itemCustomizations2;
            Vector fields = block.getFields();
            if (fields != null && (itemCustomizations2 = GeneratorCustomizationHelper.fieldsCustomizations(block, 3)) != null && itemCustomizations2.getSub_menus() != null && itemCustomizations2.getSub_menus().size() > 0) {
                detailCustomizations.addSub_menu(itemCustomizations2);
            }
            if ((buttons = block.getButtons()) != null && (itemCustomizations = GeneratorCustomizationHelper.buttonsCustomizations(block, 3)) != null && itemCustomizations.getSub_menus() != null && itemCustomizations.getSub_menus().size() > 0) {
                detailCustomizations.addSub_menu(itemCustomizations);
            }
        }
        if (detailCustomizations.getSub_menus() == null || detailCustomizations.getSub_menus().size() == 0) {
            detailCustomizations = null;
        }
        return detailCustomizations;
    }

    public static Menu fieldsCustomizations(BlockForm block, int level) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailCustomizations = new Menu();
        Vector fields = block.getFields();
        if (fields != null) {
            detailCustomizations.setLabel(bundle.getString("jsp.field"));
            for (int i = 0; i < fields.size(); ++i) {
                Field field = (Field)fields.elementAt(i);
                Menu fieldMenu = GeneratorCustomizationHelper.fieldCustomizations(field, level);
                if (fieldMenu == null) continue;
                detailCustomizations.addSub_menu(fieldMenu);
            }
        }
        if (detailCustomizations.getSub_menus() == null || detailCustomizations.getSub_menus().size() == 0) {
            detailCustomizations = null;
        }
        return detailCustomizations;
    }

    public static Menu buttonsCustomizations(BlockForm block, int level) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailCustomizations = new Menu();
        Vector buttons = block.getButtons();
        if (buttons != null) {
            detailCustomizations.setLabel(bundle.getString("jsp.button"));
            for (int i = 0; i < buttons.size(); ++i) {
                BaseButton button = (BaseButton)buttons.elementAt(i);
                Menu specificMenu = GeneratorCustomizationHelper.buttonCustomizations(button, level);
                if (specificMenu == null) continue;
                detailCustomizations.addSub_menu(specificMenu);
            }
        }
        if (detailCustomizations.getSub_menus() == null || detailCustomizations.getSub_menus().size() == 0) {
            detailCustomizations = null;
        }
        return detailCustomizations;
    }

    public static Menu buttonCustomizations(BaseButton button, int level) throws Exception {
        Menu specificMenu;
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailCustomizations = new Menu();
        detailCustomizations.setLabel(button.getName());
        if (button.getIsCustomized()) {
            Menu itemCustomizations = new Menu();
            itemCustomizations.setLabel("JSP: " + bundle.getString("jsp.customized"));
            detailCustomizations.addSub_menu(itemCustomizations);
        }
        if (button instanceof Submit && (specificMenu = GeneratorCustomizationHelper.submitButtonCustomizations((Submit)button, level)) != null) {
            detailCustomizations.addSub_menu(specificMenu);
        }
        if (detailCustomizations.getSub_menus() == null || detailCustomizations.getSub_menus().size() == 0) {
            detailCustomizations = null;
        }
        return detailCustomizations;
    }

    public static Menu submitButtonCustomizations(Submit button, int level) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailCustomizations = null;
        if ((button.getTemplate() == null || button.getTemplate().length() == 0) && button.getAction_code() != null && button.getAction_code().length() > 0) {
            detailCustomizations = new Menu();
            detailCustomizations.setLabel(bundle.getString("jsp.action"));
        }
        return detailCustomizations;
    }

    public static Menu fieldCustomizations(Field field, int level) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailCustomizations = new Menu();
        detailCustomizations.setLabel(field.getName());
        if (field.getIsCustomized() && !(field instanceof Free)) {
            Menu itemCustomizations = new Menu();
            itemCustomizations.setLabel("JSP: " + bundle.getString("jsp.customized"));
            detailCustomizations.addSub_menu(itemCustomizations);
        }
        if (level == 0 || level > 3) {
            Menu specificMenu;
            Options options;
            Menu specificMenu2;
            Menu lovMenu;
            Lov lov = field.getLovObject();
            if (lov != null && (lovMenu = GeneratorCustomizationHelper.lovCustomizations(lov, level)) != null) {
                detailCustomizations.addSub_menu(lovMenu);
            }
            if (field instanceof BaseHtmlField && (specificMenu2 = GeneratorCustomizationHelper.baseHtmlFieldCustomizations((BaseHtmlField)field, level)) != null) {
                detailCustomizations.addSub_menu(specificMenu2);
            }
            if (field instanceof Select && (options = ((Select)field).getOptions()) != null && (specificMenu = GeneratorCustomizationHelper.optionsCustomizations(options, level)) != null) {
                detailCustomizations.addSub_menu(specificMenu);
            }
            if (field instanceof Free && (specificMenu2 = GeneratorCustomizationHelper.freeFieldCustomizations((Free)field, level)) != null) {
                detailCustomizations.addSub_menu(specificMenu2);
            }
        }
        if (detailCustomizations.getSub_menus() == null || detailCustomizations.getSub_menus().size() == 0) {
            detailCustomizations = null;
        }
        return detailCustomizations;
    }

    public static Menu baseHtmlFieldCustomizations(BaseHtmlField field, int level) throws Exception {
        Menu detailCustomizations = null;
        FieldRelation fieldRelation = field.getField_relation();
        if (fieldRelation != null) {
            detailCustomizations = GeneratorCustomizationHelper.fieldRelationCustomizations(fieldRelation, level);
        }
        return detailCustomizations;
    }

    public static Menu fieldRelationCustomizations(FieldRelation fieldRelation, int level) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailCustomizations = null;
        if (fieldRelation != null && (fieldRelation.getFieldRelationTemplate() == null || fieldRelation.getFieldRelationTemplate().length() == 0) && fieldRelation.getFieldRelationCode() != null && fieldRelation.getFieldRelationCode().length() > 0) {
            detailCustomizations = new Menu();
            detailCustomizations.setLabel(bundle.getString("jsp.text") + "/" + bundle.getString("jsp.textarea") + ": " + bundle.getString("jsp.fieldrelation"));
        }
        return detailCustomizations;
    }

    public static Menu optionsCustomizations(Options options, int level) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailCustomizations = null;
        if (options != null && (options.getTemplate() == null || options.getTemplate().length() == 0) && options.getListCode() != null && options.getListCode().length() > 0) {
            detailCustomizations = new Menu();
            detailCustomizations.setLabel(bundle.getString("jsp.select") + ": " + bundle.getString("jsp.options"));
        }
        return detailCustomizations;
    }

    public static Menu freeFieldCustomizations(Free field, int level) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailCustomizations = null;
        if ((field.getTemplate() == null || field.getTemplate().length() == 0) && field.getCodeItem() != null && field.getCodeItem().length() > 0) {
            detailCustomizations = new Menu();
            detailCustomizations.setLabel(bundle.getString("jsp.free") + ": " + bundle.getString("jsp.value"));
        }
        return detailCustomizations;
    }

    public static Menu lovCustomizations(Lov lov, int level) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailCustomizations = null;
        if ((lov.getLovTemplate() == null || lov.getLovTemplate().length() == 0) && lov.getLovCode() != null && lov.getLovCode().length() > 0) {
            detailCustomizations = new Menu();
            detailCustomizations.setLabel(bundle.getString("jsp.lov"));
        }
        return detailCustomizations;
    }

    public static Menu blockCustomizations(BlockReport block, int level) throws Exception {
        Menu itemCustomizations;
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailCustomizations = new Menu();
        detailCustomizations.setLabel(bundle.getString("jsp.report") + ": " + block.getName());
        Menu blockCustomizations = GeneratorCustomizationHelper.generalBlockCustomizations(block, level);
        if (blockCustomizations != null) {
            detailCustomizations.addSub_menu(blockCustomizations);
        }
        if ((block.getReportTemplate() == null || block.getReportTemplate().length() == 0) && block.getReport() != null && block.getReport().length() > 0) {
            itemCustomizations = new Menu();
            itemCustomizations.setLabel("JSP " + bundle.getString("jsp.code"));
            detailCustomizations.addSub_menu(itemCustomizations);
        }
        if ((level == 0 || level > 2) && (itemCustomizations = GeneratorCustomizationHelper.columnsCustomizations(block, 3)) != null && itemCustomizations.getSub_menus() != null && itemCustomizations.getSub_menus().size() > 0) {
            detailCustomizations.addSub_menu(itemCustomizations);
        }
        if (detailCustomizations.getSub_menus() == null || detailCustomizations.getSub_menus().size() == 0) {
            detailCustomizations = null;
        }
        return detailCustomizations;
    }

    public static Menu columnsCustomizations(BlockReport block, int level) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailCustomizations = new Menu();
        Vector columns = block.getColumns();
        if (columns != null) {
            detailCustomizations.setLabel(bundle.getString("jsp.column"));
            for (int i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.elementAt(i);
                Menu columnMenu = GeneratorCustomizationHelper.columnCustomizations(column, level);
                if (columnMenu == null) continue;
                detailCustomizations.addSub_menu(columnMenu);
            }
        }
        if (detailCustomizations.getSub_menus() == null || detailCustomizations.getSub_menus().size() == 0) {
            detailCustomizations = null;
        }
        return detailCustomizations;
    }

    public static Menu columnCustomizations(Column column, int level) throws Exception {
        Menu itemCustomizations;
        ColumnRelation columnRelation;
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailCustomizations = new Menu();
        detailCustomizations.setLabel(column.getName());
        if (column.getColumnRelation() == null && (column.getColumnDisplayCodeCustomized() || column.getColumnHeaderCodeCustomized()) || !column.getBase_table() && column.getFormula() != null && column.getFormula().length() > 0) {
            Menu itemCustomizations2 = new Menu();
            itemCustomizations2.setLabel(bundle.getString("jsp.formula"));
            detailCustomizations.addSub_menu(itemCustomizations2);
        }
        if ((level == 0 || level > 3) && (columnRelation = column.getColumnRelation()) != null && (itemCustomizations = GeneratorCustomizationHelper.columnRelationCustomizations(columnRelation, level)) != null) {
            detailCustomizations.addSub_menu(itemCustomizations);
        }
        if (detailCustomizations.getSub_menus() == null || detailCustomizations.getSub_menus().size() == 0) {
            detailCustomizations = null;
        }
        return detailCustomizations;
    }

    public static Menu columnRelationCustomizations(ColumnRelation columnRelation, int level) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailCustomizations = new Menu();
        detailCustomizations.setLabel(bundle.getString("jsp.entity") + ": " + columnRelation.getDb_object().substring(columnRelation.getDb_object().lastIndexOf(".") + 1));
        if ((columnRelation.getColumnRelationTemplate() == null || columnRelation.getColumnRelationTemplate().length() == 0) && columnRelation.getColumnRelationCode() != null && columnRelation.getColumnRelationCode().length() > 0) {
            Menu itemCustomizations = new Menu();
            itemCustomizations.setLabel(bundle.getString("jsp.columnrelation"));
            detailCustomizations.addSub_menu(itemCustomizations);
        }
        if (detailCustomizations.getSub_menus() == null || detailCustomizations.getSub_menus().size() == 0) {
            detailCustomizations = null;
        }
        return detailCustomizations;
    }

    public static Menu blockCustomizations(BlockMenu block, int level) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailCustomizations = new Menu();
        detailCustomizations.setLabel(bundle.getString("jsp.menu") + ": " + block.getName());
        Menu blockCustomizations = GeneratorCustomizationHelper.generalBlockCustomizations(block, level);
        if (blockCustomizations != null) {
            detailCustomizations.addSub_menu(blockCustomizations);
        }
        if ((block.getMenuTemplate() == null || block.getMenuTemplate().length() == 0) && block.getMenuCode() != null && block.getMenuCode().length() > 0) {
            Menu itemCustomizations = new Menu();
            itemCustomizations.setLabel("JSP " + bundle.getString("jsp.code"));
            detailCustomizations.addSub_menu(itemCustomizations);
        }
        if (detailCustomizations.getSub_menus() == null || detailCustomizations.getSub_menus().size() == 0) {
            detailCustomizations = null;
        }
        return detailCustomizations;
    }

    public static Menu blockCustomizations(BlockChart block, int level) throws Exception {
        Vector charts;
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailCustomizations = new Menu();
        detailCustomizations.setLabel(bundle.getString("jsp.chart") + ": " + block.getName());
        Menu blockCustomizations = GeneratorCustomizationHelper.generalBlockCustomizations(block, level);
        if (blockCustomizations != null) {
            detailCustomizations.addSub_menu(blockCustomizations);
        }
        if ((block.getChartBlockTemplate() == null || block.getChartBlockTemplate().length() == 0) && block.getChartBlockCode() != null && block.getChartBlockCode().length() > 0) {
            Menu itemCustomizations = new Menu();
            itemCustomizations.setLabel("JSP " + bundle.getString("jsp.code"));
            detailCustomizations.addSub_menu(itemCustomizations);
        }
        if ((level == 0 || level > 2) && (charts = block.getCharts()) != null) {
            Menu itemCustomizations = new Menu();
            itemCustomizations.setLabel(bundle.getString("jsp.chart"));
            for (int i = 0; i < charts.size(); ++i) {
                Chart chart = (Chart)charts.elementAt(i);
                Menu chartMenu = GeneratorCustomizationHelper.chartCustomizations(chart, level);
                if (chartMenu == null) continue;
                itemCustomizations.addSub_menu(chartMenu);
            }
            if (itemCustomizations != null && itemCustomizations.getSub_menus() != null && itemCustomizations.getSub_menus().size() > 0) {
                detailCustomizations.addSub_menu(itemCustomizations);
            }
        }
        if (detailCustomizations.getSub_menus() == null || detailCustomizations.getSub_menus().size() == 0) {
            detailCustomizations = null;
        }
        return detailCustomizations;
    }

    public static Menu chartCustomizations(Chart chart, int level) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailCustomizations = new Menu();
        detailCustomizations.setLabel(chart.getId());
        if (!(level != 0 && level <= 3 || chart.getChartTemplate() != null && chart.getChartTemplate().length() != 0 || chart.getChartCode() == null || chart.getChartCode().length() <= 0)) {
            Menu itemCustomizations = new Menu();
            itemCustomizations.setLabel(bundle.getString("jsp.code"));
            detailCustomizations.addSub_menu(itemCustomizations);
        }
        if (detailCustomizations.getSub_menus() == null || detailCustomizations.getSub_menus().size() == 0) {
            detailCustomizations = null;
        }
        return detailCustomizations;
    }
}

