/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.util;

import com.egen.develop.generator.Block;
import com.egen.develop.generator.Generator;
import com.egen.develop.generator.form.BaseButton;
import com.egen.develop.generator.form.FieldRelation;
import com.egen.develop.generator.form.Options;
import com.egen.develop.generator.form.Trigger;
import com.egen.develop.generator.report.ColumnRelation;
import java.util.HashMap;

public class DataSourceHelper {
    private static final String dataSourceToken = "data_source";
    BaseButton button = null;

    public static String connectionCreation(String connectionType, Object object, String connectionName) {
        if (connectionName == null || connectionName.length() == 0) {
            connectionName = "j";
        }
        String jndi = DataSourceHelper.findAlternative(object);
        StringBuffer txt = new StringBuffer("");
        if (connectionType != null && !connectionType.equals("session")) {
            if (connectionType.equals("conn")) {
                txt.append(connectionName + " = new com.egen.util.jdbc.JdbcUtil(request" + (jndi != null && jndi.length() > 0 ? ", \"" + jndi + "\"" : "") + ");\n");
            } else if (connectionType.equals("pool")) {
                txt.append(connectionName + " = new com.egen.util.jdbc.JdbcUtil(" + (jndi != null ? "\"" + jndi + "\"" : "") + ");\n");
            }
        }
        return txt.toString();
    }

    public static String findAlternative(Object object) {
        String jndi = "";
        if (object instanceof Generator) {
            jndi = DataSourceHelper.exploreObject((Generator)object);
        } else if (object instanceof Block) {
            jndi = DataSourceHelper.exploreObject((Block)object);
        } else if (object instanceof BaseButton) {
            jndi = DataSourceHelper.exploreObject((BaseButton)object);
        } else if (object instanceof FieldRelation) {
            jndi = DataSourceHelper.exploreObject((FieldRelation)object);
        } else if (object instanceof ColumnRelation) {
            jndi = DataSourceHelper.exploreObject((ColumnRelation)object);
        } else if (object instanceof Options) {
            jndi = DataSourceHelper.exploreObject((Options)object);
        } else if (object instanceof Trigger) {
            jndi = DataSourceHelper.exploreObject((Trigger)object);
        }
        return jndi;
    }

    private static String exploreObject(Generator object) {
        HashMap setProperty;
        String jndi = null;
        if (object != null && (setProperty = object.getGeneratorSetProperty()) != null && setProperty.get(dataSourceToken) != null) {
            jndi = (String)setProperty.get(dataSourceToken);
        }
        return jndi;
    }

    private static String exploreObject(Block object) {
        String jndi = null;
        if (object != null) {
            HashMap setProperty = object.getBlockSetProperty();
            if (setProperty != null && setProperty.get(dataSourceToken) != null) {
                jndi = (String)setProperty.get(dataSourceToken);
            }
            if (jndi == null || jndi.length() == 0) {
                jndi = DataSourceHelper.exploreObject(object.retrieveParent());
            }
        }
        return jndi;
    }

    private static String exploreObject(BaseButton object) {
        HashMap setProperty;
        String jndi = null;
        if (object != null && (setProperty = object.getBaseButtonSetProperty()) != null && setProperty.get(dataSourceToken) != null) {
            jndi = (String)setProperty.get(dataSourceToken);
        }
        if (object != null && (jndi == null || jndi.length() == 0)) {
            jndi = DataSourceHelper.exploreObject(object.retrieveParent());
        }
        return jndi;
    }

    private static String exploreObject(FieldRelation object) {
        String jndi = null;
        if (object != null) {
            HashMap setProperty = object.getFieldRelationSetProperty();
            if (setProperty != null && setProperty.get(dataSourceToken) != null) {
                jndi = (String)setProperty.get(dataSourceToken);
            }
            if ((jndi == null || jndi.length() == 0) && object.retrieveField() != null) {
                jndi = DataSourceHelper.exploreObject(object.retrieveField().retrieveParent());
            }
        }
        return jndi;
    }

    private static String exploreObject(ColumnRelation object) {
        String jndi = null;
        if (object != null) {
            HashMap setProperty = object.getColumnRelationSetProperty();
            if (setProperty != null && setProperty.get(dataSourceToken) != null) {
                jndi = (String)setProperty.get(dataSourceToken);
            }
            if ((jndi == null || jndi.length() == 0) && object.retrieveParent() != null) {
                jndi = DataSourceHelper.exploreObject(object.retrieveParent().retrieveParent());
            }
        }
        return jndi;
    }

    private static String exploreObject(Options object) {
        String jndi = null;
        if (object != null) {
            HashMap setProperty = object.getOptionsSetProperty();
            if (setProperty != null && setProperty.get(dataSourceToken) != null) {
                jndi = (String)setProperty.get(dataSourceToken);
            }
            if ((jndi == null || jndi.length() == 0) && object.retrieveParent() != null) {
                jndi = DataSourceHelper.exploreObject(object.retrieveParent().retrieveParent());
            }
        }
        return jndi;
    }

    private static String exploreObject(Trigger object) {
        String jndi = null;
        if (object != null) {
            HashMap setProperty = object.getTriggerSetProperty();
            if (setProperty != null && setProperty.get(dataSourceToken) != null) {
                jndi = (String)setProperty.get(dataSourceToken);
            }
            if ((jndi == null || jndi.length() == 0) && object.retrieveParent() != null) {
                jndi = DataSourceHelper.exploreObject(object.retrieveParent().retrieveParent());
            }
        }
        return jndi;
    }
}

