/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.util;

import com.egen.develop.resource.Project;
import com.egen.develop.util.IOHelper;
import com.egen.util.logger.Logging;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;

public class Compiler {
    public static String compile(Project PROJECT, String SOURCE_FILE) {
        String str = "";
        try {
            String parameters;
            Runtime rt = Runtime.getRuntime();
            String class_path = IOHelper.correctFileSeparator(PROJECT.getClass_path());
            String pathSeparator = File.pathSeparator;
            String internal_libraries = class_path + pathSeparator;
            if (class_path.indexOf("classes") != -1) {
                String lib_path = class_path.substring(0, class_path.indexOf("classes")) + "lib";
                lib_path = IOHelper.correctFileSeparator(lib_path);
                ArrayList files = IOHelper.retrieveFileList(lib_path, null, "jar", null, true);
                for (int i = 0; i < files.size(); ++i) {
                    String file = (String)files.get(i);
                    internal_libraries = internal_libraries + file + pathSeparator;
                }
            }
            String libraries = internal_libraries + PROJECT.getLibraries();
            String source_file = IOHelper.correctFileSeparator(SOURCE_FILE.substring(0, SOURCE_FILE.indexOf(".java"))) + ".java";
            String comand = "javac -classpath \"" + libraries + "\" -d " + class_path + " " + source_file;
            String os = System.getProperty("os.name");
            if (os == null || !os.toUpperCase().startsWith("WIN")) {
                comand = "javac -classpath " + libraries + " -d " + class_path + " " + source_file;
            }
            if ((parameters = PROJECT.getJava_compile()) != null && parameters.length() > 0) {
                comand = comand + " " + parameters;
            }
            Process proc = rt.exec(comand);
            InputStream stderr = proc.getErrorStream();
            InputStreamReader isr = new InputStreamReader(stderr);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                str = str + line;
            }
            proc.waitFor();
        }
        catch (Exception e) {
            Logging.log((String)"com.egen.develop.util", (Level)Level.INFO, (String)(Compiler.class.getName() + ".compile()[72]."), (Throwable)e);
            str = str + "Exception: " + e;
        }
        return str;
    }

    public static String compile(String buildFile, Project PROJECT, String SOURCE_FILE) throws Exception {
        String class_path = PROJECT.getClass_path();
        String pathSeparator = File.pathSeparator;
        String internal_libraries = class_path + pathSeparator;
        if (class_path.indexOf("classes") != -1) {
            String lib_path = class_path.substring(0, class_path.indexOf("classes")) + "lib";
            lib_path = IOHelper.correctFileSeparator(lib_path);
            ArrayList files = IOHelper.retrieveFileList(lib_path, null, "jar", null, true);
            for (int i = 0; i < files.size(); ++i) {
                String file = (String)files.get(i);
                internal_libraries = internal_libraries + file + pathSeparator;
            }
        }
        String str = Compiler.compile(PROJECT, SOURCE_FILE);
        return str;
    }
}

