/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.util;

import com.egen.develop.generator.Generator;
import com.egen.develop.resource.Project;
import com.egen.develop.util.jstyle.JSBeautifier;
import com.egen.develop.util.jstyle.JSFormatter;
import com.egen.util.logger.Logging;
import com.egen.util.text.FormatNumber;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;

public class CodeFormatter {
    private static int PREFERRED_LINE_LENGTH = 1000;
    private static int LINE_LENGTH_DEVIATION = 2;
    private static int SPACE_INDENTATION = 2;
    private static int ENCODE = 2;

    public static String format(String code, Generator generator) {
        if (generator != null) {
            Project project = generator.getProject();
            CodeFormatter.setLINE_LENGTH_DEVIATION(2);
            CodeFormatter.setPREFERRED_LINE_LENGTH(FormatNumber.parseInt((String)project.getFormatter_lineLength()));
            CodeFormatter.setSPACE_INDENTATION(FormatNumber.parseInt((String)project.getFormatter_identation()));
            return CodeFormatter.format(code, project);
        }
        return code;
    }

    public static String format(String code, Project project) {
        String encoding = project.getFormatter_encoding();
        if (encoding == null || encoding.length() == 0) {
            encoding = "ISO-8859-1";
        }
        try {
            JSFormatter formatter = new JSFormatter();
            formatter.setPreferredLineLength(PREFERRED_LINE_LENGTH);
            formatter.setLineLengthDeviation(LINE_LENGTH_DEVIATION);
            formatter.setBracketBreak(project.getFormatter_bracketBreak());
            formatter.setBracketIndent(project.getFormatter_bracketIndent());
            ByteArrayOutputStream out = new ByteArrayOutputStream(code.length());
            formatter.format(new BufferedReader(new StringReader(code)), new PrintWriter(out, true));
            JSBeautifier beautifier = new JSBeautifier();
            code = CodeFormatter.getString(out, encoding);
            out = new ByteArrayOutputStream(code.length());
            beautifier.setSpaceIndentation(SPACE_INDENTATION);
            beautifier.setMaxInStatementIndetation(0);
            beautifier.beautifyReader(new BufferedReader(new StringReader(code)), new PrintWriter(out, true));
            return CodeFormatter.getString(out, encoding);
        }
        catch (Exception e) {
            Logging.log((String)"com.egen.develop.util", (Level)Level.INFO, (String)(CodeFormatter.class.getName() + ".format()[80]."), (Throwable)e);
            return code;
        }
    }

    protected static String getString(ByteArrayOutputStream out, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            return out.toString();
        }
        return out.toString(encoding);
    }

    public static int getPREFERRED_LINE_LENGTH() {
        return PREFERRED_LINE_LENGTH;
    }

    public static void setPREFERRED_LINE_LENGTH(int i) {
        PREFERRED_LINE_LENGTH = i;
    }

    public static int getLINE_LENGTH_DEVIATION() {
        return LINE_LENGTH_DEVIATION;
    }

    public static int getSPACE_INDENTATION() {
        return SPACE_INDENTATION;
    }

    public static void setLINE_LENGTH_DEVIATION(int i) {
        LINE_LENGTH_DEVIATION = i;
    }

    public static void setSPACE_INDENTATION(int i) {
        SPACE_INDENTATION = i;
    }

    public static int getENCODE() {
        return ENCODE;
    }

    public static void setENCODE(int i) {
        ENCODE = i;
    }
}

