/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.resource;

import com.egen.develop.resource.Project;
import com.egen.develop.resource.ToolsDataSource;
import com.egen.develop.util.IOHelper;
import com.egen.util.io.FileIo;
import com.egen.util.io.Xml;
import java.io.IOException;

public class ToolsDataSourceHelper {
    public static void save(ToolsDataSource toolsDataSource, String EnvironmentRootPath) throws IOException, Exception {
        ToolsDataSourceHelper.save(toolsDataSource, EnvironmentRootPath, null);
    }

    public static void save(ToolsDataSource toolsDataSource, String EnvironmentRootPath, Project project) throws IOException, Exception {
        if (EnvironmentRootPath != null && EnvironmentRootPath.length() > 0 && toolsDataSource != null) {
            String egen_source_path;
            String fileName = toolsDataSource.getName() + ".xml";
            if ((fileName = fileName.replaceAll(" ", "")).startsWith("jdbc/")) {
                fileName = fileName.substring("jdbc/".length());
            }
            String individualFile = EnvironmentRootPath + "/resource/datasources/" + fileName;
            StringBuffer xml_file = new StringBuffer();
            xml_file.append("<?xml version=\"1.0\"?>\n");
            xml_file.append("<ToolsDataSource>\n");
            xml_file.append(Xml.writeXml((Object)toolsDataSource, null));
            xml_file.append("</ToolsDataSource>\n");
            FileIo.write((String)individualFile, (String)xml_file.toString());
            if (project != null && (egen_source_path = project.getEgen_source_path()) != null && egen_source_path.length() > 0) {
                String resourcePath = egen_source_path + "/resource/datasources/";
                resourcePath = IOHelper.correctFileSeparator(resourcePath);
                String projectIndividualFile = resourcePath + fileName;
                FileIo.write((String)projectIndividualFile, (String)xml_file.toString());
            }
        }
    }

    public static void delete(ToolsDataSource toolsDataSource, String EnvironmentRootPath, Project project) throws IOException, Exception {
        if (EnvironmentRootPath != null && EnvironmentRootPath.length() > 0 && toolsDataSource != null && project != null) {
            String fileName = toolsDataSource.getName() + ".xml";
            if ((fileName = fileName.replaceAll(" ", "")).startsWith("jdbc/")) {
                fileName = fileName.substring("jdbc/".length());
            }
            String individualFile = EnvironmentRootPath + "/resource/datasources/" + fileName;
            FileIo.delete((String)individualFile);
            String egen_source_path = project.getEgen_source_path();
            if (egen_source_path != null && egen_source_path.length() > 0) {
                String resourcePath = egen_source_path + "/resource/datasources/";
                resourcePath = IOHelper.correctFileSeparator(resourcePath);
                String projectIndividualFile = resourcePath + fileName;
                FileIo.delete((String)projectIndividualFile);
            }
        }
    }
}

