/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.resource;

import com.egen.develop.resource.Project;
import com.egen.develop.resource.ToolsDataSource;
import com.egen.develop.resource.ToolsDataSourceHelper;
import com.egen.develop.util.IOHelper;
import com.egen.util.io.FileIo;
import com.egen.util.io.Xml;
import com.egen.util.logger.Logging;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;

public class ToolsDataSourceEnvironment {
    private ArrayList toolsDataSources = new ArrayList();

    private ToolsDataSourceEnvironment() {
    }

    private static ToolsDataSourceEnvironment parseXml(String file) {
        ToolsDataSourceEnvironment dataSourceEnvironment = new ToolsDataSourceEnvironment();
        if (file != null && file.length() > 0) {
            try {
                dataSourceEnvironment = (ToolsDataSourceEnvironment)Xml.readXml((Object)dataSourceEnvironment, (String)file);
            }
            catch (Exception e) {
                Logging.log((String)"com.egen.develop.dbobj", (Level)Level.INFO, (String)(ToolsDataSourceEnvironment.class.getName() + ".getInstance()[68]."), (Throwable)e);
            }
        }
        return dataSourceEnvironment;
    }

    public static ToolsDataSourceEnvironment newInstance(String EnvironmentRootPath) throws Exception {
        String datasourcesFilePath;
        File datasourcesFile;
        ArrayList files;
        ToolsDataSourceEnvironment toolsDataSourceEnviroment = new ToolsDataSourceEnvironment();
        String individualFilesDirPath = EnvironmentRootPath + "/resource/datasources";
        File individualFilesDir = new File(individualFilesDirPath = IOHelper.correctFileSeparator(individualFilesDirPath));
        if (individualFilesDir.exists() && (files = IOHelper.retrieveFileList(individualFilesDirPath, null, "xml", null, true)) != null) {
            for (int i = 0; i < files.size(); ++i) {
                String item = (String)files.get(i);
                String xml = FileIo.read((String)item);
                if (xml == null || xml.indexOf("<ToolsDataSource>") == -1) continue;
                ToolsDataSource toolsDataSource = new ToolsDataSource();
                if ((toolsDataSource = (ToolsDataSource)Xml.readXml((Object)toolsDataSource, (String)xml)) == null) continue;
                toolsDataSourceEnviroment.addToolsDataSource(toolsDataSource);
            }
        }
        if ((datasourcesFile = new File(datasourcesFilePath = EnvironmentRootPath + "/resource/DataSources.xml")).exists()) {
            String xml = FileIo.read((String)datasourcesFilePath);
            xml = xml.replaceAll("dbobj", "resource");
            ToolsDataSourceEnvironment oldToolsDataSourceEnviroment = new ToolsDataSourceEnvironment();
            ArrayList datasources = (oldToolsDataSourceEnviroment = (ToolsDataSourceEnvironment)Xml.readXml((Object)oldToolsDataSourceEnviroment, (String)xml)).getToolsDataSources();
            if (datasources != null) {
                for (int i = 0; i < datasources.size(); ++i) {
                    ToolsDataSource toolsDataSource = (ToolsDataSource)datasources.get(i);
                    String name = toolsDataSource.getName();
                    if (name != null && name.indexOf(" ") != -1) {
                        name = name.replaceAll(" ", "");
                        toolsDataSource.setName(name);
                    }
                    toolsDataSourceEnviroment.addToolsDataSource(toolsDataSource);
                    ToolsDataSourceHelper.save(toolsDataSource, EnvironmentRootPath);
                }
                datasourcesFile.delete();
            }
        }
        return toolsDataSourceEnviroment;
    }

    public static ToolsDataSourceEnvironment newInstance(Project project) throws Exception {
        ToolsDataSourceEnvironment dataSourceEnvironment = null;
        if (project != null) {
            dataSourceEnvironment = ToolsDataSourceEnvironment.newInstance(project.getHome_path());
        }
        return dataSourceEnvironment;
    }

    public ArrayList getToolsDataSources() {
        return this.toolsDataSources;
    }

    public void setToolsDataSources(ArrayList list) {
        this.toolsDataSources = list;
    }

    public ToolsDataSource getToolsDataSource(String NAME) {
        if (this.toolsDataSources != null) {
            for (int i = 0; i < this.toolsDataSources.size(); ++i) {
                ToolsDataSource item = (ToolsDataSource)this.toolsDataSources.get(i);
                if (item == null || !item.getName().equalsIgnoreCase(NAME)) continue;
                return item;
            }
        }
        return null;
    }

    public void addToolsDataSource(ToolsDataSource toolsDataSource) {
        if (this.toolsDataSources == null) {
            this.toolsDataSources = new ArrayList();
        }
        this.toolsDataSources.add(toolsDataSource);
    }

    public void editToolsDataSource(ToolsDataSource toolsDataSource) {
        for (int i = 0; i < this.toolsDataSources.size(); ++i) {
            ToolsDataSource table = (ToolsDataSource)this.toolsDataSources.get(i);
            if (table == null || !table.getName().equalsIgnoreCase(toolsDataSource.getName())) continue;
            this.toolsDataSources.set(i, toolsDataSource);
        }
    }

    public void delToolsDataSource(String NAME) {
        if (this.toolsDataSources != null) {
            for (int i = 0; i < this.toolsDataSources.size(); ++i) {
                ToolsDataSource table = (ToolsDataSource)this.toolsDataSources.get(i);
                if (table == null || !table.getName().equalsIgnoreCase(NAME)) continue;
                this.toolsDataSources.remove(i);
                return;
            }
        }
    }
}

