/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.resource;

import com.egen.develop.resource.ResourceProperty;
import com.egen.develop.util.PropertyHelper;
import java.util.ArrayList;

public class ResourceProperties {
    private String locale;
    private String folder;
    private String file;
    private ArrayList properties = new ArrayList();

    public static ResourceProperties getInstance(String FOLDER, String FILE) throws Exception {
        ResourceProperties instance = new ResourceProperties();
        instance.setFolder(FOLDER);
        instance.setFile(FILE);
        ArrayList[] properties = PropertyHelper.propertyList(FOLDER, FILE);
        if (properties != null && properties.length > 1) {
            ArrayList keys = properties[0];
            ArrayList values = properties[1];
            if (keys != null && values != null) {
                for (int i = 0; i < keys.size(); ++i) {
                    ResourceProperty item = new ResourceProperty();
                    item.setKey((String)keys.get(i));
                    item.setValue((String)values.get(i));
                    instance.addProperty(item);
                }
            }
        }
        return instance;
    }

    public void save() throws Exception {
        ArrayList[] list = null;
        if (this.properties != null) {
            list = new ArrayList[2];
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < this.properties.size(); ++i) {
                ResourceProperty item = (ResourceProperty)this.properties.get(i);
                keys.add(item.getKey());
                values.add(item.getValue());
            }
            list[0] = keys;
            list[1] = values;
        }
        if (list != null && this.folder != null && this.file != null) {
            PropertyHelper.save(list, this.folder, this.file);
        }
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public ArrayList getProperties() {
        if (this.properties != null) {
            for (int i = 0; i < this.properties.size(); ++i) {
                ResourceProperty item = (ResourceProperty)this.properties.get(i);
                item.assignParent(this);
            }
        }
        return this.properties;
    }

    public void setProperties(ArrayList OptionProperties) {
        if (OptionProperties != null) {
            for (int i = 0; i < OptionProperties.size(); ++i) {
                ResourceProperty item = (ResourceProperty)OptionProperties.get(i);
                item.assignParent(this);
            }
        }
        this.properties = OptionProperties;
    }

    public void deleteOptionProperty(String key, String value) {
        if (this.properties != null) {
            for (int i = 0; i < this.properties.size(); ++i) {
                ResourceProperty item = (ResourceProperty)this.properties.get(i);
                if (key == null || !key.equals(item.getKey()) || value == null || !value.equals(item.getValue())) continue;
                this.properties.remove(i);
                break;
            }
        }
    }

    public void shiftOptionProperty(ResourceProperty Property2, int newPosition) {
        if (this.properties != null && Property2 != null) {
            String key = Property2.getKey();
            String value = Property2.getValue();
            for (int i = 0; i < this.properties.size(); ++i) {
                ResourceProperty item = (ResourceProperty)this.properties.get(i);
                if (key == null || !key.equals(item.getKey()) || value == null || !value.equals(item.getValue())) continue;
                ResourceProperty newItem = new ResourceProperty();
                newItem.setKey(key);
                newItem.setValue(value);
                newItem.assignParent(this);
                this.properties.remove(i);
                this.properties.add(newPosition, newItem);
                break;
            }
        }
    }

    public void addProperty(ResourceProperty optionProperty) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        if (optionProperty != null) {
            optionProperty.assignParent(this);
        }
        this.properties.add(optionProperty);
    }
}

