/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.resource;

import com.egen.develop.resource.Project;
import com.egen.develop.resource.Property;
import com.egen.develop.util.IOHelper;
import com.egen.util.io.FileIo;
import com.egen.util.io.Xml;
import com.egen.util.logger.Logging;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;

public class PropertyEnvironment
implements Serializable {
    private Vector properties = new Vector();

    public String toXml() {
        StringBuffer txt = new StringBuffer();
        if (this.properties != null && this.properties.size() > 0) {
            txt.append("<properties>\n");
            for (int i = 0; i < this.properties.size(); ++i) {
                Property property = (Property)this.properties.elementAt(i);
                txt.append("  <properties_item>\n");
                txt.append(property.toXml());
                txt.append("  </properties_item>\n");
            }
            txt.append("</properties>\n");
        } else {
            txt.append("<properties></properties>\n");
        }
        return txt.toString();
    }

    public void writeXml(String arq) throws IOException, Exception {
        String file = arq;
        BufferedWriter buf = FileIo.getBuffer((String)file);
        StringBuffer xml_file = new StringBuffer();
        xml_file.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        xml_file.append("<PropertyEnvironment>\n");
        xml_file.append(this.toXml());
        xml_file.append("</PropertyEnvironment>\n");
        buf.write(xml_file.toString());
        buf.close();
    }

    public void setProperties(Vector Properties2) {
        this.properties = Properties2;
    }

    public Vector getProperties() {
        return this.properties;
    }

    public void addProperty(Property Property2) {
        for (int i = 0; i < this.properties.size(); ++i) {
            Property property = (Property)this.properties.elementAt(i);
            if (property == null || !property.getLabel().equalsIgnoreCase(Property2.getLabel())) continue;
            this.properties.setElementAt(Property2, i);
            return;
        }
        this.properties.addElement(Property2);
    }

    public void delProperty(Property Property2) {
        for (int i = 0; i < this.properties.size(); ++i) {
            Property property = (Property)this.properties.elementAt(i);
            if (property == null || !property.getLabel().equalsIgnoreCase(Property2.getLabel())) continue;
            this.properties.removeElementAt(i);
            return;
        }
    }

    public Property getLabel(String NAME) {
        for (int i = 0; i < this.properties.size(); ++i) {
            Property property = (Property)this.properties.elementAt(i);
            if (property == null || !property.getLabel().equalsIgnoreCase(NAME)) continue;
            return property;
        }
        return null;
    }

    public static Vector getValues(Project project, String File2) throws Exception {
        Vector<String> values = new Vector<String>();
        String tools_home = project.getHome_path();
        String resourceFile = tools_home + File2;
        String xml = FileIo.read((String)(resourceFile = IOHelper.correctFileSeparator(resourceFile)));
        if (xml != null) {
            PropertyEnvironment propertyEnviroment = new PropertyEnvironment();
            try {
                propertyEnviroment = (PropertyEnvironment)Xml.readXml((Object)propertyEnviroment, (String)xml);
            }
            catch (Exception e) {
                Logging.log((String)"com.egen.develop.generator.resource", (Level)Level.INFO, (String)(PropertyEnvironment.class.getName() + ".getValues()[158]."), (Throwable)e);
            }
            Vector properties = propertyEnviroment.getProperties();
            for (int i = 0; i < properties.size(); ++i) {
                Property property = (Property)properties.elementAt(i);
                String value = property.getValue();
                values.addElement(value);
            }
        }
        return values;
    }

    public static Vector getLabels(Project project, String File2) throws Exception {
        Vector<String> values = new Vector<String>();
        String tools_home = project.getHome_path();
        String resourceFile = tools_home + File2;
        String xml = FileIo.read((String)(resourceFile = IOHelper.correctFileSeparator(resourceFile)));
        if (xml != null) {
            PropertyEnvironment propertyEnviroment = new PropertyEnvironment();
            try {
                propertyEnviroment = (PropertyEnvironment)Xml.readXml((Object)propertyEnviroment, (String)xml);
            }
            catch (Exception e) {
                Logging.log((String)"com.egen.develop.generator.resource", (Level)Level.INFO, (String)(PropertyEnvironment.class.getName() + ".getLabels()[181]."), (Throwable)e);
            }
            Vector properties = propertyEnviroment.getProperties();
            for (int i = 0; i < properties.size(); ++i) {
                Property property = (Property)properties.elementAt(i);
                String label = property.getLabel();
                values.addElement(label);
            }
        }
        return values;
    }

    public static HashMap getResource(Project project, String File2) throws Exception {
        HashMap<String, String> attributes = new HashMap<String, String>();
        String tools_home = project.getHome_path();
        String resourceFile = tools_home + File2;
        String xml = FileIo.read((String)(resourceFile = IOHelper.correctFileSeparator(resourceFile)));
        if (xml != null) {
            PropertyEnvironment propertyEnviroment = new PropertyEnvironment();
            try {
                propertyEnviroment = (PropertyEnvironment)Xml.readXml((Object)propertyEnviroment, (String)xml);
            }
            catch (Exception e) {
                Logging.log((String)"com.egen.develop.generator.resource", (Level)Level.INFO, (String)(PropertyEnvironment.class.getName() + ".getResource()[204]."), (Throwable)e);
            }
            Vector properties = propertyEnviroment.getProperties();
            for (int i = 0; i < properties.size(); ++i) {
                Property property = (Property)properties.elementAt(i);
                attributes.put(property.getValue(), property.getLabel());
            }
        }
        return attributes;
    }

    public static Vector getString(String file) {
        Vector<String[][]> ret = new Vector<String[][]>();
        String xml = "";
        String s = "";
        try {
            BufferedReader arq = new BufferedReader(new FileReader(file));
            while ((s = arq.readLine()) != null) {
                xml = xml + s + "\n";
            }
        }
        catch (Exception e) {
            Logging.log((String)"com.egen.develop.generator.resource", (Level)Level.INFO, (String)(PropertyEnvironment.class.getName() + ".getString()[227]."), (Throwable)e);
        }
        PropertyEnvironment propertyEnviroment = new PropertyEnvironment();
        try {
            propertyEnviroment = (PropertyEnvironment)Xml.readXml((Object)propertyEnviroment, (String)xml);
        }
        catch (Exception e) {
            Logging.log((String)"com.egen.develop.generator.resource", (Level)Level.INFO, (String)(PropertyEnvironment.class.getName() + ".getString()[233]."), (Throwable)e);
        }
        Vector properties = propertyEnviroment.getProperties();
        for (int i = 0; i < properties.size(); ++i) {
            Property property = (Property)properties.elementAt(i);
            String[][] text = new String[][]{{property.getLabel()}, {property.getValue()}};
            ret.addElement(text);
        }
        return ret;
    }
}

