/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.resource;

import com.egen.develop.resource.Project;
import com.egen.develop.util.IOHelper;
import com.egen.util.io.FileIo;
import java.io.IOException;
import java.util.ArrayList;

public class ProjectHelper {
    public static ArrayList retrieveModules(Project project) {
        ArrayList modules = new ArrayList();
        if (project != null && (modules = IOHelper.retrieveDirList(project.getEgen_source_path() + "/META-INFO/")) != null && modules.contains("CVS")) {
            for (int i = 0; i < modules.size(); ++i) {
                if (!((String)modules.get(i)).equals("CVS")) continue;
                modules.remove(i);
                break;
            }
        }
        return modules;
    }

    public static ArrayList retrieveMetainfoFiles(Project project, String module) {
        ArrayList files = new ArrayList();
        if (project != null) {
            files = IOHelper.retrieveFileList(project.getEgen_source_path() + "/META-INFO", module, "xml", null, true);
        }
        return files;
    }

    public static ArrayList retrieveMetainfoFilesNames(Project project, String module) {
        ArrayList<String> filesNames = new ArrayList<String>();
        ArrayList files = ProjectHelper.retrieveMetainfoFiles(project, module);
        if (files != null) {
            for (int i = 0; i < files.size(); ++i) {
                String x = (String)files.get(i);
                x = x.lastIndexOf("\\") == -1 ? x.substring(x.lastIndexOf("/") + 1) : x.substring(x.lastIndexOf("\\") + 1);
                filesNames.add(x);
            }
        }
        return filesNames;
    }

    public static ArrayList retrieveMetainfoFilesNames(ArrayList files) {
        ArrayList<String> filesNames = new ArrayList<String>();
        if (files != null) {
            for (int i = 0; i < files.size(); ++i) {
                String x = (String)files.get(i);
                x = x.lastIndexOf("\\") == -1 ? x.substring(x.lastIndexOf("/") + 1) : x.substring(x.lastIndexOf("\\") + 1);
                filesNames.add(x);
            }
        }
        return filesNames;
    }

    public static void saveProject(Project project, String EnvironmentRootPath) throws IOException, Exception {
        if (project != null && EnvironmentRootPath != null && EnvironmentRootPath.length() > 0 && project != null) {
            String fileName = project.getName() + ".xml";
            fileName = fileName.replaceAll(" ", "");
            String file = EnvironmentRootPath + "/resource/projects/" + fileName;
            StringBuffer xml_file = new StringBuffer();
            xml_file.append("<?xml version=\"1.0\"?>\n");
            xml_file.append("<Project>\n");
            xml_file.append(project.toXml());
            xml_file.append("</Project>\n");
            FileIo.write((String)file, (String)xml_file.toString());
            String egen_source_path = project.getEgen_source_path();
            if (egen_source_path != null && egen_source_path.length() > 0) {
                String resourcePath = egen_source_path + "/resource/projects/";
                resourcePath = IOHelper.correctFileSeparator(resourcePath);
                String individualFile = resourcePath + fileName;
                FileIo.write((String)individualFile, (String)xml_file.toString());
            }
        }
    }

    public static void deleteProject(Project project, String EnvironmentRootPath) throws IOException, Exception {
        if (EnvironmentRootPath != null && EnvironmentRootPath.length() > 0 && project != null) {
            String fileName = project.getName() + ".xml";
            fileName = fileName.replaceAll(" ", "");
            String file = EnvironmentRootPath + "/resource/projects/" + fileName;
            FileIo.delete((String)file);
            String egen_source_path = project.getEgen_source_path();
            if (egen_source_path != null && egen_source_path.length() > 0) {
                String resourcePath = egen_source_path + "/resource/projects/";
                resourcePath = IOHelper.correctFileSeparator(resourcePath);
                String individualFile = resourcePath + fileName;
                FileIo.delete((String)individualFile);
            }
        }
    }
}

