/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.resource;

import com.egen.develop.resource.Project;
import com.egen.develop.resource.ProjectHelper;
import com.egen.develop.util.IOHelper;
import com.egen.util.io.FileIo;
import com.egen.util.io.Xml;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;

public class ProjectEnviroment
implements Serializable {
    private Vector projects = new Vector();

    private ProjectEnviroment() {
    }

    public static ProjectEnviroment newInstance(String EnvironmentRootPath) throws Exception {
        Project project;
        ArrayList files;
        int i;
        ProjectEnviroment projectEnviroment = new ProjectEnviroment();
        ProjectEnviroment defaultProjectEnviroment = new ProjectEnviroment();
        String projectsFilePath = EnvironmentRootPath + "/resource/projects.xml";
        File projectsFile = new File(projectsFilePath);
        if (defaultProjectEnviroment != null) {
            String confPath = projectsFilePath.substring(0, projectsFilePath.lastIndexOf("resource"));
            confPath = confPath + "config/";
            projectsFilePath = confPath + "DefaultProjects.xml";
            String xml = FileIo.read((String)(projectsFilePath = IOHelper.correctFileSeparator(projectsFilePath)));
            Vector projects = (defaultProjectEnviroment = (ProjectEnviroment)Xml.readXml((Object)defaultProjectEnviroment, (String)xml)).getProjects();
            if (projects != null) {
                for (i = 0; i < projects.size(); ++i) {
                    projectEnviroment.addProject((Project)projects.get(i));
                }
            }
        }
        String individualFilesDirPath = EnvironmentRootPath + "/resource/projects";
        File individualFilesDir = new File(individualFilesDirPath = IOHelper.correctFileSeparator(individualFilesDirPath));
        if (individualFilesDir.exists() && (files = IOHelper.retrieveFileList(individualFilesDirPath, null, "xml", null, true)) != null) {
            for (i = 0; i < files.size(); ++i) {
                String projectFile = (String)files.get(i);
                String xml = FileIo.read((String)projectFile);
                if (xml == null || xml.indexOf("com.egen.develop.resource.Project") == -1) continue;
                project = new Project();
                if ((project = (Project)Xml.readXml((Object)project, (String)xml)) == null) continue;
                projectEnviroment.addProject(project);
            }
        }
        if (projectsFile.exists()) {
            String xml = FileIo.read((String)projectsFilePath);
            ProjectEnviroment oldProjectEnviroment = new ProjectEnviroment();
            Vector projects = (oldProjectEnviroment = (ProjectEnviroment)Xml.readXml((Object)oldProjectEnviroment, (String)xml)).getProjects();
            if (projects != null) {
                for (int i2 = 0; i2 < projects.size(); ++i2) {
                    project = (Project)projects.elementAt(i2);
                    String name = project.getName();
                    if (name != null && name.indexOf(" ") != -1) {
                        name = name.replaceAll(" ", "");
                        project.setName(name);
                    }
                    projectEnviroment.addProject(project);
                    ProjectHelper.saveProject(project, individualFilesDirPath);
                }
                projectsFile.delete();
            }
        }
        if (projectEnviroment == null || projectEnviroment.getProjects() == null || projectEnviroment.getProjects().size() == 0) {
            projectEnviroment = defaultProjectEnviroment;
        }
        return projectEnviroment;
    }

    public String toXml() {
        StringBuffer txt = new StringBuffer();
        if (this.projects != null && this.projects.size() > 0) {
            txt.append("<projects>\n");
            for (int i = 0; i < this.projects.size(); ++i) {
                Project project = (Project)this.projects.elementAt(i);
                txt.append("<projects_item>\n");
                txt.append(project.toXml());
                txt.append("</projects_item>\n");
            }
            txt.append("</projects>\n");
        } else {
            txt.append("<projects></projects>\n");
        }
        return txt.toString();
    }

    public void writeXml(String FILE) throws IOException, Exception {
        String file = FILE;
        BufferedWriter buf = FileIo.getBuffer((String)file);
        StringBuffer xml_file = new StringBuffer();
        xml_file.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        xml_file.append("<ProjectEnviroment>\n");
        xml_file.append(this.toXml());
        xml_file.append("</ProjectEnviroment>\n");
        buf.write(xml_file.toString());
        buf.close();
    }

    public void setProjects(Vector Projects) {
        this.projects = Projects;
    }

    public Vector getProjects() {
        return this.projects;
    }

    public void addProject(Project Project2) {
        if (this.projects == null) {
            this.projects = new Vector();
        }
        for (int i = 0; i < this.projects.size(); ++i) {
            Project project = (Project)this.projects.elementAt(i);
            if (project == null || !project.getName().equalsIgnoreCase(Project2.getName())) continue;
            this.projects.setElementAt(Project2, i);
            return;
        }
        this.projects.addElement(Project2);
    }

    public void delProject(Project Project2) {
        if (this.projects != null) {
            for (int i = 0; i < this.projects.size(); ++i) {
                Project project = (Project)this.projects.elementAt(i);
                if (project == null || !project.getName().equalsIgnoreCase(Project2.getName())) continue;
                this.projects.removeElementAt(i);
                return;
            }
        }
    }

    public Project getProject(String NAME) {
        if (this.projects != null) {
            for (int i = 0; i < this.projects.size(); ++i) {
                Project project = (Project)this.projects.elementAt(i);
                if (project == null || !project.getName().equalsIgnoreCase(NAME)) continue;
                return project;
            }
        }
        return null;
    }
}

