/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.resource;

import com.egen.develop.resource.DeploymentProfile;
import com.egen.develop.resource.Project;
import com.egen.develop.util.AntHelper;
import com.egen.develop.util.IOHelper;
import com.egen.util.io.FileIo;
import com.egen.util.io.Xml;
import java.io.BufferedWriter;
import java.io.File;
import java.util.ArrayList;

public class DeploymentProfileHelper {
    private DeploymentProfileHelper() {
    }

    public static void runDeploy(DeploymentProfile deploymentProfile, Project project) throws Exception {
        File file;
        String antBuildFile = deploymentProfile.getAntBuildFile();
        String antTarget = deploymentProfile.getAntTarget();
        if (antBuildFile != null && antBuildFile.length() > 0 && antTarget != null && antTarget.length() > 0 && project != null && (file = new File(antBuildFile)).exists()) {
            String[][] params = new String[][]{{"workingDirectory", deploymentProfile.getWorkingDirectory()}, {"archiveName", deploymentProfile.getArchiveName()}, {"excludedResources", deploymentProfile.getExcludedResources()}, {"tranferType", deploymentProfile.getTransferType()}, {"remoteAddress", deploymentProfile.getRemoteAddress()}, {"remotePort", deploymentProfile.getRemotePort()}, {"remoteDirectory", deploymentProfile.getRemoteDirectory()}, {"remoteUser", deploymentProfile.getRemoteUser()}, {"remoteUserPassword", deploymentProfile.getRemoteUserPassword()}, {"html_path", project.getHtml_path()}};
            AntHelper.run(antBuildFile, antTarget, params);
        }
    }

    public static ArrayList listFiles(Project project) throws Exception {
        String dir;
        ArrayList list;
        ArrayList<String> fileList = null;
        if (project != null && (list = IOHelper.retrieveFileList(dir = DeploymentProfileHelper.retrieveFolder(project), null, ".xml", null, true)) != null) {
            fileList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                String item = (String)list.get(i);
                if (item.indexOf(".") == -1) continue;
                fileList.add(item);
            }
        }
        return fileList;
    }

    public static ArrayList listNames(Project project) throws Exception {
        ArrayList list;
        ArrayList<String> nameList = null;
        if (project != null && (list = DeploymentProfileHelper.listFiles(project)) != null) {
            nameList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                String item = (String)list.get(i);
                if (item.indexOf(".") == -1) continue;
                if ((item = item.substring(0, item.lastIndexOf("."))).indexOf("\\") != -1) {
                    item = item.substring(item.lastIndexOf("\\") + 1);
                } else if (item.indexOf("/") != -1) {
                    item = item.substring(item.lastIndexOf("/") + 1);
                }
                nameList.add(item);
            }
        }
        return nameList;
    }

    private static String retrieveFolder(Project project) throws Exception {
        String folder = null;
        if (project != null) {
            folder = project.getSource_path();
            if (!folder.endsWith("/") && !folder.endsWith("\\")) {
                folder = folder + "/";
            }
            folder = folder + "deploymentProfile/";
        }
        folder = IOHelper.correctFileSeparator(folder);
        return folder;
    }

    private static String retrieveFileName(DeploymentProfile deploymentProfile, Project project) throws Exception {
        String name = null;
        if (deploymentProfile != null && project != null && deploymentProfile.getDeploymentProfileName() != null) {
            String folder = DeploymentProfileHelper.retrieveFolder(project);
            if (!folder.endsWith("/") && !folder.endsWith("\\")) {
                folder = folder + "/";
            }
            folder = IOHelper.correctFileSeparator(folder);
            name = folder + deploymentProfile.getDeploymentProfileName() + ".xml";
        }
        return name;
    }

    public static void save(DeploymentProfile deploymentProfile, Project project) throws Exception {
        if (deploymentProfile != null && project != null) {
            String xml = Xml.writeXml((Object)deploymentProfile, null);
            String file = DeploymentProfileHelper.retrieveFileName(deploymentProfile, project);
            File f = new File(file);
            if (!f.exists()) {
                File dir = new File(f.getParent());
                dir.mkdirs();
            }
            if (xml != null) {
                BufferedWriter buf = FileIo.getBuffer((String)file);
                buf.write(xml);
                buf.close();
            }
        }
    }

    public static void delete(DeploymentProfile deploymentProfile, Project project) throws Exception {
        String file;
        File f;
        if (deploymentProfile != null && project != null && (f = new File(file = DeploymentProfileHelper.retrieveFileName(deploymentProfile, project))).exists()) {
            f.delete();
        }
    }

    public static void load(DeploymentProfile deploymentProfile, Project project) throws Exception {
        String xml;
        String fileName;
        File f;
        if (deploymentProfile != null && project != null && (f = new File(fileName = DeploymentProfileHelper.retrieveFileName(deploymentProfile, project))).exists() && (xml = FileIo.read((String)fileName)) != null) {
            deploymentProfile = (DeploymentProfile)Xml.readXml((Object)deploymentProfile, (String)xml);
        }
    }

    public static DeploymentProfile load(String fileName) throws Exception {
        String xml;
        File f;
        DeploymentProfile deploymentProfile = null;
        if (fileName != null && fileName.length() > 0 && fileName.indexOf(".") != -1 && (f = new File(fileName)).exists() && (xml = FileIo.read((String)fileName)) != null) {
            deploymentProfile = new DeploymentProfile();
            deploymentProfile = (DeploymentProfile)Xml.readXml((Object)deploymentProfile, (String)xml);
        }
        return deploymentProfile;
    }

    public static ArrayList list(Project project) throws Exception {
        ArrayList files;
        ArrayList<DeploymentProfile> elements = null;
        if (project != null && (files = DeploymentProfileHelper.listFiles(project)) != null) {
            elements = new ArrayList<DeploymentProfile>();
            for (int i = 0; i < files.size(); ++i) {
                String fileName = (String)files.get(i);
                DeploymentProfile deploymentProfile = DeploymentProfileHelper.load(fileName);
                if (deploymentProfile == null) continue;
                elements.add(deploymentProfile);
            }
        }
        return elements;
    }
}

