/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.process;

import com.egen.develop.process.Process;
import com.egen.develop.resource.Project;
import com.egen.develop.util.IOHelper;
import com.egen.util.io.FileIo;
import com.egen.util.io.Xml;
import com.egen.util.logger.Logging;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;

public class ApplicationProcesses {
    private ArrayList processes = new ArrayList();

    public String toXml() {
        StringBuffer txt = new StringBuffer("");
        if (this.processes != null && this.processes.size() > 0) {
            txt.append("<processes>\n");
            for (int i = 0; i < this.processes.size(); ++i) {
                Process process = (Process)this.processes.get(i);
                txt.append("<processes_item>\n");
                txt.append(process.toXml(i));
                txt.append("</processes_item>\n");
            }
            txt.append("</processes>\n");
        } else {
            txt.append("<processes></processes>\n");
        }
        return txt.toString();
    }

    public void writeXml(String file_path) throws IOException, Exception {
        BufferedWriter buf = FileIo.getBuffer((String)file_path);
        StringBuffer xml_file = new StringBuffer("");
        xml_file.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        xml_file.append("<ApplicationProcesss>\n");
        xml_file.append(this.toXml());
        xml_file.append("</ApplicationProcesss>\n");
        buf.write(xml_file.toString());
        buf.close();
    }

    public ArrayList getProcesses() {
        if (this.processes != null) {
            for (int i = 0; i < this.processes.size(); ++i) {
                Process process = (Process)this.processes.get(i);
                process.setId(i);
                this.processes.set(i, process);
            }
        }
        return this.processes;
    }

    public void setProcesses(ArrayList list) {
        this.processes = list;
    }

    public void addProcess(Process process) {
        this.processes.add(process);
    }

    public Process getProcess(String name) {
        if (this.processes != null) {
            for (int i = 0; i < this.processes.size(); ++i) {
                Process process = (Process)this.processes.get(i);
                if (!process.getName().equals(name)) continue;
                process.setId(i);
                return (Process)this.processes.get(i);
            }
        }
        return null;
    }

    public Process getProcess(int i) {
        if (this.processes != null && this.processes.size() > i) {
            return (Process)this.processes.get(i);
        }
        return null;
    }

    public void setProcess(Process item) {
        if (this.processes != null) {
            for (int i = 0; i < this.processes.size(); ++i) {
                Process process = (Process)this.processes.get(i);
                if (!process.getName().equals(item.getName())) continue;
                this.processes.set(i, item);
            }
        }
    }

    public void setProcess(int i, Process item) {
        if (this.processes != null && this.processes.size() > i) {
            this.processes.set(i, item);
        }
    }

    public void removeProcess(Process item) {
        if (this.processes != null) {
            for (int i = 0; i < this.processes.size(); ++i) {
                Process process = (Process)this.processes.get(i);
                if (!process.getName().equals(item.getName())) continue;
                this.processes.remove(i);
            }
        }
    }

    public void removeProcess(int i) {
        if (this.processes != null && this.processes.size() > i) {
            this.processes.remove(i);
        }
    }

    public static ApplicationProcesses getInstance(Project project) throws Exception {
        ApplicationProcesses applicationProcess;
        block5: {
            applicationProcess = new ApplicationProcesses();
            if (project != null) {
                String fileName = project.getEgen_source_path();
                fileName = IOHelper.correctFileSeparator(fileName);
                fileName = fileName + "application_processes.xml";
                try {
                    File file = new File(fileName);
                    if (file.exists()) {
                        String xml = FileIo.read((String)fileName);
                        applicationProcess = (ApplicationProcesses)Xml.readXml((Object)applicationProcess, (String)xml);
                        break block5;
                    }
                    applicationProcess = new ApplicationProcesses();
                    applicationProcess.writeXml(fileName);
                }
                catch (Exception e) {
                    Logging.log((String)"com.egen.develop.generator.process", (Level)Level.INFO, (String)(ApplicationProcesses.class.getName() + ".getInstance()[171]."), (Throwable)e);
                }
            } else {
                throw new Exception("NoProjectInSession");
            }
        }
        return applicationProcess;
    }

    public void save(ApplicationProcesses applicationProcess, Project project) throws Exception {
        if (project != null) {
            String fileName = project.getEgen_source_path();
            fileName = IOHelper.correctFileSeparator(fileName);
            fileName = fileName + "application_processes.xml";
            applicationProcess.writeXml(fileName);
        }
    }
}

