/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.plugin;

import com.egen.develop.generator.Generator;
import com.egen.develop.generator.form.BaseButton;
import com.egen.develop.generator.report.Column;
import com.egen.develop.plugin.Plugin;
import com.egen.develop.plugin.PluginContainer;
import com.egen.develop.resource.Project;
import com.egen.develop.util.IOHelper;
import com.egen.develop.util.NameConventionHelper;
import com.egen.util.io.FileIo;
import com.egen.util.io.Xml;
import com.egen.util.text.FormatNumber;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class PluginHelper {
    private PluginHelper() {
    }

    public static Plugin load(Plugin Plugin2, Project project) throws Exception {
        PluginContainer container;
        Plugin plugin = Plugin2;
        Class<?> containerClass = Class.forName(Plugin2.getClass().getName() + "Environment");
        Method method = containerClass.getMethod("getInstance", project.getClass());
        if (method != null && (container = (PluginContainer)method.invoke(null, project)) != null) {
            plugin = container.getElement(Plugin2.getName());
        }
        return plugin;
    }

    public static ArrayList list(Project project, String PluginContainerClass) throws Exception {
        PluginContainer container;
        ArrayList plugins = null;
        Class<?> containerClass = Class.forName(PluginContainerClass);
        Method method = containerClass.getMethod("getInstance", project.getClass());
        if (method != null && (container = (PluginContainer)method.invoke(null, project)) != null) {
            plugins = container.getElements();
        }
        return plugins;
    }

    public static void merge(Object object, Plugin plugin) throws Exception {
        Class<?> object_class = object.getClass();
        Field[] class_fields = object_class.getDeclaredFields();
        Method[] methods = object_class.getMethods();
        HashMap<String, Field> object_fields = new HashMap<String, Field>();
        for (int i = 0; i < class_fields.length; ++i) {
            object_fields.put(class_fields[i].getName(), class_fields[i]);
        }
        Class<?> superclass = object_class.getSuperclass();
        while (superclass != null) {
            Field[] super_class_fields = superclass.getDeclaredFields();
            for (int i = 0; i < super_class_fields.length; ++i) {
                object_fields.put(super_class_fields[i].getName(), super_class_fields[i]);
            }
            Class<?> new_superclass = superclass.getSuperclass();
            if (new_superclass == null) break;
            superclass = new_superclass;
        }
        Iterator iterator = object_fields.keySet().iterator();
        while (iterator.hasNext()) {
            String field_name = (String)iterator.next();
            Object plugin_property = plugin.getAttribute(field_name);
            if (plugin_property == null) continue;
            String set_method_name = "set" + NameConventionHelper.toAttributeNameFormat(field_name);
            for (int i = 0; i < methods.length; ++i) {
                Number numeric_paramater;
                Method set_method = methods[i];
                if (!set_method.getName().equals(set_method_name)) continue;
                Class<?> parameter_type = set_method.getParameterTypes()[0];
                String parameter_type_name = parameter_type.getName();
                Object[] parameter = new Object[1];
                if (parameter_type_name.equals("java.lang.String")) {
                    parameter[0] = plugin_property.toString();
                } else if (parameter_type_name.equals("boolean")) {
                    if (plugin_property.toString().equals("true") || plugin_property.toString().equals("false")) {
                        parameter[0] = new Boolean(plugin_property.toString());
                    }
                } else if (parameter_type_name.equals("byte")) {
                    numeric_paramater = FormatNumber.parseByteWrapper((String)plugin_property.toString());
                    if (numeric_paramater != null) {
                        parameter[0] = numeric_paramater;
                    }
                } else if (parameter_type_name.equals("short")) {
                    numeric_paramater = FormatNumber.parseShortWrapper((String)plugin_property.toString());
                    if (numeric_paramater != null) {
                        parameter[0] = numeric_paramater;
                    }
                } else if (parameter_type_name.equals("int")) {
                    numeric_paramater = FormatNumber.parseIntegerWrapper((String)plugin_property.toString());
                    if (numeric_paramater != null) {
                        parameter[0] = numeric_paramater;
                    }
                } else if (parameter_type_name.equals("long")) {
                    numeric_paramater = FormatNumber.parseLongWrapper((String)plugin_property.toString());
                    if (numeric_paramater != null) {
                        parameter[0] = numeric_paramater;
                    }
                } else if (parameter_type_name.equals("float")) {
                    numeric_paramater = FormatNumber.parseFloatWrapper((String)plugin_property.toString());
                    if (numeric_paramater != null) {
                        parameter[0] = numeric_paramater;
                    }
                } else if (parameter_type_name.equals("double")) {
                    numeric_paramater = FormatNumber.parseDoubleWrapper((String)plugin_property.toString());
                    if (numeric_paramater != null) {
                        parameter[0] = numeric_paramater;
                    }
                } else if (parameter_type_name.equals(plugin_property.getClass().getName())) {
                    parameter[0] = plugin_property;
                }
                if (parameter[0] == null) continue;
                set_method.invoke(object, parameter);
            }
        }
    }

    public static void addPlugin(String ident, boolean dynamic, Object elementObject, Project project) throws Exception {
        String name = null;
        String type = null;
        if (ident != null && ident.length() > 0) {
            String[] identification = ident.split("#");
            if (identification.length > 0) {
                name = identification[0];
            }
            if (identification.length > 1) {
                type = identification[1];
            }
        }
        Class<?> pluginClass = Class.forName(type);
        Object pluginObject = pluginClass.newInstance();
        Plugin plugin = null;
        if (pluginObject instanceof Plugin) {
            plugin = (Plugin)pluginObject;
            plugin.setName(name);
            plugin.setDynamic(dynamic);
        }
        if (plugin == null) {
            throw new Exception("e-Gen Error: Invalide Plugin");
        }
        if (elementObject instanceof com.egen.develop.generator.form.Field) {
            com.egen.develop.generator.form.Field element = (com.egen.develop.generator.form.Field)elementObject;
            element.addPlugin(plugin);
            Plugin loaded_plugin = PluginHelper.load(plugin, project);
            PluginHelper.merge(element, loaded_plugin);
        } else if (elementObject instanceof Column) {
            Column element = (Column)elementObject;
            element.addPlugin(plugin);
            Plugin loaded_plugin = PluginHelper.load(plugin, project);
            PluginHelper.merge(element, loaded_plugin);
        } else if (elementObject instanceof BaseButton) {
            BaseButton element = (BaseButton)elementObject;
            element.addPlugin(plugin);
            Plugin loaded_plugin = PluginHelper.load(plugin, project);
            PluginHelper.merge(element, loaded_plugin);
        }
    }

    public static ArrayList list(Project project) throws Exception {
        ArrayList plugins = null;
        Vector listPlugins = PluginHelper.listPlugins(project);
        if (listPlugins != null) {
            for (int i = 0; i < listPlugins.size(); ++i) {
                plugins.add(listPlugins.elementAt(i));
            }
        }
        return plugins;
    }

    public static Vector listPlugins(Project project) throws Exception {
        ArrayList folders;
        Vector elements = new Vector();
        if (project != null && (folders = PluginHelper.retrieveFolders(project)) != null) {
            for (int i = 0; i < folders.size(); ++i) {
                String folder = (String)folders.get(i);
                Vector list = PluginHelper.listPlugins(folder, project);
                elements.addAll(list);
            }
        }
        return elements;
    }

    public static Vector listPlugins(String folder, Project project) throws Exception {
        ArrayList files;
        Vector<Plugin> elements = new Vector<Plugin>();
        if (folder != null && folder.length() > 0 && (files = PluginHelper.listNames(folder)) != null) {
            for (int i = 0; i < files.size(); ++i) {
                Class<?> pluginClass;
                Object object;
                String className;
                String file = (String)files.get(i);
                String xml = FileIo.read((String)(folder + file + ".xml"));
                if (xml == null || xml.indexOf("<class>") == -1 || xml.indexOf("</class>") == -1 || (className = xml.substring(xml.indexOf("<class>") + "<class>".length(), xml.indexOf("</class>"))) == null || className.length() <= 0 || !((object = (pluginClass = Class.forName(className)).newInstance()) instanceof Plugin)) continue;
                Plugin plugin = (Plugin)object;
                plugin = (Plugin)Xml.readXml((Object)plugin, (String)xml);
                plugin.assignProject(project);
                elements.add(plugin);
            }
        }
        return elements;
    }

    private static ArrayList retrieveFolders(Project project) throws Exception {
        String[] files;
        String plugin_files;
        ArrayList<String> folders = new ArrayList<String>();
        if (project != null && (plugin_files = project.getPlugin_files()) != null && plugin_files.length() > 0 && (files = plugin_files.split(",")).length > 0) {
            for (int i = 0; i < files.length; ++i) {
                File pathDir;
                String path = files[i];
                if (path == null) continue;
                if (path.toLowerCase().endsWith(".xml")) {
                    if (path.indexOf("/") != -1) {
                        path = path.substring(0, path.lastIndexOf("/"));
                    } else if (path.indexOf("\\") != -1) {
                        path = path.substring(0, path.lastIndexOf("\\"));
                    }
                }
                if (!path.endsWith("/") && !path.endsWith("\\")) {
                    path = path + "/";
                }
                if (!(pathDir = new File(path)).isDirectory()) continue;
                folders.add(path);
            }
        }
        return folders;
    }

    public static ArrayList listNames(String FOLDER) throws Exception {
        String dir;
        ArrayList list;
        ArrayList<String> nameList = null;
        if (FOLDER != null && FOLDER.length() > 0 && (list = IOHelper.retrieveFileList(dir = PluginHelper.retrieveFileDir(FOLDER), null, ".xml", null, false)) != null) {
            nameList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                String item = (String)list.get(i);
                if (item.indexOf(".") == -1) continue;
                item = item.substring(0, item.lastIndexOf("."));
                nameList.add(item);
            }
        }
        return nameList;
    }

    private static String retrieveFileDir(String FOLDER) throws Exception {
        String dir = FOLDER;
        if (!dir.endsWith("/") && !dir.endsWith("\\")) {
            dir = dir + "/";
        }
        dir = IOHelper.correctFileSeparator(dir);
        return dir;
    }

    public static ArrayList getPluginList(Generator generator) throws Exception {
        Vector plugins;
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        Project project = generator.getProject();
        if (project != null && (plugins = PluginHelper.listPlugins(project)) != null) {
            for (int i = 0; i < plugins.size(); ++i) {
                Plugin plugin = (Plugin)plugins.elementAt(i);
                if (plugin == null) continue;
                list.add(plugin.getName() + "#" + plugin.getClass().getName() + "#" + plugin.getClass().getName() + "Environment");
            }
        }
        return list;
    }

    public static ArrayList getPluginLabelList(ArrayList list) throws Exception {
        ArrayList<String> labelList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            String listItem = (String)list.get(i);
            String[] identification = listItem.split("#");
            if (identification.length > 0) {
                labelList.add(identification[0]);
                continue;
            }
            labelList.add("");
        }
        return labelList;
    }

    public static Vector getPluginLov(Project project, String filter_name, String filter_description) throws Exception {
        Vector plugins;
        Vector<String> list = new Vector<String>();
        list.addElement("");
        if (project != null && (plugins = PluginHelper.listPlugins(project)) != null) {
            for (int i = 0; i < plugins.size(); ++i) {
                Plugin plugin = (Plugin)plugins.elementAt(i);
                if (plugin == null) continue;
                boolean filter = true;
                if (filter_name != null && filter_name.length() > 0 && plugin.getName().indexOf(filter_name) < 0) {
                    filter = false;
                }
                if (filter && filter_description != null && filter_description.length() > 0 && plugin.getDescription().indexOf(filter_description) < 0) {
                    filter = false;
                }
                if (!filter) continue;
                list.addElement("<tr><td><a href=javascript:setPlugin(\"" + plugin.getName() + "#" + plugin.getClass().getName() + "#" + plugin.getClass().getName() + "Environment" + "\")>" + plugin.getName() + "</td><td>" + plugin.getDescription() + "</td></tr>");
            }
        }
        return list;
    }
}

