/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.integration.model;

import com.egen.develop.integration.model.VObject;
import com.egen.develop.integration.model.VObjectColumn;
import com.egen.develop.resource.Project;
import com.egen.develop.util.IOHelper;
import com.egen.util.io.FileIo;
import com.egen.util.io.Xml;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;

public class VObjectHelper {
    public static void save(VObject vObject, Project project) throws Exception {
        String xml;
        String file = VObjectHelper.findFile(vObject, project);
        if (file != null && file.length() > 0 && (xml = Xml.writeXml((Object)vObject, null)) != null) {
            FileIo.write((String)file, (String)xml);
        }
    }

    public static VObject load(String entityName, Project project) throws Exception {
        VObject vObject = null;
        if (entityName != null && project != null) {
            vObject = new VObject();
            vObject.setName(entityName);
            VObjectHelper.load(vObject, project);
        }
        return vObject;
    }

    public static VObject load(VObject vObject, Project project) throws Exception {
        String xml;
        File f;
        String file = VObjectHelper.findFile(vObject, project);
        if (file != null && file.length() > 0 && (f = new File(file)).exists() && (xml = FileIo.read((String)file)) != null && xml.length() > 0) {
            vObject = (VObject)Xml.readXml((Object)vObject, (String)xml);
        }
        return vObject;
    }

    public static VObject delete(VObject vObject, Project project) throws Exception {
        File f;
        String file = VObjectHelper.findFile(vObject, project);
        if (file != null && file.length() > 0 && (f = new File(file)).exists()) {
            f.delete();
        }
        return vObject;
    }

    public static String findPath(Project project) throws Exception {
        String path = null;
        if (project != null) {
            File pathDir;
            path = project.getEgen_source_path();
            if (path != null && !path.endsWith("/") && !path.endsWith("\\")) {
                path = path + "/";
            }
            if (!(pathDir = new File(path = IOHelper.correctFileSeparator(path))).isDirectory()) {
                ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
                throw new Exception(bundle.getString("jsp.sourcepath") + " " + bundle.getString("msg.notfound"));
            }
            path = path + "entities\\";
            pathDir = new File(path = IOHelper.correctFileSeparator(path));
            if (!pathDir.isDirectory()) {
                pathDir.mkdir();
            }
        }
        return path;
    }

    private static String findFile(VObject vObject, Project project) throws Exception {
        String file = null;
        if (project != null && vObject != null && vObject.getName() != null && vObject.getName().length() > 0) {
            String path = VObjectHelper.findPath(project);
            file = path + vObject.getName();
            if (!vObject.getName().endsWith(".xml")) {
                file = file + ".xml";
            }
        }
        return file;
    }

    public static ArrayList listNames(Project project) throws Exception {
        ArrayList list;
        String path;
        ArrayList<String> nameList = null;
        if (project != null && (path = VObjectHelper.findPath(project)) != null && path.length() > 0 && (list = IOHelper.retrieveFileList(path, null, ".xml", null, false)) != null) {
            nameList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                String item = (String)list.get(i);
                if (item.indexOf(".") == -1) continue;
                item = item.substring(0, item.lastIndexOf("."));
                nameList.add(item);
            }
        }
        return nameList;
    }

    public static ArrayList listEntities(Project project, boolean hasBlank) throws Exception {
        ArrayList list = VObjectHelper.listNames(project);
        if (list != null && hasBlank) {
            list.add(0, "");
        }
        return list;
    }

    public static ArrayList listEntityColumnNames(Project project, String entity, boolean notNullMark) throws Exception {
        ArrayList vObjectColumns;
        ArrayList<String> columns = new ArrayList<String>();
        VObject vObject = VObjectHelper.load(entity, project);
        if (vObject != null && (vObjectColumns = vObject.getColumns()) != null) {
            for (int j = 0; j < vObjectColumns.size(); ++j) {
                VObjectColumn column = (VObjectColumn)vObjectColumns.get(j);
                HashMap columnProperties = column.getColumnProperties();
                String columnName = column.getColumnName();
                if (notNullMark && columnProperties != null) {
                    String not_null = "";
                    if (columnProperties.get("not_null") != null) {
                        not_null = (String)columnProperties.get("not_null");
                    }
                    String mark = not_null.equals("true") || not_null.equals("in") ? "*" : "";
                    columnName = mark + columnName;
                }
                columns.add(columnName);
            }
        }
        return columns;
    }
}

