/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.generator.struts;

import com.egen.develop.generator.form.BlockForm;
import com.egen.develop.resource.Project;
import com.egen.develop.struts.Action;
import com.egen.develop.struts.ActionMappings;
import com.egen.develop.struts.FormBean;
import com.egen.develop.struts.FormBeans;
import com.egen.develop.struts.MessageResources;
import com.egen.develop.struts.ModuleConfig;
import com.egen.develop.util.CodeFilesHelper;
import com.egen.util.io.FileIo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class StrutsConfig {
    private String strutsConfigFileName = "struts-config.xml";
    private ArrayList formBeans = new ArrayList();
    private ArrayList actions = new ArrayList();

    public void updateStrutsConfig(Project project) throws IOException, Exception {
        if (project != null) {
            ModuleConfig moduleConfig;
            String html_path = project.getHtml_path();
            String struts_path = html_path + "/WEB-INF/" + this.strutsConfigFileName;
            File file = new File(struts_path);
            if (!file.exists()) {
                String newStrutsConfig = CodeFilesHelper.readFile(project, "struts-config.xml");
                FileIo.write((String)struts_path, (String)newStrutsConfig);
            }
            if ((moduleConfig = new ModuleConfig(struts_path)) != null) {
                StringBuffer original = new StringBuffer(moduleConfig.toStrutsXml());
                com.egen.develop.struts.StrutsConfig strutsConfig = moduleConfig.getStrutsConfig();
                if (strutsConfig != null) {
                    StringBuffer altered;
                    ActionMappings actionMappings;
                    FormBeans oldFormBeans = strutsConfig.getFormBeans();
                    if (oldFormBeans == null) {
                        oldFormBeans = new FormBeans();
                    }
                    if (this.formBeans != null && this.formBeans.size() > 0) {
                        for (int i = 0; i < this.formBeans.size(); ++i) {
                            FormBean formBean = (FormBean)this.formBeans.get(i);
                            if (formBean == null) continue;
                            if (oldFormBeans.getFormBean(formBean.getName()) != null) {
                                oldFormBeans.setFormBean(formBean);
                                continue;
                            }
                            oldFormBeans.addFormBean(formBean);
                        }
                    }
                    if ((actionMappings = strutsConfig.getActionMappings()) == null) {
                        actionMappings = new ActionMappings();
                    }
                    if (this.actions != null && this.actions.size() > 0) {
                        for (int i = 0; i < this.actions.size(); ++i) {
                            Action action = (Action)this.actions.get(i);
                            if (action == null) continue;
                            if (actionMappings.getAction(action.getPath()) != null) {
                                actionMappings.setAction(action);
                                continue;
                            }
                            actionMappings.addAction(action);
                        }
                    }
                    if ((altered = new StringBuffer(moduleConfig.toStrutsXml())) != null && altered.length() > 10 && !original.equals(altered)) {
                        moduleConfig.writeXml(struts_path);
                    }
                }
            } else {
                throw new Exception("Warn: " + struts_path + " file does not exist. Check the correct path in the application project!");
            }
        }
    }

    public String toXml() throws Exception {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("<class>com.egen.develop.generator.struts.StrutsConfig</class>\n");
        if (this.strutsConfigFileName != null && this.strutsConfigFileName.length() > 0) {
            sb.append("<strutsConfigFileName>" + this.strutsConfigFileName + "</strutsConfigFileName>\n");
        } else {
            sb.append("<strutsConfigFileName></strutsConfigFileName>\n");
        }
        if (this.formBeans != null && this.formBeans.size() > 0) {
            sb.append("<formBeans>\n");
            for (i = 0; i < this.formBeans.size(); ++i) {
                FormBean formBean = (FormBean)this.formBeans.get(i);
                sb.append("<formBeans_item>\n");
                sb.append(formBean.toXml());
                sb.append("</formBeans_item>\n");
            }
            sb.append("</formBeans>\n");
        } else {
            sb.append("<formBeans></formBeans>\n");
        }
        if (this.actions != null && this.actions.size() > 0) {
            sb.append("<actions>\n");
            for (i = 0; i < this.actions.size(); ++i) {
                Action action = (Action)this.actions.get(i);
                sb.append("<actions_item>\n");
                sb.append(action.toXml());
                sb.append("</actions_item>\n");
            }
            sb.append("</actions>\n");
        } else {
            sb.append("<actions></actions>\n");
        }
        return sb.toString();
    }

    public ArrayList getActions() {
        return this.actions;
    }

    public void setActions(ArrayList list) {
        this.actions = list;
    }

    public Action getAction(String string) {
        if (this.actions != null && this.actions.size() > 0) {
            for (int i = 0; i < this.actions.size(); ++i) {
                Action action = (Action)this.actions.get(i);
                if (!action.getPath().equals(string)) continue;
                return action;
            }
        }
        return null;
    }

    public void addAction(Action Action2) {
        if (this.actions == null) {
            this.actions = new ArrayList();
        }
        for (int i = 0; i < this.actions.size(); ++i) {
            Action action = (Action)this.actions.get(i);
            if (!action.getPath().equals(Action2.getPath())) continue;
            this.actions.set(i, Action2);
            return;
        }
        this.actions.add(Action2);
    }

    public void setAction(Action Action2) {
        if (this.actions != null && this.actions.size() > 0) {
            for (int i = 0; i < this.actions.size(); ++i) {
                Action action = (Action)this.actions.get(i);
                if (!action.getPath().equals(Action2.getPath())) continue;
                this.actions.set(i, Action2);
                return;
            }
        }
        if (this.actions == null) {
            this.actions = new ArrayList();
        }
        this.actions.add(Action2);
    }

    public void delAction(String string) {
        if (this.actions != null && this.actions.size() > 0) {
            for (int i = 0; i < this.actions.size(); ++i) {
                Action action = (Action)this.actions.get(i);
                if (!action.getPath().equals(string)) continue;
                this.actions.remove(i);
                return;
            }
        }
    }

    public ArrayList getFormBeans() {
        return this.formBeans;
    }

    public void setFormBeans(ArrayList list) {
        this.formBeans = list;
    }

    public FormBean getFormBean(String string) {
        if (this.formBeans != null && this.formBeans.size() > 0) {
            for (int i = 0; i < this.formBeans.size(); ++i) {
                FormBean formBean = (FormBean)this.formBeans.get(i);
                if (!formBean.getName().equals(string)) continue;
                return formBean;
            }
        }
        return null;
    }

    public void addFormBean(FormBean bean) {
        if (this.formBeans == null) {
            this.formBeans = new ArrayList();
        }
        for (int i = 0; i < this.formBeans.size(); ++i) {
            FormBean formBean = (FormBean)this.formBeans.get(i);
            if (!formBean.getName().equals(bean.getName())) continue;
            this.formBeans.set(i, bean);
            return;
        }
        this.formBeans.add(bean);
    }

    public void setFormBean(FormBean bean) {
        if (this.formBeans != null && this.formBeans.size() > 0) {
            for (int i = 0; i < this.formBeans.size(); ++i) {
                FormBean formBean = (FormBean)this.formBeans.get(i);
                if (!formBean.getName().equals(bean.getName())) continue;
                this.formBeans.set(i, bean);
                return;
            }
        }
        if (this.formBeans == null) {
            this.formBeans = new ArrayList();
        }
        this.formBeans.add(bean);
    }

    public void delFormBean(String string) {
        if (this.formBeans != null && this.formBeans.size() > 0) {
            for (int i = 0; i < this.formBeans.size(); ++i) {
                FormBean formBean = (FormBean)this.formBeans.get(i);
                if (!formBean.getName().equals(string)) continue;
                this.formBeans.remove(i);
                return;
            }
        }
    }

    public String getStrutsConfigFileName() {
        return this.strutsConfigFileName;
    }

    public void setStrutsConfigFileName(String string) {
        this.strutsConfigFileName = string;
    }

    public void strutsConfigMessageResources(Project project, MessageResources message_resources, String type) throws IOException, Exception {
        if (project != null) {
            String html_path = project.getHtml_path();
            String struts_path = html_path + "/WEB-INF/" + this.strutsConfigFileName;
            ModuleConfig moduleConfig = new ModuleConfig(struts_path);
            if (moduleConfig != null) {
                StringBuffer original = new StringBuffer(moduleConfig.toStrutsXml());
                com.egen.develop.struts.StrutsConfig strutsConfig = moduleConfig.getStrutsConfig();
                if (strutsConfig != null) {
                    if (type.equalsIgnoreCase("add")) {
                        strutsConfig.addMessageResources(message_resources);
                    } else if (type.equalsIgnoreCase("del")) {
                        strutsConfig.delMessageResources(message_resources.getParameter());
                    }
                    StringBuffer altered = new StringBuffer(moduleConfig.toStrutsXml());
                    if (altered != null && altered.length() > 10 && !original.equals(altered)) {
                        moduleConfig.writeXml(struts_path);
                    }
                }
            } else {
                throw new Exception("Warn: " + struts_path + " file does not exist. Check the correct path in the application project!");
            }
        }
    }

    public static String transformActionInPath(BlockForm blockForm) throws Exception {
        String path = null;
        if (blockForm != null && blockForm.getForm() != null) {
            path = blockForm.getForm().getAction();
            if (path != null && path.length() > 0) {
                path = "/" + path.substring(0, path.lastIndexOf("."));
            } else {
                throw new Exception("No defined Action for Form!");
            }
        }
        return path;
    }
}

