/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.generator;

import com.egen.develop.configuration.TemplateSetHelper;
import com.egen.develop.generator.Block;
import com.egen.develop.generator.Generator;
import com.egen.develop.generator.chart.BlockChart;
import com.egen.develop.generator.chart.Chart;
import com.egen.develop.generator.form.BaseButton;
import com.egen.develop.generator.form.BaseHtmlField;
import com.egen.develop.generator.form.BlockForm;
import com.egen.develop.generator.form.Field;
import com.egen.develop.generator.form.FieldRelation;
import com.egen.develop.generator.form.Free;
import com.egen.develop.generator.form.Lov;
import com.egen.develop.generator.form.Options;
import com.egen.develop.generator.form.Select;
import com.egen.develop.generator.form.Submit;
import com.egen.develop.generator.form.Trigger;
import com.egen.develop.generator.menu.BlockMenu;
import com.egen.develop.generator.report.BlockReport;
import com.egen.develop.generator.report.Column;
import com.egen.develop.generator.report.ColumnRelation;
import com.egen.develop.resource.Project;
import com.egen.util.process.ProcessContext;
import com.egen.util.process.ProcessFacade;
import com.egen.util.process.ProcessParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class GeneratorHelper {
    public static ArrayList make(Generator generator, boolean compact, boolean generateView, boolean generateModel, boolean generateAction, boolean compile, boolean makeConfiguration) throws Exception {
        ProcessParameter p = new ProcessParameter();
        p.setAttribute("com.egen.develop.generator.Generator", (Object)generator);
        p.setAttribute("COMPACT", (Object)new Boolean(compact));
        p.setAttribute("GENERATE_VIEW", (Object)new Boolean(generateView));
        p.setAttribute("GENERATE_MODEL", (Object)new Boolean(generateModel));
        p.setAttribute("GENERATE_ACTION", (Object)new Boolean(generateAction));
        p.setAttribute("COMPILE", (Object)new Boolean(compile));
        p.setAttribute("MAKE_CONFIGURATION", (Object)new Boolean(makeConfiguration));
        ProcessContext context = TemplateSetHelper.configureProcessContext(generator.getProject());
        ProcessFacade.execute((String)generator.getGeneratorMasterTemplate(), (ProcessContext)context, (ProcessParameter)p);
        ArrayList returnedMessages = (ArrayList)p.getAttribute("RETURNED_MESSAGES");
        return returnedMessages;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateGeneratorTemplates(Generator generator, String EnvironmentRootPath) throws Exception {
        Vector blocks;
        String template;
        Iterator iterator;
        Set keySet;
        Project project;
        if (generator == null || (project = generator.getProject()) == null || EnvironmentRootPath == null || project.getTemplateSet() == null) return;
        HashMap<String, String> oldTemplatesMap = new HashMap<String, String>();
        HashMap templateSetHasMap = TemplateSetHelper.templateSetMap(EnvironmentRootPath, project);
        if (templateSetHasMap != null && (keySet = templateSetHasMap.keySet()) != null && (iterator = keySet.iterator()) != null) {
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = (String)templateSetHasMap.get(key);
                if (value == null || value.length() <= 0) continue;
                oldTemplatesMap.put(value, key);
            }
        }
        if ((template = generator.getGeneratorMasterTemplate()) != null && template.length() > 0 && oldTemplatesMap.get(template) != null) {
            generator.setGeneratorMasterTemplate((String)oldTemplatesMap.get(template));
        }
        if ((template = generator.getActionFormTemplate()) != null && template.length() > 0 && oldTemplatesMap.get(template) != null) {
            generator.setActionFormTemplate((String)oldTemplatesMap.get(template));
        }
        if ((template = generator.getActionTemplate()) != null && template.length() > 0 && oldTemplatesMap.get(template) != null) {
            generator.setActionTemplate((String)oldTemplatesMap.get(template));
        }
        if ((template = generator.getJspTemplate()) != null && template.length() > 0 && oldTemplatesMap.get(template) != null) {
            generator.setJspTemplate((String)oldTemplatesMap.get(template));
        }
        if ((blocks = generator.getBlocks()) == null) return;
        for (int i = 0; i < blocks.size(); ++i) {
            Block block;
            if (blocks.get(i) instanceof BlockForm) {
                block = (BlockForm)blocks.get(i);
                template = ((BlockForm)block).getFormTemplate();
                if (template != null && template.length() > 0 && oldTemplatesMap.get(template) != null) {
                    ((BlockForm)block).setFormTemplate((String)oldTemplatesMap.get(template));
                }
                Vector fields = ((BlockForm)block).getFields();
                for (int j = 0; j < fields.size(); ++j) {
                    BaseHtmlField baseHtmlField;
                    FieldRelation fieldRelation;
                    Field field = (Field)fields.get(j);
                    Lov lov = field.getLovObject();
                    if (lov != null && (template = lov.getLovTemplate()) != null && template.length() > 0 && oldTemplatesMap.get(template) != null) {
                        lov.setLovTemplate((String)oldTemplatesMap.get(template));
                    }
                    if (field instanceof Select) {
                        Select select = (Select)field;
                        Options options = select.getOptions();
                        if (options == null || (template = options.getTemplate()) == null || template.length() <= 0 || oldTemplatesMap.get(template) == null) continue;
                        options.setTemplate((String)oldTemplatesMap.get(template));
                        continue;
                    }
                    if (field instanceof Free) {
                        Free free = (Free)field;
                        template = free.getTemplate();
                        if (template == null || template.length() <= 0 || oldTemplatesMap.get(template) == null) continue;
                        free.setTemplate((String)oldTemplatesMap.get(template));
                        continue;
                    }
                    if (!(field instanceof BaseHtmlField) || (fieldRelation = (baseHtmlField = (BaseHtmlField)field).getField_relation()) == null || (template = fieldRelation.getFieldRelationTemplate()) == null || template.length() <= 0 || oldTemplatesMap.get(template) == null) continue;
                    fieldRelation.setFieldRelationTemplate((String)oldTemplatesMap.get(template));
                }
                Vector buttons = ((BlockForm)block).getButtons();
                for (int j = 0; j < buttons.size(); ++j) {
                    Vector triggers;
                    BaseButton baseButton = (BaseButton)buttons.get(j);
                    if (!(baseButton instanceof Submit)) continue;
                    Submit button = (Submit)baseButton;
                    template = button.getTemplate();
                    if (template != null && template.length() > 0 && oldTemplatesMap.get(template) != null) {
                        button.setTemplate((String)oldTemplatesMap.get(template));
                    }
                    if ((triggers = button.getTriggers()) == null) continue;
                    for (int k = 0; k < triggers.size(); ++k) {
                        Trigger trigger = (Trigger)triggers.get(k);
                        template = trigger.getTriggerTemplate();
                        if (template == null || template.length() <= 0 || oldTemplatesMap.get(template) == null) continue;
                        trigger.setTriggerTemplate((String)oldTemplatesMap.get(template));
                    }
                }
            } else if (blocks.get(i) instanceof BlockReport) {
                Vector columns;
                block = (BlockReport)blocks.get(i);
                template = ((BlockReport)block).getReportTemplate();
                if (template != null && template.length() > 0) {
                    if (oldTemplatesMap.get(template) != null) {
                        ((BlockReport)block).setReportTemplate((String)oldTemplatesMap.get(template));
                    }
                    if (template.equalsIgnoreCase("getDefaultReport") || template.equalsIgnoreCase("com.egen.develop.template.DefaultReport")) {
                        ((BlockReport)block).setReportTemplate("default_report_block");
                    } else if (template.equalsIgnoreCase("getSpreadsheetReport") || template.equalsIgnoreCase("com.egen.develop.template.SpreadsheetReport")) {
                        ((BlockReport)block).setReportTemplate("spreadsheet_report_block");
                    } else if (template.equalsIgnoreCase("getPdfReport") || template.equalsIgnoreCase("com.egen.develop.template.PdfReport")) {
                        ((BlockReport)block).setReportTemplate("pdf_report_block");
                    } else if (template.equalsIgnoreCase("getPdfLetterReport") || template.equalsIgnoreCase("com.egen.develop.template.PdfLetterReport")) {
                        ((BlockReport)block).setReportTemplate("pdf_letter_report_block");
                    } else if (template.equalsIgnoreCase("getPdfLabelReport") || template.equalsIgnoreCase("com.egen.develop.template.PdfLabelReport")) {
                        ((BlockReport)block).setReportTemplate("pdf_label_report_block");
                    } else if (template.equalsIgnoreCase("getRtfReport") || template.equalsIgnoreCase("com.egen.develop.template.RtfReport")) {
                        ((BlockReport)block).setReportTemplate("rtf_report_block");
                    }
                }
                if ((columns = ((BlockReport)block).getColumns()) != null) {
                    for (int j = 0; j < columns.size(); ++j) {
                        Column column = (Column)columns.get(j);
                        ColumnRelation columnRelation = column.getColumnRelation();
                        if (columnRelation == null || (template = columnRelation.getColumnRelationTemplate()) == null || template.length() <= 0 || oldTemplatesMap.get(template) == null) continue;
                        columnRelation.setColumnRelationTemplate((String)oldTemplatesMap.get(template));
                    }
                }
            } else if (blocks.get(i) instanceof BlockMenu) {
                block = (BlockMenu)blocks.get(i);
                template = ((BlockMenu)block).getMenuTemplate();
                if (template != null && template.length() > 0 && oldTemplatesMap.get(template) != null) {
                    ((BlockMenu)block).setMenuTemplate((String)oldTemplatesMap.get(template));
                }
                if ((template = ((BlockMenu)block).getType_menu()) != null && template.length() > 0 && oldTemplatesMap.get(template) != null) {
                    ((BlockMenu)block).setType_menu((String)oldTemplatesMap.get(template));
                }
            } else if (blocks.get(i) instanceof BlockChart) {
                Vector charts;
                block = (BlockChart)blocks.get(i);
                template = ((BlockChart)block).getChartBlockTemplate();
                if (template != null && template.length() > 0 && oldTemplatesMap.get(template) != null) {
                    ((BlockChart)block).setChartBlockTemplate((String)oldTemplatesMap.get(template));
                }
                if ((charts = ((BlockChart)block).getCharts()) != null) {
                    for (int j = 0; j < charts.size(); ++j) {
                        Chart chart = (Chart)charts.get(j);
                        template = chart.getChartTemplate();
                        if (template == null || template.length() <= 0 || oldTemplatesMap.get(template) == null) continue;
                        chart.setChartTemplate((String)oldTemplatesMap.get(template));
                    }
                }
            }
            block = (Block)blocks.get(i);
            template = block.getScript_template();
            if (template == null || template.length() <= 0) continue;
            if (oldTemplatesMap.get(template) != null) {
                block.setScript_template((String)oldTemplatesMap.get(template));
            }
            if (template.equalsIgnoreCase("getLovScript")) {
                template = "LOV_SCRIPT";
                continue;
            }
            if (!template.equalsIgnoreCase("getFormValidateScript")) continue;
            template = "CLIENT_VALIDATION_SCRIPT";
        }
    }
}

