/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.domain;

import com.egen.develop.domain.Domain;
import com.egen.develop.generator.Block;
import com.egen.develop.generator.Element;
import com.egen.develop.generator.Generator;
import com.egen.develop.generator.form.BaseButton;
import com.egen.develop.generator.form.BlockForm;
import com.egen.develop.generator.form.Field;
import com.egen.develop.generator.report.BlockReport;
import com.egen.develop.generator.report.Column;
import com.egen.develop.plugin.Plugin;
import com.egen.develop.plugin.PluginHelper;
import com.egen.develop.resource.Project;
import com.egen.develop.util.GeneratorReportHelper;
import com.egen.util.system.Menu;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;

public class DomainReportHelper {
    public static Menu reportDomains(Project project, String[] moduleFilter, String nameFilter, String domainFilter, String domainTypeFilter) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu domainsMenu = new Menu();
        domainsMenu.setName(bundle.getString("jsp.project"));
        domainsMenu.setLabel(bundle.getString("jsp.project") + ": " + project.getName());
        if (project != null) {
            ArrayList modules = GeneratorReportHelper.retrieveModuleList(project);
            for (int i = 0; i < modules.size(); ++i) {
                String module = (String)modules.get(i);
                if (module == null || module.length() <= 0 || !GeneratorReportHelper.checkModuleFilter(moduleFilter, module)) continue;
                ArrayList metaFiles = GeneratorReportHelper.retrieveMetaFileList(project, module);
                for (int a = 0; a < metaFiles.size(); ++a) {
                    Menu menu;
                    String fileName;
                    String metaFile = (String)metaFiles.get(a);
                    Generator generator = GeneratorReportHelper.retrieveGenerator(metaFile, project);
                    if (generator == null || !GeneratorReportHelper.checkNameFilter(nameFilter, fileName = generator.getFile_name()) || (menu = DomainReportHelper.generatorDomains(generator, domainFilter, domainTypeFilter, project)) == null) continue;
                    domainsMenu.addSub_menu(menu);
                }
            }
        }
        if (domainsMenu.getSub_menus() == null || domainsMenu.getSub_menus().size() == 0) {
            domainsMenu = null;
        }
        return domainsMenu;
    }

    public static Menu generatorDomains(Generator generator, String domainFilter, String domainTypeFilter, Project project) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu itemsMenu = new Menu();
        itemsMenu.setLabel(generator.getModule() + " - " + generator.getFile_name());
        if (generator != null) {
            Menu blocksCust;
            Vector blocks = generator.getBlocks();
            if (blocks != null && blocks.size() > 0 && (blocksCust = DomainReportHelper.blocks(blocks, domainFilter, domainTypeFilter, project)) != null) {
                itemsMenu.addSub_menu(blocksCust);
            }
            if (itemsMenu.getSub_menus() == null || itemsMenu.getSub_menus().size() == 0) {
                itemsMenu = null;
            }
        }
        return itemsMenu;
    }

    public static Menu blocks(Vector blocks, String domainFilter, String domainTypeFilter, Project project) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailCustomizations = new Menu();
        detailCustomizations.setLabel(bundle.getString("menu.generator.blocks"));
        for (int i = 0; i < blocks.size(); ++i) {
            Menu blockItems;
            Block block = (Block)blocks.elementAt(i);
            if (block instanceof BlockForm) {
                blockItems = DomainReportHelper.blockItems((BlockForm)block, domainFilter, domainTypeFilter, project);
                if (blockItems == null) continue;
                detailCustomizations.addSub_menu(blockItems);
                continue;
            }
            if (!(block instanceof BlockReport) || (blockItems = DomainReportHelper.blockItems((BlockReport)block, domainFilter, domainTypeFilter, project)) == null) continue;
            detailCustomizations.addSub_menu(blockItems);
        }
        if (detailCustomizations.getSub_menus() == null || detailCustomizations.getSub_menus().size() == 0) {
            detailCustomizations = null;
        }
        return detailCustomizations;
    }

    public static Menu blockItems(BlockForm block, String domainFilter, String domainTypeFilter, Project project) throws Exception {
        Menu itemCustomizations;
        Vector buttons;
        Menu itemCustomizations2;
        Vector fields;
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailItems = new Menu();
        detailItems.setLabel(bundle.getString("jsp.form") + ": " + block.getName());
        if ((block.getFormTemplate() == null || block.getFormTemplate().length() == 0) && block.getForm_code() != null && block.getForm_code().length() > 0) {
            Menu itemCustomizations3 = new Menu();
            itemCustomizations3.setLabel(bundle.getString("jsp.code"));
            detailItems.addSub_menu(itemCustomizations3);
        }
        if ((fields = block.getFields()) != null && (itemCustomizations2 = DomainReportHelper.fieldsItems(block, domainFilter, domainTypeFilter, project)) != null && itemCustomizations2.getSub_menus() != null && itemCustomizations2.getSub_menus().size() > 0) {
            detailItems.addSub_menu(itemCustomizations2);
        }
        if ((buttons = block.getButtons()) != null && (itemCustomizations = DomainReportHelper.buttonsItems(block, domainFilter, domainTypeFilter, project)) != null && itemCustomizations.getSub_menus() != null && itemCustomizations.getSub_menus().size() > 0) {
            detailItems.addSub_menu(itemCustomizations);
        }
        if (detailItems.getSub_menus() == null || detailItems.getSub_menus().size() == 0) {
            detailItems = null;
        }
        return detailItems;
    }

    public static Menu fieldsItems(BlockForm block, String domainFilter, String domainTypeFilter, Project project) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailItems = new Menu();
        Vector fields = block.getFields();
        if (fields != null) {
            detailItems.setLabel(bundle.getString("menu.generator.fields"));
            for (int i = 0; i < fields.size(); ++i) {
                Field field = (Field)fields.elementAt(i);
                Menu subItem = DomainReportHelper.elementItems(field, domainFilter, domainTypeFilter, project);
                if (subItem == null) continue;
                detailItems.addSub_menu(subItem);
            }
        }
        if (detailItems.getSub_menus() == null || detailItems.getSub_menus().size() == 0) {
            detailItems = null;
        }
        return detailItems;
    }

    public static Menu elementItems(Element element, String domainFilter, String domainTypeFilter, Project project) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailItems = new Menu();
        detailItems.setLabel(element.getName());
        ArrayList domains = element.getPlugins();
        if (domains != null) {
            for (int j = 0; j < domains.size(); ++j) {
                Domain domain;
                if (!(domains.get(j) instanceof Domain) || !DomainReportHelper.checkDomain(domain = (Domain)domains.get(j), domainFilter, domainTypeFilter, project)) continue;
                Menu subItem = new Menu();
                subItem.setLabel(domain.getName());
                detailItems.addSub_menu(subItem);
            }
        }
        if (detailItems.getSub_menus() == null || detailItems.getSub_menus().size() == 0) {
            detailItems = null;
        }
        return detailItems;
    }

    public static Menu buttonsItems(BlockForm block, String domainFilter, String domainTypeFilter, Project project) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailItems = new Menu();
        Vector buttons = block.getButtons();
        if (buttons != null) {
            detailItems.setLabel(bundle.getString("menu.generator.buttons"));
            for (int i = 0; i < buttons.size(); ++i) {
                BaseButton button = (BaseButton)buttons.elementAt(i);
                Menu subItem = DomainReportHelper.elementItems(button, domainFilter, domainTypeFilter, project);
                if (subItem == null) continue;
                detailItems.addSub_menu(subItem);
            }
        }
        if (detailItems.getSub_menus() == null || detailItems.getSub_menus().size() == 0) {
            detailItems = null;
        }
        return detailItems;
    }

    public static Menu blockItems(BlockReport block, String domainFilter, String domainTypeFilter, Project project) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailItems = new Menu();
        detailItems.setLabel(bundle.getString("jsp.report") + ": " + block.getName());
        Menu itemCustomizations = DomainReportHelper.columnsItems(block, domainFilter, domainTypeFilter, project);
        if (itemCustomizations != null && itemCustomizations.getSub_menus() != null && itemCustomizations.getSub_menus().size() > 0) {
            detailItems.addSub_menu(itemCustomizations);
        }
        if (detailItems.getSub_menus() == null || detailItems.getSub_menus().size() == 0) {
            detailItems = null;
        }
        return detailItems;
    }

    public static Menu columnsItems(BlockReport block, String domainFilter, String domainTypeFilter, Project project) throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
        Menu detailItems = new Menu();
        Vector columns = block.getColumns();
        if (columns != null) {
            detailItems.setLabel(bundle.getString("menu.generator.columns"));
            for (int i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.elementAt(i);
                Menu subItem = DomainReportHelper.elementItems(column, domainFilter, domainTypeFilter, project);
                if (subItem == null) continue;
                detailItems.addSub_menu(subItem);
            }
        }
        if (detailItems.getSub_menus() == null || detailItems.getSub_menus().size() == 0) {
            detailItems = null;
        }
        return detailItems;
    }

    private static boolean checkDomain(Domain domain, String domainFilter, String domainTypeFilter, Project project) {
        boolean valid = false;
        if (domain != null) {
            boolean validName = true;
            if (domainFilter != null && domainFilter.length() > 0 && !GeneratorReportHelper.checkNameFilter(domainFilter, domain.getName())) {
                validName = false;
            }
            boolean validType = true;
            if (domainTypeFilter != null && domainTypeFilter.length() > 0) {
                try {
                    Plugin loaded_plugin = PluginHelper.load(domain, project);
                    if (!GeneratorReportHelper.checkNameFilter(domainTypeFilter, loaded_plugin.getClass().getName())) {
                        validType = false;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (validName && validType) {
                valid = true;
            }
        }
        return valid;
    }
}

