/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.domain;

import com.egen.develop.domain.Domain;
import com.egen.develop.resource.Project;
import com.egen.develop.util.IOHelper;
import com.egen.util.io.FileIo;
import com.egen.util.io.Xml;
import java.io.BufferedWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.ResourceBundle;

public class DomainHelper {
    public static void save(Domain Element2, String FOLDER) throws Exception {
        if (Element2 != null && FOLDER != null && FOLDER.length() > 0) {
            String xml = Xml.writeXml((Object)Element2, null);
            String file = DomainHelper.retrieveFileName(Element2, FOLDER);
            File f = new File(file);
            if (!f.exists()) {
                File dir = new File(f.getParent());
                dir.mkdirs();
            }
            if (xml != null) {
                BufferedWriter buf = FileIo.getBuffer((String)file);
                buf.write(xml);
                buf.close();
            }
        }
    }

    public static void save(Domain Element2, Project project) throws Exception {
        if (Element2 != null && project != null) {
            String folder = DomainHelper.retrieveFolder(project);
            DomainHelper.save(Element2, folder);
        }
    }

    public static void delete(Domain Element2, String FOLDER) throws Exception {
        if (Element2 != null && FOLDER != null && FOLDER.length() > 0) {
            String xml = Xml.writeXml((Object)Element2, null);
            String file = DomainHelper.retrieveFileName(Element2, FOLDER);
            File f = new File(file);
            if (f.exists()) {
                f.delete();
            }
        }
    }

    public static void delete(Domain Element2, Project project) throws Exception {
        if (Element2 != null && project != null) {
            String folder = DomainHelper.retrieveFolder(project);
            DomainHelper.delete(Element2, folder);
        }
    }

    public static void load(Domain Element2, String FOLDER) throws Exception {
        String file;
        String xml;
        if (Element2 != null && FOLDER != null && FOLDER.length() > 0 && (xml = FileIo.read((String)(file = DomainHelper.retrieveFileName(Element2, FOLDER)))) != null) {
            Element2 = (Domain)Xml.readXml((Object)Element2, (String)xml);
        }
    }

    public static void load(Domain Element2, Project project) throws Exception {
        if (Element2 != null && project != null) {
            String folder = DomainHelper.retrieveFolder(project);
            DomainHelper.load(Element2, folder);
        }
    }

    public static ArrayList list(Domain Element2, String FOLDER) throws Exception {
        ArrayList list;
        ArrayList<Domain> elements = null;
        if (Element2 != null && FOLDER != null && FOLDER.length() > 0 && (list = DomainHelper.listNames(Element2, FOLDER)) != null) {
            elements = new ArrayList<Domain>();
            for (int i = 0; i < list.size(); ++i) {
                String item = (String)list.get(i);
                if (item.indexOf(".") != -1) {
                    item = item.substring(0, item.lastIndexOf("."));
                }
                Domain elem = (Domain)Element2.getClass().newInstance();
                elem.setName(item);
                DomainHelper.load(elem, FOLDER);
                elements.add(elem);
            }
        }
        return elements;
    }

    public static ArrayList list(String FOLDER) throws Exception {
        ArrayList list;
        ArrayList<Domain> elements = null;
        if (FOLDER != null && FOLDER.length() > 0 && (list = DomainHelper.listNames(FOLDER)) != null) {
            elements = new ArrayList<Domain>();
            for (int i = 0; i < list.size(); ++i) {
                String item = (String)list.get(i);
                Domain elem = new Domain();
                elem.setName(item);
                DomainHelper.load(elem, FOLDER);
                elements.add(elem);
            }
        }
        return elements;
    }

    public static ArrayList listNames(String FOLDER) throws Exception {
        String dir;
        ArrayList list;
        ArrayList<String> nameList = null;
        if (FOLDER != null && FOLDER.length() > 0 && (list = IOHelper.retrieveFileList(dir = DomainHelper.retrieveFileDir(FOLDER), null, ".xml", null, false)) != null) {
            nameList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                String item = (String)list.get(i);
                if (item.indexOf(".") == -1) continue;
                item = item.substring(0, item.lastIndexOf("."));
                nameList.add(item);
            }
        }
        return nameList;
    }

    public static ArrayList listNames(Domain Element2, String FOLDER) throws Exception {
        String dir;
        ArrayList list;
        ArrayList<String> nameList = null;
        if (Element2 != null && FOLDER != null && FOLDER.length() > 0 && (list = IOHelper.retrieveFileList(dir = DomainHelper.retrieveFileDir(Element2, FOLDER), null, null, null, false)) != null) {
            nameList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                String item = (String)list.get(i);
                if (item.indexOf(".") == -1) continue;
                item = item.substring(0, item.lastIndexOf("."));
                nameList.add(item);
            }
        }
        return nameList;
    }

    public static ArrayList listFiles(Domain Element2, String FOLDER) throws Exception {
        ArrayList list = null;
        if (Element2 != null && FOLDER != null && FOLDER.length() > 0) {
            String dir = DomainHelper.retrieveFileDir(Element2, FOLDER);
            list = IOHelper.retrieveFileList(dir, null, null, null, true);
        }
        return list;
    }

    public static ArrayList list(Domain Element2, Project project) throws Exception {
        ArrayList elements = null;
        if (Element2 != null && project != null) {
            String folder = DomainHelper.retrieveFolder(project);
            elements = DomainHelper.list(Element2, folder);
        }
        return elements;
    }

    public static ArrayList list(Project project) throws Exception {
        ArrayList elements = null;
        if (project != null) {
            String folder = DomainHelper.retrieveFolder(project);
            elements = DomainHelper.list(folder);
        }
        return elements;
    }

    private static String retrieveFolder(Project project) throws Exception {
        String path = null;
        if (project != null) {
            File pathDir;
            path = project.getSource_path();
            if (path != null && !path.endsWith("/") && !path.endsWith("\\")) {
                path = path + "/";
            }
            if (!(pathDir = new File(path = IOHelper.correctFileSeparator(path))).isDirectory()) {
                ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
                throw new Exception("Project Source Path " + bundle.getString("msg.notfound"));
            }
        } else {
            ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
            throw new Exception(bundle.getString("jsp.project") + " " + bundle.getString("msg.notfound"));
        }
        path = path + "domain\\";
        path = IOHelper.correctFileSeparator(path);
        return path;
    }

    private static String retrieveFileName(Domain Element2, String FOLDER) throws Exception {
        String file = DomainHelper.retrieveFileDir(Element2, FOLDER) + Element2.getName() + ".xml";
        return file;
    }

    private static String retrieveFileDir(String FOLDER) throws Exception {
        String dir = FOLDER;
        if (!dir.endsWith("/") && !dir.endsWith("\\")) {
            dir = dir + "/";
        }
        dir = IOHelper.correctFileSeparator(dir);
        return dir;
    }

    private static String retrieveFileDir(Domain Element2, String FOLDER) throws Exception {
        String dir = FOLDER;
        if (!dir.endsWith("/") && !dir.endsWith("\\")) {
            dir = dir + "/";
        }
        dir = IOHelper.correctFileSeparator(dir);
        return dir;
    }
}

