/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.domain;

import com.egen.develop.domain.Domain;
import com.egen.develop.domain.DomainHelper;
import com.egen.develop.plugin.Plugin;
import com.egen.develop.plugin.PluginContainer;
import com.egen.develop.resource.Project;
import com.egen.develop.util.IOHelper;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ResourceBundle;

public class DomainEnvironment
extends PluginContainer
implements Serializable {
    public static final String DOMAIN_ENVIRONMENT = "DomainEnvironment";
    private Project project = null;

    private DomainEnvironment() {
    }

    public ArrayList getElements() {
        try {
            return this.getDomains();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DomainEnvironment getInstance(Project project) throws Exception {
        DomainEnvironment domainEnvironment = new DomainEnvironment();
        if (project == null) {
            ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
            throw new Exception(bundle.getString("jsp.project") + " " + bundle.getString("msg.notfound"));
        }
        domainEnvironment.assignProject(project);
        return domainEnvironment;
    }

    public static PluginContainer newInstance(Project project) throws Exception {
        return DomainEnvironment.getInstance(project);
    }

    private String getDomainPath() throws Exception {
        File pathDir;
        String path = this.project.getSource_path();
        if (path != null && !path.endsWith("/") && !path.endsWith("\\")) {
            path = path + "/";
        }
        if (!(pathDir = new File(path = IOHelper.correctFileSeparator(path))).isDirectory()) {
            ResourceBundle bundle = ResourceBundle.getBundle("eGenResources");
            throw new Exception("Project Source Path " + bundle.getString("msg.notfound"));
        }
        path = path + "domain\\";
        path = IOHelper.correctFileSeparator(path);
        return path;
    }

    public void setDomains(ArrayList list) throws Exception {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Domain item = (Domain)list.get(i);
                item.assignProject(this.project);
                DomainHelper.save(item, this.retrieveProject());
            }
        }
    }

    public ArrayList getDomains() throws Exception {
        ArrayList elements = DomainHelper.list(this.retrieveProject());
        return elements;
    }

    public void addDomain(Domain Element2) throws Exception {
        Element2.assignProject(this.retrieveProject());
        DomainHelper.save(Element2, this.retrieveProject());
    }

    public void editDomain(Domain Element2) throws Exception {
        Element2.assignProject(this.retrieveProject());
        DomainHelper.save(Element2, this.retrieveProject());
    }

    public void delDomain(String Name) throws Exception {
        Domain Element2 = new Domain();
        Element2.setName(Name);
        Element2.assignProject(this.retrieveProject());
        DomainHelper.delete(Element2, this.retrieveProject());
    }

    public void delDomain(Domain Element2) throws Exception {
        Element2.assignProject(this.retrieveProject());
        DomainHelper.delete(Element2, this.retrieveProject());
    }

    public Plugin getElement(String NAME) throws Exception {
        return this.getDomain(NAME);
    }

    public Domain getDomain(String NAME) throws Exception {
        if (NAME != null) {
            Domain element = new Domain();
            element.assignProject(this.retrieveProject());
            element.setName(NAME);
            DomainHelper.load(element, this.retrieveProject());
            return element;
        }
        return null;
    }

    public Project retrieveProject() {
        return this.project;
    }

    public void assignProject(Project PARAM) {
        this.project = PARAM;
    }
}

