/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.configuration;

import com.egen.develop.resource.Project;
import com.egen.develop.util.IOHelper;
import com.egen.develop.util.PropertyHelper;
import com.egen.util.io.FileIo;
import com.egen.util.logger.Logging;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;

public class ToolOptionsHelper {
    public static void customize(String file, String configType, Project project) throws Exception {
        String egen_source_path;
        String projectConfigPath = null;
        if (project != null && (egen_source_path = project.getEgen_source_path()) != null && egen_source_path.length() > 0) {
            projectConfigPath = egen_source_path + "/config/";
        }
        if (projectConfigPath != null && file != null && file.length() > 0 && configType != null && configType.length() > 0) {
            String fileName = IOHelper.removePathInformation(file);
            String fileContents = FileIo.read((String)file);
            if (fileContents != null) {
                projectConfigPath = projectConfigPath + File.separator + configType + File.separator;
                String newFilePath = IOHelper.correctFileSeparator(projectConfigPath + fileName);
                FileIo.write((String)newFilePath, (String)fileContents);
            }
        }
    }

    public static void fillOptionsList(String FOLDER, String systemFolder, String FILE, ArrayList valueList, ArrayList labelList, Project project) {
        try {
            String projectFolder = null;
            if (project != null && (projectFolder = project.getEgen_source_path() + "config/") != null) {
                projectFolder = projectFolder + File.separator + FOLDER + File.separator;
                projectFolder = IOHelper.correctFileSeparator(projectFolder);
            }
            ArrayList[] properties = null;
            if (projectFolder != null) {
                try {
                    properties = PropertyHelper.propertyList(projectFolder, FILE);
                }
                catch (Exception e) {
                    Logging.log((String)"com.egen.develop.configuration", (Level)Level.FINER, (String)(ToolOptionsHelper.class.getName() + ".fillOptionsList()."), (Throwable)e);
                }
            }
            if (properties == null) {
                String folder = systemFolder + File.separator + FOLDER + File.separator;
                properties = PropertyHelper.propertyList(folder, FILE);
            }
            if (properties != null && properties.length > 1) {
                ArrayList keys = properties[0];
                ArrayList values = properties[1];
                if (keys != null) {
                    valueList.clear();
                    valueList.addAll(keys);
                }
                if (labelList != null && values != null) {
                    labelList.clear();
                    labelList.addAll(values);
                }
            }
        }
        catch (Exception e) {
            Logging.log((String)"com.egen.develop.configuration", (Level)Level.INFO, (String)(ToolOptionsHelper.class.getName() + ".fillOptionsList()."), (Throwable)e);
        }
    }

    public static ArrayList[] retrieveOptionsList(String FOLDER, String FILE, Project project) {
        ArrayList valueList = new ArrayList();
        ArrayList labelList = new ArrayList();
        try {
            String projectFolder = null;
            if (project != null && (projectFolder = project.getEgen_source_path() + "config/") != null) {
                projectFolder = projectFolder + File.separator + FOLDER + File.separator;
                projectFolder = IOHelper.correctFileSeparator(projectFolder);
            }
            ArrayList[] properties = null;
            if (projectFolder != null) {
                try {
                    properties = PropertyHelper.propertyList(projectFolder, FILE);
                }
                catch (Exception e) {
                    Logging.log((String)"com.egen.develop.configuration", (Level)Level.FINER, (String)(ToolOptionsHelper.class.getName() + ".fillOptionsList()."), (Throwable)e);
                }
            }
            if (properties == null) {
                properties = PropertyHelper.propertyList(FOLDER, FILE);
            }
            if (properties != null && properties.length > 1) {
                ArrayList keys = properties[0];
                ArrayList values = properties[1];
                if (valueList != null && keys != null) {
                    valueList.clear();
                    valueList.addAll(keys);
                }
                if (labelList != null && values != null) {
                    labelList.clear();
                    labelList.addAll(values);
                }
            }
        }
        catch (Exception e) {
            Logging.log((String)"com.egen.develop.configuration", (Level)Level.INFO, (String)(ToolOptionsHelper.class.getName() + ".fillOptionsList()."), (Throwable)e);
        }
        ArrayList[] option = new ArrayList[]{valueList, labelList};
        return option;
    }
}

