/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.configuration;

import com.egen.develop.configuration.OptionProperty;
import com.egen.develop.configuration.ToolOptionsEnvironment;
import com.egen.develop.util.PropertyHelper;
import java.util.ArrayList;

public class ToolOptions {
    ToolOptionsEnvironment parent;
    private String type;
    private String folder;
    private String file;
    private ArrayList optionProperties = new ArrayList();

    public static ToolOptions getInstance(String FOLDER, String FILE) throws Exception {
        ToolOptions instance = new ToolOptions();
        instance.setFolder(FOLDER);
        instance.setFile(FILE);
        ArrayList[] properties = PropertyHelper.propertyList(FOLDER, FILE);
        if (properties != null && properties.length > 1) {
            ArrayList keys = properties[0];
            ArrayList values = properties[1];
            if (keys != null && values != null) {
                for (int i = 0; i < keys.size(); ++i) {
                    OptionProperty item = new OptionProperty();
                    item.setKey((String)keys.get(i));
                    item.setValue((String)values.get(i));
                    instance.addOptionProperty(item);
                }
            }
        }
        return instance;
    }

    public void save() throws Exception {
        ArrayList[] properties = null;
        if (this.optionProperties != null) {
            properties = new ArrayList[2];
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < this.optionProperties.size(); ++i) {
                OptionProperty item = (OptionProperty)this.optionProperties.get(i);
                keys.add(item.getKey());
                values.add(item.getValue());
            }
            properties[0] = keys;
            properties[1] = values;
        }
        if (properties != null && this.folder != null && this.file != null) {
            PropertyHelper.save(properties, this.folder, this.file);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public ArrayList getOptionProperties() {
        if (this.optionProperties != null) {
            for (int i = 0; i < this.optionProperties.size(); ++i) {
                OptionProperty item = (OptionProperty)this.optionProperties.get(i);
                item.assignParent(this);
            }
        }
        return this.optionProperties;
    }

    public void setOptionProperties(ArrayList OptionProperties) {
        if (OptionProperties != null) {
            for (int i = 0; i < OptionProperties.size(); ++i) {
                OptionProperty item = (OptionProperty)OptionProperties.get(i);
                item.assignParent(this);
            }
        }
        this.optionProperties = OptionProperties;
    }

    public void deleteOptionPropertiy(String key, String value) {
        if (this.optionProperties != null) {
            for (int i = 0; i < this.optionProperties.size(); ++i) {
                OptionProperty item = (OptionProperty)this.optionProperties.get(i);
                if (key == null || !key.equals(item.getKey()) || value == null || !value.equals(item.getValue())) continue;
                this.optionProperties.remove(i);
                break;
            }
        }
    }

    public void shiftOptionPropertiy(OptionProperty OptionProperty2, int newPosition) {
        if (this.optionProperties != null && OptionProperty2 != null) {
            String key = OptionProperty2.getKey();
            String value = OptionProperty2.getValue();
            for (int i = 0; i < this.optionProperties.size(); ++i) {
                OptionProperty item = (OptionProperty)this.optionProperties.get(i);
                if (key == null || !key.equals(item.getKey()) || value == null || !value.equals(item.getValue())) continue;
                OptionProperty newItem = new OptionProperty();
                newItem.setKey(key);
                newItem.setValue(value);
                newItem.assignParent(this);
                this.optionProperties.remove(i);
                this.optionProperties.add(newPosition, newItem);
                break;
            }
        }
    }

    public void addOptionProperty(OptionProperty optionProperty) {
        if (this.optionProperties == null) {
            this.optionProperties = new ArrayList();
        }
        if (optionProperty != null) {
            optionProperty.assignParent(this);
        }
        this.optionProperties.add(optionProperty);
    }

    public ToolOptionsEnvironment retrieveParent() {
        return this.parent;
    }

    public void assignParent(ToolOptionsEnvironment Parent) {
        this.parent = Parent;
    }
}

