/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.configuration;

import com.egen.develop.configuration.TemplateDef;
import com.egen.develop.configuration.TemplateSet;
import com.egen.develop.configuration.TemplateSetEnvironment;
import com.egen.develop.configuration.ToolOptionsHelper;
import com.egen.develop.resource.Project;
import com.egen.develop.util.IOHelper;
import com.egen.util.io.FileIo;
import com.egen.util.io.Xml;
import com.egen.util.logger.Logging;
import com.egen.util.process.ProcessContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;

public class TemplateSetHelper {
    public static void customize(String file, Project project) throws Exception {
        String egen_source_path;
        String projectConfigPath = null;
        if (project != null && (egen_source_path = project.getEgen_source_path()) != null && egen_source_path.length() > 0) {
            projectConfigPath = egen_source_path + "/config/templatesets/";
            String fileName = IOHelper.removePathInformation(file);
            String fileContents = FileIo.read((String)file);
            if (fileContents != null) {
                String newFilePath = IOHelper.correctFileSeparator(projectConfigPath + fileName);
                FileIo.write((String)newFilePath, (String)fileContents);
            }
        }
    }

    public static HashMap templateSetMap(TemplateSet templateSet) throws Exception {
        HashMap<String, String> list = null;
        if (templateSet != null) {
            list = new HashMap<String, String>();
            ArrayList templates = templateSet.getTemplates();
            if (templates != null) {
                for (int i = 0; i < templates.size(); ++i) {
                    TemplateDef template = (TemplateDef)templates.get(i);
                    list.put(template.getTemplateAlias(), template.getTemplateImplementation());
                }
            }
        }
        return list;
    }

    public static HashMap templateSetMap(String EnvironmentRootPath, Project project) throws IOException, Exception {
        HashMap list = null;
        if (project != null || EnvironmentRootPath != null) {
            String templateSetFilePath;
            File file;
            String templateSetName = "Struts12";
            if (project != null && project.getTemplateSet() != null) {
                templateSetName = project.getTemplateSet();
            }
            if (!(file = new File(templateSetFilePath = TemplateSetHelper.findTemplateSetFilePath(templateSetName, EnvironmentRootPath, project, true))).exists()) {
                templateSetFilePath = TemplateSetHelper.findTemplateSetFilePath(templateSetName, EnvironmentRootPath, null, true);
            }
            if (templateSetFilePath != null) {
                String xml = FileIo.read((String)templateSetFilePath);
                TemplateSet templateSet = new TemplateSet();
                if ((templateSet = (TemplateSet)Xml.readXml((Object)templateSet, (String)xml)) != null) {
                    list = TemplateSetHelper.templateSetMap(templateSet);
                }
            }
        }
        return list;
    }

    public static ArrayList retrieveAllTemplateSets(String EnvironmentRootPath, Project project) throws Exception {
        String projectFolder;
        ArrayList projectFiles;
        ArrayList<TemplateSet> templateSets = new ArrayList<TemplateSet>();
        String folder = EnvironmentRootPath + "/config/templatesets/";
        ArrayList files = IOHelper.retrieveFileList(folder, null, "xml", null, true);
        if (files != null) {
            for (int i = 0; i < files.size(); ++i) {
                String file = (String)files.get(i);
                String xml = FileIo.read((String)file);
                if (xml == null || xml.length() <= 0) continue;
                TemplateSet templateSet = new TemplateSet();
                if ((templateSet = (TemplateSet)Xml.readXml((Object)templateSet, (String)xml)) == null) continue;
                templateSets.add(templateSet);
            }
        }
        if (project != null && project.getEgen_source_path() != null && project.getEgen_source_path().length() > 0 && (projectFiles = IOHelper.retrieveFileList(projectFolder = project.getEgen_source_path() + "/config/templatesets/", null, "xml", null, true)) != null) {
            for (int i = 0; i < projectFiles.size(); ++i) {
                String file = (String)projectFiles.get(i);
                String xml = FileIo.read((String)file);
                if (xml == null || xml.length() <= 0) continue;
                TemplateSet templateSet = new TemplateSet();
                if ((templateSet = (TemplateSet)Xml.readXml((Object)templateSet, (String)xml)) == null) continue;
                templateSets.add(templateSet);
            }
        }
        return templateSets;
    }

    public static void save(TemplateSet templateSet, String EnvironmentRootPath) throws IOException, Exception {
        TemplateSetHelper.save(templateSet, EnvironmentRootPath, null);
    }

    public static void save(TemplateSet templateSet, String EnvironmentRootPath, Project project) throws IOException, Exception {
        if (templateSet != null) {
            String templateSetFilePath = templateSet.getFile();
            if (templateSetFilePath == null || templateSetFilePath.length() == 0) {
                templateSetFilePath = TemplateSetHelper.findTemplateSetFilePath(templateSet.getTemplateSetName(), EnvironmentRootPath, project, false);
            }
            if (templateSetFilePath != null && templateSetFilePath.length() > 0 && templateSet != null) {
                StringBuffer xml_file = new StringBuffer();
                xml_file.append("<?xml version=\"1.0\"?>\n");
                xml_file.append("<TemplateSet>\n");
                xml_file.append(Xml.writeXml((Object)templateSet, null));
                xml_file.append("</TemplateSet>\n");
                FileIo.write((String)templateSetFilePath, (String)xml_file.toString());
                templateSet.setFile(templateSetFilePath);
            }
        }
    }

    public static void delete(TemplateSet templateSet, String EnvironmentRootPath, Project project) throws IOException, Exception {
        if (templateSet != null) {
            String templateSetFilePath = templateSet.getFile();
            if (templateSetFilePath == null || templateSetFilePath.length() == 0) {
                templateSetFilePath = TemplateSetHelper.findTemplateSetFilePath(templateSet.getTemplateSetName(), EnvironmentRootPath, project, true);
            }
            if (templateSetFilePath != null && templateSetFilePath.length() > 0 && templateSet != null) {
                FileIo.delete((String)templateSetFilePath);
            }
        }
    }

    private static String findTemplateSetFilePath(String TemplateSetName, String EnvironmentRootPath, Project project, boolean checkFile) {
        String egen_source_path;
        String templateSetFilePath = null;
        String fileIdentification = "/config/templatesets/" + TemplateSetName + ".xml";
        if (project != null && (egen_source_path = project.getEgen_source_path()) != null && egen_source_path.length() > 0) {
            File file;
            templateSetFilePath = egen_source_path + fileIdentification;
            if (checkFile && !(file = new File(templateSetFilePath)).exists()) {
                templateSetFilePath = null;
            }
        }
        if (templateSetFilePath == null || templateSetFilePath.length() == 0) {
            templateSetFilePath = EnvironmentRootPath + fileIdentification;
        }
        return templateSetFilePath;
    }

    public static ProcessContext configureProcessContext(String EnvironmentRootPath, Project project, ProcessContext context) throws Exception {
        if (context == null) {
            context = new ProcessContext();
        }
        HashMap templateSetHashMap = null;
        if (project != null) {
            String environmentRootPath = EnvironmentRootPath;
            if (EnvironmentRootPath == null || EnvironmentRootPath.length() == 0) {
                environmentRootPath = project.getHome_path();
            }
            templateSetHashMap = TemplateSetEnvironment.getTemplateSet(environmentRootPath, project);
        } else if (EnvironmentRootPath != null) {
            templateSetHashMap = TemplateSetEnvironment.getTemplateSet(EnvironmentRootPath, null);
        }
        if (templateSetHashMap != null) {
            context.setAttribute("aliases", (Object)templateSetHashMap);
        }
        return context;
    }

    public static ProcessContext configureProcessContext(Project project) throws Exception {
        String environmentRootPath;
        HashMap templateSetHashMap;
        ProcessContext context = new ProcessContext();
        if (project != null && (templateSetHashMap = TemplateSetEnvironment.getTemplateSet(environmentRootPath = project.getHome_path(), project)) != null) {
            context.setAttribute("aliases", (Object)templateSetHashMap);
        }
        return context;
    }

    public static ProcessContext configureProcessContext(String EnvironmentRootPath) throws Exception {
        HashMap templateSetHashMap;
        ProcessContext context = new ProcessContext();
        if (EnvironmentRootPath != null && (templateSetHashMap = TemplateSetEnvironment.getTemplateSet(EnvironmentRootPath, null)) != null) {
            context.setAttribute("aliases", (Object)templateSetHashMap);
        }
        return context;
    }

    public static void fillTemplateList(String TemplateType, ArrayList valueList, ArrayList labelList, String EnvironmentRootPath, Project project) {
        try {
            if (valueList != null && labelList != null && EnvironmentRootPath != null) {
                String templateSetFilePath;
                valueList.clear();
                valueList.add("");
                labelList.clear();
                labelList.add("");
                String templateSetName = "Struts12";
                if (project != null && project.getTemplateSet() != null) {
                    templateSetName = project.getTemplateSet();
                }
                if ((templateSetFilePath = TemplateSetHelper.findTemplateSetFilePath(templateSetName, EnvironmentRootPath, project, true)) != null) {
                    ArrayList templates;
                    String xml = FileIo.read((String)templateSetFilePath);
                    TemplateSet templateSet = new TemplateSet();
                    if ((templateSet = (TemplateSet)Xml.readXml((Object)templateSet, (String)xml)) != null && (templates = templateSet.getTemplates()) != null) {
                        for (int i = 0; i < templates.size(); ++i) {
                            TemplateDef item = (TemplateDef)templates.get(i);
                            String type = item.getTemplateType();
                            if (TemplateType != null && TemplateType.length() > 0) {
                                if (!TemplateType.equals(type)) continue;
                                valueList.add(item.getTemplateAlias());
                                labelList.add(item.getTemplateAlias());
                                continue;
                            }
                            valueList.add(item.getTemplateAlias());
                            labelList.add(item.getTemplateAlias());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Logging.log((String)"com.egen.develop.configuration", (Level)Level.INFO, (String)(ToolOptionsHelper.class.getName() + ".fillOptionsList()."), (Throwable)e);
        }
    }
}

