/*
 * Decompiled with CFR 0.152.
 */
package com.egen.develop.ajax;

import com.egen.develop.ajax.DwrDescriptor;
import com.egen.develop.configuration.TemplateSetHelper;
import com.egen.develop.resource.Project;
import com.egen.develop.util.IOHelper;
import com.egen.util.io.FileIo;
import com.egen.util.io.Xml;
import com.egen.util.process.ProcessContext;
import com.egen.util.process.ProcessFacade;
import com.egen.util.process.ProcessParameter;
import java.io.File;

public class DwrDescriptorHelper {
    public static DwrDescriptor getInstance(Project project) throws Exception {
        DwrDescriptor dwrDescriptor = null;
        if (project != null) {
            dwrDescriptor = new DwrDescriptor();
            String fileName = DwrDescriptorHelper.findPath(project);
            File file = new File(fileName);
            if (file.exists()) {
                String xml = FileIo.read((String)fileName);
                dwrDescriptor = (DwrDescriptor)Xml.readXml((Object)dwrDescriptor, (String)xml);
            } else {
                String xml = Xml.writeXml((Object)dwrDescriptor, (StringBuffer)new StringBuffer());
                FileIo.write((String)fileName, (String)xml);
            }
        }
        return dwrDescriptor;
    }

    public static void save(DwrDescriptor dwrDescriptor, Project project) throws Exception {
        if (project != null && dwrDescriptor != null) {
            String fileName = DwrDescriptorHelper.findPath(project);
            String xml = Xml.writeXml((Object)dwrDescriptor, (StringBuffer)new StringBuffer());
            FileIo.write((String)fileName, (String)xml);
        }
    }

    public static void generate(DwrDescriptor dwrDescriptor, String template, Project project) throws Exception {
        if (project != null && dwrDescriptor != null) {
            ProcessParameter p = new ProcessParameter();
            p.setAttribute(DwrDescriptor.class.getName(), (Object)dwrDescriptor);
            ProcessContext context = TemplateSetHelper.configureProcessContext(project);
            ProcessFacade.execute((String)template, (ProcessContext)context, (ProcessParameter)p);
            String templateReturn = (String)p.getAttribute("com.egen.develop.template.TEMPLATE_RETURN");
            if (templateReturn != null) {
                String drwDescriptorFile = project.getHtml_path() + "/WEB-INF/";
                drwDescriptorFile = IOHelper.correctFileSeparator(drwDescriptorFile);
                drwDescriptorFile = drwDescriptorFile + "dwr.xml";
                FileIo.write((String)drwDescriptorFile, (String)templateReturn);
            }
        }
    }

    private static String findPath(Project project) {
        String file_path = project.getEgen_source_path();
        file_path = IOHelper.correctFileSeparator(file_path);
        String fileName = file_path + "dwr_descriptor.xml";
        return fileName;
    }
}

