import classNames from 'classnames';
import { AzureCredentials } from '@utils/cloudAccountHelpers';
import LabelledInput from '../onboarding-wizard/LabelledInput';
import { CloudAccountPayload } from '../cloud-account/hooks/useCloudAccounts/useCloudAccount';

interface AzureAccountDetailsProps {
  cloudAccountData?: CloudAccountPayload<AzureCredentials>;
  hasError?: boolean;
}

function AzureAccountDetails({
  cloudAccountData,
  hasError = false
}: AzureAccountDetailsProps) {
  return (
    <div className="flex flex-col space-y-4 py-10">
      <LabelledInput
        type="text"
        id="account-name"
        name="name"
        label="Account name"
        placeholder="my-azure-account"
        required
        value={cloudAccountData?.name}
      />

      <div
        className={classNames(
          'flex flex-col space-y-8 rounded-md p-5',
          hasError ? 'bg-red-50' : 'bg-gray-50'
        )}
      >
        <LabelledInput
          type="text"
          id="source"
          name="source"
          label="Source"
          value="Credentials Keys"
          disabled={true}
          required
          icon={
            <svg
              width="24"
              height="25"
              viewBox="0 0 24 25"
              fill="none"
              xmlns="http://www.w3.org/2000/svg"
              className="h-5 w-5"
            >
              <path
                d="M19.79 15.5621C17.73 17.6121 14.78 18.2421 12.19 17.4321L7.48002 22.1321C7.14002 22.4821 6.47002 22.6921 5.99002 22.6221L3.81002 22.3221C3.09002 22.2221 2.42002 21.5421 2.31002 20.8221L2.01002 18.6421C1.94002 18.1621 2.17002 17.4921 2.50002 17.1521L7.20002 12.4521C6.40002 9.85215 7.02002 6.90215 9.08002 4.85215C12.03 1.90215 16.82 1.90215 19.78 4.85215C22.74 7.80215 22.74 12.6121 19.79 15.5621Z"
                stroke="#0C1717"
                strokeWidth="1.5"
                strokeMiterlimit="10"
                strokeLinecap="round"
                strokeLinejoin="round"
              />
              <path
                d="M6.89001 18.1221L9.19001 20.4221"
                stroke="#0C1717"
                strokeWidth="1.5"
                strokeMiterlimit="10"
                strokeLinecap="round"
                strokeLinejoin="round"
              />
              <path
                d="M14.5 11.6318C15.3284 11.6318 16 10.9603 16 10.1318C16 9.30341 15.3284 8.63184 14.5 8.63184C13.6716 8.63184 13 9.30341 13 10.1318C13 10.9603 13.6716 11.6318 14.5 11.6318Z"
                stroke="#0C1717"
                strokeWidth="1.5"
                strokeLinecap="round"
                strokeLinejoin="round"
              />
            </svg>
          }
        />
        <LabelledInput
          type="text"
          id="tenant-id"
          name="tenantId"
          value={cloudAccountData?.credentials.tenantId}
          required
          label="Tenant ID"
          subLabel="The ID of the AAD directory in which you created the application"
          placeholder="00000-00000-00000-00000"
        />
        <LabelledInput
          type="text"
          id="client-id"
          name="clientId"
          value={cloudAccountData?.credentials.clientId}
          required
          label="Client ID"
          subLabel="The secret access key is generated by AWS when an access key is created"
          placeholder="aSbG%hF7kL9p#2jN5mH8qR3tV6wZ"
        />
        <LabelledInput
          type="text"
          id="client-secret"
          name="clientSecret"
          value={cloudAccountData?.credentials.clientSecret}
          required
          label="Client secret"
          subLabel="You can find it as the authentication key string"
          placeholder="9e5b97c6-16a1-4f5d-a3a7-62c4b3b0d8c7"
        />
        <LabelledInput
          type="text"
          id="subscription-id"
          name="subscriptionId"
          value={cloudAccountData?.credentials.subscriptionId}
          required
          label="Subscription ID"
          subLabel="The subscription ID is a GUID that uniquely identifies your subscription to use Azure services"
          placeholder="abcdef12-3456-7890-1234-567890abcdef"
        />
      </div>
      {hasError && (
        <div className="text-sm text-red-500">
          We couldn&apos;t connect to your Azure account. Please check if the
          file is correct.
        </div>
      )}
    </div>
  );
}

export default AzureAccountDetails;
