import * as React from 'react';

function ShapeLine(props) {
  return /*#__PURE__*/ React.createElement(
    'svg',
    Object.assign(
      {
        width: '1em',
        height: '1em',
        viewBox: '0 0 16 17',
        xmlns: 'http://www.w3.org/2000/svg',
        xmlnsXlink: 'http://www.w3.org/1999/xlink',
      },
      props,
      {
        style: Object.assign(
          {
            verticalAlign: '-0.125em',
          },
          props.style,
        ),
        className: ['nanqu-token-panel-icon', props.className].filter(Boolean).join(' '),
      },
    ),
    /*#__PURE__*/ React.createElement(
      'g',
      {
        id: 'ShapeLine-\u9875\u9762-1',
        stroke: 'none',
        strokeWidth: 1,
        fill: 'none',
        fillRule: 'evenodd',
      },
      /*#__PURE__*/ React.createElement(
        'g',
        {
          id: 'ShapeLine-shape-line',
          transform: 'translate(0.000000, 0.923169)',
          fill: 'currentColor',
          fillRule: 'nonzero',
        },
        /*#__PURE__*/ React.createElement('rect', {
          id: 'ShapeLine-\u77E9\u5F62',
          opacity: 0,
          x: 0,
          y: 0,
          width: 16,
          height: 15.9807923,
        }),
        /*#__PURE__*/ React.createElement('path', {
          d: 'M5.22,13.3173269 C4.90928357,14.1946577 4.03334945,14.7416208 3.10760502,14.6363783 C2.18186059,14.5311359 1.45139881,13.801551 1.34602985,12.8769179 C1.24066088,11.9522848 1.78828141,11.0774022 2.66666667,10.7670588 L2.66666667,5.21373349 C1.78828141,4.90339007 1.24066088,4.02850749 1.34602985,3.1038744 C1.45139881,2.1792413 2.18186059,1.44965643 3.10760502,1.34441396 C4.03334945,1.23917149 4.90928357,1.78613461 5.22,2.66346539 L10.78,2.66346539 C11.0907164,1.78613461 11.9666505,1.23917149 12.892395,1.34441396 C13.8181394,1.44965643 14.5486012,2.1792413 14.6539702,3.1038744 C14.7593391,4.02850749 14.2117186,4.90339007 13.3333333,5.21373349 L13.3333333,10.7670588 C14.2117186,11.0774022 14.7593391,11.9522848 14.6539702,12.8769179 C14.5486012,13.801551 13.8181394,14.5311359 12.892395,14.6363783 C11.9666505,14.7416208 11.0907164,14.1946577 10.78,13.3173269 L5.22,13.3173269 Z M5.22,11.9855942 L10.78,11.9855942 C10.9819939,11.4165133 11.430235,10.9688103 12,10.7670588 L12,5.21373349 C11.430235,5.01198206 10.9819939,4.56427905 10.78,3.99519808 L5.22,3.99519808 C5.01800608,4.56427905 4.56976496,5.01198206 4,5.21373349 L4,10.7670588 C4.56976496,10.9688103 5.01800608,11.4165133 5.22,11.9855942 Z M3.33333333,3.99519809 C3.5715347,3.9952345 3.79165744,3.86832906 3.91076865,3.66229434 C4.02987987,3.45625961 4.02987987,3.20240385 3.91076865,2.99636913 C3.79165744,2.79033441 3.5715347,2.66342897 3.33333333,2.66346538 C2.96518335,2.66352168 2.66676872,2.96162371 2.66676872,3.32933173 C2.66676872,3.69703976 2.96518335,3.99514178 3.33333333,3.99519809 L3.33333333,3.99519809 Z M12.6666667,3.99519809 C12.904868,3.9952345 13.1249908,3.86832906 13.244102,3.66229434 C13.3632132,3.45625961 13.3632132,3.20240385 13.244102,2.99636913 C13.1249908,2.79033441 12.904868,2.66342897 12.6666667,2.66346538 C12.2985167,2.66352168 12.0001021,2.96162371 12.0001021,3.32933173 C12.0001021,3.69703976 12.2985167,3.99514178 12.6666667,3.99519809 L12.6666667,3.99519809 Z M12.6666667,13.3173269 C12.904868,13.3173633 13.1249908,13.1904579 13.244102,12.9844232 C13.3632132,12.7783885 13.3632132,12.5245327 13.244102,12.318498 C13.1249908,12.1124633 12.904868,11.9855578 12.6666667,11.9855942 C12.2985167,11.9856505 12.0001021,12.2837526 12.0001021,12.6514606 C12.0001021,13.0191686 12.2985167,13.3172706 12.6666667,13.3173269 L12.6666667,13.3173269 Z M3.33333333,13.3173269 C3.5715347,13.3173633 3.79165744,13.1904579 3.91076865,12.9844232 C4.02987987,12.7783885 4.02987987,12.5245327 3.91076865,12.318498 C3.79165744,12.1124633 3.5715347,11.9855578 3.33333333,11.9855942 C2.96518335,11.9856505 2.66676872,12.2837526 2.66676872,12.6514606 C2.66676872,13.0191686 2.96518335,13.3172706 3.33333333,13.3173269 L3.33333333,13.3173269 Z',
          id: 'ShapeLine-\u5F62\u72B6',
        }),
      ),
    ),
  );
}

export default ShapeLine;
