// 数据表-用户
export const collectionUsers = {
  name: 'users',
  fields: [
    {
      interface: 'id',
      type: 'bigInt',
      name: 'id',
      primaryKey: true,
      autoIncrement: true,
      allowNull: false,
      uiSchema: {
        type: 'number',
        title: '{{t("ID")}}',
        'x-component': 'InputNumber',
        'x-read-pretty': true,
      },
    },
    {
      interface: 'input',
      type: 'string',
      name: 'nickname',
      uiSchema: {
        type: 'string',
        title: '{{t("Nickname")}}',
        'x-component': 'Input',
      },
    },
    {
      interface: 'input',
      type: 'string',
      name: 'username',
      unique: true,
      uiSchema: {
        type: 'string',
        title: '{{t("Username")}}',
        'x-component': 'Input',
        'x-validator': {
          username: true,
        },
        required: true,
      },
    },
    {
      interface: 'email',
      type: 'string',
      name: 'email',
      unique: true,
      uiSchema: {
        type: 'string',
        title: '{{t("Email")}}',
        'x-component': 'Input',
        'x-validator': 'email',
        required: true,
      },
    },
    {
      interface: 'phone',
      type: 'string',
      name: 'phone',
      unique: true,
      uiSchema: {
        type: 'string',
        title: '{{t("Phone")}}',
        'x-component': 'Input',
        'x-validator': 'phone',
        required: true,
      },
    },
    {
      interface: 'm2m',
      type: 'belongsToMany',
      name: 'roles',
      target: 'roles',
      foreignKey: 'userId',
      otherKey: 'roleName',
      onDelete: 'CASCADE',
      sourceKey: 'id',
      targetKey: 'name',
      through: 'rolesUsers',
      uiSchema: {
        type: 'array',
        title: '{{t("Roles")}}',
        'x-component': 'AssociationField',
        'x-component-props': {
          multiple: true,
          fieldNames: {
            label: 'title',
            value: 'name',
          },
        },
      },
    },
    {
      interface: 'm2m',
      type: 'belongsToMany',
      name: 'departments',
      target: 'departments',
      foreignKey: 'userId',
      otherKey: 'departmentId',
      onDelete: 'CASCADE',
      sourceKey: 'id',
      targetKey: 'id',
      through: 'departmentsUsers',
      uiSchema: {
        type: 'array',
        title: '{{t("Departments")}}',
        'x-component': 'DepartmentField',
      },
    },
    {
      interface: 'm2m',
      type: 'belongsToMany',
      name: 'mainDepartment',
      target: 'departments',
      foreignKey: 'userId',
      otherKey: 'departmentId',
      onDelete: 'CASCADE',
      sourceKey: 'id',
      targetKey: 'id',
      through: 'departmentsUsers',
      throughScope: {
        isMain: true,
      },
      uiSchema: {
        type: 'array',
        title: '{{t("Main department")}}',
        'x-component': 'DepartmentField',
      },
    },
  ],
};
