import { CollectionSetting, PageConfig } from '@tachybase/test/e2e';

/**
 * 1. 创建一个名为 general 的 collection，其包含 时间、Percent 类型的字段
 */
export const generalWithDatetimeFields: CollectionSetting[] = [
  {
    name: 'general',
    title: 'General',
    fields: [
      {
        name: 'singleLineText',
        interface: 'input',
        uiSchema: {
          type: 'string',
          'x-component': 'Input',
          title: 'Single line text',
        },
      },
      {
        name: 'startDatetime',
        interface: 'datetime',
        uiSchema: {
          type: 'string',
          'x-component': 'DatePicker',
          title: 'Start date time',
          required: true,
        },
      },
      {
        name: 'endDatetime',
        interface: 'datetime',
        uiSchema: {
          type: 'string',
          'x-component': 'DatePicker',
          title: 'End date time',
          required: true,
        },
      },
      {
        name: 'f_t22o7loai3j',
        interface: 'integer',
        isForeignKey: true,
        uiSchema: {
          type: 'number',
          title: 'f_t22o7loai3j',
          'x-component': 'InputNumber',
          'x-read-pretty': true,
        },
      },
      {
        name: 'manyToOne',
        interface: 'm2o',
        foreignKey: 'f_t22o7loai3j',
        uiSchema: {
          'x-component': 'AssociationField',
          'x-component-props': {
            multiple: false,
            fieldNames: {
              label: 'id',
              value: 'id',
            },
          },
          title: 'Many to one',
        },
        target: 'users',
        targetKey: 'id',
      },
      {
        name: 'percent',
        type: 'float',
        interface: 'percent',
        uiSchema: {
          'x-component-props': {
            step: '0.01',
            stringMode: true,
            addonAfter: '%',
          },
          'x-component': 'Percent',
          title: 'Percent',
        },
      },
    ],
  },
];

export const oneTableWithViewAction: PageConfig = {
  collections: generalWithDatetimeFields,
  pageSchema: {
    type: 'void',
    version: '2.0',
    'x-component': 'Page',
    _isJSONSchemaObject: true,
    properties: {
      xieizx8p4lf: {
        type: 'void',
        version: '2.0',
        'x-component': 'Grid',
        'x-initializer': 'page:addBlock',
        _isJSONSchemaObject: true,
        properties: {
          '8xj4v8eg792': {
            type: 'void',
            version: '2.0',
            'x-component': 'Grid.Row',
            _isJSONSchemaObject: true,
            properties: {
              ghuh9k5lciy: {
                type: 'void',
                version: '2.0',
                'x-component': 'Grid.Col',
                _isJSONSchemaObject: true,
                properties: {
                  xes7knealgh: {
                    type: 'void',
                    version: '2.0',
                    'x-designer': 'TableBlockDesigner',
                    'x-component': 'CardItem',
                    'x-decorator': 'TableBlockProvider',
                    'x-acl-action': 'general:list',
                    'x-filter-targets': [],
                    'x-decorator-props': {
                      action: 'list',
                      params: {
                        pageSize: 20,
                      },
                      rowKey: 'id',
                      dragSort: false,
                      resource: 'general',
                      showIndex: true,
                      collection: 'general',
                      disableTemplate: false,
                    },
                    _isJSONSchemaObject: true,
                    properties: {
                      actions: {
                        type: 'void',
                        version: '2.0',
                        'x-component': 'ActionBar',
                        'x-initializer': 'table:configureActions',
                        'x-component-props': {
                          style: {
                            marginBottom: 'var(--tb-spacing)',
                          },
                        },
                        _isJSONSchemaObject: true,
                        'x-uid': '7yd6j32gi3t',
                        'x-async': false,
                        'x-index': 1,
                      },
                      ivgkbdl5qsl: {
                        type: 'array',
                        version: '2.0',
                        'x-component': 'TableV2',
                        'x-initializer': 'table:configureColumns',
                        'x-component-props': {
                          rowKey: 'id',
                          useProps: '{{ useTableBlockProps }}',
                          rowSelection: {
                            type: 'checkbox',
                          },
                        },
                        _isJSONSchemaObject: true,
                        properties: {
                          actions: {
                            type: 'void',
                            title: '{{ t("Actions") }}',
                            version: '2.0',
                            'x-designer': 'TableV2.ActionColumnDesigner',
                            'x-component': 'TableV2.Column',
                            'x-decorator': 'TableV2.Column.ActionBar',
                            'x-initializer': 'table:configureItemActions',
                            'x-action-column': 'actions',
                            _isJSONSchemaObject: true,
                            properties: {
                              actions: {
                                type: 'void',
                                version: '2.0',
                                'x-component': 'Space',
                                'x-decorator': 'DndContext',
                                'x-component-props': {
                                  split: '|',
                                },
                                _isJSONSchemaObject: true,
                                properties: {
                                  yo5cicv109t: {
                                    type: 'void',
                                    title: '{{ t("View") }}',
                                    version: '2.0',
                                    'x-action': 'view',
                                    'x-designer': 'Action.Designer',
                                    'x-component': 'Action.Link',
                                    'x-decorator': 'ACLActionProvider',
                                    'x-designer-props': {
                                      linkageAction: true,
                                    },
                                    'x-component-props': {
                                      openMode: 'drawer',
                                    },
                                    _isJSONSchemaObject: true,
                                    properties: {
                                      drawer: {
                                        type: 'void',
                                        title: '{{ t("View record") }}',
                                        version: '2.0',
                                        'x-component': 'Action.Container',
                                        'x-component-props': {
                                          className: 'tb-action-popup',
                                        },
                                        _isJSONSchemaObject: true,
                                        properties: {
                                          tabs: {
                                            type: 'void',
                                            version: '2.0',
                                            'x-component': 'Tabs',
                                            'x-initializer': 'TabPaneInitializers',
                                            'x-component-props': {},
                                            _isJSONSchemaObject: true,
                                            properties: {
                                              tab1: {
                                                type: 'void',
                                                title: '{{t("Details")}}',
                                                version: '2.0',
                                                'x-designer': 'Tabs.Designer',
                                                'x-component': 'Tabs.TabPane',
                                                'x-component-props': {},
                                                _isJSONSchemaObject: true,
                                                properties: {
                                                  grid: {
                                                    type: 'void',
                                                    version: '2.0',
                                                    'x-component': 'Grid',
                                                    'x-initializer': 'popup:common:addBlock',
                                                    _isJSONSchemaObject: true,
                                                    properties: {
                                                      v9jpx7749ok: {
                                                        type: 'void',
                                                        version: '2.0',
                                                        'x-component': 'Grid.Row',
                                                        _isJSONSchemaObject: true,
                                                        properties: {
                                                          pniqykhsw7y: {
                                                            type: 'void',
                                                            version: '2.0',
                                                            'x-component': 'Grid.Col',
                                                            _isJSONSchemaObject: true,
                                                            properties: {
                                                              wr8q6b5nv1m: {
                                                                type: 'void',
                                                                version: '2.0',
                                                                'x-designer': 'FormV2.ReadPrettyDesigner',
                                                                'x-component': 'CardItem',
                                                                'x-decorator': 'FormBlockProvider',
                                                                'x-acl-action': 'general:get',
                                                                'x-decorator-props': {
                                                                  action: 'get',
                                                                  resource: 'general',
                                                                  useParams: '{{ useParamsFromRecord }}',
                                                                  collection: 'general',
                                                                  readPretty: true,
                                                                  useSourceId: '{{ useSourceIdFromParentRecord }}',
                                                                },
                                                                _isJSONSchemaObject: true,
                                                                properties: {
                                                                  '3kr5dxwjtg6': {
                                                                    type: 'void',
                                                                    version: '2.0',
                                                                    'x-component': 'FormV2',
                                                                    'x-read-pretty': true,
                                                                    'x-component-props': {
                                                                      useProps: '{{ useFormBlockProps }}',
                                                                    },
                                                                    _isJSONSchemaObject: true,
                                                                    properties: {
                                                                      actions: {
                                                                        type: 'void',
                                                                        version: '2.0',
                                                                        'x-component': 'ActionBar',
                                                                        'x-initializer': 'details:configureActions',
                                                                        'x-component-props': {
                                                                          style: {
                                                                            marginBottom: 24,
                                                                          },
                                                                        },
                                                                        _isJSONSchemaObject: true,
                                                                        'x-uid': 'xfagozpna5f',
                                                                        'x-async': false,
                                                                        'x-index': 1,
                                                                      },
                                                                      grid: {
                                                                        type: 'void',
                                                                        version: '2.0',
                                                                        'x-component': 'Grid',
                                                                        'x-initializer': 'details:configureFields',
                                                                        _isJSONSchemaObject: true,
                                                                        'x-uid': 'kum0xpsh9se',
                                                                        'x-async': false,
                                                                        'x-index': 2,
                                                                      },
                                                                    },
                                                                    'x-uid': 'wfh52ibwf0m',
                                                                    'x-async': false,
                                                                    'x-index': 1,
                                                                  },
                                                                },
                                                                'x-uid': 'yucndoepwjp',
                                                                'x-async': false,
                                                                'x-index': 1,
                                                              },
                                                            },
                                                            'x-uid': 'srns2fk2bm5',
                                                            'x-async': false,
                                                            'x-index': 1,
                                                          },
                                                        },
                                                        'x-uid': 'bl004rxhzxo',
                                                        'x-async': false,
                                                        'x-index': 1,
                                                      },
                                                    },
                                                    'x-uid': 'lbkw6c33nev',
                                                    'x-async': false,
                                                    'x-index': 1,
                                                  },
                                                },
                                                'x-uid': 'z0cz3f3w2ls',
                                                'x-async': false,
                                                'x-index': 1,
                                              },
                                            },
                                            'x-uid': 'h7fj3lyjgcp',
                                            'x-async': false,
                                            'x-index': 1,
                                          },
                                        },
                                        'x-uid': 'vnb6jm1n4mr',
                                        'x-async': false,
                                        'x-index': 1,
                                      },
                                    },
                                    'x-uid': 'ts9jr505zwp',
                                    'x-async': false,
                                    'x-index': 1,
                                  },
                                },
                                'x-uid': '0odqbqq1w1b',
                                'x-async': false,
                                'x-index': 1,
                              },
                            },
                            'x-uid': 'ik6vmhvlwq0',
                            'x-async': false,
                            'x-index': 1,
                          },
                        },
                        'x-uid': 'zi8p6p4yv7n',
                        'x-async': false,
                        'x-index': 2,
                      },
                    },
                    'x-uid': 'axnj0ck85xs',
                    'x-async': false,
                    'x-index': 1,
                  },
                },
                'x-uid': '5ryow4jpdv8',
                'x-async': false,
                'x-index': 1,
              },
            },
            'x-uid': 'tutp0qeuczt',
            'x-async': false,
            'x-index': 1,
          },
        },
      },
    },
  },
};

export const oneCalenderWithViewAction: PageConfig = {
  collections: generalWithDatetimeFields,
  pageSchema: {
    type: 'void',
    version: '2.0',
    'x-component': 'Page',
    _isJSONSchemaObject: true,
    properties: {
      xieizx8p4lf: {
        type: 'void',
        version: '2.0',
        'x-component': 'Grid',
        'x-initializer': 'page:addBlock',
        _isJSONSchemaObject: true,
        properties: {
          '8er4x7qwc0p': {
            type: 'void',
            version: '2.0',
            'x-component': 'Grid.Row',
            _isJSONSchemaObject: true,
            properties: {
              ihsa0qvrlz0: {
                type: 'void',
                version: '2.0',
                'x-component': 'Grid.Col',
                _isJSONSchemaObject: true,
                properties: {
                  '2tocmd26pct': {
                    type: 'void',
                    version: '2.0',
                    'x-designer': 'CalendarV2.Designer',
                    'x-component': 'CardItem',
                    'x-decorator': 'CalendarBlockProvider',
                    'x-acl-action': 'general:list',
                    'x-decorator-props': {
                      action: 'list',
                      params: {
                        paginate: false,
                      },
                      resource: 'general',
                      collection: 'general',
                      fieldNames: {
                        id: 'id',
                        end: ['endDateTime'],
                        start: ['startDateTime'],
                        title: 'singleLineText',
                      },
                    },
                    _isJSONSchemaObject: true,
                    properties: {
                      ac13dxxbtdx: {
                        type: 'void',
                        version: '2.0',
                        'x-component': 'CalendarV2',
                        'x-component-props': {
                          useProps: '{{ useCalendarBlockProps }}',
                        },
                        _isJSONSchemaObject: true,
                        properties: {
                          toolBar: {
                            type: 'void',
                            version: '2.0',
                            'x-component': 'CalendarV2.ActionBar',
                            'x-initializer': 'calendar:configureActions',
                            'x-component-props': {
                              style: {
                                marginBottom: 24,
                              },
                            },
                            _isJSONSchemaObject: true,
                            properties: {
                              '6gz1f7kcy9f': {
                                type: 'void',
                                title: "{{t('Add new')}}",
                                version: '2.0',
                                'x-align': 'right',
                                'x-action': 'create',
                                'x-designer': 'Action.Designer',
                                'x-component': 'Action',
                                'x-decorator': 'ACLActionProvider',
                                'x-acl-action': 'create',
                                'x-component-props': {
                                  icon: 'PlusOutlined',
                                  type: 'primary',
                                  openMode: 'drawer',
                                  component: 'CreateRecordAction',
                                },
                                'x-acl-action-props': {
                                  skipScopeCheck: true,
                                },
                                _isJSONSchemaObject: true,
                                properties: {
                                  drawer: {
                                    type: 'void',
                                    title: '{{ t("Add record") }}',
                                    version: '2.0',
                                    'x-component': 'Action.Container',
                                    'x-component-props': {
                                      className: 'tb-action-popup',
                                    },
                                    _isJSONSchemaObject: true,
                                    properties: {
                                      tabs: {
                                        type: 'void',
                                        version: '2.0',
                                        'x-component': 'Tabs',
                                        'x-initializer': 'TabPaneInitializersForCreateFormBlock',
                                        'x-component-props': {},
                                        _isJSONSchemaObject: true,
                                        properties: {
                                          tab1: {
                                            type: 'void',
                                            title: '{{t("Add new")}}',
                                            version: '2.0',
                                            'x-designer': 'Tabs.Designer',
                                            'x-component': 'Tabs.TabPane',
                                            'x-component-props': {},
                                            _isJSONSchemaObject: true,
                                            properties: {
                                              grid: {
                                                type: 'void',
                                                version: '2.0',
                                                'x-component': 'Grid',
                                                'x-initializer': 'popup:addNew:addBlock',
                                                _isJSONSchemaObject: true,
                                                properties: {
                                                  '7e9xtqdm96x': {
                                                    type: 'void',
                                                    version: '2.0',
                                                    'x-component': 'Grid.Row',
                                                    _isJSONSchemaObject: true,
                                                    properties: {
                                                      '49cc4rzlix3': {
                                                        type: 'void',
                                                        version: '2.0',
                                                        'x-component': 'Grid.Col',
                                                        _isJSONSchemaObject: true,
                                                        properties: {
                                                          aqlgjvkrcx7: {
                                                            type: 'void',
                                                            version: '2.0',
                                                            'x-designer': 'FormV2.Designer',
                                                            'x-component': 'CardItem',
                                                            'x-decorator': 'FormBlockProvider',
                                                            'x-acl-action': 'general:create',
                                                            'x-component-props': {},
                                                            'x-decorator-props': {
                                                              resource: 'general',
                                                              collection: 'general',
                                                            },
                                                            'x-acl-action-props': {
                                                              skipScopeCheck: true,
                                                            },
                                                            _isJSONSchemaObject: true,
                                                            properties: {
                                                              e9hvag8g8z1: {
                                                                type: 'void',
                                                                version: '2.0',
                                                                'x-component': 'FormV2',
                                                                'x-component-props': {
                                                                  useProps: '{{ useFormBlockProps }}',
                                                                },
                                                                _isJSONSchemaObject: true,
                                                                properties: {
                                                                  grid: {
                                                                    type: 'void',
                                                                    version: '2.0',
                                                                    'x-component': 'Grid',
                                                                    'x-initializer': 'form:configureFields',
                                                                    _isJSONSchemaObject: true,
                                                                    properties: {
                                                                      ikh538659hb: {
                                                                        type: 'void',
                                                                        version: '2.0',
                                                                        'x-component': 'Grid.Row',
                                                                        _isJSONSchemaObject: true,
                                                                        properties: {
                                                                          n0gqcx2an2n: {
                                                                            type: 'void',
                                                                            version: '2.0',
                                                                            'x-component': 'Grid.Col',
                                                                            _isJSONSchemaObject: true,
                                                                            properties: {
                                                                              f_gsdltgajej4: {
                                                                                type: 'string',
                                                                                version: '2.0',
                                                                                'x-designer': 'FormItem.Designer',
                                                                                'x-component': 'CollectionField',
                                                                                'x-decorator': 'FormItem',
                                                                                'x-component-props': {},
                                                                                'x-collection-field':
                                                                                  'general.f_gsdltgajej4',
                                                                                _isJSONSchemaObject: true,
                                                                                'x-uid': 'oa2zgpva04m',
                                                                                'x-async': false,
                                                                                'x-index': 1,
                                                                              },
                                                                            },
                                                                            'x-uid': 'zj8cfg6yn8l',
                                                                            'x-async': false,
                                                                            'x-index': 1,
                                                                          },
                                                                        },
                                                                        'x-uid': 'pjalhrecpln',
                                                                        'x-async': false,
                                                                        'x-index': 1,
                                                                      },
                                                                      axdppstkbuy: {
                                                                        type: 'void',
                                                                        version: '2.0',
                                                                        'x-component': 'Grid.Row',
                                                                        _isJSONSchemaObject: true,
                                                                        properties: {
                                                                          gwjxqr45unr: {
                                                                            type: 'void',
                                                                            version: '2.0',
                                                                            'x-component': 'Grid.Col',
                                                                            _isJSONSchemaObject: true,
                                                                            properties: {
                                                                              f_3sjr0e6uvdv: {
                                                                                type: 'string',
                                                                                version: '2.0',
                                                                                'x-designer': 'FormItem.Designer',
                                                                                'x-component': 'CollectionField',
                                                                                'x-decorator': 'FormItem',
                                                                                'x-component-props': {},
                                                                                'x-collection-field':
                                                                                  'general.f_3sjr0e6uvdv',
                                                                                _isJSONSchemaObject: true,
                                                                                'x-uid': 'w32tknasgsz',
                                                                                'x-async': false,
                                                                                'x-index': 1,
                                                                              },
                                                                            },
                                                                            'x-uid': 'p33boqlbg5g',
                                                                            'x-async': false,
                                                                            'x-index': 1,
                                                                          },
                                                                        },
                                                                        'x-uid': 'm2uf9lc6gnk',
                                                                        'x-async': false,
                                                                        'x-index': 2,
                                                                      },
                                                                      '2cv7fqwte5j': {
                                                                        type: 'void',
                                                                        version: '2.0',
                                                                        'x-component': 'Grid.Row',
                                                                        _isJSONSchemaObject: true,
                                                                        properties: {
                                                                          '33bbe57si0a': {
                                                                            type: 'void',
                                                                            version: '2.0',
                                                                            'x-component': 'Grid.Col',
                                                                            _isJSONSchemaObject: true,
                                                                            properties: {
                                                                              f_fxzp8hq7x3g: {
                                                                                type: 'string',
                                                                                version: '2.0',
                                                                                'x-designer': 'FormItem.Designer',
                                                                                'x-component': 'CollectionField',
                                                                                'x-decorator': 'FormItem',
                                                                                'x-component-props': {},
                                                                                'x-collection-field':
                                                                                  'general.f_fxzp8hq7x3g',
                                                                                _isJSONSchemaObject: true,
                                                                                'x-uid': '85pbklphbhd',
                                                                                'x-async': false,
                                                                                'x-index': 1,
                                                                              },
                                                                            },
                                                                            'x-uid': 'adjbay0axfl',
                                                                            'x-async': false,
                                                                            'x-index': 1,
                                                                          },
                                                                        },
                                                                        'x-uid': '8exc4ivguxv',
                                                                        'x-async': false,
                                                                        'x-index': 3,
                                                                      },
                                                                    },
                                                                    'x-uid': 'u0jmxwugzrx',
                                                                    'x-async': false,
                                                                    'x-index': 1,
                                                                  },
                                                                  actions: {
                                                                    type: 'void',
                                                                    version: '2.0',
                                                                    'x-component': 'ActionBar',
                                                                    'x-initializer': 'createForm:configureActions',
                                                                    'x-component-props': {
                                                                      style: {
                                                                        marginTop: 24,
                                                                      },
                                                                      layout: 'one-column',
                                                                    },
                                                                    _isJSONSchemaObject: true,
                                                                    properties: {
                                                                      qnx55tt3wat: {
                                                                        type: 'void',
                                                                        title: '{{ t("Submit") }}',
                                                                        version: '2.0',
                                                                        'x-action': 'submit',
                                                                        'x-designer': 'Action.Designer',
                                                                        'x-component': 'Action',
                                                                        'x-action-settings': {
                                                                          triggerWorkflows: [],
                                                                        },
                                                                        'x-component-props': {
                                                                          type: 'primary',
                                                                          htmlType: 'submit',
                                                                          useProps: '{{ useCreateActionProps }}',
                                                                        },
                                                                        _isJSONSchemaObject: true,
                                                                        'x-uid': '264pfxox9kd',
                                                                        'x-async': false,
                                                                        'x-index': 1,
                                                                      },
                                                                    },
                                                                    'x-uid': 'r6vw3madgav',
                                                                    'x-async': false,
                                                                    'x-index': 2,
                                                                  },
                                                                },
                                                                'x-uid': '0zblewekh2c',
                                                                'x-async': false,
                                                                'x-index': 1,
                                                              },
                                                            },
                                                            'x-uid': '93lpozbj1vl',
                                                            'x-async': false,
                                                            'x-index': 1,
                                                          },
                                                        },
                                                        'x-uid': 'b8jlo8hoild',
                                                        'x-async': false,
                                                        'x-index': 1,
                                                      },
                                                    },
                                                    'x-uid': 'jw54aewoz9w',
                                                    'x-async': false,
                                                    'x-index': 1,
                                                  },
                                                },
                                                'x-uid': 'q4cx3qzdfs1',
                                                'x-async': false,
                                                'x-index': 1,
                                              },
                                            },
                                            'x-uid': 'gkxz1m2j6tf',
                                            'x-async': false,
                                            'x-index': 1,
                                          },
                                        },
                                        'x-uid': '1siw8ntx5hc',
                                        'x-async': false,
                                        'x-index': 1,
                                      },
                                    },
                                    'x-uid': '7v0kc5p1qgz',
                                    'x-async': false,
                                    'x-index': 1,
                                  },
                                },
                                'x-uid': 'eql58c5e8gy',
                                'x-async': false,
                                'x-index': 1,
                              },
                            },
                            'x-uid': '4vbgl2z1230',
                            'x-async': false,
                            'x-index': 1,
                          },
                          event: {
                            type: 'void',
                            version: '2.0',
                            'x-component': 'CalendarV2.Event',
                            _isJSONSchemaObject: true,
                            properties: {
                              drawer: {
                                type: 'void',
                                title: '{{ t("View record") }}',
                                version: '2.0',
                                'x-component': 'Action.Drawer',
                                'x-component-props': {
                                  className: 'tb-action-popup',
                                },
                                _isJSONSchemaObject: true,
                                properties: {
                                  tabs: {
                                    type: 'void',
                                    version: '2.0',
                                    'x-component': 'Tabs',
                                    'x-initializer': 'TabPaneInitializers',
                                    'x-component-props': {},
                                    _isJSONSchemaObject: true,
                                    'x-initializer-props': {
                                      gridInitializer: 'popup:common:addBlock',
                                    },
                                    properties: {
                                      tab1: {
                                        type: 'void',
                                        title: '{{t("Details")}}',
                                        version: '2.0',
                                        'x-designer': 'Tabs.Designer',
                                        'x-component': 'Tabs.TabPane',
                                        'x-component-props': {},
                                        _isJSONSchemaObject: true,
                                        properties: {
                                          grid: {
                                            type: 'void',
                                            version: '2.0',
                                            'x-component': 'Grid',
                                            'x-initializer': 'popup:common:addBlock',
                                            _isJSONSchemaObject: true,
                                            'x-initializer-props': {
                                              actionInitializers: 'details:configureActions',
                                            },
                                            properties: {
                                              '0j7rb0bivys': {
                                                type: 'void',
                                                version: '2.0',
                                                'x-component': 'Grid.Row',
                                                _isJSONSchemaObject: true,
                                                properties: {
                                                  o4f9ukr5ddb: {
                                                    type: 'void',
                                                    version: '2.0',
                                                    'x-component': 'Grid.Col',
                                                    _isJSONSchemaObject: true,
                                                    properties: {
                                                      '8ek51sk98tr': {
                                                        type: 'void',
                                                        version: '2.0',
                                                        'x-designer': 'FormV2.ReadPrettyDesigner',
                                                        'x-component': 'CardItem',
                                                        'x-decorator': 'FormBlockProvider',
                                                        'x-acl-action': 'general:get',
                                                        'x-decorator-props': {
                                                          action: 'get',
                                                          resource: 'general',
                                                          useParams: '{{ useParamsFromRecord }}',
                                                          collection: 'general',
                                                          readPretty: true,
                                                          useSourceId: '{{ useSourceIdFromParentRecord }}',
                                                        },
                                                        _isJSONSchemaObject: true,
                                                        properties: {
                                                          k3af8hdt47o: {
                                                            type: 'void',
                                                            version: '2.0',
                                                            'x-component': 'FormV2',
                                                            'x-read-pretty': true,
                                                            'x-component-props': {
                                                              useProps: '{{ useFormBlockProps }}',
                                                            },
                                                            _isJSONSchemaObject: true,
                                                            properties: {
                                                              actions: {
                                                                type: 'void',
                                                                version: '2.0',
                                                                'x-component': 'ActionBar',
                                                                'x-initializer': 'details:configureActions',
                                                                'x-component-props': {
                                                                  style: {
                                                                    marginBottom: 24,
                                                                  },
                                                                },
                                                                _isJSONSchemaObject: true,
                                                                'x-uid': 'qlwu7qv0in8',
                                                                'x-async': false,
                                                                'x-index': 1,
                                                              },
                                                              grid: {
                                                                type: 'void',
                                                                version: '2.0',
                                                                'x-component': 'Grid',
                                                                'x-initializer': 'details:configureFields',
                                                                _isJSONSchemaObject: true,
                                                                'x-uid': 'br7bq2ddccy',
                                                                'x-async': false,
                                                                'x-index': 2,
                                                              },
                                                            },
                                                            'x-uid': 'el0x7lhmzhh',
                                                            'x-async': false,
                                                            'x-index': 1,
                                                          },
                                                        },
                                                        'x-uid': 'fel6h5vudp2',
                                                        'x-async': false,
                                                        'x-index': 1,
                                                      },
                                                    },
                                                    'x-uid': 'f5zkbrpb0jw',
                                                    'x-async': false,
                                                    'x-index': 1,
                                                  },
                                                },
                                                'x-uid': 's5neszd0kjk',
                                                'x-async': false,
                                                'x-index': 1,
                                              },
                                            },
                                            'x-uid': 'qzrhtapf6w8',
                                            'x-async': false,
                                            'x-index': 1,
                                          },
                                        },
                                        'x-uid': '7w618khbjpg',
                                        'x-async': false,
                                        'x-index': 1,
                                      },
                                    },
                                    'x-uid': '9xkbplyqfwg',
                                    'x-async': false,
                                    'x-index': 1,
                                  },
                                },
                                'x-uid': '7zn54xk2fim',
                                'x-async': false,
                                'x-index': 1,
                              },
                            },
                            'x-uid': '8bgjrafg6be',
                            'x-async': false,
                            'x-index': 2,
                          },
                        },
                        'x-uid': 'z2venf40j0t',
                        'x-async': false,
                        'x-index': 1,
                      },
                    },
                    'x-uid': '6w8yaucqe97',
                    'x-async': false,
                    'x-index': 1,
                  },
                },
                'x-uid': 'zxbujzse5o0',
                'x-async': false,
                'x-index': 1,
              },
            },
            'x-uid': 'd6sohpn2e5u',
            'x-async': false,
            'x-index': 1,
          },
        },
        'x-uid': 'h3e5hz7qv5p',
        'x-async': false,
        'x-index': 1,
      },
    },
    'x-uid': 'a0wcr2f03wj',
    'x-async': true,
    'x-index': 1,
  },
};
