import actions from '@tachybase/actions';
import { HandlerType } from '@tachybase/resourcer';
import { Plugin } from '@tachybase/server';

import WorkflowPlugin, { JOB_STATUS } from '../..';
import { submit } from './actions';
import ManualInstruction from './ManualInstruction';

export class PluginManual extends Plugin {
  async load() {
    this.app.resourcer.define({
      name: 'users_jobs',
      actions: {
        list: {
          filter: {
            $or: [
              {
                'workflow.enabled': true,
              },
              {
                'workflow.enabled': false,
                status: {
                  $ne: JOB_STATUS.PENDING,
                },
              },
            ],
          },
          handler: actions.list as HandlerType,
        },
        submit,
      },
    });

    this.app.acl.allow('users_jobs', ['list', 'get', 'submit'], 'loggedIn');

    const workflowPlugin = this.app.pm.get(WorkflowPlugin) as WorkflowPlugin;
    workflowPlugin.registerInstruction('manual', ManualInstruction);
  }
}
