import { Authenticator } from '@tachybase/auth';
import { Database, Model } from '@tachybase/database';

export class AuthModel extends Model implements Authenticator {
  declare authType: string;
  declare options: any;

  async findUser(uuid: string) {
    let user: Model;
    const users = await this.getUsers({
      through: {
        where: { uuid },
      },
    });
    if (users.length) {
      user = users[0];
      return user;
    }
    return null;
  }

  async newUser(uuid: string, userValues?: any) {
    let user: Model;
    const db: Database = (this.constructor as any).database;
    await this.sequelize.transaction(async (transaction) => {
      // Create a new user if not exists
      user = await this.createUser(
        userValues || {
          nickname: uuid,
        },
        {
          through: {
            uuid: uuid,
          },
          transaction,
        },
      );
      await db.emitAsync(`users.afterCreateWithAssociations`, user, {
        transaction,
      });
    });
    return user;
  }

  async findOrCreateUser(uuid: string, userValues?: any) {
    const user = await this.findUser(uuid);
    if (user) {
      return user;
    }

    return await this.newUser(uuid, userValues);
  }

  async bindUser(userId: number, uuid: string, info: Record<string, any>) {
    await this.sequelize.transaction(async (transaction) => {
      await this.addUser(userId, {
        through: {
          uuid: uuid,
          ...info,
        },
        transaction,
      });
    });
  }
}
