import React from 'react';
import { css, PoweredBy, useAPIClient, useRequest, useSystemSettings } from '@tachybase/client';

import { Outlet } from 'react-router-dom';

import { AuthenticatorsContext } from '../authenticator';

export function AuthLayout(props: any) {
  const { data } = useSystemSettings();
  const api = useAPIClient();
  const { data: authenticators = [], error } = useRequest(() =>
    api
      .resource('authenticators')
      .publicList()
      .then((res) => {
        return res?.data?.data || [];
      }),
  );

  if (error) {
    throw error;
  }

  return (
    <div
      style={{
        maxWidth: 320,
        margin: '0 auto',
        paddingTop: '20vh',
      }}
    >
      <h1>{data?.data?.title}</h1>
      <AuthenticatorsContext.Provider value={authenticators as any}>
        <Outlet />
      </AuthenticatorsContext.Provider>
      <div
        className={css`
          position: absolute;
          bottom: 24px;
          width: 100%;
          left: 0;
          text-align: center;
        `}
      >
        <PoweredBy />
      </div>
    </div>
  );
}
