// Generated by Peggy 3.0.2.
//
// https://peggyjs.org/

'use strict';

function peg$subclass(child, parent) {
  function C() {
    this.constructor = child;
  }
  C.prototype = parent.prototype;
  child.prototype = new C();
}

function peg$SyntaxError(message, expected, found, location) {
  var self = Error.call(this, message);
  // istanbul ignore next Check is a necessary evil to support older environments
  if (Object.setPrototypeOf) {
    Object.setPrototypeOf(self, peg$SyntaxError.prototype);
  }
  self.expected = expected;
  self.found = found;
  self.location = location;
  self.name = 'SyntaxError';
  return self;
}

peg$subclass(peg$SyntaxError, Error);

function peg$padEnd(str, targetLength, padString) {
  padString = padString || ' ';
  if (str.length > targetLength) {
    return str;
  }
  targetLength -= str.length;
  padString += padString.repeat(targetLength);
  return str + padString.slice(0, targetLength);
}

peg$SyntaxError.prototype.format = function (sources) {
  var str = 'Error: ' + this.message;
  if (this.location) {
    var src = null;
    var k;
    for (k = 0; k < sources.length; k++) {
      if (sources[k].source === this.location.source) {
        src = sources[k].text.split(/\r\n|\n|\r/g);
        break;
      }
    }
    var s = this.location.start;
    var offset_s =
      this.location.source && typeof this.location.source.offset === 'function' ? this.location.source.offset(s) : s;
    var loc = this.location.source + ':' + offset_s.line + ':' + offset_s.column;
    if (src) {
      var e = this.location.end;
      var filler = peg$padEnd('', offset_s.line.toString().length, ' ');
      var line = src[s.line - 1];
      var last = s.line === e.line ? e.column : line.length + 1;
      var hatLen = last - s.column || 1;
      str +=
        '\n --> ' +
        loc +
        '\n' +
        filler +
        ' |\n' +
        offset_s.line +
        ' | ' +
        line +
        '\n' +
        filler +
        ' | ' +
        peg$padEnd('', s.column - 1, ' ') +
        peg$padEnd('', hatLen, '^');
    } else {
      str += '\n at ' + loc;
    }
  }
  return str;
};

peg$SyntaxError.buildMessage = function (expected, found) {
  var DESCRIBE_EXPECTATION_FNS = {
    literal: function (expectation) {
      return '"' + literalEscape(expectation.text) + '"';
    },

    class: function (expectation) {
      var escapedParts = expectation.parts.map(function (part) {
        return Array.isArray(part) ? classEscape(part[0]) + '-' + classEscape(part[1]) : classEscape(part);
      });

      return '[' + (expectation.inverted ? '^' : '') + escapedParts.join('') + ']';
    },

    any: function () {
      return 'any character';
    },

    end: function () {
      return 'end of input';
    },

    other: function (expectation) {
      return expectation.description;
    },
  };

  function hex(ch) {
    return ch.charCodeAt(0).toString(16).toUpperCase();
  }

  function literalEscape(s) {
    return s
      .replace(/\\/g, '\\\\')
      .replace(/"/g, '\\"')
      .replace(/\0/g, '\\0')
      .replace(/\t/g, '\\t')
      .replace(/\n/g, '\\n')
      .replace(/\r/g, '\\r')
      .replace(/[\x00-\x0F]/g, function (ch) {
        return '\\x0' + hex(ch);
      })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function (ch) {
        return '\\x' + hex(ch);
      });
  }

  function classEscape(s) {
    return s
      .replace(/\\/g, '\\\\')
      .replace(/\]/g, '\\]')
      .replace(/\^/g, '\\^')
      .replace(/-/g, '\\-')
      .replace(/\0/g, '\\0')
      .replace(/\t/g, '\\t')
      .replace(/\n/g, '\\n')
      .replace(/\r/g, '\\r')
      .replace(/[\x00-\x0F]/g, function (ch) {
        return '\\x0' + hex(ch);
      })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function (ch) {
        return '\\x' + hex(ch);
      });
  }

  function describeExpectation(expectation) {
    return DESCRIBE_EXPECTATION_FNS[expectation.type](expectation);
  }

  function describeExpected(expected) {
    var descriptions = expected.map(describeExpectation);
    var i, j;

    descriptions.sort();

    if (descriptions.length > 0) {
      for (i = 1, j = 1; i < descriptions.length; i++) {
        if (descriptions[i - 1] !== descriptions[i]) {
          descriptions[j] = descriptions[i];
          j++;
        }
      }
      descriptions.length = j;
    }

    switch (descriptions.length) {
      case 1:
        return descriptions[0];

      case 2:
        return descriptions[0] + ' or ' + descriptions[1];

      default:
        return descriptions.slice(0, -1).join(', ') + ', or ' + descriptions[descriptions.length - 1];
    }
  }

  function describeFound(found) {
    return found ? '"' + literalEscape(found) + '"' : 'end of input';
  }

  return 'Expected ' + describeExpected(expected) + ' but ' + describeFound(found) + ' found.';
};

function peg$parse(input, options) {
  options = options !== undefined ? options : {};

  var peg$FAILED = {};
  var peg$source = options.grammarSource;

  var peg$startRuleFunctions = { start: peg$parsestart };
  var peg$startRuleFunction = peg$parsestart;

  var peg$c0 = 'if';
  var peg$c1 = 'extension';
  var peg$c2 = 'schema';
  var peg$c3 = 'version';
  var peg$c4 = 'cascaded';
  var peg$c5 = 'local';
  var peg$c6 = 'check';
  var peg$c7 = 'OPTION';
  var peg$c8 = 'check_option';
  var peg$c9 = 'security_barrier';
  var peg$c10 = 'security_invoker';
  var peg$c11 = 'sfunc';
  var peg$c12 = 'stype';
  var peg$c13 = 'aggregate';
  var peg$c14 = 'returns';
  var peg$c15 = 'setof';
  var peg$c16 = 'constant';
  var peg$c17 = ':=';
  var peg$c18 = 'begin';
  var peg$c19 = 'declare';
  var peg$c20 = 'LANGUAGE';
  var peg$c21 = 'transorm';
  var peg$c22 = 'FOR';
  var peg$c23 = 'TYPE';
  var peg$c24 = 'window';
  var peg$c25 = 'immutable';
  var peg$c26 = 'stable';
  var peg$c27 = 'volatile';
  var peg$c28 = 'strict';
  var peg$c29 = 'not';
  var peg$c30 = 'leakproof';
  var peg$c31 = 'called';
  var peg$c32 = 'null';
  var peg$c33 = 'on';
  var peg$c34 = 'input';
  var peg$c35 = 'external';
  var peg$c36 = 'security';
  var peg$c37 = 'invoker';
  var peg$c38 = 'definer';
  var peg$c39 = 'parallel';
  var peg$c40 = 'unsafe';
  var peg$c41 = 'restricted';
  var peg$c42 = 'safe';
  var peg$c43 = 'cost';
  var peg$c44 = 'rows';
  var peg$c45 = 'support';
  var peg$c46 = 'to';
  var peg$c47 = '=';
  var peg$c48 = 'current';
  var peg$c49 = 'function';
  var peg$c50 = 'type';
  var peg$c51 = 'domain';
  var peg$c52 = 'increment';
  var peg$c53 = 'minvalue';
  var peg$c54 = 'no';
  var peg$c55 = 'maxvalue';
  var peg$c56 = 'start';
  var peg$c57 = 'cache';
  var peg$c58 = 'cycle';
  var peg$c59 = 'owned';
  var peg$c60 = 'none';
  var peg$c61 = 'nulls';
  var peg$c62 = 'first';
  var peg$c63 = 'last';
  var peg$c64 = 'auto_increment';
  var peg$c65 = 'unique';
  var peg$c66 = 'key';
  var peg$c67 = 'primary';
  var peg$c68 = 'column_format';
  var peg$c69 = 'fixed';
  var peg$c70 = 'dynamic';
  var peg$c71 = 'default';
  var peg$c72 = 'storage';
  var peg$c73 = 'disk';
  var peg$c74 = 'memory';
  var peg$c75 = 'cascade';
  var peg$c76 = 'restrict';
  var peg$c77 = 'out';
  var peg$c78 = 'variadic';
  var peg$c79 = 'inout';
  var peg$c80 = 'owner';
  var peg$c81 = 'current_role';
  var peg$c82 = 'current_user';
  var peg$c83 = 'session_user';
  var peg$c84 = 'algorithm';
  var peg$c85 = 'instant';
  var peg$c86 = 'inplace';
  var peg$c87 = 'copy';
  var peg$c88 = 'lock';
  var peg$c89 = 'shared';
  var peg$c90 = 'exclusive';
  var peg$c91 = 'primary key';
  var peg$c92 = 'foreign key';
  var peg$c93 = 'match full';
  var peg$c94 = 'match partial';
  var peg$c95 = 'match simple';
  var peg$c96 = 'set null';
  var peg$c97 = 'no action';
  var peg$c98 = 'set default';
  var peg$c99 = 'trigger';
  var peg$c100 = 'before';
  var peg$c101 = 'after';
  var peg$c102 = 'instead of';
  var peg$c103 = 'execute';
  var peg$c104 = 'procedure';
  var peg$c105 = 'of';
  var peg$c106 = 'deferrable';
  var peg$c107 = 'initially immediate';
  var peg$c108 = 'initially deferred';
  var peg$c109 = 'for';
  var peg$c110 = 'each';
  var peg$c111 = 'row';
  var peg$c112 = 'statement';
  var peg$c113 = 'character';
  var peg$c114 = 'set';
  var peg$c115 = 'charset';
  var peg$c116 = 'collate';
  var peg$c117 = 'avg_row_length';
  var peg$c118 = 'key_block_size';
  var peg$c119 = 'max_rows';
  var peg$c120 = 'min_rows';
  var peg$c121 = 'stats_sample_pages';
  var peg$c122 = 'connection';
  var peg$c123 = 'compression';
  var peg$c124 = "'";
  var peg$c125 = 'zlib';
  var peg$c126 = 'lz4';
  var peg$c127 = 'engine';
  var peg$c128 = 'in';
  var peg$c129 = 'access share';
  var peg$c130 = 'row share';
  var peg$c131 = 'row exclusive';
  var peg$c132 = 'share update exclusive';
  var peg$c133 = 'share row exclusive';
  var peg$c134 = 'access exclusive';
  var peg$c135 = 'share';
  var peg$c136 = 'mode';
  var peg$c137 = 'nowait';
  var peg$c138 = 'tables';
  var peg$c139 = 'prepare';
  var peg$c140 = 'usage';
  var peg$c141 = 'connect';
  var peg$c142 = 'privileges';
  var peg$c143 = 'sequence';
  var peg$c144 = 'database';
  var peg$c145 = 'DOMAIN';
  var peg$c146 = 'FUNCTION';
  var peg$c147 = 'routine';
  var peg$c148 = 'language';
  var peg$c149 = 'large';
  var peg$c150 = 'SCHEMA';
  var peg$c151 = 'functions';
  var peg$c152 = 'procedures';
  var peg$c153 = 'routines';
  var peg$c154 = 'public';
  var peg$c155 = 'grant';
  var peg$c156 = 'option';
  var peg$c157 = 'admin';
  var peg$c158 = 'revoke';
  var peg$c159 = 'elseif';
  var peg$c160 = 'then';
  var peg$c161 = 'end';
  var peg$c162 = 'debug';
  var peg$c163 = 'log';
  var peg$c164 = 'info';
  var peg$c165 = 'notice';
  var peg$c166 = 'warning';
  var peg$c167 = 'exception';
  var peg$c168 = 'message';
  var peg$c169 = 'detail';
  var peg$c170 = 'hint';
  var peg$c171 = 'errcode';
  var peg$c172 = 'column';
  var peg$c173 = 'constraint';
  var peg$c174 = 'datatype';
  var peg$c175 = 'table';
  var peg$c176 = 'sqlstate';
  var peg$c177 = 'raise';
  var peg$c178 = 'loop';
  var peg$c179 = ';';
  var peg$c180 = '(';
  var peg$c181 = ')';
  var peg$c182 = '"';
  var peg$c183 = 'outfile';
  var peg$c184 = 'dumpfile';
  var peg$c185 = 'btree';
  var peg$c186 = 'hash';
  var peg$c187 = 'gist';
  var peg$c188 = 'gin';
  var peg$c189 = 'with';
  var peg$c190 = 'parser';
  var peg$c191 = 'visible';
  var peg$c192 = 'invisible';
  var peg$c193 = 'lateral';
  var peg$c194 = 'tablesample';
  var peg$c195 = 'repeatable';
  var peg$c196 = 'cross';
  var peg$c197 = 'following';
  var peg$c198 = 'preceding';
  var peg$c199 = 'unbounded';
  var peg$c200 = 'do';
  var peg$c201 = 'nothing';
  var peg$c202 = 'conflict';
  var peg$c203 = '!';
  var peg$c204 = '>=';
  var peg$c205 = '>';
  var peg$c206 = '<=';
  var peg$c207 = '<>';
  var peg$c208 = '<';
  var peg$c209 = '!=';
  var peg$c210 = 'similar';
  var peg$c211 = '!~*';
  var peg$c212 = '~*';
  var peg$c213 = '~';
  var peg$c214 = '!~';
  var peg$c215 = 'escape';
  var peg$c216 = '@>';
  var peg$c217 = '<@';
  var peg$c218 = '?';
  var peg$c219 = '?|';
  var peg$c220 = '?&';
  var peg$c221 = '#-';
  var peg$c222 = '+';
  var peg$c223 = '-';
  var peg$c224 = '*';
  var peg$c225 = '/';
  var peg$c226 = '%';
  var peg$c227 = '||';
  var peg$c228 = '$';
  var peg$c229 = 'e';
  var peg$c230 = '`';
  var peg$c231 = ':';
  var peg$c232 = 'over';
  var peg$c233 = 'filter';
  var peg$c234 = 'first_value';
  var peg$c235 = 'last_value';
  var peg$c236 = 'row_number';
  var peg$c237 = 'dense_rank';
  var peg$c238 = 'rank';
  var peg$c239 = 'lag';
  var peg$c240 = 'lead';
  var peg$c241 = 'nth_value';
  var peg$c242 = 'ignore';
  var peg$c243 = 'respect';
  var peg$c244 = 'percentile_cont';
  var peg$c245 = 'percentile_disc';
  var peg$c246 = 'within';
  var peg$c247 = 'separator';
  var peg$c248 = 'both';
  var peg$c249 = 'leading';
  var peg$c250 = 'trailing';
  var peg$c251 = 'trim';
  var peg$c252 = 'now';
  var peg$c253 = 'at';
  var peg$c254 = 'zone';
  var peg$c255 = 'century';
  var peg$c256 = 'day';
  var peg$c257 = 'date';
  var peg$c258 = 'decade';
  var peg$c259 = 'dow';
  var peg$c260 = 'doy';
  var peg$c261 = 'epoch';
  var peg$c262 = 'hour';
  var peg$c263 = 'isodow';
  var peg$c264 = 'isoyear';
  var peg$c265 = 'microseconds';
  var peg$c266 = 'millennium';
  var peg$c267 = 'milliseconds';
  var peg$c268 = 'minute';
  var peg$c269 = 'month';
  var peg$c270 = 'quarter';
  var peg$c271 = 'second';
  var peg$c272 = 'timezone';
  var peg$c273 = 'timezone_hour';
  var peg$c274 = 'timezone_minute';
  var peg$c275 = 'week';
  var peg$c276 = 'year';
  var peg$c277 = 'ntile';
  var peg$c278 = "\\'";
  var peg$c279 = '\\"';
  var peg$c280 = '\\\\';
  var peg$c281 = '\\/';
  var peg$c282 = '\\b';
  var peg$c283 = '\\f';
  var peg$c284 = '\\n';
  var peg$c285 = '\\r';
  var peg$c286 = '\\t';
  var peg$c287 = '\\u';
  var peg$c288 = '\\';
  var peg$c289 = "''";
  var peg$c290 = '.';
  var peg$c291 = 'not null';
  var peg$c292 = 'true';
  var peg$c293 = 'false';
  var peg$c294 = 'show';
  var peg$c295 = 'drop';
  var peg$c296 = 'use';
  var peg$c297 = 'alter';
  var peg$c298 = 'select';
  var peg$c299 = 'update';
  var peg$c300 = 'create';
  var peg$c301 = 'temporary';
  var peg$c302 = 'temp';
  var peg$c303 = 'delete';
  var peg$c304 = 'insert';
  var peg$c305 = 'RECURSIVE';
  var peg$c306 = 'replace';
  var peg$c307 = 'returning';
  var peg$c308 = 'rename';
  var peg$c309 = 'explain';
  var peg$c310 = 'partition';
  var peg$c311 = 'into';
  var peg$c312 = 'from';
  var peg$c313 = 'as';
  var peg$c314 = 'tablespace';
  var peg$c315 = 'deallocate';
  var peg$c316 = 'left';
  var peg$c317 = 'right';
  var peg$c318 = 'full';
  var peg$c319 = 'inner';
  var peg$c320 = 'join';
  var peg$c321 = 'outer';
  var peg$c322 = 'union';
  var peg$c323 = 'values';
  var peg$c324 = 'using';
  var peg$c325 = 'where';
  var peg$c326 = 'group';
  var peg$c327 = 'by';
  var peg$c328 = 'order';
  var peg$c329 = 'having';
  var peg$c330 = 'limit';
  var peg$c331 = 'offset';
  var peg$c332 = 'asc';
  var peg$c333 = 'desc';
  var peg$c334 = 'all';
  var peg$c335 = 'distinct';
  var peg$c336 = 'between';
  var peg$c337 = 'is';
  var peg$c338 = 'like';
  var peg$c339 = 'ilike';
  var peg$c340 = 'exists';
  var peg$c341 = 'and';
  var peg$c342 = 'or';
  var peg$c343 = 'array';
  var peg$c344 = 'array_agg';
  var peg$c345 = 'count';
  var peg$c346 = 'group_concat';
  var peg$c347 = 'max';
  var peg$c348 = 'min';
  var peg$c349 = 'sum';
  var peg$c350 = 'avg';
  var peg$c351 = 'extract';
  var peg$c352 = 'call';
  var peg$c353 = 'case';
  var peg$c354 = 'when';
  var peg$c355 = 'else';
  var peg$c356 = 'cast';
  var peg$c357 = 'bool';
  var peg$c358 = 'boolean';
  var peg$c359 = 'char';
  var peg$c360 = 'varchar';
  var peg$c361 = 'numeric';
  var peg$c362 = 'decimal';
  var peg$c363 = 'signed';
  var peg$c364 = 'unsigned';
  var peg$c365 = 'int';
  var peg$c366 = 'zerofill';
  var peg$c367 = 'integer';
  var peg$c368 = 'json';
  var peg$c369 = 'jsonb';
  var peg$c370 = 'geometry';
  var peg$c371 = 'smallint';
  var peg$c372 = 'serial';
  var peg$c373 = 'tinyint';
  var peg$c374 = 'tinytext';
  var peg$c375 = 'text';
  var peg$c376 = 'mediumtext';
  var peg$c377 = 'longtext';
  var peg$c378 = 'bigint';
  var peg$c379 = 'enum';
  var peg$c380 = 'float';
  var peg$c381 = 'double precision';
  var peg$c382 = 'bigserial';
  var peg$c383 = 'real';
  var peg$c384 = 'datetime';
  var peg$c385 = 'time';
  var peg$c386 = 'timestamp';
  var peg$c387 = 'truncate';
  var peg$c388 = 'user';
  var peg$c389 = 'uuid';
  var peg$c390 = 'oid';
  var peg$c391 = 'regclass';
  var peg$c392 = 'regcollation';
  var peg$c393 = 'regconfig';
  var peg$c394 = 'regdictionary';
  var peg$c395 = 'regnamespace';
  var peg$c396 = 'regoper';
  var peg$c397 = 'regoperator';
  var peg$c398 = 'regproc';
  var peg$c399 = 'regprocedure';
  var peg$c400 = 'regrole';
  var peg$c401 = 'regtype';
  var peg$c402 = 'current_date';
  var peg$c403 = 'adddate';
  var peg$c404 = 'interval';
  var peg$c405 = 'current_time';
  var peg$c406 = 'current_timestamp';
  var peg$c407 = 'system_user';
  var peg$c408 = 'global';
  var peg$c409 = 'session';
  var peg$c410 = 'persist';
  var peg$c411 = 'persist_only';
  var peg$c412 = 'view';
  var peg$c413 = '@';
  var peg$c414 = '@@';
  var peg$c415 = '$$';
  var peg$c416 = 'return';
  var peg$c417 = '::';
  var peg$c418 = 'dual';
  var peg$c419 = 'add';
  var peg$c420 = 'index';
  var peg$c421 = 'fulltext';
  var peg$c422 = 'spatial';
  var peg$c423 = 'comment';
  var peg$c424 = 'concurrently';
  var peg$c425 = 'references';
  var peg$c426 = 'sql_calc_found_rows';
  var peg$c427 = 'sql_cache';
  var peg$c428 = 'sql_no_cache';
  var peg$c429 = 'sql_small_result';
  var peg$c430 = 'sql_big_result';
  var peg$c431 = 'sql_buffer_result';
  var peg$c432 = ',';
  var peg$c433 = '[';
  var peg$c434 = ']';
  var peg$c435 = '->';
  var peg$c436 = '->>';
  var peg$c437 = '#>';
  var peg$c438 = '#>>';
  var peg$c439 = '&&';
  var peg$c440 = '/*';
  var peg$c441 = '*/';
  var peg$c442 = '--';
  var peg$c443 = '#';
  var peg$c444 = 'bytea';
  var peg$c445 = 'varying';
  var peg$c446 = 'without';
  var peg$c447 = 'record';

  var peg$r0 = /^[^ s\t\n\r]/;
  var peg$r1 = /^[^ s\t\n\r;]/;
  var peg$r2 = /^[^"]/;
  var peg$r3 = /^[^']/;
  var peg$r4 = /^[^`]/;
  var peg$r5 = /^[A-Za-z_\u4E00-\u9FA5]/;
  var peg$r6 = /^[A-Za-z0-9_\-$\u4E00-\u9FA5\xC0-\u017F]/;
  var peg$r7 = /^[A-Za-z0-9_\u4E00-\u9FA5]/;
  var peg$r8 = /^[\n]/;
  var peg$r9 = /^[^"\\\0-\x1F\x7F]/;
  var peg$r10 = /^[^'\\]/;
  var peg$r11 = /^[\n\r]/;
  var peg$r12 = /^[0-9]/;
  var peg$r13 = /^[0-9a-fA-F]/;
  var peg$r14 = /^[eE]/;
  var peg$r15 = /^[+\-]/;
  var peg$r16 = /^[ \t\n\r]/;
  var peg$r17 = /^[^$]/;

  var peg$e0 = peg$literalExpectation('IF', true);
  var peg$e1 = peg$literalExpectation('EXTENSION', true);
  var peg$e2 = peg$literalExpectation('SCHEMA', true);
  var peg$e3 = peg$literalExpectation('VERSION', true);
  var peg$e4 = peg$literalExpectation('CASCADED', true);
  var peg$e5 = peg$literalExpectation('LOCAL', true);
  var peg$e6 = peg$literalExpectation('CHECK', true);
  var peg$e7 = peg$literalExpectation('OPTION', false);
  var peg$e8 = peg$literalExpectation('check_option', true);
  var peg$e9 = peg$literalExpectation('security_barrier', true);
  var peg$e10 = peg$literalExpectation('security_invoker', true);
  var peg$e11 = peg$literalExpectation('SFUNC', true);
  var peg$e12 = peg$literalExpectation('STYPE', true);
  var peg$e13 = peg$literalExpectation('AGGREGATE', true);
  var peg$e14 = peg$literalExpectation('RETURNS', true);
  var peg$e15 = peg$literalExpectation('SETOF', true);
  var peg$e16 = peg$literalExpectation('CONSTANT', true);
  var peg$e17 = peg$literalExpectation(':=', false);
  var peg$e18 = peg$literalExpectation('BEGIN', true);
  var peg$e19 = peg$literalExpectation('DECLARE', true);
  var peg$e20 = peg$literalExpectation('LANGUAGE', false);
  var peg$e21 = peg$literalExpectation('TRANSORM', true);
  var peg$e22 = peg$literalExpectation('FOR', false);
  var peg$e23 = peg$literalExpectation('TYPE', false);
  var peg$e24 = peg$literalExpectation('WINDOW', true);
  var peg$e25 = peg$literalExpectation('IMMUTABLE', true);
  var peg$e26 = peg$literalExpectation('STABLE', true);
  var peg$e27 = peg$literalExpectation('VOLATILE', true);
  var peg$e28 = peg$literalExpectation('STRICT', true);
  var peg$e29 = peg$literalExpectation('NOT', true);
  var peg$e30 = peg$literalExpectation('LEAKPROOF', true);
  var peg$e31 = peg$literalExpectation('CALLED', true);
  var peg$e32 = peg$literalExpectation('NULL', true);
  var peg$e33 = peg$literalExpectation('ON', true);
  var peg$e34 = peg$literalExpectation('INPUT', true);
  var peg$e35 = peg$literalExpectation('EXTERNAL', true);
  var peg$e36 = peg$literalExpectation('SECURITY', true);
  var peg$e37 = peg$literalExpectation('INVOKER', true);
  var peg$e38 = peg$literalExpectation('DEFINER', true);
  var peg$e39 = peg$literalExpectation('PARALLEL', true);
  var peg$e40 = peg$literalExpectation('UNSAFE', true);
  var peg$e41 = peg$literalExpectation('RESTRICTED', true);
  var peg$e42 = peg$literalExpectation('SAFE', true);
  var peg$e43 = peg$classExpectation([' ', 's', '\t', '\n', '\r'], true, false);
  var peg$e44 = peg$classExpectation([' ', 's', '\t', '\n', '\r', ';'], true, false);
  var peg$e45 = peg$literalExpectation('COST', true);
  var peg$e46 = peg$literalExpectation('ROWS', true);
  var peg$e47 = peg$literalExpectation('SUPPORT', true);
  var peg$e48 = peg$literalExpectation('TO', true);
  var peg$e49 = peg$literalExpectation('=', false);
  var peg$e50 = peg$literalExpectation('CURRENT', true);
  var peg$e51 = peg$literalExpectation('FUNCTION', true);
  var peg$e52 = peg$literalExpectation('TYPE', true);
  var peg$e53 = peg$literalExpectation('DOMAIN', true);
  var peg$e54 = peg$literalExpectation('INCREMENT', true);
  var peg$e55 = peg$literalExpectation('MINVALUE', true);
  var peg$e56 = peg$literalExpectation('NO', true);
  var peg$e57 = peg$literalExpectation('MAXVALUE', true);
  var peg$e58 = peg$literalExpectation('START', true);
  var peg$e59 = peg$literalExpectation('CACHE', true);
  var peg$e60 = peg$literalExpectation('CYCLE', true);
  var peg$e61 = peg$literalExpectation('OWNED', true);
  var peg$e62 = peg$literalExpectation('NONE', true);
  var peg$e63 = peg$literalExpectation('NULLS', true);
  var peg$e64 = peg$literalExpectation('FIRST', true);
  var peg$e65 = peg$literalExpectation('LAST', true);
  var peg$e66 = peg$literalExpectation('AUTO_INCREMENT', true);
  var peg$e67 = peg$literalExpectation('UNIQUE', true);
  var peg$e68 = peg$literalExpectation('KEY', true);
  var peg$e69 = peg$literalExpectation('PRIMARY', true);
  var peg$e70 = peg$literalExpectation('COLUMN_FORMAT', true);
  var peg$e71 = peg$literalExpectation('FIXED', true);
  var peg$e72 = peg$literalExpectation('DYNAMIC', true);
  var peg$e73 = peg$literalExpectation('DEFAULT', true);
  var peg$e74 = peg$literalExpectation('STORAGE', true);
  var peg$e75 = peg$literalExpectation('DISK', true);
  var peg$e76 = peg$literalExpectation('MEMORY', true);
  var peg$e77 = peg$literalExpectation('CASCADE', true);
  var peg$e78 = peg$literalExpectation('RESTRICT', true);
  var peg$e79 = peg$literalExpectation('OUT', true);
  var peg$e80 = peg$literalExpectation('VARIADIC', true);
  var peg$e81 = peg$literalExpectation('INOUT', true);
  var peg$e82 = peg$literalExpectation('OWNER', true);
  var peg$e83 = peg$literalExpectation('CURRENT_ROLE', true);
  var peg$e84 = peg$literalExpectation('CURRENT_USER', true);
  var peg$e85 = peg$literalExpectation('SESSION_USER', true);
  var peg$e86 = peg$literalExpectation('ALGORITHM', true);
  var peg$e87 = peg$literalExpectation('INSTANT', true);
  var peg$e88 = peg$literalExpectation('INPLACE', true);
  var peg$e89 = peg$literalExpectation('COPY', true);
  var peg$e90 = peg$literalExpectation('LOCK', true);
  var peg$e91 = peg$literalExpectation('SHARED', true);
  var peg$e92 = peg$literalExpectation('EXCLUSIVE', true);
  var peg$e93 = peg$literalExpectation('PRIMARY KEY', true);
  var peg$e94 = peg$literalExpectation('FOREIGN KEY', true);
  var peg$e95 = peg$literalExpectation('MATCH FULL', true);
  var peg$e96 = peg$literalExpectation('MATCH PARTIAL', true);
  var peg$e97 = peg$literalExpectation('MATCH SIMPLE', true);
  var peg$e98 = peg$literalExpectation('SET NULL', true);
  var peg$e99 = peg$literalExpectation('NO ACTION', true);
  var peg$e100 = peg$literalExpectation('SET DEFAULT', true);
  var peg$e101 = peg$literalExpectation('TRIGGER', true);
  var peg$e102 = peg$literalExpectation('BEFORE', true);
  var peg$e103 = peg$literalExpectation('AFTER', true);
  var peg$e104 = peg$literalExpectation('INSTEAD OF', true);
  var peg$e105 = peg$literalExpectation('EXECUTE', true);
  var peg$e106 = peg$literalExpectation('PROCEDURE', true);
  var peg$e107 = peg$literalExpectation('OF', true);
  var peg$e108 = peg$literalExpectation('DEFERRABLE', true);
  var peg$e109 = peg$literalExpectation('INITIALLY IMMEDIATE', true);
  var peg$e110 = peg$literalExpectation('INITIALLY DEFERRED', true);
  var peg$e111 = peg$literalExpectation('FOR', true);
  var peg$e112 = peg$literalExpectation('EACH', true);
  var peg$e113 = peg$literalExpectation('ROW', true);
  var peg$e114 = peg$literalExpectation('STATEMENT', true);
  var peg$e115 = peg$literalExpectation('CHARACTER', true);
  var peg$e116 = peg$literalExpectation('SET', true);
  var peg$e117 = peg$literalExpectation('CHARSET', true);
  var peg$e118 = peg$literalExpectation('COLLATE', true);
  var peg$e119 = peg$literalExpectation('AVG_ROW_LENGTH', true);
  var peg$e120 = peg$literalExpectation('KEY_BLOCK_SIZE', true);
  var peg$e121 = peg$literalExpectation('MAX_ROWS', true);
  var peg$e122 = peg$literalExpectation('MIN_ROWS', true);
  var peg$e123 = peg$literalExpectation('STATS_SAMPLE_PAGES', true);
  var peg$e124 = peg$literalExpectation('CONNECTION', true);
  var peg$e125 = peg$literalExpectation('COMPRESSION', true);
  var peg$e126 = peg$literalExpectation("'", false);
  var peg$e127 = peg$literalExpectation('ZLIB', true);
  var peg$e128 = peg$literalExpectation('LZ4', true);
  var peg$e129 = peg$literalExpectation('ENGINE', true);
  var peg$e130 = peg$literalExpectation('IN', true);
  var peg$e131 = peg$literalExpectation('ACCESS SHARE', true);
  var peg$e132 = peg$literalExpectation('ROW SHARE', true);
  var peg$e133 = peg$literalExpectation('ROW EXCLUSIVE', true);
  var peg$e134 = peg$literalExpectation('SHARE UPDATE EXCLUSIVE', true);
  var peg$e135 = peg$literalExpectation('SHARE ROW EXCLUSIVE', true);
  var peg$e136 = peg$literalExpectation('ACCESS EXCLUSIVE', true);
  var peg$e137 = peg$literalExpectation('SHARE', true);
  var peg$e138 = peg$literalExpectation('MODE', true);
  var peg$e139 = peg$literalExpectation('NOWAIT', true);
  var peg$e140 = peg$literalExpectation('TABLES', true);
  var peg$e141 = peg$literalExpectation('PREPARE', true);
  var peg$e142 = peg$literalExpectation('USAGE', true);
  var peg$e143 = peg$literalExpectation('CONNECT', true);
  var peg$e144 = peg$literalExpectation('PRIVILEGES', true);
  var peg$e145 = peg$literalExpectation('SEQUENCE', true);
  var peg$e146 = peg$literalExpectation('DATABASE', true);
  var peg$e147 = peg$literalExpectation('DOMAIN', false);
  var peg$e148 = peg$literalExpectation('FUNCTION', false);
  var peg$e149 = peg$literalExpectation('ROUTINE', true);
  var peg$e150 = peg$literalExpectation('LANGUAGE', true);
  var peg$e151 = peg$literalExpectation('LARGE', true);
  var peg$e152 = peg$literalExpectation('SCHEMA', false);
  var peg$e153 = peg$literalExpectation('FUNCTIONS', true);
  var peg$e154 = peg$literalExpectation('PROCEDURES', true);
  var peg$e155 = peg$literalExpectation('ROUTINES', true);
  var peg$e156 = peg$literalExpectation('PUBLIC', true);
  var peg$e157 = peg$literalExpectation('GRANT', true);
  var peg$e158 = peg$literalExpectation('OPTION', true);
  var peg$e159 = peg$literalExpectation('ADMIN', true);
  var peg$e160 = peg$literalExpectation('REVOKE', true);
  var peg$e161 = peg$literalExpectation('ELSEIF', true);
  var peg$e162 = peg$literalExpectation('THEN', true);
  var peg$e163 = peg$literalExpectation('END', true);
  var peg$e164 = peg$literalExpectation('DEBUG', true);
  var peg$e165 = peg$literalExpectation('LOG', true);
  var peg$e166 = peg$literalExpectation('INFO', true);
  var peg$e167 = peg$literalExpectation('NOTICE', true);
  var peg$e168 = peg$literalExpectation('WARNING', true);
  var peg$e169 = peg$literalExpectation('EXCEPTION', true);
  var peg$e170 = peg$literalExpectation('MESSAGE', true);
  var peg$e171 = peg$literalExpectation('DETAIL', true);
  var peg$e172 = peg$literalExpectation('HINT', true);
  var peg$e173 = peg$literalExpectation('ERRCODE', true);
  var peg$e174 = peg$literalExpectation('COLUMN', true);
  var peg$e175 = peg$literalExpectation('CONSTRAINT', true);
  var peg$e176 = peg$literalExpectation('DATATYPE', true);
  var peg$e177 = peg$literalExpectation('TABLE', true);
  var peg$e178 = peg$literalExpectation('SQLSTATE', true);
  var peg$e179 = peg$literalExpectation('RAISE', true);
  var peg$e180 = peg$literalExpectation('LOOP', true);
  var peg$e181 = peg$literalExpectation(';', false);
  var peg$e182 = peg$literalExpectation('(', false);
  var peg$e183 = peg$literalExpectation(')', false);
  var peg$e184 = peg$literalExpectation('"', false);
  var peg$e185 = peg$literalExpectation('OUTFILE', true);
  var peg$e186 = peg$literalExpectation('DUMPFILE', true);
  var peg$e187 = peg$literalExpectation('BTREE', true);
  var peg$e188 = peg$literalExpectation('HASH', true);
  var peg$e189 = peg$literalExpectation('GIST', true);
  var peg$e190 = peg$literalExpectation('GIN', true);
  var peg$e191 = peg$literalExpectation('WITH', true);
  var peg$e192 = peg$literalExpectation('PARSER', true);
  var peg$e193 = peg$literalExpectation('VISIBLE', true);
  var peg$e194 = peg$literalExpectation('INVISIBLE', true);
  var peg$e195 = peg$literalExpectation('LATERAL', true);
  var peg$e196 = peg$literalExpectation('TABLESAMPLE', true);
  var peg$e197 = peg$literalExpectation('REPEATABLE', true);
  var peg$e198 = peg$literalExpectation('CROSS', true);
  var peg$e199 = peg$literalExpectation('FOLLOWING', true);
  var peg$e200 = peg$literalExpectation('PRECEDING', true);
  var peg$e201 = peg$literalExpectation('UNBOUNDED', true);
  var peg$e202 = peg$literalExpectation('DO', true);
  var peg$e203 = peg$literalExpectation('NOTHING', true);
  var peg$e204 = peg$literalExpectation('CONFLICT', true);
  var peg$e205 = peg$literalExpectation('!', false);
  var peg$e206 = peg$literalExpectation('>=', false);
  var peg$e207 = peg$literalExpectation('>', false);
  var peg$e208 = peg$literalExpectation('<=', false);
  var peg$e209 = peg$literalExpectation('<>', false);
  var peg$e210 = peg$literalExpectation('<', false);
  var peg$e211 = peg$literalExpectation('!=', false);
  var peg$e212 = peg$literalExpectation('SIMILAR', true);
  var peg$e213 = peg$literalExpectation('!~*', false);
  var peg$e214 = peg$literalExpectation('~*', false);
  var peg$e215 = peg$literalExpectation('~', false);
  var peg$e216 = peg$literalExpectation('!~', false);
  var peg$e217 = peg$literalExpectation('ESCAPE', true);
  var peg$e218 = peg$literalExpectation('@>', false);
  var peg$e219 = peg$literalExpectation('<@', false);
  var peg$e220 = peg$literalExpectation('?', false);
  var peg$e221 = peg$literalExpectation('?|', false);
  var peg$e222 = peg$literalExpectation('?&', false);
  var peg$e223 = peg$literalExpectation('#-', false);
  var peg$e224 = peg$literalExpectation('+', false);
  var peg$e225 = peg$literalExpectation('-', false);
  var peg$e226 = peg$literalExpectation('*', false);
  var peg$e227 = peg$literalExpectation('/', false);
  var peg$e228 = peg$literalExpectation('%', false);
  var peg$e229 = peg$literalExpectation('||', false);
  var peg$e230 = peg$literalExpectation('$', false);
  var peg$e231 = peg$literalExpectation('E', true);
  var peg$e232 = peg$classExpectation(['"'], true, false);
  var peg$e233 = peg$classExpectation(["'"], true, false);
  var peg$e234 = peg$literalExpectation('`', false);
  var peg$e235 = peg$classExpectation(['`'], true, false);
  var peg$e236 = peg$classExpectation([['A', 'Z'], ['a', 'z'], '_', ['\u4E00', '\u9FA5']], false, false);
  var peg$e237 = peg$classExpectation(
    [['A', 'Z'], ['a', 'z'], ['0', '9'], '_', '-', '$', ['\u4E00', '\u9FA5'], ['\xC0', '\u017F']],
    false,
    false,
  );
  var peg$e238 = peg$classExpectation([['A', 'Z'], ['a', 'z'], ['0', '9'], '_', ['\u4E00', '\u9FA5']], false, false);
  var peg$e239 = peg$literalExpectation(':', false);
  var peg$e240 = peg$literalExpectation('OVER', true);
  var peg$e241 = peg$literalExpectation('FILTER', true);
  var peg$e242 = peg$literalExpectation('FIRST_VALUE', true);
  var peg$e243 = peg$literalExpectation('LAST_VALUE', true);
  var peg$e244 = peg$literalExpectation('ROW_NUMBER', true);
  var peg$e245 = peg$literalExpectation('DENSE_RANK', true);
  var peg$e246 = peg$literalExpectation('RANK', true);
  var peg$e247 = peg$literalExpectation('LAG', true);
  var peg$e248 = peg$literalExpectation('LEAD', true);
  var peg$e249 = peg$literalExpectation('NTH_VALUE', true);
  var peg$e250 = peg$literalExpectation('IGNORE', true);
  var peg$e251 = peg$literalExpectation('RESPECT', true);
  var peg$e252 = peg$literalExpectation('percentile_cont', true);
  var peg$e253 = peg$literalExpectation('percentile_disc', true);
  var peg$e254 = peg$literalExpectation('within', true);
  var peg$e255 = peg$literalExpectation('mode', true);
  var peg$e256 = peg$literalExpectation('SEPARATOR', true);
  var peg$e257 = peg$literalExpectation('BOTH', true);
  var peg$e258 = peg$literalExpectation('LEADING', true);
  var peg$e259 = peg$literalExpectation('TRAILING', true);
  var peg$e260 = peg$literalExpectation('trim', true);
  var peg$e261 = peg$literalExpectation('now', true);
  var peg$e262 = peg$literalExpectation('at', true);
  var peg$e263 = peg$literalExpectation('zone', true);
  var peg$e264 = peg$literalExpectation('CENTURY', true);
  var peg$e265 = peg$literalExpectation('DAY', true);
  var peg$e266 = peg$literalExpectation('DATE', true);
  var peg$e267 = peg$literalExpectation('DECADE', true);
  var peg$e268 = peg$literalExpectation('DOW', true);
  var peg$e269 = peg$literalExpectation('DOY', true);
  var peg$e270 = peg$literalExpectation('EPOCH', true);
  var peg$e271 = peg$literalExpectation('HOUR', true);
  var peg$e272 = peg$literalExpectation('ISODOW', true);
  var peg$e273 = peg$literalExpectation('ISOYEAR', true);
  var peg$e274 = peg$literalExpectation('MICROSECONDS', true);
  var peg$e275 = peg$literalExpectation('MILLENNIUM', true);
  var peg$e276 = peg$literalExpectation('MILLISECONDS', true);
  var peg$e277 = peg$literalExpectation('MINUTE', true);
  var peg$e278 = peg$literalExpectation('MONTH', true);
  var peg$e279 = peg$literalExpectation('QUARTER', true);
  var peg$e280 = peg$literalExpectation('SECOND', true);
  var peg$e281 = peg$literalExpectation('TIMEZONE', true);
  var peg$e282 = peg$literalExpectation('TIMEZONE_HOUR', true);
  var peg$e283 = peg$literalExpectation('TIMEZONE_MINUTE', true);
  var peg$e284 = peg$literalExpectation('WEEK', true);
  var peg$e285 = peg$literalExpectation('YEAR', true);
  var peg$e286 = peg$literalExpectation('NTILE', true);
  var peg$e287 = peg$classExpectation(['\n'], false, false);
  var peg$e288 = peg$classExpectation(['"', '\\', ['\0', '\x1F'], '\x7F'], true, false);
  var peg$e289 = peg$classExpectation(["'", '\\'], true, false);
  var peg$e290 = peg$literalExpectation("\\'", false);
  var peg$e291 = peg$literalExpectation('\\"', false);
  var peg$e292 = peg$literalExpectation('\\\\', false);
  var peg$e293 = peg$literalExpectation('\\/', false);
  var peg$e294 = peg$literalExpectation('\\b', false);
  var peg$e295 = peg$literalExpectation('\\f', false);
  var peg$e296 = peg$literalExpectation('\\n', false);
  var peg$e297 = peg$literalExpectation('\\r', false);
  var peg$e298 = peg$literalExpectation('\\t', false);
  var peg$e299 = peg$literalExpectation('\\u', false);
  var peg$e300 = peg$literalExpectation('\\', false);
  var peg$e301 = peg$literalExpectation("''", false);
  var peg$e302 = peg$classExpectation(['\n', '\r'], false, false);
  var peg$e303 = peg$literalExpectation('.', false);
  var peg$e304 = peg$classExpectation([['0', '9']], false, false);
  var peg$e305 = peg$classExpectation(
    [
      ['0', '9'],
      ['a', 'f'],
      ['A', 'F'],
    ],
    false,
    false,
  );
  var peg$e306 = peg$classExpectation(['e', 'E'], false, false);
  var peg$e307 = peg$classExpectation(['+', '-'], false, false);
  var peg$e308 = peg$literalExpectation('NOT NULL', true);
  var peg$e309 = peg$literalExpectation('TRUE', true);
  var peg$e310 = peg$literalExpectation('FALSE', true);
  var peg$e311 = peg$literalExpectation('SHOW', true);
  var peg$e312 = peg$literalExpectation('DROP', true);
  var peg$e313 = peg$literalExpectation('USE', true);
  var peg$e314 = peg$literalExpectation('ALTER', true);
  var peg$e315 = peg$literalExpectation('SELECT', true);
  var peg$e316 = peg$literalExpectation('UPDATE', true);
  var peg$e317 = peg$literalExpectation('CREATE', true);
  var peg$e318 = peg$literalExpectation('TEMPORARY', true);
  var peg$e319 = peg$literalExpectation('TEMP', true);
  var peg$e320 = peg$literalExpectation('DELETE', true);
  var peg$e321 = peg$literalExpectation('INSERT', true);
  var peg$e322 = peg$literalExpectation('RECURSIVE', false);
  var peg$e323 = peg$literalExpectation('REPLACE', true);
  var peg$e324 = peg$literalExpectation('RETURNING', true);
  var peg$e325 = peg$literalExpectation('RENAME', true);
  var peg$e326 = peg$literalExpectation('EXPLAIN', true);
  var peg$e327 = peg$literalExpectation('PARTITION', true);
  var peg$e328 = peg$literalExpectation('INTO', true);
  var peg$e329 = peg$literalExpectation('FROM', true);
  var peg$e330 = peg$literalExpectation('AS', true);
  var peg$e331 = peg$literalExpectation('TABLESPACE', true);
  var peg$e332 = peg$literalExpectation('DEALLOCATE', true);
  var peg$e333 = peg$literalExpectation('LEFT', true);
  var peg$e334 = peg$literalExpectation('RIGHT', true);
  var peg$e335 = peg$literalExpectation('FULL', true);
  var peg$e336 = peg$literalExpectation('INNER', true);
  var peg$e337 = peg$literalExpectation('JOIN', true);
  var peg$e338 = peg$literalExpectation('OUTER', true);
  var peg$e339 = peg$literalExpectation('UNION', true);
  var peg$e340 = peg$literalExpectation('VALUES', true);
  var peg$e341 = peg$literalExpectation('USING', true);
  var peg$e342 = peg$literalExpectation('WHERE', true);
  var peg$e343 = peg$literalExpectation('GROUP', true);
  var peg$e344 = peg$literalExpectation('BY', true);
  var peg$e345 = peg$literalExpectation('ORDER', true);
  var peg$e346 = peg$literalExpectation('HAVING', true);
  var peg$e347 = peg$literalExpectation('LIMIT', true);
  var peg$e348 = peg$literalExpectation('OFFSET', true);
  var peg$e349 = peg$literalExpectation('ASC', true);
  var peg$e350 = peg$literalExpectation('DESC', true);
  var peg$e351 = peg$literalExpectation('ALL', true);
  var peg$e352 = peg$literalExpectation('DISTINCT', true);
  var peg$e353 = peg$literalExpectation('BETWEEN', true);
  var peg$e354 = peg$literalExpectation('IS', true);
  var peg$e355 = peg$literalExpectation('LIKE', true);
  var peg$e356 = peg$literalExpectation('ILIKE', true);
  var peg$e357 = peg$literalExpectation('EXISTS', true);
  var peg$e358 = peg$literalExpectation('AND', true);
  var peg$e359 = peg$literalExpectation('OR', true);
  var peg$e360 = peg$literalExpectation('ARRAY', true);
  var peg$e361 = peg$literalExpectation('ARRAY_AGG', true);
  var peg$e362 = peg$literalExpectation('COUNT', true);
  var peg$e363 = peg$literalExpectation('GROUP_CONCAT', true);
  var peg$e364 = peg$literalExpectation('MAX', true);
  var peg$e365 = peg$literalExpectation('MIN', true);
  var peg$e366 = peg$literalExpectation('SUM', true);
  var peg$e367 = peg$literalExpectation('AVG', true);
  var peg$e368 = peg$literalExpectation('EXTRACT', true);
  var peg$e369 = peg$literalExpectation('CALL', true);
  var peg$e370 = peg$literalExpectation('CASE', true);
  var peg$e371 = peg$literalExpectation('WHEN', true);
  var peg$e372 = peg$literalExpectation('ELSE', true);
  var peg$e373 = peg$literalExpectation('CAST', true);
  var peg$e374 = peg$literalExpectation('BOOL', true);
  var peg$e375 = peg$literalExpectation('BOOLEAN', true);
  var peg$e376 = peg$literalExpectation('CHAR', true);
  var peg$e377 = peg$literalExpectation('VARCHAR', true);
  var peg$e378 = peg$literalExpectation('NUMERIC', true);
  var peg$e379 = peg$literalExpectation('DECIMAL', true);
  var peg$e380 = peg$literalExpectation('SIGNED', true);
  var peg$e381 = peg$literalExpectation('UNSIGNED', true);
  var peg$e382 = peg$literalExpectation('INT', true);
  var peg$e383 = peg$literalExpectation('ZEROFILL', true);
  var peg$e384 = peg$literalExpectation('INTEGER', true);
  var peg$e385 = peg$literalExpectation('JSON', true);
  var peg$e386 = peg$literalExpectation('JSONB', true);
  var peg$e387 = peg$literalExpectation('GEOMETRY', true);
  var peg$e388 = peg$literalExpectation('SMALLINT', true);
  var peg$e389 = peg$literalExpectation('SERIAL', true);
  var peg$e390 = peg$literalExpectation('TINYINT', true);
  var peg$e391 = peg$literalExpectation('TINYTEXT', true);
  var peg$e392 = peg$literalExpectation('TEXT', true);
  var peg$e393 = peg$literalExpectation('MEDIUMTEXT', true);
  var peg$e394 = peg$literalExpectation('LONGTEXT', true);
  var peg$e395 = peg$literalExpectation('BIGINT', true);
  var peg$e396 = peg$literalExpectation('ENUM', true);
  var peg$e397 = peg$literalExpectation('FLOAT', true);
  var peg$e398 = peg$literalExpectation('DOUBLE PRECISION', true);
  var peg$e399 = peg$literalExpectation('BIGSERIAL', true);
  var peg$e400 = peg$literalExpectation('REAL', true);
  var peg$e401 = peg$literalExpectation('DATETIME', true);
  var peg$e402 = peg$literalExpectation('TIME', true);
  var peg$e403 = peg$literalExpectation('TIMESTAMP', true);
  var peg$e404 = peg$literalExpectation('TRUNCATE', true);
  var peg$e405 = peg$literalExpectation('USER', true);
  var peg$e406 = peg$literalExpectation('UUID', true);
  var peg$e407 = peg$literalExpectation('OID', true);
  var peg$e408 = peg$literalExpectation('REGCLASS', true);
  var peg$e409 = peg$literalExpectation('REGCOLLATION', true);
  var peg$e410 = peg$literalExpectation('REGCONFIG', true);
  var peg$e411 = peg$literalExpectation('REGDICTIONARY', true);
  var peg$e412 = peg$literalExpectation('REGNAMESPACE', true);
  var peg$e413 = peg$literalExpectation('REGOPER', true);
  var peg$e414 = peg$literalExpectation('REGOPERATOR', true);
  var peg$e415 = peg$literalExpectation('REGPROC', true);
  var peg$e416 = peg$literalExpectation('REGPROCEDURE', true);
  var peg$e417 = peg$literalExpectation('REGROLE', true);
  var peg$e418 = peg$literalExpectation('REGTYPE', true);
  var peg$e419 = peg$literalExpectation('CURRENT_DATE', true);
  var peg$e420 = peg$literalExpectation('ADDDATE', true);
  var peg$e421 = peg$literalExpectation('INTERVAL', true);
  var peg$e422 = peg$literalExpectation('CURRENT_TIME', true);
  var peg$e423 = peg$literalExpectation('CURRENT_TIMESTAMP', true);
  var peg$e424 = peg$literalExpectation('SYSTEM_USER', true);
  var peg$e425 = peg$literalExpectation('GLOBAL', true);
  var peg$e426 = peg$literalExpectation('SESSION', true);
  var peg$e427 = peg$literalExpectation('PERSIST', true);
  var peg$e428 = peg$literalExpectation('PERSIST_ONLY', true);
  var peg$e429 = peg$literalExpectation('VIEW', true);
  var peg$e430 = peg$literalExpectation('@', false);
  var peg$e431 = peg$literalExpectation('@@', false);
  var peg$e432 = peg$literalExpectation('$$', false);
  var peg$e433 = peg$literalExpectation('return', true);
  var peg$e434 = peg$literalExpectation('::', false);
  var peg$e435 = peg$literalExpectation('DUAL', true);
  var peg$e436 = peg$literalExpectation('ADD', true);
  var peg$e437 = peg$literalExpectation('INDEX', true);
  var peg$e438 = peg$literalExpectation('FULLTEXT', true);
  var peg$e439 = peg$literalExpectation('SPATIAL', true);
  var peg$e440 = peg$literalExpectation('COMMENT', true);
  var peg$e441 = peg$literalExpectation('CONCURRENTLY', true);
  var peg$e442 = peg$literalExpectation('REFERENCES', true);
  var peg$e443 = peg$literalExpectation('SQL_CALC_FOUND_ROWS', true);
  var peg$e444 = peg$literalExpectation('SQL_CACHE', true);
  var peg$e445 = peg$literalExpectation('SQL_NO_CACHE', true);
  var peg$e446 = peg$literalExpectation('SQL_SMALL_RESULT', true);
  var peg$e447 = peg$literalExpectation('SQL_BIG_RESULT', true);
  var peg$e448 = peg$literalExpectation('SQL_BUFFER_RESULT', true);
  var peg$e449 = peg$literalExpectation(',', false);
  var peg$e450 = peg$literalExpectation('[', false);
  var peg$e451 = peg$literalExpectation(']', false);
  var peg$e452 = peg$literalExpectation('->', false);
  var peg$e453 = peg$literalExpectation('->>', false);
  var peg$e454 = peg$literalExpectation('#>', false);
  var peg$e455 = peg$literalExpectation('#>>', false);
  var peg$e456 = peg$literalExpectation('&&', false);
  var peg$e457 = peg$literalExpectation('/*', false);
  var peg$e458 = peg$literalExpectation('*/', false);
  var peg$e459 = peg$literalExpectation('--', false);
  var peg$e460 = peg$literalExpectation('#', false);
  var peg$e461 = peg$anyExpectation();
  var peg$e462 = peg$classExpectation([' ', '\t', '\n', '\r'], false, false);
  var peg$e463 = peg$classExpectation(['$'], true, false);
  var peg$e464 = peg$literalExpectation('bytea', true);
  var peg$e465 = peg$literalExpectation('varying', true);
  var peg$e466 = peg$literalExpectation('WITHOUT', true);
  var peg$e467 = peg$literalExpectation('ZONE', true);
  var peg$e468 = peg$literalExpectation('RECORD', true);

  var peg$f0 = function (n) {
    // => multiple_stmt
    return n;
  };
  var peg$f1 = function (head, tail) {
    /*
      // is in reality: { tableList: any[]; columnList: any[]; ast: T; }
      export type AstStatement<T> = T;
       => AstStatement<curd_stmt | crud_stmt[]> */
    const headAst = (head && head.ast) || head;
    const cur = tail && tail.length && tail[0].length >= 4 ? [headAst] : headAst;
    for (let i = 0; i < tail.length; i++) {
      if (!tail[i][3] || tail[i][3].length === 0) continue;
      cur.push((tail[i][3] && tail[i][3].ast) || tail[i][3]);
    }
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: cur,
    };
  };
  var peg$f2 = function (a) {
    // => 'union' | 'union all' | 'union distinct'
    return a ? `union ${a.toLowerCase()}` : 'union';
  };
  var peg$f3 = function (head, tail, ob, l) {
    /* export interface union_stmt_node extends select_stmt_node  {
         _next: union_stmt_node;
         set_op: 'union' | 'union all' | 'union distinct';
      }
     => AstStatement<union_stmt_node>
     */
    let cur = head;
    for (let i = 0; i < tail.length; i++) {
      cur._next = tail[i][3];
      cur.set_op = tail[i][1];
      cur = cur._next;
    }
    if (ob) head._orderby = ob;
    if (l && l.value && l.value.length > 0) head._limit = l;
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: head,
    };
  };
  var peg$f4 = function () {
    // => 'IF NOT EXISTS'
    return 'IF NOT EXISTS';
  };
  var peg$f5 = function (a, e, ife, n, w, s, v, f) {
    /*
       export type nameOrLiteral = literal_string | { type: 'same', value: string; };
      => {
          type: 'create';
          keyword: 'extension';
          if_not_exists?: 'if not exists';
          extension: nameOrLiteral;
          with: 'with';
          schema: nameOrLiteral;
          version: nameOrLiteral;
          from: nameOrLiteral;
        }
      */
    return {
      type: 'create',
      keyword: e.toLowerCase(),
      if_not_exists: ife,
      extension: commonStrToLiteral(n),
      with: w && w[0].toLowerCase(),
      schema: commonStrToLiteral(s && s[2].toLowerCase()), // <== wont that be a bug ?
      version: commonStrToLiteral(v && v[2]),
      from: commonStrToLiteral(f && f[2]),
    };
  };
  var peg$f6 = function (head, tail) {
    // => create_option_character_set[]
    return createList(head, tail, 1);
  };
  var peg$f7 = function (a, k, ife, t, c) {
    /*
      export type create_db_stmt = {
        type: 'create',
        keyword: 'database' | 'schema',
        if_not_exists?: 'if not exists',
        database: string,
        create_definitions?: create_db_definition
      }
      => AstStatement<create_db_stmt>
      */
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: a[0].toLowerCase(),
        keyword: 'database',
        if_not_exists: ife,
        database: t,
        create_definitions: c,
      },
    };
  };
  var peg$f8 = function (c) {
    // => string
    return `with ${c.toLowerCase()} check option`;
  };
  var peg$f9 = function () {
    // => string
    return 'with check option';
  };
  var peg$f10 = function (t) {
    // => {type: string; value: string; symbol: string; }
    return { type: 'check_option', value: t, symbol: '=' };
  };
  var peg$f11 = function (k, t) {
    // => {type: string; value: string; symbol: string; }
    return { type: k.toLowerCase(), value: t.value ? 'true' : 'false', symbol: '=' };
  };
  var peg$f12 = function (head, tail) {
    // => with_view_option[]
    return createList(head, tail);
  };
  var peg$f13 = function (a, or, tp, r, v, c, wo, s, w) {
    /*
      export type create_view_stmt = {
        type: 'create',
        keyword: 'view',
        replace?: 'or replace',
        temporary?: 'temporary' | 'temp',
        recursive?: 'recursive',
        view: table_name,
        columns?: column_list,
        select: select_stmt_nake,
        with_options?: with_options,
        with?: string,
      }
      => AstStatement<create_view_stmt>
      */
    v.view = v.table;
    delete v.table;
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: a[0].toLowerCase(),
        keyword: 'view',
        replace: or && 'or replace',
        temporary: tp && tp.toLowerCase(),
        recursive: r && r.toLowerCase(),
        columns: c && c[2],
        select: s,
        view: v,
        with_options: wo && wo[4],
        with: w,
      },
    };
  };
  var peg$f14 = function (n, d) {
    // => { type: string; symbol: '='; value: expr; }[]
    return [
      {
        type: 'sfunc',
        symbol: '=',
        value: { schema: n.db, name: n.table },
      },
      {
        type: 'stype',
        symbol: '=',
        value: d,
      },
    ];
  };
  var peg$f15 = function (n, e) {
    // => { type: string; symbol: '='; value: ident | expr; }
    return {
      type: n,
      symbol: '=',
      value: typeof e === 'string' ? { type: 'default', value: e } : e,
    };
  };
  var peg$f16 = function (head, tail) {
    // => create_aggregate_opt_optional[]
    return createList(head, tail);
  };
  var peg$f17 = function (a, or, t, s, as, opts) {
    /*
      export type create_aggregate_stmt = {
        type: 'create',
        keyword: 'aggregate',
        replace?: 'or replace',
        name: table_name,
        args?: aggregate_signature,
        options: create_aggregate_opt_optional[]
      }
      => AstStatement<create_aggregate_stmt>
      */
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: 'create',
        keyword: 'aggregate',
        name: { schema: s.db, name: s.table },
        args: {
          parentheses: true,
          expr: as,
          orderby: as.orderby,
        },
        options: opts,
      },
    };
  };
  var peg$f18 = function (c, d) {
    // => { column: column_ref; definition: data_type; }
    return {
      column: c,
      definition: d,
    };
  };
  var peg$f19 = function (head, tail) {
    // => column_data_type[]
    return createList(head, tail);
  };
  var peg$f20 = function (k, t) {
    // => { type: "returns"; keyword?: "setof"; expr: data_type; }
    return {
      type: 'returns',
      keyword: k,
      expr: t,
    };
  };
  var peg$f21 = function (e) {
    // => { type: "returns"; keyword?: "table"; expr: column_data_type_list; }
    return {
      type: 'returns',
      keyword: 'table',
      expr: e,
    };
  };
  var peg$f22 = function (n) {
    return n.toLowerCase() !== 'begin';
  };
  var peg$f23 = function (n, c, d, collate, nu, expr, s) {
    // => { keyword: 'variable'; name: string, constant?: string; datatype: data_type; collate?: collate; not_null?: string; default?: { type: 'default'; keyword: string; value: literal | expr; }; }
    return {
      keyword: 'variable',
      name: n,
      constant: c,
      datatype: d,
      collate,
      not_null: nu && 'not null',
      definition: expr &&
        expr[0] && {
          type: 'default',
          keyword: expr[0],
          value: expr[2],
        },
    };
  };
  var peg$f24 = function (head, tail) {
    // => declare_variable_item[]
    return createList(head, tail, 1);
  };
  var peg$f25 = function (vars) {
    /*
      export type declare_stmt = { type: 'declare'; declare: declare_variable_item[]; }
      => AstStatement<declare_stmt>
    */
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: 'declare',
        declare: vars,
        symbol: ';',
      },
    };
  };
  var peg$f26 = function (ln) {
    // => literal_string
    return {
      prefix: 'LANGUAGE',
      type: 'default',
      value: ln,
    };
  };
  var peg$f27 = function (ft) {
    // => literal_string
    if (!ft) return { type: 'origin', value: 'TRANSORM' };
    return {
      prefix: ['TRANSORM', ft[0].toUpperCase(), ft[2].toUpperCase()].join(' '),
      type: 'default',
      value: ft[4],
    };
  };
  var peg$f28 = function (i) {
    // => literal_string
    return {
      type: 'origin',
      value: i,
    };
  };
  var peg$f29 = function (n) {
    // => literal_string
    return {
      type: 'origin',
      value: [n, 'LEAKPROOF'].filter((v) => v).join(' '),
    };
  };
  var peg$f30 = function (i) {
    // => literal_string
    if (Array.isArray(i)) i = [i[0], i[2]].join(' ');
    return {
      type: 'origin',
      value: `${i} ON NULL INPUT`,
    };
  };
  var peg$f31 = function (e, i) {
    // => literal_string
    return {
      type: 'origin',
      value: [e, 'SECURITY', i].filter((v) => v).join(' '),
    };
  };
  var peg$f32 = function (i) {
    // => literal_string
    return {
      type: 'origin',
      value: ['PARALLEL', i].join(' '),
    };
  };
  var peg$f33 = function (c, de, b, s, e) {
    return (b && e) || (!b && !e);
  };
  var peg$f34 = function (c, de, b, s, e, l) {
    // => { type: 'as'; begin?: string; declare?: declare_stmt; expr: multiple_stmt; end?: string; symbol: string; }
    const start = c.join('');
    const end = l.join('');
    if (start !== end) throw new Error(`start symbol '${start}'is not same with end symbol '${end}'`);
    return {
      type: 'as',
      declare: de && de.ast,
      begin: b,
      expr: Array.isArray(s.ast) ? s.ast.flat() : [s.ast],
      end: e && e[0],
      symbol: start,
    };
  };
  var peg$f35 = function (p, n) {
    // => literal_numeric
    n.prefix = p;
    return n;
  };
  var peg$f36 = function (n) {
    // => literal_string
    return {
      prefix: 'support',
      type: 'default',
      value: n,
    };
  };
  var peg$f37 = function (ca, e) {
    // => { type: "set"; parameter: ident_name; value?: { prefix: string; expr: expr }}
    let value;
    if (e) {
      const val = Array.isArray(e[2]) ? e[2] : [e[2]];
      value = {
        prefix: e[0],
        expr: val.map((v) => ({ type: 'default', value: v })),
      };
    }
    return {
      type: 'set',
      parameter: ca,
      value,
    };
  };
  var peg$f38 = function (a, or, t, c, args, r, fo) {
    /*
      export type create_function_stmt = {
        type: 'create';
        replace?: string;
        name: { schema?: string; name: string };
        args?: alter_func_args;
        returns?: func_returns;
        keyword: 'function';
        options?: create_func_opt[];
      }
      => AstStatement<create_function_stmt>
      */
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        args: args || [],
        type: 'create',
        replace: or && 'or replace',
        name: { schema: c.db, name: c.table },
        returns: r,
        keyword: t && t.toLowerCase(),
        options: fo || [],
      },
    };
  };
  var peg$f39 = function (a, k, s, as, r, e) {
    /*
      export type create_type_stmt = {
        type: 'create',
        keyword: 'type',
        name: { schema: string; name: string },
        as?: string,
        resource?: string,
        create_definitions?: any
      }
      => AstStatement<create_type_stmt>
      */
    e.parentheses = true;
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: a[0].toLowerCase(),
        keyword: k.toLowerCase(),
        name: { schema: s.db, name: s.table },
        as: as && as[0] && as[0].toLowerCase(),
        resource: r.toLowerCase(),
        create_definitions: e,
      },
    };
  };
  var peg$f40 = function (a, k, s) {
    // => AstStatement<create_type_stmt>
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: a[0].toLowerCase(),
        keyword: k.toLowerCase(),
        name: { schema: s.db, name: s.table },
      },
    };
  };
  var peg$f41 = function (a, k, s, as, d, ce, de, ccc) {
    /*
      export type create_domain_stmt = {
        type: 'create',
        keyword: 'domain',
        domain: { schema: string; name: string },
        as?: string,
        target: data_type,
        create_definitions?: any[]
      }
      => AstStatement<create_domain_stmt>
      */
    if (ccc) ccc.type = 'constraint';
    const definitions = [ce, de, ccc].filter((v) => v);
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: a[0].toLowerCase(),
        keyword: k.toLowerCase(),
        domain: { schema: s.db, name: s.table },
        as: as && as[0] && as[0].toLowerCase(),
        target: d,
        create_definitions: definitions,
      },
    };
  };
  var peg$f42 = function (a, tp, ife, t, c, to, ir, as, qe) {
    /*
      export type create_table_stmt_node = create_table_stmt_node_simple | create_table_stmt_node_like;
      export interface create_table_stmt_node_base {
        type: 'create';
        keyword: 'table';
        temporary?: 'temporary';
        if_not_exists?: 'if not exists';
        table: table_ref_list;
      }
      export interface create_table_stmt_node_simple extends create_table_stmt_node_base{
        ignore_replace?: 'ignore' | 'replace';
        as?: 'as';
        query_expr?: union_stmt_node;
        create_definitions?: create_table_definition;
        table_options?: table_options;
      }
      => AstStatement<create_table_stmt_node>
      */
    if (t) t.forEach((tt) => tableList.add(`create::${tt.db}::${tt.table}`));
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: a[0].toLowerCase(),
        keyword: 'table',
        temporary: tp && tp.toLowerCase(),
        if_not_exists: ife,
        table: t,
        ignore_replace: ir && ir[0].toLowerCase(),
        as: as && as[0].toLowerCase(),
        query_expr: qe && qe.ast,
        create_definitions: c,
        table_options: to,
      },
    };
  };
  var peg$f43 = function (a, tp, ife, t, lt) {
    /*

      export interface create_table_stmt_node_like extends create_table_stmt_node_base{
        like: create_like_table;
      }
      => AstStatement<create_table_stmt_node>;
      */
    if (t) t.forEach((tt) => tableList.add(`create::${tt.db}::${tt.table}`));
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: a[0].toLowerCase(),
        keyword: 'table',
        temporary: tp && tp.toLowerCase(),
        if_not_exists: ife,
        table: t,
        like: lt,
      },
    };
  };
  var peg$f44 = function (a, tp, ife, t, as, c) {
    /*
      export type create_sequence_stmt = {
        type: 'create',
        keyword: 'sequence',
        temporary?: 'temporary' | 'temp',
        if_not_exists?: 'if not exists',
        table: table_ref_list,
        create_definitions?: create_sequence_definition_list
      }
      => AstStatement<create_sequence_stmt>
      */
    t.as = as && as[2];
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: a[0].toLowerCase(),
        keyword: 'sequence',
        temporary: tp && tp.toLowerCase(),
        if_not_exists: ife,
        sequence: [t],
        create_definitions: c,
      },
    };
  };
  var peg$f45 = function (k, b, n) {
    /*
    export type sequence_definition = { "resource": "sequence", prefix?: string,value: literal | column_ref }
    => sequence_definition
    */
    return {
      resource: 'sequence',
      prefix: b ? `${k.toLowerCase()} by` : k.toLowerCase(),
      value: n,
    };
  };
  var peg$f46 = function (k, n) {
    // => sequence_definition
    return {
      resource: 'sequence',
      prefix: k.toLowerCase(),
      value: n,
    };
  };
  var peg$f47 = function () {
    // => sequence_definition
    return {
      resource: 'sequence',
      value: {
        type: 'origin',
        value: 'no minvalue',
      },
    };
  };
  var peg$f48 = function (k, n) {
    // => sequence_definition
    return {
      resource: 'sequence',
      prefix: k.toLowerCase(),
      value: n,
    };
  };
  var peg$f49 = function () {
    // => sequence_definition
    return {
      resource: 'sequence',
      value: {
        type: 'origin',
        value: 'no maxvalue',
      },
    };
  };
  var peg$f50 = function (k, w, n) {
    // => sequence_definition
    return {
      resource: 'sequence',
      prefix: w ? `${k.toLowerCase()} with` : k.toLowerCase(),
      value: n,
    };
  };
  var peg$f51 = function (k, n) {
    // => sequence_definition
    return {
      resource: 'sequence',
      prefix: k.toLowerCase(),
      value: n,
    };
  };
  var peg$f52 = function (n) {
    // => sequence_definition
    return {
      resource: 'sequence',
      value: {
        type: 'origin',
        value: n ? 'no cycle' : 'cycle',
      },
    };
  };
  var peg$f53 = function () {
    // => sequence_definition
    return {
      resource: 'sequence',
      prefix: 'owned by',
      value: {
        type: 'origin',
        value: 'none',
      },
    };
  };
  var peg$f54 = function (n, col) {
    // => sequence_definition
    return {
      resource: 'sequence',
      prefix: 'owned by',
      value: col,
    };
  };
  var peg$f55 = function (head, tail) {
    // => create_sequence_definition[]
    return createList(head, tail, 1);
  };
  var peg$f56 = function (a, kw, t, co, n, on, ta, um, cols, wr, ts, w) {
    /*
    export interface create_index_stmt_node {
      type: 'create';
      index_type?: 'unique';
      keyword: 'index';
      concurrently?: 'concurrently';
      index: string;
      on_kw: string;
      table: table_name;
      index_using?: index_type;
      index_columns: column_order[];
      with?: index_option[];
      with_before_where: true;
      tablespace?: {type: 'origin'; value: string; }
      where?: where_clause;
    }
    => AstStatement<create_index_stmt_node>
    */
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: a[0].toLowerCase(),
        index_type: kw && kw.toLowerCase(),
        keyword: t.toLowerCase(),
        concurrently: co && co.toLowerCase(),
        index: n,
        on_kw: on[0].toLowerCase(),
        table: ta,
        index_using: um,
        index_columns: cols,
        with: wr && wr[4],
        with_before_where: true,
        tablespace: ts && { type: 'origin', value: ts[2] },
        where: w,
      },
    };
  };
  var peg$f57 = function (head, tail) {
    // => column_order[]
    return createList(head, tail);
  };
  var peg$f58 = function (c, ca, op, o, nf) {
    /*
    => {
      collate: collate_expr;
      opclass: ident;
      order: 'asc' | 'desc';
      nulls: 'nulls last' | 'nulls first';
    }
    */
    return {
      ...c,
      collate: ca,
      opclass: op,
      order_by: o && o.toLowerCase(),
      nulls: nf && `${nf[0].toLowerCase()} ${nf[2].toLowerCase()}`,
    };
  };
  var peg$f59 = function (t) {
    // => { type: 'like'; table: table_ref_list; }
    return {
      type: 'like',
      table: t,
    };
  };
  var peg$f60 = function (e) {
    // => create_like_table_simple & { parentheses?: boolean; }
    e.parentheses = true;
    return e;
  };
  var peg$f61 = function (head, tail) {
    // => create_definition[]
    return createList(head, tail);
  };
  var peg$f62 = function (a) {
    // => { auto_increment: 'auto_increment'; }
    return { auto_increment: a.toLowerCase() };
  };
  var peg$f63 = function (k) {
    // => { unique: 'unique' | 'unique key'; }
    const sql = ['unique'];
    if (k) sql.push(k);
    return { unique: sql.join(' ').toLowerCase('') };
  };
  var peg$f64 = function (p) {
    // => { unique: 'key' | 'primary key'; }
    const sql = [];
    if (p) sql.push('primary');
    sql.push('key');
    return { primary_key: sql.join(' ').toLowerCase('') };
  };
  var peg$f65 = function (co) {
    // => { comment: keyword_comment; }
    return { comment: co };
  };
  var peg$f66 = function (ca) {
    // => { collate: collate_expr; }
    return { collate: ca };
  };
  var peg$f67 = function (cf) {
    // => { column_format: column_format; }
    return { column_format: cf };
  };
  var peg$f68 = function (s) {
    // => { storage: storage }
    return { storage: s };
  };
  var peg$f69 = function (re) {
    // => { reference_definition: reference_definition; }
    return { reference_definition: re };
  };
  var peg$f70 = function (t, s, v) {
    // => { character_set: collate_expr }
    return { character_set: { type: t, value: v, symbol: s } };
  };
  var peg$f71 = function (head, tail) {
    /*
      => {
        nullable?: column_constraint['nullable'];
        default_val?: column_constraint['default_val'];
        auto_increment?: 'auto_increment';
        unique?: 'unique' | 'unique key';
        primary?: 'key' | 'primary key';
        comment?: keyword_comment;
        collate?: collate_expr;
        column_format?: column_format;
        storage?: storage;
        reference_definition?: reference_definition;
      }
      */
    let opt = head;
    for (let i = 0; i < tail.length; i++) {
      opt = { ...opt, ...tail[i][1] };
    }
    return opt;
  };
  var peg$f72 = function (c, d, cdo) {
    /*
      => {
        column: column_ref;
        definition: data_type;
        nullable: column_constraint['nullable'];
        default_val: column_constraint['default_val'];
        auto_increment?: 'auto_increment';
        unique?: 'unique' | 'unique key';
        primary?: 'key' | 'primary key';
        comment?: keyword_comment;
        collate?: collate_expr;
        column_format?: column_format;
        storage?: storage;
        reference_definition?: reference_definition;
        resource: 'column';
      }
      */
    columnList.add(`create::${c.table}::${c.column}`);
    return {
      column: c,
      definition: d,
      resource: 'column',
      ...(cdo || {}),
    };
  };
  var peg$f73 = function (n, df) {
    // => { nullable: literal_null | literal_not_null; default_val: default_expr; }
    if (n && !n.value) n.value = 'null';
    return {
      default_val: df,
      nullable: n,
    };
  };
  var peg$f74 = function (df, n) {
    // => { nullable: literal_null | literal_not_null; default_val: default_expr; }
    if (n && !n.value) n.value = 'null';
    return {
      default_val: df,
      nullable: n,
    };
  };
  var peg$f75 = function (s, ca) {
    // => { type: 'collate'; symbol: '=' | null; value: ident; }
    return {
      type: 'collate',
      symbol: s,
      value: ca,
    };
  };
  var peg$f76 = function (k, f) {
    // => { type: 'column_format'; value: 'fixed' | 'dynamic' | 'default'; }
    return {
      type: 'column_format',
      value: f.toLowerCase(),
    };
  };
  var peg$f77 = function (k, s) {
    // => { type: 'storage'; value: 'disk' | 'memory' }
    return {
      type: 'storage',
      value: s.toLowerCase(),
    };
  };
  var peg$f78 = function (kw, ce) {
    // => { type: 'default'; keyword: string, value: literal | expr; }
    return {
      type: 'default',
      keyword: kw && kw[0],
      value: ce,
    };
  };
  var peg$f79 = function (ce) {
    // => { type: 'default'; value: literal | expr; }
    return {
      type: 'default',
      value: ce,
    };
  };
  var peg$f80 = function (head, tail) {
    // => (ALTER_ALGORITHM | ALTER_LOCK)[]
    return createList(head, tail, 1);
  };
  var peg$f81 = function (a, r, t) {
    /*
      export interface drop_stmt_node {
        type: 'drop';
        keyword: 'table';
        name: table_ref_list;
      }
      => AstStatement<drop_stmt_node>
      */
    if (t) t.forEach((tt) => tableList.add(`${a}::${tt.db}::${tt.table}`));
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: a.toLowerCase(),
        keyword: r.toLowerCase(),
        name: t,
      },
    };
  };
  var peg$f82 = function (a, r, cu, ie, i, op) {
    /*
      export interface drop_index_stmt_node {
        type: 'drop';
        prefix?: 'CONCURRENTLY';
        keyword: string;
        name: column_ref;
        options?: 'cascade' | 'restrict';
      }
      => AstStatement<drop_index_stmt_node>
      */
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: a.toLowerCase(),
        keyword: r.toLowerCase(),
        prefix: cu,
        name: i,
        options: op && [{ type: 'origin', value: op }],
      },
    };
  };
  var peg$f83 = function (a, kw, t) {
    /*
      export interface truncate_stmt_node {
        type: 'trucate';
        keyword: 'table';
        name: table_ref_list;
      }
      => AstStatement<truncate_stmt_node>
      */
    if (t) t.forEach((tt) => tableList.add(`${a}::${tt.db}::${tt.table}`));
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: a.toLowerCase(),
        keyword: (kw && kw.toLowerCase()) || 'table',
        name: t,
      },
    };
  };
  var peg$f84 = function (d) {
    /*
      export interface use_stmt_node {
        type: 'use';
        db: ident;
      }
      => AstStatement<use_stmt_node>
      */
    tableList.add(`use::${d}::null`);
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: 'use',
        db: d,
      },
    };
  };
  var peg$f85 = function () {
    // => { name: ”*“ }
    return [
      {
        name: '*',
      },
    ];
  };
  var peg$f86 = function (s, o) {
    // => alter_func_args
    const ans = s || [];
    ans.orderby = o;
    return ans;
  };
  var peg$f87 = function (t) {
    // => ignore
    return t.toUpperCase();
  };
  var peg$f88 = function (m, ad, de) {
    // => { mode?: string; name?: string; type: data_type;  default: default_arg_expr; }
    return {
      mode: m,
      type: ad,
      default: de,
    };
  };
  var peg$f89 = function (m, an, ad, de) {
    // => { mode?: string; name?: string; type: data_type;  default: default_arg_expr; }
    return {
      mode: m,
      name: an,
      type: ad,
      default: de,
    };
  };
  var peg$f90 = function (head, tail) {
    // => alter_func_arg_item[]
    return createList(head, tail);
  };
  var peg$f91 = function (t, s, as, ac) {
    // => AstStatement<alter_resource_stmt_node>
    const keyword = t.toLowerCase();
    ac.resource = keyword;
    ac[keyword] = ac.table;
    delete ac.table;
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: 'alter',
        keyword,
        name: { schema: s.db, name: s.table },
        args: {
          parentheses: true,
          expr: as,
          orderby: as.orderby,
        },
        expr: ac,
      },
    };
  };
  var peg$f92 = function (t, s, ags, ac) {
    // => AstStatement<alter_resource_stmt_node>
    const keyword = t.toLowerCase();
    ac.resource = keyword;
    ac[keyword] = ac.table;
    delete ac.table;
    const args = {};
    if (ags && ags[0]) args.parentheses = true;
    args.expr = ags && ags[2];
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: 'alter',
        keyword,
        name: { schema: s.db, name: s.table },
        args,
        expr: ac,
      },
    };
  };
  var peg$f93 = function (t, s, ac) {
    /*
      export interface alter_resource_stmt_node {
        type: 'alter';
        keyword: 'domain' | 'type',
        name: string | { schema: string, name: string };
        args?: { parentheses: true; expr?: alter_func_args; orderby?: alter_func_args; };
        expr: alter_rename_owner;
      }
      => AstStatement<alter_resource_stmt_node>
      */
    const keyword = t.toLowerCase();
    ac.resource = keyword;
    ac[keyword] = ac.table;
    delete ac.table;
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: 'alter',
        keyword,
        name: { schema: s.db, name: s.table },
        expr: ac,
      },
    };
  };
  var peg$f94 = function (t, s, ac) {
    // => AstStatement<alter_resource_stmt_node>
    const keyword = t.toLowerCase();
    ac.resource = keyword;
    ac[keyword] = ac.table;
    delete ac.table;
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: 'alter',
        keyword,
        schema: s,
        expr: ac,
      },
    };
  };
  var peg$f95 = function (t, e) {
    /*
      export interface alter_table_stmt_node {
        type: 'alter';
        table: table_ref_list;
        expr: alter_action_list;
      }
      => AstStatement<alter_table_stmt_node>
      */
    if (t && t.length > 0) t.forEach((table) => tableList.add(`alter::${table.db}::${table.table}`));
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: 'alter',
        table: t,
        expr: e,
      },
    };
  };
  var peg$f96 = function (head, tail) {
    // => alter_action[]
    return createList(head, tail);
  };
  var peg$f97 = function (kc, cd) {
    /*
      => {
        action: 'add';
        keyword: KW_COLUMN;
        resource: 'column';
        type: 'alter';
      } & create_column_definition;
      */
    return {
      action: 'add',
      ...cd,
      keyword: kc,
      resource: 'column',
      type: 'alter',
    };
  };
  var peg$f98 = function (kc, c) {
    /* => {
        action: 'drop';
        collumn: column_ref;
        keyword: KW_COLUMN;
        resource: 'column';
        type: 'alter';
      } */
    return {
      action: 'drop',
      column: c,
      keyword: kc,
      resource: 'column',
      type: 'alter',
    };
  };
  var peg$f99 = function (c) {
    /* => {
        action: 'add';
        create_definitions: create_db_definition;
        resource: 'constraint';
        type: 'alter';
      } */
    return {
      action: 'add',
      create_definitions: c,
      resource: 'constraint',
      type: 'alter',
    };
  };
  var peg$f100 = function (id) {
    /* => {
         action: 'add';
         type: 'alter';
         } & create_index_definition */
    return {
      action: 'add',
      type: 'alter',
      ...id,
    };
  };
  var peg$f101 = function (kw, tn) {
    /*
      export interface alter_rename_owner {
        action: string;
        type: 'alter';
        resource: string;
        keyword?: 'to' | 'as';
        [key: string]: ident;
      }
      => AstStatement<alter_rename>
      */
    return {
      action: 'rename',
      type: 'alter',
      resource: 'table',
      keyword: kw && kw[0].toLowerCase(),
      table: tn,
    };
  };
  var peg$f102 = function (tn) {
    // => AstStatement<alter_rename_owner>
    return {
      action: 'owner',
      type: 'alter',
      resource: 'table',
      keyword: 'to',
      table: tn,
    };
  };
  var peg$f103 = function (s) {
    // => AstStatement<alter_rename_owner>
    return {
      action: 'set',
      type: 'alter',
      resource: 'table',
      keyword: 'schema',
      table: s,
    };
  };
  var peg$f104 = function (s, val) {
    /* => {
        type: 'alter';
        keyword: 'algorithm';
        resource: 'algorithm';
        symbol?: '=';
        algorithm: 'DEFAULT' | 'INSTANT' | 'INPLACE' | 'COPY';
      }*/
    return {
      type: 'alter',
      keyword: 'algorithm',
      resource: 'algorithm',
      symbol: s,
      algorithm: val,
    };
  };
  var peg$f105 = function (s, val) {
    /* => {
      type: 'alter';
      keyword: 'lock';
      resource: 'lock';
      symbol?: '=';
      lock: 'DEFAULT' | 'NONE' | 'SHARED' | 'EXCLUSIVE';
    }*/
    return {
      type: 'alter',
      keyword: 'lock',
      resource: 'lock',
      symbol: s,
      lock: val,
    };
  };
  var peg$f106 = function (kc, c, t, de, id) {
    /* => {
         index: column;
         definition: cte_column_definition;
         keyword: 'index' | 'key';
         index_type?: index_type;
         resource: 'index';
         index_options?: index_options;
       }*/
    return {
      index: c,
      definition: de,
      keyword: kc.toLowerCase(),
      index_type: t,
      resource: 'index',
      index_options: id,
    };
  };
  var peg$f107 = function (p, kc, c, de, id) {
    /* => {
          index: column;
          definition: cte_column_definition;
          keyword: 'fulltext' | 'spatial' | 'fulltext key' | 'spatial key' | 'fulltext index' | 'spatial index';
          index_options?: index_options;
          resource: 'index';
        }*/
    return {
      index: c,
      definition: de,
      keyword: (kc && `${p.toLowerCase()} ${kc.toLowerCase()}`) || p.toLowerCase(),
      index_options: id,
      resource: 'index',
    };
  };
  var peg$f108 = function (kc, c) {
    // => { keyword: 'constraint'; constraint: ident; }
    return {
      keyword: kc.toLowerCase(),
      constraint: c,
    };
  };
  var peg$f109 = function (kc, p, e) {
    /* => {
      constraint?: constraint_name['constraint'];
      definition: or_and_where_expr;
      keyword?: constraint_name['keyword'];
      constraint_type: 'check';
      resource: 'constraint';
    }*/
    return {
      constraint: kc && kc.constraint,
      definition: [e],
      constraint_type: p.toLowerCase(),
      keyword: kc && kc.keyword,
      resource: 'constraint',
    };
  };
  var peg$f110 = function (kc, p, t, de, id) {
    /* => {
      constraint?: constraint_name['constraint'];
      definition: cte_column_definition;
      constraint_type: 'primary key';
      keyword?: constraint_name['keyword'];
      index_type?: index_type;
      resource: 'constraint';
      index_options?: index_options;
    }*/
    return {
      constraint: kc && kc.constraint,
      definition: de,
      constraint_type: p.toLowerCase(),
      keyword: kc && kc.keyword,
      index_type: t,
      resource: 'constraint',
      index_options: id,
    };
  };
  var peg$f111 = function (kc, u, p, i, t, de, id) {
    /* => {
      constraint?: constraint_name['constraint'];
      definition: cte_column_definition;
      constraint_type: 'unique key' | 'unique' | 'unique index';
      keyword?: constraint_name['keyword'];
      index_type?: index_type;
      resource: 'constraint';
      index_options?: index_options;
    }*/
    return {
      constraint: kc && kc.constraint,
      definition: de,
      constraint_type: (p && `${u.toLowerCase()} ${p.toLowerCase()}`) || u.toLowerCase(),
      keyword: kc && kc.keyword,
      index_type: t,
      index: i,
      resource: 'constraint',
      index_options: id,
    };
  };
  var peg$f112 = function (kc, p, i, de, id) {
    /* => {
      constraint?: constraint_name['constraint'];
      definition: cte_column_definition;
      constraint_type: 'FOREIGN KEY';
      keyword: constraint_name['keyword'];
      index?: column;
      resource: 'constraint';
      reference_definition?: reference_definition;
    }*/
    return {
      constraint: kc && kc.constraint,
      definition: de,
      constraint_type: p,
      keyword: kc && kc.keyword,
      index: i,
      resource: 'constraint',
      reference_definition: id,
    };
  };
  var peg$f113 = function (kc, t, de, m, od, ou) {
    /* => {
        definition: cte_column_definition;
        table: table_ref_list;
        keyword: 'references';
        match: 'match full' | 'match partial' | 'match simple';
        on_action: [on_reference?];
      }*/
    return {
      definition: de,
      table: [t],
      keyword: kc.toLowerCase(),
      match: m && m.toLowerCase(),
      on_action: [od, ou].filter((v) => v),
    };
  };
  var peg$f114 = function (oa) {
    /* => {
      on_action: [on_reference];
    }
    */
    return {
      on_action: [oa],
    };
  };
  var peg$f115 = function (kw, ro) {
    // => { type: 'on delete' | 'on update'; value: reference_option; }
    return {
      type: `on ${kw[0].toLowerCase()}`,
      value: ro,
    };
  };
  var peg$f116 = function (kw, l) {
    // => { type: 'function'; name: string; args: expr_list; }
    return {
      type: 'function',
      name: kw,
      args: l,
    };
  };
  var peg$f117 = function (kc) {
    // => 'restrict' | 'cascade' | 'set null' | 'no action' | 'set default' | 'current_timestamp'
    return {
      type: 'origin',
      value: kc.toLowerCase(),
    };
  };
  var peg$f118 = function (kw, or, kc, t, c, p, te, on, tn, fr, de, fe, tw, fc, e, fct) {
    /*
    => {
      type: 'create';
      replace?: string;
      constraint?: string;
      location: 'before' | 'after' | 'instead of';
      events: trigger_event_list;
      table: table_name;
      from?: table_name;
      deferrable?: trigger_deferrable;
      for_each?: trigger_for_row;
      when?: trigger_when;
      execute: {
        keyword: string;
        expr: proc_func_call;
      };
      constraint_type: 'trigger';
      keyword: 'trigger';
      constraint_kw: 'constraint';
      resource: 'constraint';
    }
    */
    return {
      type: 'create',
      replace: or && 'or replace',
      constraint: c,
      location: p && p.toLowerCase(),
      events: te,
      table: tn,
      from: fr && fr[2],
      deferrable: de,
      for_each: fe,
      when: tw,
      execute: {
        keyword: `execute ${e.toLowerCase()}`,
        expr: fct,
      },
      constraint_type: t && t.toLowerCase(),
      keyword: t && t.toLowerCase(),
      constraint_kw: kc && kc.toLowerCase(),
      resource: 'constraint',
    };
  };
  var peg$f119 = function (kw) {
    // => { keyword: 'insert' | 'delete' | 'truncate' }
    const keyword = Array.isArray(kw) ? kw[0].toLowerCase() : kw.toLowerCase();
    return {
      keyword,
    };
  };
  var peg$f120 = function (kw, a) {
    // => { keyword: 'update'; args?: { keyword: 'of', columns: column_ref_list; }}
    return {
      keyword: kw && kw[0] && kw[0].toLowerCase(),
      args: (a && { keyword: a[0], columns: a[2] }) || null,
    };
  };
  var peg$f121 = function (head, tail) {
    // => trigger_event[];
    return createList(head, tail);
  };
  var peg$f122 = function (kw, args) {
    // => { keyword: 'deferrable' | 'not deferrable'; args: 'initially immediate' | 'initially deferred' }
    return {
      keyword: kw && kw[0] ? `${kw[0].toLowerCase()} deferrable` : 'deferrable',
      args: args && args.toLowerCase(),
    };
  };
  var peg$f123 = function (kw, e, ob) {
    // => { keyword: 'for' | 'for each'; args: 'row' | 'statement' }
    return {
      keyword: e ? `${kw.toLowerCase()} ${e.toLowerCase()}` : kw.toLowerCase(),
      args: ob.toLowerCase(),
    };
  };
  var peg$f124 = function (condition) {
    // => { type: 'when'; cond: expr; parentheses: true; }
    return {
      type: 'when',
      cond: condition,
      parentheses: true,
    };
  };
  var peg$f125 = function (head, tail) {
    // => table_option[]
    return createList(head, tail);
  };
  var peg$f126 = function () {
    // => string
    return 'CHARACTER SET';
  };
  var peg$f127 = function (kw, t, s, v) {
    /* => {
      keyword: 'character set' | 'charset' | 'collate' | 'default character set' | 'default charset' | 'default collate';
      symbol: '=';
      value: ident_name;
      } */
    return {
      keyword: (kw && `${kw[0].toLowerCase()} ${t.toLowerCase()}`) || t.toLowerCase(),
      symbol: s,
      value: v,
    };
  };
  var peg$f128 = function (kw, s, v) {
    /* => {
      keyword: 'auto_increment' | 'avg_row_length' | 'key_block_size' | 'max_rows' | 'min_rows' | 'stats_sample_pages';
      symbol: '=';
      value: number; // <== literal_numeric['value']
      } */
    return {
      keyword: kw.toLowerCase(),
      symbol: s,
      value: v.value,
    };
  };
  var peg$f129 = function (kw, s, c) {
    // => { keyword: 'connection' | 'comment'; symbol: '='; value: string; }
    return {
      keyword: kw.toLowerCase(),
      symbol: s,
      value: `'${c.value}'`,
    };
  };
  var peg$f130 = function (kw, s, v) {
    // => { keyword: 'compression'; symbol: '='; value: "'ZLIB'" | "'LZ4'" | "'NONE'" }
    return {
      keyword: kw.toLowerCase(),
      symbol: s,
      value: v.join('').toUpperCase(),
    };
  };
  var peg$f131 = function (kw, s, c) {
    // => { keyword: 'engine'; symbol: '='; value: string; }
    return {
      keyword: kw.toLowerCase(),
      symbol: s,
      value: c.toUpperCase(),
    };
  };
  var peg$f132 = function (fsid) {
    // => create_fulltext_spatial_index_definition & { action: 'add'; type: 'alter' }
    return {
      action: 'add',
      type: 'alter',
      ...fsid,
    };
  };
  var peg$f133 = function (t) {
    /*
      export interface rename_stmt_node {
        type: 'rename';
        table: table_to_list;
      }
       => AstStatement<rename_stmt_node>
       */
    t.forEach((tg) => tg.forEach((dt) => dt.table && tableList.add(`rename::${dt.db}::${dt.table}`)));
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: 'rename',
        table: t,
      },
    };
  };
  var peg$f134 = function (kw, a) {
    /*
      export interface set_stmt_node {
        type: 'set';
        expr: assign_stmt & { keyword?: 'GLOBAL' | 'SESSION' | 'LOCAL' | 'PERSIST' | 'PERSIST_ONLY'; };
      }
       => AstStatement<set_stmt_node>
       */
    a.keyword = kw;
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: 'set',
        expr: a,
      },
    };
  };
  var peg$f135 = function (m) {
    // => { mode: string; }
    return {
      mode: `in ${m.toLowerCase()} mode`,
    };
  };
  var peg$f136 = function (k, t, lm, nw) {
    /*
      export interface lock_stmt_node {
        type: 'lock';
        keyword: 'lock';
        tables: [[table_base], ...{table: table_ref}[]]; // see table_ref_list
        lock_mode?: lock_mode;
        nowait?: 'NOWAIT';
      }
       => AstStatement<lock_stmt_node>
       */

    if (t) t.forEach((tt) => tableList.add(`lock::${tt.db}::${tt.table}`));
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: 'lock',
        keyword: k && k.toLowerCase(),
        tables: t.map((table) => ({ table })),
        lock_mode: lm,
        nowait: nw,
      },
    };
  };
  var peg$f137 = function (e) {
    /*
    export interface call_stmt_node {
      type: 'call';
      expr: proc_func_call;
    }
    => AstStatement<call_stmt_node>
    */
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: 'call',
        expr: e,
      },
    };
  };
  var peg$f138 = function () {
    return {
      /*
        export interface show_stmt_node {
          type: 'show';
          keyword: 'tables' | 'var';
          var?: without_prefix_var_decl;
        }
        => AstStatement<show_stmt_node>
       */
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: 'show',
        keyword: 'tables',
      },
    };
  };
  var peg$f139 = function (c) {
    return {
      // => AstStatement<show_stmt_node>
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: 'show',
        keyword: 'var',
        var: c,
      },
    };
  };
  var peg$f140 = function (p, i) {
    return {
      /*
        export interface deallocate_stmt_node {
          type: 'deallocate';
          keyword: 'PREPARE' | undefined;
          expr: { type: 'default', value: string }
        }
        => AstStatement<deallocate_stmt_node>
       */
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: 'deallocate',
        keyword: p,
        expr: { type: 'default', value: i },
      },
    };
  };
  var peg$f141 = function (p) {
    /* export interface origin_str_stmt {
        type: 'origin';
        value: string;
      }
      => origin_str_stmt
     */
    return {
      type: 'origin',
      value: Array.isArray(p) ? p[0] : p,
    };
  };
  var peg$f142 = function (p) {
    // => origin_str_stmt
    return {
      type: 'origin',
      value: Array.isArray(p) ? p[0] : p,
    };
  };
  var peg$f143 = function (p) {
    // => origin_str_stmt
    return {
      type: 'origin',
      value: Array.isArray(p) ? p[0] : p,
    };
  };
  var peg$f144 = function (p) {
    // => origin_str_stmt
    return {
      type: 'origin',
      value: p ? 'all privileges' : 'all',
    };
  };
  var peg$f145 = function (p) {
    // => origin_str_stmt
    return {
      type: 'origin',
      value: p,
    };
  };
  var peg$f146 = function (p) {
    // => origin_str_stmt
    return {
      type: 'origin',
      value: p,
    };
  };
  var peg$f147 = function (p, c) {
    // => { priv: priv_type; columns: column_ref_list; }
    return {
      priv: p,
      columns: c && c[2],
    };
  };
  var peg$f148 = function (head, tail) {
    // => priv_item[]
    return createList(head, tail);
  };
  var peg$f149 = function (o) {
    // => origin_str_stmt
    return {
      type: 'origin',
      value: o.toUpperCase(),
    };
  };
  var peg$f150 = function (i) {
    // => origin_str_stmt
    return {
      type: 'origin',
      value: `all ${i} in schema`,
    };
  };
  var peg$f151 = function (prefix, name) {
    // => { prefix: string; name: string; }
    return {
      prefix: prefix && prefix[0],
      name,
    };
  };
  var peg$f152 = function (head, tail) {
    // => priv_level[]
    return createList(head, tail);
  };
  var peg$f153 = function (g, i) {
    // => origin_str_stmt
    const name = g ? `${group} ${i}` : i;
    return {
      name: { type: 'origin', value: name },
    };
  };
  var peg$f154 = function (i) {
    // => origin_str_stmt
    return {
      name: { type: 'origin', value: i },
    };
  };
  var peg$f155 = function (head, tail) {
    // => user_or_role[]
    return createList(head, tail);
  };
  var peg$f156 = function () {
    // => origin_str_stmt
    return {
      type: 'origin',
      value: 'with grant option',
    };
  };
  var peg$f157 = function () {
    // => origin_str_stmt
    return {
      type: 'origin',
      value: 'with admin option',
    };
  };
  var peg$f158 = function () {
    // => { type: 'grant' }
    return {
      type: 'grant',
    };
  };
  var peg$f159 = function (i) {
    // => { type: 'revoke'; grant_option_for?: origin_str_stmt; }
    return {
      type: 'revoke',
      grant_option_for: i && { type: 'origin', value: 'grant option for' },
    };
  };
  var peg$f160 = function (g, pl, ot, le, t) {
    const obj = { revoke: 'from', grant: 'to' };
    return obj[g.type].toLowerCase() === t[0].toLowerCase();
  };
  var peg$f161 = function (g, pl, ot, le, t, to, wo) {
    /* export interface grant_revoke_stmt {
        type: string;
        grant_option_for?: origin_str_stmt;
        keyword: 'priv';
        objects: priv_list;
        on: {
          object_type?: object_type;
          priv_level: priv_level_list;
        };
        to_from: 'to' | 'from';
        user_or_roles?: user_or_role_list;
        with?: with_grant_option;
      }
      => AstStatement<grant_revoke_stmt>
     */
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        ...g,
        keyword: 'priv',
        objects: pl,
        on: {
          object_type: ot,
          priv_level: le,
        },
        to_from: t[0],
        user_or_roles: to,
        with: wo,
      },
    };
  };
  var peg$f162 = function (g, o, t) {
    const obj = { revoke: 'from', grant: 'to' };
    return obj[g.type].toLowerCase() === t[0].toLowerCase();
  };
  var peg$f163 = function (g, o, t, to, wo) {
    // => => AstStatement<grant_revoke_stmt>
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        ...g,
        keyword: 'role',
        objects: o.map((name) => ({ priv: { type: 'string', value: name } })),
        to_from: t[0],
        user_or_roles: to,
        with: wo,
      },
    };
  };
  var peg$f164 = function (e, ia, s) {
    // => { type: 'elseif'; boolean_expr: expr; then: curd_stmt; semicolon?: string; }
    return {
      type: 'elseif',
      boolean_expr: e,
      then: ia,
      semicolon: s,
    };
  };
  var peg$f165 = function (head, tail) {
    // => elseif_stmt[]
    return createList(head, tail, 1);
  };
  var peg$f166 = function (ie, ia, s, ei, el, es) {
    /* export interface if_else_stmt {
        type: 'if';
        keyword: 'if';
        boolean_expr: expr;
        semicolons: string[];
        if_expr: crud_stmt;
        elseif_expr: elseif_stmt[];
        else_expr: curd_stmt;
        prefix: literal_string;
        suffix: literal_string;
      }
     => AstStatement<if_else_stmt>
     */
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: 'if',
        keyword: 'if',
        boolean_expr: ie,
        semicolons: [s || '', es || ''],
        prefix: {
          type: 'origin',
          value: 'then',
        },
        if_expr: ia,
        elseif_expr: ei,
        else_expr: el && el[2],
        suffix: {
          type: 'origin',
          value: 'end if',
        },
      },
    };
  };
  var peg$f167 = function (o, e, es) {
    // => { type: 'using'; option: string; symbol: '='; expr: expr[]; }
    const expr = [e];
    if (es) es.forEach((ex) => expr.push(ex[3]));
    return {
      type: 'using',
      option: o,
      symbol: '=',
      expr,
    };
  };
  var peg$f168 = function (format, e) {
    // => IGNORE
    return {
      type: 'format',
      keyword: format,
      expr: e && e.map((ex) => ex[3]),
    };
  };
  var peg$f169 = function (ss) {
    // => IGNORE
    return {
      type: 'sqlstate',
      keyword: { type: 'origin', value: 'SQLSTATE' },
      expr: [ss],
    };
  };
  var peg$f170 = function (n) {
    // => IGNORE
    return {
      type: 'condition',
      expr: [{ type: 'default', value: n }],
    };
  };
  var peg$f171 = function (l, r, using) {
    /* export interface raise_stmt {
        type: 'raise';
        level?: string;
        raise?: raise_item;
        using?: raise_opt;
      }
      => AstStatement<raise_stmt>
     */
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: 'raise',
        level: l,
        using,
        raise: r,
      },
    };
  };
  var peg$f172 = function (name, a) {
    /* export interface execute_stmt {
        type: 'execute';
        name: string;
        args?: { type: expr_list; value: proc_primary_list; }
      }
      => AstStatement<execute_stmt>
     */
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: 'execute',
        name,
        args: a && { type: 'expr_list', value: a[2] },
      },
    };
  };
  var peg$f173 = function () {
    // => { label?: string; keyword: 'for'; }
    return {
      label: null,
      keyword: 'for',
    };
  };
  var peg$f174 = function (label) {
    // => IGNORE
    return {
      label,
      keyword: 'for',
    };
  };
  var peg$f175 = function (f, target, query, stmts, label) {
    if (f.label && label && f.label === label) return true;
    if (!f.label && !label) return true;
    return false;
  };
  var peg$f176 = function (f, target, query, stmts, label) {
    /* export interface for_loop_stmt {
        type: 'for';
        label?: string
        target: string;
        query: select_stmt;
        stmts: multiple_stmt;
      }
      => AstStatement<for_loop_stmt>
     */
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: 'for',
        label,
        target,
        query,
        stmts: stmts.ast,
      },
    };
  };
  var peg$f177 = function () {
    // => { type: 'select'; }
    return {
      type: 'select',
    };
  };
  var peg$f178 = function (s) {
    /*
    export interface select_stmt_node extends select_stmt_nake  {
       parentheses: true;
      }
      => select_stmt_node
      */
    return {
      ...s[2],
      parentheses_symbol: true,
    };
  };
  var peg$f179 = function (head, tail) {
    // => cte_definition[]
    return createList(head, tail);
  };
  var peg$f180 = function (cte) {
    // => [cte_definition & { recursive: true; }]
    cte.recursive = true;
    return [cte];
  };
  var peg$f181 = function (name, columns, stmt) {
    // => { name: { type: 'default'; value: string; }; stmt: crud_stmt; columns?: cte_column_definition; }
    if (typeof name === 'string') name = { type: 'default', value: name };
    return { name, stmt: stmt.ast, columns };
  };
  var peg$f182 = function (l) {
    // => column_ref_list
    return l;
  };
  var peg$f183 = function (d, o, c) {
    // => {type: string; columns: column_ref_list;}
    console.lo;
    return {
      type: `${d} ON`,
      columns: c,
    };
  };
  var peg$f184 = function (d) {
    // => { type: string | undefined; }
    return {
      type: d,
    };
  };
  var peg$f185 = function (cte, opts, d, c, ci, f, fi, w, g, h, o, l, win, li) {
    /* => {
          with?: with_clause;
          type: 'select';
          options?: option_clause;
          distinct?: {type: string; columns?: column_list; };
          columns: column_clause;
          from?: from_clause;
          into?: into_clause;
          where?: where_clause;
          groupby?: group_by_clause;
          having?: having_clause;
          orderby?: order_by_clause;
          limit?: limit_clause;
          window?: window_clause;
        }*/
    if ((ci && fi) || (ci && li) || (fi && li) || (ci && fi && li)) {
      throw new Error('A given SQL statement can contain at most one INTO clause');
    }
    if (f) f.forEach((info) => info.table && tableList.add(`select::${info.db}::${info.table}`));
    return {
      with: cte,
      type: 'select',
      options: opts,
      distinct: d,
      columns: c,
      into: {
        ...(ci || fi || li || {}),
        position: (ci && 'column') || (fi && 'from') || (li && 'end'),
      },
      from: f,
      where: w,
      groupby: g,
      having: h,
      orderby: o,
      limit: l,
      window: win,
    };
  };
  var peg$f186 = function (head, tail) {
    // => query_option[]
    const opts = [head];
    for (let i = 0, l = tail.length; i < l; ++i) {
      opts.push(tail[i][1]);
    }
    return opts;
  };
  var peg$f187 = function (option) {
    // =>  'SQL_CALC_FOUND_ROWS'| 'SQL_CACHE'| 'SQL_NO_CACHE'| 'SQL_BIG_RESULT'| 'SQL_SMALL_RESULT'| 'SQL_BUFFER_RESULT'
    return option;
  };
  var peg$f188 = function (head, tail) {
    // => 'ALL' | '*' | column_list_item[]
    columnList.add('select::null::(.*)');
    const item = {
      expr: {
        type: 'column_ref',
        table: null,
        column: '*',
      },
      as: null,
    };
    if (tail && tail.length > 0) return createList(item, tail);
    return [item];
  };
  var peg$f189 = function (head, tail) {
    // => column_list_item[]
    return createList(head, tail);
  };
  var peg$f190 = function (n) {
    // => { brackets: boolean, number: number }
    return {
      brackets: true,
      index: n,
    };
  };
  var peg$f191 = function (e, a) {
    // => binary_expr & { array_index: array_index }
    if (a) e.array_index = a;
    return e;
  };
  var peg$f192 = function (p, t, s) {
    // => data_type & { quoted?: string }
    if ((p && !s) || (!p && s)) throw new Error('double quoted not match');
    if (p && s) t.quoted = '"';
    return t;
  };
  var peg$f193 = function (c) {
    // => { expr: expr; as: null; }
    return { expr: c, as: null };
  };
  var peg$f194 = function (e, s, t, a, tail, alias) {
    // => { type: 'cast'; expr: expr; symbol: '::'; target: cast_data_type;  as?: null; arrows?: ('->>' | '->')[]; property?: (literal_string | literal_numeric)[]; }
    return {
      as: alias,
      type: 'cast',
      expr: e,
      symbol: '::',
      target: t,
      tail: tail && tail[0] && { operator: tail[0][1], expr: tail[0][3] },
      arrows: a.map((item) => item[0]),
      properties: a.map((item) => item[2]),
    };
  };
  var peg$f195 = function (tbl, pro) {
    // => { expr: column_ref; as: null; }
    const mid = pro && pro[0];
    let schema;
    if (mid) {
      schema = tbl;
      tbl = mid;
    }
    columnList.add(`select::${tbl}::(.*)`);
    const column = '*';
    return {
      expr: {
        type: 'column_ref',
        table: tbl,
        schema,
        column,
      },
      as: null,
    };
  };
  var peg$f196 = function (tbl) {
    // => { expr: column_ref; as: null; }
    const table = (tbl && tbl[0]) || null;
    columnList.add(`select::${table}::(.*)`);
    return {
      expr: {
        type: 'column_ref',
        table: table,
        column: '*',
      },
      as: null,
    };
  };
  var peg$f197 = function (c, d) {
    if (d) return true;
  };
  var peg$f198 = function (c, d, alias) {
    // => { type: 'expr'; expr: expr; as?: alias_clause; }
    columnList.add(`select::null::${c}`);
    return { type: 'expr', expr: { type: 'column_ref', table: null, column: c }, as: alias };
  };
  var peg$f199 = function (e, alias) {
    // => { type: 'expr'; expr: expr; as?: alias_clause; }
    return { type: 'expr', expr: e, as: alias };
  };
  var peg$f200 = function (i) {
    /*=>alias_ident*/ return i;
  };
  var peg$f201 = function (i) {
    /*=>alias_ident*/ return i;
  };
  var peg$f202 = function (i) {
    /*=>ident*/ return i;
  };
  var peg$f203 = function (v) {
    // => { keyword: 'var'; type: 'into'; expr: var_decl_list; }
    return {
      keyword: 'var',
      type: 'into',
      expr: v,
    };
  };
  var peg$f204 = function (k, f) {
    // => { keyword: 'var'; type: 'into'; expr: literal_string | ident; }
    return {
      keyword: k,
      type: 'into',
      expr: f,
    };
  };
  var peg$f205 = function (l) {
    /*=>table_ref_list*/ return l;
  };
  var peg$f206 = function (head, tail) {
    // => table_to_item[]
    return createList(head, tail);
  };
  var peg$f207 = function (head, tail) {
    // => table_name[]
    return [head, tail];
  };
  var peg$f208 = function (t) {
    // => { keyword: 'using'; type: 'btree' | 'hash' | 'gist' | 'gin' }
    return {
      keyword: 'using',
      type: t.toLowerCase(),
    };
  };
  var peg$f209 = function (head, tail) {
    // => index_option[]
    return createList(head, tail);
  };
  var peg$f210 = function (head, tail) {
    // => index_option[]
    const result = [head];
    for (let i = 0; i < tail.length; i++) {
      result.push(tail[i][1]);
    }
    return result;
  };
  var peg$f211 = function (k, e, kbs) {
    // => { type: 'key_block_size'; symbol: '='; expr: number; }
    return {
      type: k.toLowerCase(),
      symbol: e,
      expr: kbs,
    };
  };
  var peg$f212 = function (k, e, kbs) {
    // => { type: ident_name; symbol: '='; expr: number | {type: 'origin'; value: ident; }; }
    return {
      type: k.toLowerCase(),
      symbol: e,
      expr: (typeof kbs === 'string' && { type: 'origin', value: kbs }) || kbs,
    };
  };
  var peg$f213 = function (pn) {
    // => { type: 'with parser'; expr: ident_name }
    return {
      type: 'with parser',
      expr: pn,
    };
  };
  var peg$f214 = function (k) {
    // => { type: 'visible'; expr: 'visible' } | { type: 'invisible'; expr: 'invisible' }
    return {
      type: k.toLowerCase(),
      expr: k.toLowerCase(),
    };
  };
  var peg$f215 = function (head, tail) {
    // => [table_base, ...table_ref[]]
    tail.unshift(head);
    tail.forEach((tableInfo) => {
      const { table, as } = tableInfo;
      tableAlias[table] = table;
      if (as) tableAlias[as] = table;
      refreshColumnList(columnList);
    });
    return tail;
  };
  var peg$f216 = function (t) {
    /* => table_base */ return t;
  };
  var peg$f217 = function (t) {
    /* => table_join */ return t;
  };
  var peg$f218 = function (op, t, head, tail) {
    // => table_base & {join: join_op; using: ident_name[]; }
    t.join = op;
    t.using = createList(head, tail);
    return t;
  };
  var peg$f219 = function (op, t, expr) {
    // => table_base & {join: join_op; on?: on_clause; }
    t.join = op;
    t.on = expr;
    return t;
  };
  var peg$f220 = function (op, stmt, alias, expr) {
    /* => {
      expr: (union_stmt || table_ref_list) & { parentheses: true; };
      as?: alias_clause;
      join: join_op;
      on?: on_clause;
    }*/
    if (Array.isArray(stmt)) stmt = { type: 'tables', expr: stmt };
    stmt.parentheses = true;
    return {
      expr: stmt,
      as: alias,
      join: op,
      on: expr,
    };
  };
  var peg$f221 = function () {
    // => { type: 'dual' }
    return {
      type: 'dual',
    };
  };
  var peg$f222 = function (stmt, alias) {
    // => { expr: value_clause; as?: alias_clause; }
    return {
      expr: { type: 'values', values: stmt },
      as: alias,
    };
  };
  var peg$f223 = function (l, stmt, alias) {
    // => { prefix?: string; expr: union_stmt | value_clause; as?: alias_clause; }
    if (Array.isArray(stmt)) stmt = { type: 'values', values: stmt };
    stmt.parentheses = true;
    return {
      prefix: l,
      expr: stmt,
      as: alias,
    };
  };
  var peg$f224 = function (l, stmt, alias) {
    // => { prefix?: string; expr: table_ref_list; as?: alias_clause; }
    stmt = { type: 'tables', expr: stmt, parentheses: true };
    return {
      prefix: l,
      expr: stmt,
      as: alias,
    };
  };
  var peg$f225 = function (l, e, alias) {
    // => { prefix?: string; type: 'expr'; expr: expr; as?: alias_clause; }
    return { prefix: l, type: 'expr', expr: e, as: alias };
  };
  var peg$f226 = function (t, f, re, alias) {
    // => table_name & { expr: expr, repeatable: literal_numeric; as?: alias_clause;}
    return {
      ...t,
      as: alias,
      tablesample: {
        expr: f,
        repeatable: re && re[4],
      },
    };
  };
  var peg$f227 = function (t, alias) {
    // => table_name & { as?: alias_clause; }
    if (t.type === 'var') {
      t.as = alias;
      return t;
    } else {
      return {
        ...t,
        as: alias,
      };
    }
  };
  var peg$f228 = function () {
    /* => 'LEFT JOIN' */ return 'LEFT JOIN';
  };
  var peg$f229 = function () {
    /* =>  'RIGHT JOIN' */ return 'RIGHT JOIN';
  };
  var peg$f230 = function () {
    /* => 'FULL JOIN' */ return 'FULL JOIN';
  };
  var peg$f231 = function () {
    /* => 'CROSS JOIN' */ return 'CROSS JOIN';
  };
  var peg$f232 = function () {
    /* => 'INNER JOIN' */ return 'INNER JOIN';
  };
  var peg$f233 = function (dt, schema, tail) {
    // => { db?: ident; schema?: ident, table: ident | '*'; }
    const obj = { db: null, table: dt };
    if (tail !== null) {
      obj.db = dt;
      obj.schema = schema[3];
      obj.table = tail[3];
      return obj;
    }
    if (schema !== null) {
      obj.db = dt;
      obj.table = schema[3];
    }
    return obj;
  };
  var peg$f234 = function (v) {
    // => IGNORE
    v.db = null;
    v.table = v.name;
    return v;
  };
  var peg$f235 = function (e) {
    /* => or_and_where_expr */ return e;
  };
  var peg$f236 = function (e) {
    /* => binary_expr */ return e;
  };
  var peg$f237 = function (e) {
    /* => expr_list['value'] */ return e.value;
  };
  var peg$f238 = function (head, tail) {
    // => column_ref[]
    return createList(head, tail);
  };
  var peg$f239 = function (e) {
    /* => expr */ return e;
  };
  var peg$f240 = function (l) {
    // => { keyword: 'window'; type: 'window', expr: named_window_expr_list; }
    return {
      keyword: 'window',
      type: 'window',
      expr: l,
    };
  };
  var peg$f241 = function (head, tail) {
    // => named_window_expr[]
    return createList(head, tail);
  };
  var peg$f242 = function (nw, anw) {
    // => { name: ident_name;  as_window_specification: as_window_specification; }
    return {
      name: nw,
      as_window_specification: anw,
    };
  };
  var peg$f243 = function (ws) {
    // => { window_specification: window_specification; parentheses: boolean }
    return {
      window_specification: ws || {},
      parentheses: true,
    };
  };
  var peg$f244 = function (bc, l, w) {
    // => { name: null; partitionby: partition_by_clause; orderby: order_by_clause; window_frame_clause: string | null; }
    return {
      name: null,
      partitionby: bc,
      orderby: l,
      window_frame_clause: w,
    };
  };
  var peg$f245 = function (bc, l) {
    // => { name: null; partitionby: partition_by_clause; orderby: order_by_clause; window_frame_clause: null }
    return {
      name: null,
      partitionby: bc,
      orderby: l,
      window_frame_clause: null,
    };
  };
  var peg$f246 = function (kw, s) {
    // => string
    return `rows ${s.value}`;
  };
  var peg$f247 = function (p, f) {
    // => string
    return `rows between ${p.value} and ${f.value}`;
  };
  var peg$f248 = function (s) {
    // => string
    s.value += ' FOLLOWING';
    return s;
  };
  var peg$f249 = function (s) {
    // => string
    s.value += ' PRECEDING';
    return s;
  };
  var peg$f250 = function () {
    // => { type: 'single_quote_string'; value: string }
    return { type: 'single_quote_string', value: 'current row' };
  };
  var peg$f251 = function (s) {
    // => literal_string
    return { type: 'single_quote_string', value: s.toUpperCase() };
  };
  var peg$f252 = function (bc) {
    /* => column_clause */ return bc;
  };
  var peg$f253 = function (l) {
    /* => order_by_list */ return l;
  };
  var peg$f254 = function (head, tail) {
    // => order_by_element[]
    return createList(head, tail);
  };
  var peg$f255 = function (e, d, nl) {
    // => { expr: expr; type: 'ASC' | 'DESC' | undefined;  nulls: 'NULLS FIRST' | 'NULLS LAST' | undefined }
    const obj = { expr: e, type: d };
    obj.nulls = nl && [nl[0], nl[2]].filter((v) => v).join(' ');
    return obj;
  };
  var peg$f256 = function (l, tail) {
    // => { separator: 'offset' | ''; value: [number_or_param | { type: 'origin', value: 'all' }, number_or_param?] }
    const res = [];
    if (l) res.push(typeof l[2] === 'string' ? { type: 'origin', value: 'all' } : l[2]);
    if (tail) res.push(tail[2]);
    return {
      seperator: (tail && tail[0] && tail[0].toLowerCase()) || '',
      value: res,
    };
  };
  var peg$f257 = function (cte, t, l, f, w, r) {
    /* export interface update_stmt_node {
        with?: with_clause;
         type: 'update';
         table: table_ref_list;
         set: set_list;
         from?: from_clause;
         where?: where_clause;
         returning?: returning_stmt;
      }
     => AstStatement<update_stmt_node>
     */
    const dbObj = {};
    if (t)
      t.forEach((tableInfo) => {
        const { db, as, table, join } = tableInfo;
        const action = join ? 'select' : 'update';
        if (db) dbObj[table] = db;
        if (table) tableList.add(`${action}::${db}::${table}`);
      });
    if (l) {
      l.forEach((col) => {
        if (col.table) {
          const table = queryTableAlias(col.table);
          tableList.add(`update::${dbObj[table] || null}::${table}`);
        }
        columnList.add(`update::${col.table}::${col.column}`);
      });
    }
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        with: cte,
        type: 'update',
        table: t,
        set: l,
        from: f,
        where: w,
        returning: r,
      },
    };
  };
  var peg$f258 = function (t, f, w) {
    /*
      export interface table_ref_addition extends table_name {
        addition: true;
        as?: alias_clause;
      }
       export interface delete_stmt_node {
         type: 'delete';
         table?: table_ref_list | [table_ref_addition];
         where?: where_clause;
      }
     => AstStatement<delete_stmt_node>
     */
    if (f)
      f.forEach((tableInfo) => {
        const { db, as, table, join } = tableInfo;
        const action = join ? 'select' : 'delete';
        if (table) tableList.add(`${action}::${db}::${table}`);
        if (!join) columnList.add(`delete::${table}::(.*)`);
      });
    if (t === null && f.length === 1) {
      const tableInfo = f[0];
      t = [
        {
          db: tableInfo.db,
          table: tableInfo.table,
          as: tableInfo.as,
          addition: true,
        },
      ];
    }
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: 'delete',
        table: t,
        from: f,
        where: w,
      },
    };
  };
  var peg$f259 = function (head, tail) {
    // => set_item[]
    return createList(head, tail);
  };
  var peg$f260 = function (tbl, c, v) {
    // => { column: ident; value: additive_expr; table?: ident;}
    return { column: c, value: v, table: tbl && tbl[0] };
  };
  var peg$f261 = function (tbl, c, v) {
    // => { column: ident; value: column_ref; table?: ident; keyword: 'values' }
    return { column: c, value: v, table: tbl && tbl[0], keyword: 'values' };
  };
  var peg$f262 = function (k, c) {
    // => { type: 'returning'; columns: column_clause | select_stmt; }
    return {
      type: (k && k.toLowerCase()) || 'returning',
      columns: (c === '*' && [{ type: 'expr', expr: { type: 'column_ref', table: null, column: '*' }, as: null }]) || c,
    };
  };
  var peg$f263 = function (head, tail) {
    // => ident_name[]
    return createList(head, tail);
  };
  var peg$f264 = function (v) {
    // => value_item
    return v;
  };
  var peg$f265 = function (c) {
    // => { type: 'column'; expr: column_ref_list; parentheses: true; }
    return {
      type: 'column',
      expr: c,
      parentheses: true,
    };
  };
  var peg$f266 = function () {
    // => { keyword: "do"; expr: {type: 'origin'; value: string; }; }
    return {
      keyword: 'do',
      expr: {
        type: 'origin',
        value: 'nothing',
      },
    };
  };
  var peg$f267 = function (s, w) {
    // => { keyword: "do"; expr: {type: 'update'; set: set_list; where: where_clause; }; }
    return {
      keyword: 'do',
      expr: {
        type: 'update',
        set: s,
        where: w,
      },
    };
  };
  var peg$f268 = function (ct, ca) {
    // => { type: "conflict"; keyword: "on"; target: conflict_target; action: conflict_action; }
    return {
      type: 'conflict',
      keyword: 'on',
      target: ct,
      action: ca,
    };
  };
  var peg$f269 = function (ri, t, p, c, v, oc, r) {
    /*
       export interface replace_insert_stmt_node {
         type: 'insert' | 'replace';
         table?: [table_name];
         columns: column_list;
         conflict?: on_clifict;
         values: insert_value_clause;
         partition?: insert_partition;
         returning?: returning_stmt;
      }
     => AstStatement<replace_insert_stmt_node>
     */
    if (t) {
      tableList.add(`insert::${t.db}::${t.table}`);
      t.as = null;
    }
    if (c) {
      let table = (t && t.table) || null;
      if (Array.isArray(v)) {
        v.forEach((row, idx) => {
          if (row.value.length != c.length) {
            throw new Error(`Error: column count doesn't match value count at row ${idx + 1}`);
          }
        });
      }
      c.forEach((c) => columnList.add(`insert::${table}::${c}`));
    }
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: ri,
        table: [t],
        columns: c,
        values: v,
        partition: p,
        conflict: oc,
        returning: r,
      },
    };
  };
  var peg$f270 = function (ri, ig, it, t, p, v, r) {
    // => AstStatement<replace_insert_stmt_node>
    if (t) {
      tableList.add(`insert::${t.db}::${t.table}`);
      columnList.add(`insert::${t.table}::(.*)`);
      t.as = null;
    }
    const prefix = [ig, it]
      .filter((v) => v)
      .map((v) => v[0] && v[0].toLowerCase())
      .join(' ');
    return {
      tableList: Array.from(tableList),
      columnList: columnListTableAlias(columnList),
      ast: {
        type: ri,
        table: [t],
        columns: null,
        values: v,
        partition: p,
        prefix,
        returning: r,
      },
    };
  };
  var peg$f271 = function () {
    /* => 'insert' */ return 'insert';
  };
  var peg$f272 = function () {
    /* => 'replace' */ return 'replace';
  };
  var peg$f273 = function (l) {
    /* => value_list */ return l;
  };
  var peg$f274 = function (head, tail) {
    // => value_item[]
    return createList(head, tail);
  };
  var peg$f275 = function (l) {
    // => expr_list
    return l;
  };
  var peg$f276 = function (head, tail) {
    // => { type: 'expr_list'; value: expr[] }
    const el = { type: 'expr_list' };
    el.value = createList(head, tail);
    return el;
  };
  var peg$f277 = function (e, u) {
    // => { type: 'interval', expr: expr; unit: interval_unit; }
    return {
      type: 'interval',
      expr: e,
      unit: u.toLowerCase(),
    };
  };
  var peg$f278 = function (e) {
    // => { type: 'interval', expr: expr; unit: interval_unit; }
    return {
      type: 'interval',
      expr: e,
      unit: '',
    };
  };
  var peg$f279 = function (condition_list, otherwise) {
    /* => {
          type: 'case';
          expr:  null;
          // nb: Only the last element is a case_else
          args: (case_when_then | case_else)[];
        } */
    if (otherwise) condition_list.push(otherwise);
    return {
      type: 'case',
      expr: null,
      args: condition_list,
    };
  };
  var peg$f280 = function (expr, condition_list, otherwise) {
    /* => {
          type: 'case';
          expr: expr;
          // nb: Only the last element is a case_else
          args: (case_when_then | case_else)[];
        } */
    if (otherwise) condition_list.push(otherwise);
    return {
      type: 'case',
      expr: expr,
      args: condition_list,
    };
  };
  var peg$f281 = function (head, tail) {
    // => case_when_then[]
    return createList(head, tail, 1);
  };
  var peg$f282 = function (condition, result) {
    // => { type: 'when'; cond: binary_expr; result: expr; }
    return {
      type: 'when',
      cond: condition,
      result: result,
    };
  };
  var peg$f283 = function (result) {
    // => { type: 'else'; condition?: never; result: expr; }
    return { type: 'else', result: result };
  };
  var peg$f284 = function (head, tail, rh) {
    /*
    export type BINARY_OPERATORS = LOGIC_OPERATOR | 'OR' | 'AND' | multiplicative_operator | additive_operator
      | arithmetic_comparison_operator
      | 'IN' | 'NOT IN'
      | 'BETWEEN' | 'NOT BETWEEN'
      | 'IS' | 'IS NOT'
      | 'LIKE'
      | '@>' | '<@' | OPERATOR_CONCATENATION | DOUBLE_WELL_ARROW | WELL_ARROW | '?' | '?|' | '?&' | '#-'
    export interface binary_expr {
      type: 'binary_expr',
      operator: BINARY_OPERATORS,
      left: expr,
      right: expr
    }
    => binary_expr
    */
    const logicExpr = createBinaryExprChain(head, tail);
    if (rh === null) return logicExpr;
    else if (rh.type === 'arithmetic') return createBinaryExprChain(logicExpr, rh.tail);
    else return createBinaryExpr(rh.op, logicExpr, rh.right);
  };
  var peg$f285 = function (op, tail) {
    /*
    export type UNARY_OPERATORS = '+' | '-' | 'EXISTS' | 'NOT EXISTS'  | 'NULL'
    => {
      type: 'unary_expr',
      operator: UNARY_OPERATORS,
      expr: expr;
      parentheses?: boolean;
    } */
    return createUnaryExpr(op, tail[0][1]);
  };
  var peg$f286 = function (head, tail) {
    const ast = head.ast;
    if (ast && ast.type === 'select') {
      if (
        !(head.parentheses_symbol || head.parentheses || head.ast.parentheses || head.ast.parentheses_symbol) ||
        ast.columns.length !== 1 ||
        ast.columns[0].expr.column === '*'
      )
        throw new Error('invalid column clause with select statement');
    }
    if (!tail || tail.length === 0) return head;
    // => binary_expr
    const len = tail.length;
    let result = tail[len - 1][3];
    for (let i = len - 1; i >= 0; i--) {
      const left = i === 0 ? head : tail[i - 1][3];
      result = createBinaryExpr(tail[i][1], left, result);
    }
    return result;
  };
  var peg$f287 = function (head, tail) {
    // => binary_expr | { type: 'expr_list'; value: expr[] }
    const len = tail.length;
    let result = head;
    let seperator = '';
    for (let i = 0; i < len; ++i) {
      if (tail[i][1] === ',') {
        seperator = ',';
        if (!Array.isArray(result)) result = [result];
        result.push(tail[i][3]);
      } else {
        result = createBinaryExpr(tail[i][1], result, tail[i][3]);
      }
    }
    if (seperator === ',') {
      const el = { type: 'expr_list' };
      el.value = result;
      return el;
    }
    return result;
  };
  var peg$f288 = function (head, tail) {
    // => binary_expr
    return createBinaryExprChain(head, tail);
  };
  var peg$f289 = function (head, tail) {
    // => binary_expr
    return createBinaryExprChain(head, tail);
  };
  var peg$f290 = function (expr) {
    // => unary_expr
    return createUnaryExpr('NOT', expr);
  };
  var peg$f291 = function (left, rh) {
    // => binary_expr
    if (rh === null) return left;
    else if (rh.type === 'arithmetic') return createBinaryExprChain(left, rh.tail);
    else return createBinaryExpr(rh.op, left, rh.right);
  };
  var peg$f292 = function (op, stmt) {
    // => unary_expr
    stmt.parentheses = true;
    return createUnaryExpr(op, stmt);
  };
  var peg$f293 = function (nk) {
    /* => 'NOT EXISTS' */ return nk[0] + ' ' + nk[2];
  };
  var peg$f294 = function (l) {
    // => { type: 'arithmetic'; tail: any }
    return { type: 'arithmetic', tail: l };
  };
  var peg$f295 = function (right) {
    // => { op: 'IS'; right: additive_expr; }
    return { op: 'IS', right: right };
  };
  var peg$f296 = function (right) {
    // => { type: 'origin'; value: string; }
    const { db, table } = right.pop();
    const tableName = table === '*' ? '*' : `"${table}"`;
    let tableStr = db ? `"${db}".${tableName}` : tableName;
    return {
      op: 'IS',
      right: {
        type: 'default',
        value: `DISTINCT FROM ${tableStr}`,
      },
    };
  };
  var peg$f297 = function (right) {
    // => { type: 'IS NOT'; right: additive_expr; }
    return { op: 'IS NOT', right: right };
  };
  var peg$f298 = function (op, begin, end) {
    // => { op: 'BETWEEN' | 'NOT BETWEEN'; right: { type: 'expr_list'; value: [expr, expr] }  }
    return {
      op: op,
      right: {
        type: 'expr_list',
        value: [begin, end],
      },
    };
  };
  var peg$f299 = function (nk) {
    /* => 'NOT BETWEEN' */ return nk[0] + ' ' + nk[2];
  };
  var peg$f300 = function (nk) {
    /* => 'LIKE' */ return nk[0] + ' ' + nk[2];
  };
  var peg$f301 = function () {
    // => 'SIMILAR TO'
    return 'SIMILAR TO';
  };
  var peg$f302 = function () {
    // => 'NOT SIMILAR TO'
    return 'NOT SIMILAR TO';
  };
  var peg$f303 = function (op, right) {
    // => { op: regex_op; right: literal | comparison_expr}
    return { op: op, right: right };
  };
  var peg$f304 = function (kw, c) {
    // => { type: 'ESCAPE'; value: literal_string }
    return {
      type: 'ESCAPE',
      value: c,
    };
  };
  var peg$f305 = function (nk) {
    /* => 'NOT IN' */ return nk[0] + ' ' + nk[2];
  };
  var peg$f306 = function (op, right, es) {
    // => { op: like_op; right: (literal | comparison_expr) & { escape?: escape_op }; }
    if (es) right.escape = es;
    return { op: op, right: right };
  };
  var peg$f307 = function (op, l) {
    // => {op: in_op; right: expr_list | var_decl | literal_string; }
    return { op: op, right: l };
  };
  var peg$f308 = function (op, e) {
    // => IGNORE
    return { op: op, right: e };
  };
  var peg$f309 = function (s, c) {
    // => { op: string; right: expr }
    return {
      op: s,
      right: (c && c.expr) || c,
    };
  };
  var peg$f310 = function (head, tail) {
    // => binary_expr
    return createBinaryExprChain(head, tail);
  };
  var peg$f311 = function (head, tail) {
    // => binary_expr
    return createBinaryExprChain(head, tail);
  };
  var peg$f312 = function (c, a) {
    // => column_ref
    if (a) c.array_index = a;
    return c;
  };
  var peg$f313 = function (list) {
    // => or_and_where_expr
    list.parentheses = true;
    return list;
  };
  var peg$f314 = function (p, n) {
    // => { type: 'origin'; value: string; }
    return {
      type: 'origin',
      value: `$<${n.value}>`,
    };
  };
  var peg$f315 = function (n) {
    // => { type: 'origin'; value: string; }
    return {
      type: 'origin',
      value: `E'${n.join('')}'`,
    };
  };
  var peg$f316 = function (tbl) {
    // => IGNORE
    const table = (tbl && tbl[0]) || null;
    columnList.add(`select::${table}::(.*)`);
    return {
      type: 'column_ref',
      table: table,
      column: '*',
    };
  };
  var peg$f317 = function (tbl, col, a) {
    // => IGNORE
    const tableName = (tbl && tbl[0]) || null;
    columnList.add(`select::${tableName}::${col}`);
    return {
      type: 'column_ref',
      table: tableName,
      column: col,
      arrows: a.map((item) => item[0]),
      properties: a.map((item) => item[2]),
    };
  };
  var peg$f318 = function (schema, tbl, col) {
    /* => {
        type: 'column_ref';
        schema: string;
        table: string;
        column: column | '*';
        arrows?: ('->>' | '->')[];
        property?: (literal_string | literal_numeric)[];
      } */
    columnList.add(`select::${schema}.${tbl[3]}::${col[3]}`);
    return {
      type: 'column_ref',
      schema: schema,
      table: tbl[3],
      column: col[3],
    };
  };
  var peg$f319 = function (tbl, col) {
    /* => {
        type: 'column_ref';
        table: ident;
        column: column | '*';
        arrows?: ('->>' | '->')[];
        property?: (literal_string | literal_numeric)[];
      } */
    columnList.add(`select::${tbl}::${col}`);
    return {
      type: 'column_ref',
      table: tbl,
      column: col,
    };
  };
  var peg$f320 = function (col) {
    // => IGNORE
    columnList.add(`select::null::${col}`);
    return {
      type: 'column_ref',
      table: null,
      column: col,
    };
  };
  var peg$f321 = function (head, tail) {
    // => column[]
    return createList(head, tail);
  };
  var peg$f322 = function (name) {
    return reservedMap[name.toUpperCase()] === true;
  };
  var peg$f323 = function (name) {
    // => ident_name
    return name;
  };
  var peg$f324 = function (name) {
    // => indent_name
    return name;
  };
  var peg$f325 = function (head, tail) {
    // => ident[]
    return createList(head, tail);
  };
  var peg$f326 = function (name) {
    return reservedMap[name.toUpperCase()] === true;
  };
  var peg$f327 = function (name, c) {
    // => string
    if (!c) return name;
    return `${name}(${c[3].join(', ')})`;
  };
  var peg$f328 = function (name) {
    // => IGNORE
    return name;
  };
  var peg$f329 = function (chars) {
    /* => string */ return chars.join('');
  };
  var peg$f330 = function (chars) {
    /* => string */ return chars.join('');
  };
  var peg$f331 = function (chars) {
    /* => string */ return chars.join('');
  };
  var peg$f332 = function (name) {
    return reservedMap[name.toUpperCase()] === true;
  };
  var peg$f333 = function (name) {
    /* => string */ return name;
  };
  var peg$f334 = function (start, parts) {
    /* => string */ return start + parts.join('');
  };
  var peg$f335 = function (start, parts) {
    // => string
    return start + parts.join('');
  };
  var peg$f336 = function (l) {
    // => { type: 'param'; value: ident_name }
    return { type: 'param', value: l[1] };
  };
  var peg$f337 = function (kw, l) {
    // => { type: 'on update'; keyword: string; parentheses: boolean; expr: expr }
    return {
      type: 'on update',
      keyword: kw,
      parentheses: true,
      expr: l,
    };
  };
  var peg$f338 = function (kw) {
    // => { type: 'on update'; keyword: string; }
    return {
      type: 'on update',
      keyword: kw,
    };
  };
  var peg$f339 = function (aws) {
    // => { type: 'windows'; as_window_specification: as_window_specification }
    return {
      type: 'window',
      as_window_specification: aws,
    };
  };
  var peg$f340 = function (bc, l) {
    // => { partitionby: partition_by_clause; orderby: order_by_clause }
    return {
      partitionby: bc,
      orderby: l,
    };
  };
  var peg$f341 = function (wc) {
    // => { keyword: 'filter'; parentheses: true, where: where_clause }
    return {
      keyword: 'filter',
      parentheses: true,
      where: wc,
    };
  };
  var peg$f342 = function (e, f) {
    // => { type: 'aggr_func'; name: string; args: { expr: additive_expr } | count_arg; over: over_partition; filter?: aggr_filter; }
    if (f) e.filter = f;
    return e;
  };
  var peg$f343 = function (name, over) {
    // => { type: 'window_func'; name: string; over: over_partition }
    return {
      type: 'window_func',
      name: name,
      over: over,
    };
  };
  var peg$f344 = function (name, l, cn, over) {
    // => { type: 'window_func'; name: string; args: expr_list; consider_nulls: null | string; over: over_partition }
    return {
      type: 'window_func',
      name: name,
      args: l,
      over: over,
      consider_nulls: cn,
    };
  };
  var peg$f345 = function (name, l, cn, over) {
    // => window_fun_laglead
    return {
      type: 'window_func',
      name: name,
      args: {
        type: 'expr_list',
        value: [l],
      },
      over: over,
      consider_nulls: cn,
    };
  };
  var peg$f346 = function (v) {
    // => string
    return v.toUpperCase() + ' NULLS';
  };
  var peg$f347 = function (name, e, bc) {
    // => { type: 'aggr_func'; name: 'SUM' | 'MAX' | 'MIN' | 'AVG'; args: { expr: additive_expr }; over: over_partition }
    return {
      type: 'aggr_func',
      name: name,
      args: {
        expr: e,
      },
      over: bc,
    };
  };
  var peg$f348 = function (name, arg, bc) {
    // => { type: 'aggr_func'; name: 'COUNT' | 'GROUP_CONCAT'; args:count_arg; over: over_partition }
    return {
      type: 'aggr_func',
      name: name,
      args: arg,
      over: bc,
    };
  };
  var peg$f349 = function (name, arg, or, bc) {
    // => { type: 'aggr_func'; name: 'PERCENTILE_CONT' | 'PERCENTILE_DISC'; args: literal_numeric / literal_array; within_group_orderby: order_by_clause; over?: over_partition }
    return {
      type: 'aggr_func',
      name: name.toUpperCase(),
      args: {
        expr: arg,
      },
      within_group_orderby: or,
      over: bc,
    };
  };
  var peg$f350 = function (name, or, bc) {
    // => { type: 'aggr_func'; name: 'MODE'; args: literal_numeric / literal_array; within_group_orderby: order_by_clause; over?: over_partition }
    return {
      type: 'aggr_func',
      name: name.toUpperCase(),
      args: { expr: {} },
      within_group_orderby: or,
      over: bc,
    };
  };
  var peg$f351 = function (kw, s) {
    // => { keyword: string | null; value: literal_string; }
    return {
      keyword: kw,
      value: s,
    };
  };
  var peg$f352 = function (d, c, or, s) {
    /* => { distinct: 'DISTINCT'; expr: expr; orderby?: order_by_clause; parentheses: boolean; separator?: concat_separator; } */ return {
      distinct: d,
      expr: c,
      orderby: or,
      parentheses: true,
      separator: s,
    };
  };
  var peg$f353 = function (d, c, or, s) {
    /* => { distinct: 'DISTINCT'; expr: expr; orderby?: order_by_clause; parentheses: boolean; separator?: concat_separator; } */ return {
      distinct: d,
      expr: c,
      orderby: or,
      parentheses: false,
      separator: s,
    };
  };
  var peg$f354 = function (e) {
    /* => { expr: star_expr } */ return { expr: e };
  };
  var peg$f355 = function (pre, name, arg, o) {
    // => { type: 'aggr_func'; args:count_arg; name: 'ARRAY_AGG'; orderby?: order_by_clause  }
    return {
      type: 'aggr_func',
      name: pre ? `${pre[0]}.${name}` : name,
      args: arg,
      orderby: o,
    };
  };
  var peg$f356 = function () {
    /* => { type: 'star'; value: '*' } */ return { type: 'star', value: '*' };
  };
  var peg$f357 = function (p, rm, k) {
    // => expr_list
    let value = [];
    if (p) value.push({ type: 'origin', value: p });
    if (rm) value.push(rm);
    value.push({ type: 'origin', value: 'from' });
    return {
      type: 'expr_list',
      value,
    };
  };
  var peg$f358 = function (tr, s) {
    // => { type: 'function'; name: string; args: expr_list; }
    let args = tr || { type: 'expr_list', value: [] };
    args.value.push(s);
    return {
      type: 'function',
      name: 'TRIM',
      args,
    };
  };
  var peg$f359 = function (name, l, z) {
    // => { type: 'function'; name: string; args: expr_list; suffix: literal_string; }
    z.prefix = 'at time zone';
    return {
      type: 'function',
      name: name,
      args: l ? l : { type: 'expr_list', value: [] },
      suffix: z,
    };
  };
  var peg$f360 = function (name, l, bc) {
    // => { type: 'function'; name: string; args: expr_list; over?: over_partition; }
    return {
      type: 'function',
      name: name,
      args: l ? l : { type: 'expr_list', value: [] },
      over: bc,
    };
  };
  var peg$f361 = function (f, up) {
    // => { type: 'function'; name: string; over?: on_update_current_timestamp; }
    return {
      type: 'function',
      name: f,
      over: up,
    };
  };
  var peg$f362 = function (name, l) {
    // => { type: 'function'; name: string; args: expr_list; }
    if (l && l.type !== 'expr_list') l = { type: 'expr_list', value: [l] };
    return {
      type: 'function',
      name: name,
      args: l ? l : { type: 'expr_list', value: [] },
    };
  };
  var peg$f363 = function (f) {
    // => 'string'
    return f;
  };
  var peg$f364 = function (kw, f, t, s) {
    // => { type: 'extract'; args: { field: extract_filed; cast_type: 'TIMESTAMP' | 'INTERVAL' | 'TIME'; source: expr; }}
    return {
      type: kw.toLowerCase(),
      args: {
        field: f,
        cast_type: t,
        source: s,
      },
    };
  };
  var peg$f365 = function (kw, f, s) {
    // => { type: 'extract'; args: { field: extract_filed; source: expr; }}
    return {
      type: kw.toLowerCase(),
      args: {
        field: f,
        source: s,
      },
    };
  };
  var peg$f366 = function (s, t, a, alias) {
    /* => {
        as?: alias_clause,
        symbol: '::' | 'as',
        target: data_type;
        arrows?: ('->>' | '->')[];
        property?: (literal_string | literal_numeric)[];
      }
      */
    return {
      as: alias,
      symbol: '::',
      target: t,
      arrows: a.map((item) => item[0]),
      properties: a.map((item) => item[2]),
    };
  };
  var peg$f367 = function (c, e, t, a) {
    // => IGNORE
    return {
      type: 'cast',
      keyword: c.toLowerCase(),
      expr: e,
      symbol: 'as',
      target: t,
      arrows: a.map((item) => item[0]),
      properties: a.map((item) => item[2]),
    };
  };
  var peg$f368 = function (c, e, precision) {
    // => IGNORE
    return {
      type: 'cast',
      keyword: c.toLowerCase(),
      expr: e,
      symbol: 'as',
      target: {
        dataType: 'DECIMAL(' + precision + ')',
      },
    };
  };
  var peg$f369 = function (c, e, precision, scale) {
    // => IGNORE
    return {
      type: 'cast',
      keyword: c.toLowerCase(),
      expr: e,
      symbol: 'as',
      target: {
        dataType: 'DECIMAL(' + precision + ', ' + scale + ')',
      },
    };
  };
  var peg$f370 = function (c, e, s, t) {
    /* MySQL cast to un-/signed integer */
    // => IGNORE
    return {
      type: 'cast',
      keyword: c.toLowerCase(),
      expr: e,
      symbol: 'as',
      target: {
        dataType: s + (t ? ' ' + t : ''),
      },
    };
  };
  var peg$f371 = function (e, c) {
    /* => {
        type: 'cast';
        expr: literal | aggr_func | func_call | case_expr | interval_expr | column_ref | param
          | expr;
        keyword: 'cast';
        ...cast_double_colon;
      }
      */
    e.parentheses = true;
    if (!c) return e;
    return {
      type: 'cast',
      keyword: 'cast',
      expr: e,
      ...c,
    };
  };
  var peg$f372 = function (e, c) {
    /* => {
        type: 'cast';
        expr: literal | aggr_func | func_call | case_expr | interval_expr | column_ref | param
          | expr;
        keyword: 'cast';
        ...cast_double_colon;
      }
      */
    if (!c) return e;
    return {
      type: 'cast',
      keyword: 'cast',
      expr: e,
      ...c,
    };
  };
  var peg$f373 = function (s, c) {
    /*
      => {
        expr_list: expr_list | {type: 'origin', value: ident },
        type: string,
        keyword: string,
        brackets: boolean
      }
    */
    return {
      expr_list: c || { type: 'origin', value: '' },
      type: 'array',
      keyword: 'array',
      brackets: true,
    };
  };
  var peg$f374 = function (head, tail) {
    // => literal[]
    return createList(head, tail);
  };
  var peg$f375 = function () {
    // => { type: 'null'; value: null }
    return { type: 'null', value: null };
  };
  var peg$f376 = function () {
    // => { type: 'not null'; value: 'not null' }
    return {
      type: 'not null',
      value: 'not null',
    };
  };
  var peg$f377 = function () {
    // => { type: 'bool', value: true }
    return { type: 'bool', value: true };
  };
  var peg$f378 = function () {
    //=> { type: 'bool', value: false }
    return { type: 'bool', value: false };
  };
  var peg$f379 = function (ca, fs) {
    // => { type: 'single_quote_string'; value: string; }
    return {
      type: 'single_quote_string',
      value: `${ca[1].join('')}${fs[1].join('')}`,
    };
  };
  var peg$f380 = function (ca) {
    // => { type: 'single_quote_string'; value: string; }
    return {
      type: 'single_quote_string',
      value: ca[1].join(''),
    };
  };
  var peg$f381 = function (ca) {
    // => { type: 'string'; value: string; }
    return {
      type: 'double_quote_string',
      value: ca[1].join(''),
    };
  };
  var peg$f382 = function (type, ca) {
    // => { type: 'TIME' | 'DATE' | 'TIMESTAMP' | 'DATETIME', value: string }
    return {
      type: type.toLowerCase(),
      value: ca[1].join(''),
    };
  };
  var peg$f383 = function (type, ca) {
    // => { type: 'TIME' | 'DATE' | 'TIMESTAMP' | 'DATETIME', value: string }
    return {
      type: type.toLowerCase(),
      value: ca[1].join(''),
    };
  };
  var peg$f384 = function () {
    return "\\'";
  };
  var peg$f385 = function () {
    return '\\"';
  };
  var peg$f386 = function () {
    return '\\\\';
  };
  var peg$f387 = function () {
    return '\\/';
  };
  var peg$f388 = function () {
    return '\b';
  };
  var peg$f389 = function () {
    return '\f';
  };
  var peg$f390 = function () {
    return '\n';
  };
  var peg$f391 = function () {
    return '\r';
  };
  var peg$f392 = function () {
    return '\t';
  };
  var peg$f393 = function (h1, h2, h3, h4) {
    return String.fromCharCode(parseInt('0x' + h1 + h2 + h3 + h4));
  };
  var peg$f394 = function () {
    return '\\';
  };
  var peg$f395 = function () {
    return "''";
  };
  var peg$f396 = function (n) {
    // => number | { type: 'bigint'; value: string; }
    if (n && n.type === 'bigint') return n;
    return { type: 'number', value: n };
  };
  var peg$f397 = function (int_, frac, exp) {
    const numStr = (int_ || '') + frac + exp;
    return {
      type: 'bigint',
      value: numStr,
    };
  };
  var peg$f398 = function (int_, frac) {
    // => IGNORE
    const numStr = (int_ || '') + frac;
    if (int_ && isBigInt(int_))
      return {
        type: 'bigint',
        value: numStr,
      };
    return parseFloat(numStr);
  };
  var peg$f399 = function (int_, exp) {
    // => IGNORE
    const numStr = int_ + exp;
    return {
      type: 'bigint',
      value: numStr,
    };
  };
  var peg$f400 = function (int_) {
    // => IGNORE
    if (isBigInt(int_))
      return {
        type: 'bigint',
        value: int_,
      };
    return parseFloat(int_);
  };
  var peg$f401 = function (op, digits) {
    return op + digits;
  };
  var peg$f402 = function (op, digit) {
    return op + digit;
  };
  var peg$f403 = function (digits) {
    return '.' + digits;
  };
  var peg$f404 = function (e, digits) {
    return e + digits;
  };
  var peg$f405 = function (digits) {
    return digits.join('');
  };
  var peg$f406 = function (e, sign) {
    return e + (sign !== null ? sign : '');
  };
  var peg$f407 = function () {
    return 'DROP';
  };
  var peg$f408 = function () {
    return 'TEMPORARY';
  };
  var peg$f409 = function () {
    return 'TEMP';
  };
  var peg$f410 = function () {
    return 'RECURSIVE';
  };
  var peg$f411 = function () {
    return 'RETURNING';
  };
  var peg$f412 = function () {
    return 'PARTITION';
  };
  var peg$f413 = function () {
    return 'SET';
  };
  var peg$f414 = function () {
    return 'TABLE';
  };
  var peg$f415 = function () {
    return 'DATABASE';
  };
  var peg$f416 = function () {
    return 'SCHEMA';
  };
  var peg$f417 = function () {
    return 'SEQUENCE';
  };
  var peg$f418 = function () {
    return 'TABLESPACE';
  };
  var peg$f419 = function () {
    return 'COLLATE';
  };
  var peg$f420 = function () {
    return 'DEALLOCATE';
  };
  var peg$f421 = function () {
    return 'OFFSET';
  };
  var peg$f422 = function () {
    return 'ASC';
  };
  var peg$f423 = function () {
    return 'DESC';
  };
  var peg$f424 = function () {
    return 'ALL';
  };
  var peg$f425 = function () {
    return 'DISTINCT';
  };
  var peg$f426 = function () {
    return 'BETWEEN';
  };
  var peg$f427 = function () {
    return 'IN';
  };
  var peg$f428 = function () {
    return 'IS';
  };
  var peg$f429 = function () {
    return 'LIKE';
  };
  var peg$f430 = function () {
    return 'ILIKE';
  };
  var peg$f431 = function () {
    /* => 'EXISTS' */ return 'EXISTS';
  };
  var peg$f432 = function () {
    return 'NOT';
  };
  var peg$f433 = function () {
    return 'AND';
  };
  var peg$f434 = function () {
    return 'OR';
  };
  var peg$f435 = function () {
    return 'ARRAY';
  };
  var peg$f436 = function () {
    return 'ARRAY_AGG';
  };
  var peg$f437 = function () {
    return 'COUNT';
  };
  var peg$f438 = function () {
    return 'GROUP_CONCAT';
  };
  var peg$f439 = function () {
    return 'MAX';
  };
  var peg$f440 = function () {
    return 'MIN';
  };
  var peg$f441 = function () {
    return 'SUM';
  };
  var peg$f442 = function () {
    return 'AVG';
  };
  var peg$f443 = function () {
    return 'EXTRACT';
  };
  var peg$f444 = function () {
    return 'CALL';
  };
  var peg$f445 = function () {
    return 'CAST';
  };
  var peg$f446 = function () {
    return 'BOOL';
  };
  var peg$f447 = function () {
    return 'BOOLEAN';
  };
  var peg$f448 = function () {
    return 'CHAR';
  };
  var peg$f449 = function () {
    return 'CHARACTER';
  };
  var peg$f450 = function () {
    return 'VARCHAR';
  };
  var peg$f451 = function () {
    return 'NUMERIC';
  };
  var peg$f452 = function () {
    return 'DECIMAL';
  };
  var peg$f453 = function () {
    return 'SIGNED';
  };
  var peg$f454 = function () {
    return 'UNSIGNED';
  };
  var peg$f455 = function () {
    return 'INT';
  };
  var peg$f456 = function () {
    return 'ZEROFILL';
  };
  var peg$f457 = function () {
    return 'INTEGER';
  };
  var peg$f458 = function () {
    return 'JSON';
  };
  var peg$f459 = function () {
    return 'JSONB';
  };
  var peg$f460 = function () {
    return 'GEOMETRY';
  };
  var peg$f461 = function () {
    return 'SMALLINT';
  };
  var peg$f462 = function () {
    return 'SERIAL';
  };
  var peg$f463 = function () {
    return 'TINYINT';
  };
  var peg$f464 = function () {
    return 'TINYTEXT';
  };
  var peg$f465 = function () {
    return 'TEXT';
  };
  var peg$f466 = function () {
    return 'MEDIUMTEXT';
  };
  var peg$f467 = function () {
    return 'LONGTEXT';
  };
  var peg$f468 = function () {
    return 'BIGINT';
  };
  var peg$f469 = function () {
    return 'ENUM';
  };
  var peg$f470 = function () {
    return 'FLOAT';
  };
  var peg$f471 = function () {
    return 'DOUBLE PRECISION';
  };
  var peg$f472 = function () {
    return 'BIGSERIAL';
  };
  var peg$f473 = function () {
    return 'REAL';
  };
  var peg$f474 = function () {
    return 'DATE';
  };
  var peg$f475 = function () {
    return 'DATETIME';
  };
  var peg$f476 = function () {
    return 'ROWS';
  };
  var peg$f477 = function () {
    return 'TIME';
  };
  var peg$f478 = function () {
    return 'TIMESTAMP';
  };
  var peg$f479 = function () {
    return 'TRUNCATE';
  };
  var peg$f480 = function () {
    return 'USER';
  };
  var peg$f481 = function () {
    return 'UUID';
  };
  var peg$f482 = function () {
    return 'OID';
  };
  var peg$f483 = function () {
    return 'REGCLASS';
  };
  var peg$f484 = function () {
    return 'REGCOLLATION';
  };
  var peg$f485 = function () {
    return 'REGCONFIG';
  };
  var peg$f486 = function () {
    return 'REGDICTIONARY';
  };
  var peg$f487 = function () {
    return 'REGNAMESPACE';
  };
  var peg$f488 = function () {
    return 'REGOPER';
  };
  var peg$f489 = function () {
    return 'REGOPERATOR';
  };
  var peg$f490 = function () {
    return 'REGPROC';
  };
  var peg$f491 = function () {
    return 'REGPROCEDURE';
  };
  var peg$f492 = function () {
    return 'REGROLE';
  };
  var peg$f493 = function () {
    return 'REGTYPE';
  };
  var peg$f494 = function () {
    return 'CURRENT_DATE';
  };
  var peg$f495 = function () {
    return 'ADDDATE';
  };
  var peg$f496 = function () {
    return 'INTERVAL';
  };
  var peg$f497 = function () {
    return 'YEAR';
  };
  var peg$f498 = function () {
    return 'MONTH';
  };
  var peg$f499 = function () {
    return 'DAY';
  };
  var peg$f500 = function () {
    return 'HOUR';
  };
  var peg$f501 = function () {
    return 'MINUTE';
  };
  var peg$f502 = function () {
    return 'SECOND';
  };
  var peg$f503 = function () {
    return 'CURRENT_TIME';
  };
  var peg$f504 = function () {
    return 'CURRENT_TIMESTAMP';
  };
  var peg$f505 = function () {
    return 'CURRENT_USER';
  };
  var peg$f506 = function () {
    return 'CURRENT_ROLE';
  };
  var peg$f507 = function () {
    return 'SESSION_USER';
  };
  var peg$f508 = function () {
    return 'SYSTEM_USER';
  };
  var peg$f509 = function () {
    return 'GLOBAL';
  };
  var peg$f510 = function () {
    return 'SESSION';
  };
  var peg$f511 = function () {
    return 'LOCAL';
  };
  var peg$f512 = function () {
    return 'PERSIST';
  };
  var peg$f513 = function () {
    return 'PERSIST_ONLY';
  };
  var peg$f514 = function () {
    return 'VIEW';
  };
  var peg$f515 = function () {
    return 'ADD';
  };
  var peg$f516 = function () {
    return 'COLUMN';
  };
  var peg$f517 = function () {
    return 'INDEX';
  };
  var peg$f518 = function () {
    return 'KEY';
  };
  var peg$f519 = function () {
    return 'FULLTEXT';
  };
  var peg$f520 = function () {
    return 'SPATIAL';
  };
  var peg$f521 = function () {
    return 'UNIQUE';
  };
  var peg$f522 = function () {
    return 'KEY_BLOCK_SIZE';
  };
  var peg$f523 = function () {
    return 'COMMENT';
  };
  var peg$f524 = function () {
    return 'CONSTRAINT';
  };
  var peg$f525 = function () {
    return 'CONCURRENTLY';
  };
  var peg$f526 = function () {
    return 'REFERENCES';
  };
  var peg$f527 = function (k, s, c) {
    // => { type: 'comment'; keyword: 'comment'; symbol: '='; value: literal_string; }
    return {
      type: k.toLowerCase(),
      keyword: k.toLowerCase(),
      symbol: s,
      value: c,
    };
  };
  var peg$f528 = function () {
    varList = [];
    return true;
  };
  var peg$f529 = function (s) {
    /* export interface proc_stmt { type: 'proc'; stmt: assign_stmt | return_stmt; vars: any }
     => AstStatement<proc_stmt>
     */
    return { type: 'proc', stmt: s, vars: varList };
  };
  var peg$f530 = function (va, s, e) {
    // => { type: 'assign'; left: var_decl | without_prefix_var_decl; symbol: ':=' | '='; right: proc_expr; }
    return {
      type: 'assign',
      left: va,
      symbol: s,
      right: e,
    };
  };
  var peg$f531 = function (e) {
    // => { type: 'return'; expr: proc_expr; }
    return { type: 'return', expr: e };
  };
  var peg$f532 = function (head, tail) {
    // => binary_expr
    return createBinaryExprChain(head, tail);
  };
  var peg$f533 = function (head, tail) {
    // => binary_expr
    return createBinaryExprChain(head, tail);
  };
  var peg$f534 = function (lt, op, rt, expr) {
    // => { type: 'join'; ltable: var_decl; rtable: var_decl; op: join_op; expr: on_clause; }
    return {
      type: 'join',
      ltable: lt,
      rtable: rt,
      op: op,
      on: expr,
    };
  };
  var peg$f535 = function (e) {
    // => proc_additive_expr & { parentheses: true; }
    e.parentheses = true;
    return e;
  };
  var peg$f536 = function (n, s) {
    // => { type: 'var'; prefix: null; name: number; members: []; quoted: null } | column_ref
    if (!s)
      return {
        type: 'var',
        name: n,
        prefix: null,
      };
    return {
      type: 'column_ref',
      table: n,
      column: s[2],
    };
  };
  var peg$f537 = function (dt, tail) {
    // => string
    let name = dt;
    if (tail !== null) {
      name = `${dt}.${tail[3]}`;
    }
    return name;
  };
  var peg$f538 = function (name, l) {
    // => { type: 'function'; name: string; args: null | { type: expr_list; value: proc_primary_list; }}
    //compatible with original func_call
    return {
      type: 'function',
      name: name,
      args: {
        type: 'expr_list',
        value: l,
      },
    };
  };
  var peg$f539 = function (head, tail) {
    // => proc_primary[]
    return createList(head, tail);
  };
  var peg$f540 = function (l) {
    // => { type: 'array'; value: proc_primary_list }
    return { type: 'array', value: l };
  };
  var peg$f541 = function (head, tail) {
    // => var_decl[]
    return createList(head, tail);
  };
  var peg$f542 = function (p, d, s) {
    // => { type: 'var'; name: string; prefix: string; suffix: string; };
    return {
      type: 'var',
      name: d.join(''),
      prefix: '$$',
      suffix: '$$',
    };
  };
  var peg$f543 = function (f, d, s) {
    if (f !== s) return true;
  };
  var peg$f544 = function (f, d, s) {
    // => { type: 'var'; name: string; prefix: string; suffix: string; };
    return {
      type: 'var',
      name: d.join(''),
      prefix: `$${f}$`,
      suffix: `$${s}$`,
    };
  };
  var peg$f545 = function (p, d) {
    // => without_prefix_var_decl & { type: 'var'; prefix: string; };
    // push for analysis
    return {
      type: 'var',
      ...d,
      prefix: p,
    };
  };
  var peg$f546 = function (p, name, m, s) {
    // => { type: 'var'; prefix: string; name: ident_name; members: mem_chain; quoted: string | null }
    //push for analysis
    if ((p && !s) || (!p && s)) throw new Error('double quoted not match');
    varList.push(name);
    return {
      type: 'var',
      name: name,
      members: m,
      quoted: p && s ? '"' : null,
      prefix: null,
    };
  };
  var peg$f547 = function (n) {
    // => { type: 'var'; prefix: null; name: number; members: []; quoted: null }
    return {
      type: 'var',
      name: n.value,
      members: [],
      quoted: null,
      prefix: null,
    };
  };
  var peg$f548 = function (l) {
    // => ident_name[];
    const s = [];
    for (let i = 0; i < l.length; i++) {
      s.push(l[i][1]);
    }
    return s;
  };
  var peg$f549 = function (t) {
    /* => data_type */
    return { ...t, array: 'two' };
  };
  var peg$f550 = function (t) {
    /* => data_type */
    return { ...t, array: 'one' };
  };
  var peg$f551 = function (t) {
    /* => data_type */ return { dataType: t };
  };
  var peg$f552 = function () {
    /* => data_type */ return { dataType: 'BYTEA' };
  };
  var peg$f553 = function () {
    // => string
    return 'CHARACTER VARYING';
  };
  var peg$f554 = function (t, l) {
    // => data_type
    return { dataType: t, length: parseInt(l.join(''), 10), parentheses: true };
  };
  var peg$f555 = function (t) {
    /* =>  data_type */ return { dataType: t };
  };
  var peg$f556 = function (un, ze) {
    // => any[];
    const result = [];
    if (un) result.push(un);
    if (ze) result.push(ze);
    return result;
  };
  var peg$f557 = function (t, l, r, s) {
    /* =>  data_type */ return {
      dataType: t,
      length: parseInt(l.join(''), 10),
      scale: r && parseInt(r[2].join(''), 10),
      parentheses: true,
      suffix: s,
    };
  };
  var peg$f558 = function (t, l, s) {
    /* =>  data_type */ return { dataType: t, length: parseInt(l.join(''), 10), suffix: s };
  };
  var peg$f559 = function (t, s) {
    /* =>  data_type */ return { dataType: t, suffix: s };
  };
  var peg$f560 = function (t) {
    /* => data_type */ return { dataType: t };
  };
  var peg$f561 = function (w) {
    // => string[];
    return [w.toUpperCase(), 'TIME', 'ZONE'];
  };
  var peg$f562 = function (t, l, tz) {
    /* =>  data_type */ return { dataType: t, length: parseInt(l.join(''), 10), parentheses: true, suffix: tz };
  };
  var peg$f563 = function (t, tz) {
    /* =>  data_type */ return { dataType: t, suffix: tz };
  };
  var peg$f564 = function (t, l) {
    /* =>  data_type */ return { dataType: t, length: parseInt(l.join(''), 10), parentheses: true };
  };
  var peg$f565 = function (t) {
    /* =>  data_type */ return { dataType: t };
  };
  var peg$f566 = function (t, e) {
    /* =>  data_type */
    e.parentheses = true;
    return {
      dataType: t,
      expr: e,
    };
  };
  var peg$f567 = function (t) {
    /* =>  data_type */ return { dataType: t };
  };
  var peg$f568 = function (t) {
    /* =>  data_type */ return { dataType: t };
  };
  var peg$f569 = function (t) {
    /* =>  data_type */ return { dataType: t };
  };
  var peg$f570 = function (t) {
    /* =>  data_type */ return { dataType: `${t}[]` };
  };
  var peg$f571 = function (t) {
    /* =>  data_type */ return { dataType: t };
  };
  var peg$f572 = function (t) {
    /* =>  data_type */ return { dataType: t };
  };
  var peg$f573 = function () {
    /* =>  data_type */ return { dataType: 'RECORD' };
  };
  var peg$currPos = 0;
  var peg$savedPos = 0;
  var peg$posDetailsCache = [{ line: 1, column: 1 }];
  var peg$maxFailPos = 0;
  var peg$maxFailExpected = [];
  var peg$silentFails = 0;

  var peg$result;

  if ('startRule' in options) {
    if (!(options.startRule in peg$startRuleFunctions)) {
      throw new Error('Can\'t start parsing from rule "' + options.startRule + '".');
    }

    peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
  }

  function text() {
    return input.substring(peg$savedPos, peg$currPos);
  }

  function offset() {
    return peg$savedPos;
  }

  function range() {
    return {
      source: peg$source,
      start: peg$savedPos,
      end: peg$currPos,
    };
  }

  function location() {
    return peg$computeLocation(peg$savedPos, peg$currPos);
  }

  function expected(description, location) {
    location = location !== undefined ? location : peg$computeLocation(peg$savedPos, peg$currPos);

    throw peg$buildStructuredError(
      [peg$otherExpectation(description)],
      input.substring(peg$savedPos, peg$currPos),
      location,
    );
  }

  function error(message, location) {
    location = location !== undefined ? location : peg$computeLocation(peg$savedPos, peg$currPos);

    throw peg$buildSimpleError(message, location);
  }

  function peg$literalExpectation(text, ignoreCase) {
    return { type: 'literal', text: text, ignoreCase: ignoreCase };
  }

  function peg$classExpectation(parts, inverted, ignoreCase) {
    return { type: 'class', parts: parts, inverted: inverted, ignoreCase: ignoreCase };
  }

  function peg$anyExpectation() {
    return { type: 'any' };
  }

  function peg$endExpectation() {
    return { type: 'end' };
  }

  function peg$otherExpectation(description) {
    return { type: 'other', description: description };
  }

  function peg$computePosDetails(pos) {
    var details = peg$posDetailsCache[pos];
    var p;

    if (details) {
      return details;
    } else {
      p = pos - 1;
      while (!peg$posDetailsCache[p]) {
        p--;
      }

      details = peg$posDetailsCache[p];
      details = {
        line: details.line,
        column: details.column,
      };

      while (p < pos) {
        if (input.charCodeAt(p) === 10) {
          details.line++;
          details.column = 1;
        } else {
          details.column++;
        }

        p++;
      }

      peg$posDetailsCache[pos] = details;

      return details;
    }
  }

  function peg$computeLocation(startPos, endPos, offset) {
    var startPosDetails = peg$computePosDetails(startPos);
    var endPosDetails = peg$computePosDetails(endPos);

    var res = {
      source: peg$source,
      start: {
        offset: startPos,
        line: startPosDetails.line,
        column: startPosDetails.column,
      },
      end: {
        offset: endPos,
        line: endPosDetails.line,
        column: endPosDetails.column,
      },
    };
    if (offset && peg$source && typeof peg$source.offset === 'function') {
      res.start = peg$source.offset(res.start);
      res.end = peg$source.offset(res.end);
    }
    return res;
  }

  function peg$fail(expected) {
    if (peg$currPos < peg$maxFailPos) {
      return;
    }

    if (peg$currPos > peg$maxFailPos) {
      peg$maxFailPos = peg$currPos;
      peg$maxFailExpected = [];
    }

    peg$maxFailExpected.push(expected);
  }

  function peg$buildSimpleError(message, location) {
    return new peg$SyntaxError(message, null, null, location);
  }

  function peg$buildStructuredError(expected, found, location) {
    return new peg$SyntaxError(peg$SyntaxError.buildMessage(expected, found), expected, found, location);
  }

  function peg$parsestart() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = peg$parse__();
    s2 = peg$parsecreate_function_stmt();
    if (s2 === peg$FAILED) {
      s2 = peg$parsemultiple_stmt();
    }
    if (s2 !== peg$FAILED) {
      peg$savedPos = s0;
      s0 = peg$f0(s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecmd_stmt() {
    var s0;

    s0 = peg$parsedrop_stmt();
    if (s0 === peg$FAILED) {
      s0 = peg$parsecreate_stmt();
      if (s0 === peg$FAILED) {
        s0 = peg$parsedeclare_stmt();
        if (s0 === peg$FAILED) {
          s0 = peg$parsetruncate_stmt();
          if (s0 === peg$FAILED) {
            s0 = peg$parserename_stmt();
            if (s0 === peg$FAILED) {
              s0 = peg$parsecall_stmt();
              if (s0 === peg$FAILED) {
                s0 = peg$parseuse_stmt();
                if (s0 === peg$FAILED) {
                  s0 = peg$parsealter_stmt();
                  if (s0 === peg$FAILED) {
                    s0 = peg$parseset_stmt();
                    if (s0 === peg$FAILED) {
                      s0 = peg$parselock_stmt();
                      if (s0 === peg$FAILED) {
                        s0 = peg$parseshow_stmt();
                        if (s0 === peg$FAILED) {
                          s0 = peg$parsedeallocate_stmt();
                          if (s0 === peg$FAILED) {
                            s0 = peg$parsegrant_revoke_stmt();
                            if (s0 === peg$FAILED) {
                              s0 = peg$parseif_else_stmt();
                              if (s0 === peg$FAILED) {
                                s0 = peg$parseraise_stmt();
                                if (s0 === peg$FAILED) {
                                  s0 = peg$parseexecute_stmt();
                                  if (s0 === peg$FAILED) {
                                    s0 = peg$parsefor_loop_stmt();
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsecreate_stmt() {
    var s0;

    s0 = peg$parsecreate_table_stmt();
    if (s0 === peg$FAILED) {
      s0 = peg$parsecreate_constraint_trigger();
      if (s0 === peg$FAILED) {
        s0 = peg$parsecreate_extension_stmt();
        if (s0 === peg$FAILED) {
          s0 = peg$parsecreate_index_stmt();
          if (s0 === peg$FAILED) {
            s0 = peg$parsecreate_sequence();
            if (s0 === peg$FAILED) {
              s0 = peg$parsecreate_db_stmt();
              if (s0 === peg$FAILED) {
                s0 = peg$parsecreate_domain_stmt();
                if (s0 === peg$FAILED) {
                  s0 = peg$parsecreate_type_stmt();
                  if (s0 === peg$FAILED) {
                    s0 = peg$parsecreate_view_stmt();
                    if (s0 === peg$FAILED) {
                      s0 = peg$parsecreate_aggregate_stmt();
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsealter_stmt() {
    var s0;

    s0 = peg$parsealter_table_stmt();
    if (s0 === peg$FAILED) {
      s0 = peg$parsealter_schema_stmt();
      if (s0 === peg$FAILED) {
        s0 = peg$parsealter_domain_type_stmt();
        if (s0 === peg$FAILED) {
          s0 = peg$parsealter_function_stmt();
          if (s0 === peg$FAILED) {
            s0 = peg$parsealter_aggregate_stmt();
          }
        }
      }
    }

    return s0;
  }

  function peg$parsecrud_stmt() {
    var s0;

    s0 = peg$parseunion_stmt();
    if (s0 === peg$FAILED) {
      s0 = peg$parseupdate_stmt();
      if (s0 === peg$FAILED) {
        s0 = peg$parsereplace_insert_stmt();
        if (s0 === peg$FAILED) {
          s0 = peg$parseinsert_no_columns_stmt();
          if (s0 === peg$FAILED) {
            s0 = peg$parsedelete_stmt();
            if (s0 === peg$FAILED) {
              s0 = peg$parsecmd_stmt();
              if (s0 === peg$FAILED) {
                s0 = peg$parseproc_stmts();
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsemultiple_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsecrud_stmt();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseSEMICOLON();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsecrud_stmt();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseSEMICOLON();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsecrud_stmt();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f1(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseset_op() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_UNION();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_ALL();
      if (s3 === peg$FAILED) {
        s3 = peg$parseKW_DISTINCT();
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f2(s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseunion_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseselect_stmt();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseset_op();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseselect_stmt();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseset_op();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseselect_stmt();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      s3 = peg$parse__();
      s4 = peg$parseorder_by_clause();
      if (s4 === peg$FAILED) {
        s4 = null;
      }
      s5 = peg$parse__();
      s6 = peg$parselimit_clause();
      peg$savedPos = s0;
      s0 = peg$f3(s1, s2, s4, s6);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseif_not_exists_stmt() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c0) {
      s1 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e0);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_NOT();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseKW_EXISTS();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f4();
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_extension_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18;

    s0 = peg$currPos;
    s1 = peg$parseKW_CREATE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 9).toLowerCase() === peg$c1) {
        s3 = input.substr(peg$currPos, 9);
        peg$currPos += 9;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e1);
        }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseif_not_exists_stmt();
        if (s5 === peg$FAILED) {
          s5 = null;
        }
        s6 = peg$parse__();
        s7 = peg$parseident_name();
        if (s7 === peg$FAILED) {
          s7 = peg$parseliteral_string();
        }
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s9 = peg$parseKW_WITH();
          if (s9 === peg$FAILED) {
            s9 = null;
          }
          s10 = peg$parse__();
          s11 = peg$currPos;
          if (input.substr(peg$currPos, 6).toLowerCase() === peg$c2) {
            s12 = input.substr(peg$currPos, 6);
            peg$currPos += 6;
          } else {
            s12 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e2);
            }
          }
          if (s12 !== peg$FAILED) {
            s13 = peg$parse__();
            s14 = peg$parseident_name();
            if (s14 !== peg$FAILED) {
              s12 = [s12, s13, s14];
              s11 = s12;
            } else {
              peg$currPos = s11;
              s11 = peg$FAILED;
            }
          } else {
            peg$currPos = s11;
            s11 = peg$FAILED;
          }
          if (s11 === peg$FAILED) {
            s11 = peg$parseliteral_string();
          }
          if (s11 === peg$FAILED) {
            s11 = null;
          }
          s12 = peg$parse__();
          s13 = peg$currPos;
          if (input.substr(peg$currPos, 7).toLowerCase() === peg$c3) {
            s14 = input.substr(peg$currPos, 7);
            peg$currPos += 7;
          } else {
            s14 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e3);
            }
          }
          if (s14 !== peg$FAILED) {
            s15 = peg$parse__();
            s16 = peg$parseident_name();
            if (s16 === peg$FAILED) {
              s16 = peg$parseliteral_string();
            }
            if (s16 !== peg$FAILED) {
              s14 = [s14, s15, s16];
              s13 = s14;
            } else {
              peg$currPos = s13;
              s13 = peg$FAILED;
            }
          } else {
            peg$currPos = s13;
            s13 = peg$FAILED;
          }
          if (s13 === peg$FAILED) {
            s13 = null;
          }
          s14 = peg$parse__();
          s15 = peg$currPos;
          s16 = peg$parseKW_FROM();
          if (s16 !== peg$FAILED) {
            s17 = peg$parse__();
            s18 = peg$parseident_name();
            if (s18 === peg$FAILED) {
              s18 = peg$parseliteral_string();
            }
            if (s18 !== peg$FAILED) {
              s16 = [s16, s17, s18];
              s15 = s16;
            } else {
              peg$currPos = s15;
              s15 = peg$FAILED;
            }
          } else {
            peg$currPos = s15;
            s15 = peg$FAILED;
          }
          if (s15 === peg$FAILED) {
            s15 = null;
          }
          peg$savedPos = s0;
          s0 = peg$f5(s1, s3, s5, s7, s9, s11, s13, s15);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_db_definition() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsecreate_option_character_set();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parsecreate_option_character_set();
      if (s5 !== peg$FAILED) {
        s4 = [s4, s5];
        s3 = s4;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parsecreate_option_character_set();
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f6(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_db_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parseKW_CREATE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_DATABASE();
      if (s3 === peg$FAILED) {
        s3 = peg$parseKW_SCHEMA();
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseif_not_exists_stmt();
        if (s5 === peg$FAILED) {
          s5 = null;
        }
        s6 = peg$parse__();
        s7 = peg$parseident_name();
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s9 = peg$parsecreate_db_definition();
          if (s9 === peg$FAILED) {
            s9 = null;
          }
          peg$savedPos = s0;
          s0 = peg$f7(s1, s3, s5, s7, s9);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseview_with() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseKW_WITH();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 8).toLowerCase() === peg$c4) {
        s3 = input.substr(peg$currPos, 8);
        peg$currPos += 8;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e4);
        }
      }
      if (s3 === peg$FAILED) {
        if (input.substr(peg$currPos, 5).toLowerCase() === peg$c5) {
          s3 = input.substr(peg$currPos, 5);
          peg$currPos += 5;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e5);
          }
        }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        if (input.substr(peg$currPos, 5).toLowerCase() === peg$c6) {
          s5 = input.substr(peg$currPos, 5);
          peg$currPos += 5;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e6);
          }
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          if (input.substr(peg$currPos, 6) === peg$c7) {
            s7 = peg$c7;
            peg$currPos += 6;
          } else {
            s7 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e7);
            }
          }
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f8(s3);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_WITH();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        if (input.substr(peg$currPos, 5).toLowerCase() === peg$c6) {
          s3 = input.substr(peg$currPos, 5);
          peg$currPos += 5;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e6);
          }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          if (input.substr(peg$currPos, 6) === peg$c7) {
            s5 = peg$c7;
            peg$currPos += 6;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e7);
            }
          }
          if (s5 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f9();
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsewith_view_option() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 12).toLowerCase() === peg$c8) {
      s1 = input.substr(peg$currPos, 12);
      peg$currPos += 12;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e8);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_ASSIGIN_EQUAL();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        if (input.substr(peg$currPos, 8).toLowerCase() === peg$c4) {
          s5 = input.substr(peg$currPos, 8);
          peg$currPos += 8;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e4);
          }
        }
        if (s5 === peg$FAILED) {
          if (input.substr(peg$currPos, 5).toLowerCase() === peg$c5) {
            s5 = input.substr(peg$currPos, 5);
            peg$currPos += 5;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e5);
            }
          }
        }
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f10(s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 16).toLowerCase() === peg$c9) {
        s1 = input.substr(peg$currPos, 16);
        peg$currPos += 16;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e9);
        }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 16).toLowerCase() === peg$c10) {
          s1 = input.substr(peg$currPos, 16);
          peg$currPos += 16;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e10);
          }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseKW_ASSIGIN_EQUAL();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parseliteral_bool();
          if (s5 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f11(s1, s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsewith_view_options() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsewith_view_option();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsewith_view_option();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsewith_view_option();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f12(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_view_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20, s21, s22;

    s0 = peg$currPos;
    s1 = peg$parseKW_CREATE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$currPos;
      s4 = peg$parseKW_OR();
      if (s4 !== peg$FAILED) {
        s5 = peg$parse__();
        s6 = peg$parseKW_REPLACE();
        if (s6 !== peg$FAILED) {
          s4 = [s4, s5, s6];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseKW_TEMP();
      if (s5 === peg$FAILED) {
        s5 = peg$parseKW_TEMPORARY();
      }
      if (s5 === peg$FAILED) {
        s5 = null;
      }
      s6 = peg$parse__();
      s7 = peg$parseKW_RECURSIVE();
      if (s7 === peg$FAILED) {
        s7 = null;
      }
      s8 = peg$parse__();
      s9 = peg$parseKW_VIEW();
      if (s9 !== peg$FAILED) {
        s10 = peg$parse__();
        s11 = peg$parsetable_name();
        if (s11 !== peg$FAILED) {
          s12 = peg$parse__();
          s13 = peg$currPos;
          s14 = peg$parseLPAREN();
          if (s14 !== peg$FAILED) {
            s15 = peg$parse__();
            s16 = peg$parsecolumn_list();
            if (s16 !== peg$FAILED) {
              s17 = peg$parse__();
              s18 = peg$parseRPAREN();
              if (s18 !== peg$FAILED) {
                s14 = [s14, s15, s16, s17, s18];
                s13 = s14;
              } else {
                peg$currPos = s13;
                s13 = peg$FAILED;
              }
            } else {
              peg$currPos = s13;
              s13 = peg$FAILED;
            }
          } else {
            peg$currPos = s13;
            s13 = peg$FAILED;
          }
          if (s13 === peg$FAILED) {
            s13 = null;
          }
          s14 = peg$parse__();
          s15 = peg$currPos;
          s16 = peg$parseKW_WITH();
          if (s16 !== peg$FAILED) {
            s17 = peg$parse__();
            s18 = peg$parseLPAREN();
            if (s18 !== peg$FAILED) {
              s19 = peg$parse__();
              s20 = peg$parsewith_view_options();
              if (s20 !== peg$FAILED) {
                s21 = peg$parse__();
                s22 = peg$parseRPAREN();
                if (s22 !== peg$FAILED) {
                  s16 = [s16, s17, s18, s19, s20, s21, s22];
                  s15 = s16;
                } else {
                  peg$currPos = s15;
                  s15 = peg$FAILED;
                }
              } else {
                peg$currPos = s15;
                s15 = peg$FAILED;
              }
            } else {
              peg$currPos = s15;
              s15 = peg$FAILED;
            }
          } else {
            peg$currPos = s15;
            s15 = peg$FAILED;
          }
          if (s15 === peg$FAILED) {
            s15 = null;
          }
          s16 = peg$parse__();
          s17 = peg$parseKW_AS();
          if (s17 !== peg$FAILED) {
            s18 = peg$parse__();
            s19 = peg$parseselect_stmt_nake();
            if (s19 !== peg$FAILED) {
              s20 = peg$parse__();
              s21 = peg$parseview_with();
              if (s21 === peg$FAILED) {
                s21 = null;
              }
              peg$savedPos = s0;
              s0 = peg$f13(s1, s3, s5, s7, s11, s13, s15, s19, s21);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_aggregate_opt_required() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c11) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e11);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_ASSIGIN_EQUAL();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsetable_name();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseCOMMA();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            if (input.substr(peg$currPos, 5).toLowerCase() === peg$c12) {
              s9 = input.substr(peg$currPos, 5);
              peg$currPos += 5;
            } else {
              s9 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e12);
              }
            }
            if (s9 !== peg$FAILED) {
              s10 = peg$parse__();
              s11 = peg$parseKW_ASSIGIN_EQUAL();
              if (s11 !== peg$FAILED) {
                s12 = peg$parse__();
                s13 = peg$parsedata_type();
                if (s13 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s0 = peg$f14(s5, s13);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_aggregate_opt_optional() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseident();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_ASSIGIN_EQUAL();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseident();
        if (s5 === peg$FAILED) {
          s5 = peg$parseexpr();
        }
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f15(s1, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_aggregate_opts() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsecreate_aggregate_opt_required();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsecreate_aggregate_opt_optional();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsecreate_aggregate_opt_optional();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f16(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_aggregate_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19;

    s0 = peg$currPos;
    s1 = peg$parseKW_CREATE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$currPos;
      s4 = peg$parseKW_OR();
      if (s4 !== peg$FAILED) {
        s5 = peg$parse__();
        s6 = peg$parseKW_REPLACE();
        if (s6 !== peg$FAILED) {
          s4 = [s4, s5, s6];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      if (input.substr(peg$currPos, 9).toLowerCase() === peg$c13) {
        s5 = input.substr(peg$currPos, 9);
        peg$currPos += 9;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e13);
        }
      }
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsetable_name();
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s9 = peg$parseLPAREN();
          if (s9 !== peg$FAILED) {
            s10 = peg$parse__();
            s11 = peg$parseaggregate_signature();
            if (s11 !== peg$FAILED) {
              s12 = peg$parse__();
              s13 = peg$parseRPAREN();
              if (s13 !== peg$FAILED) {
                s14 = peg$parse__();
                s15 = peg$parseLPAREN();
                if (s15 !== peg$FAILED) {
                  s16 = peg$parse__();
                  s17 = peg$parsecreate_aggregate_opts();
                  if (s17 !== peg$FAILED) {
                    s18 = peg$parse__();
                    s19 = peg$parseRPAREN();
                    if (s19 !== peg$FAILED) {
                      peg$savedPos = s0;
                      s0 = peg$f17(s1, s3, s5, s7, s11, s17);
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecolumn_data_type() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsecolumn_ref();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsedata_type();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f18(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecolumn_data_type_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsecolumn_data_type();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsecolumn_data_type();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsecolumn_data_type();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f19(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsefunc_returns() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c14) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e14);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 5).toLowerCase() === peg$c15) {
        s3 = input.substr(peg$currPos, 5);
        peg$currPos += 5;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e15);
        }
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parsedata_type();
      if (s5 === peg$FAILED) {
        s5 = peg$parsetable_name();
      }
      if (s5 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f20(s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 7).toLowerCase() === peg$c14) {
        s1 = input.substr(peg$currPos, 7);
        peg$currPos += 7;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e14);
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseKW_TABLE();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parseLPAREN();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse__();
            s7 = peg$parsecolumn_data_type_list();
            if (s7 !== peg$FAILED) {
              s8 = peg$parse__();
              s9 = peg$parseRPAREN();
              if (s9 !== peg$FAILED) {
                peg$savedPos = s0;
                s0 = peg$f21(s7);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsedeclare_variable_item() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16;

    s0 = peg$currPos;
    s1 = peg$parseident_name();
    if (s1 !== peg$FAILED) {
      peg$savedPos = peg$currPos;
      s2 = peg$f22(s1);
      if (s2) {
        s2 = undefined;
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        if (input.substr(peg$currPos, 8).toLowerCase() === peg$c16) {
          s4 = input.substr(peg$currPos, 8);
          peg$currPos += 8;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e16);
          }
        }
        if (s4 === peg$FAILED) {
          s4 = null;
        }
        s5 = peg$parse__();
        s6 = peg$parsedata_type();
        if (s6 !== peg$FAILED) {
          s7 = peg$parse__();
          s8 = peg$parsecollate_expr();
          if (s8 === peg$FAILED) {
            s8 = null;
          }
          s9 = peg$parse__();
          s10 = peg$currPos;
          s11 = peg$parseKW_NOT();
          if (s11 !== peg$FAILED) {
            s12 = peg$parse__();
            s13 = peg$parseKW_NULL();
            if (s13 !== peg$FAILED) {
              s11 = [s11, s12, s13];
              s10 = s11;
            } else {
              peg$currPos = s10;
              s10 = peg$FAILED;
            }
          } else {
            peg$currPos = s10;
            s10 = peg$FAILED;
          }
          if (s10 === peg$FAILED) {
            s10 = null;
          }
          s11 = peg$parse__();
          s12 = peg$currPos;
          s13 = peg$parseKW_DEFAULT();
          if (s13 === peg$FAILED) {
            if (input.substr(peg$currPos, 2) === peg$c17) {
              s13 = peg$c17;
              peg$currPos += 2;
            } else {
              s13 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e17);
              }
            }
          }
          if (s13 === peg$FAILED) {
            s13 = null;
          }
          s14 = peg$parse__();
          s15 = peg$currPos;
          peg$silentFails++;
          if (input.substr(peg$currPos, 5).toLowerCase() === peg$c18) {
            s16 = input.substr(peg$currPos, 5);
            peg$currPos += 5;
          } else {
            s16 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e18);
            }
          }
          peg$silentFails--;
          if (s16 !== peg$FAILED) {
            peg$currPos = s15;
            s15 = undefined;
          } else {
            s15 = peg$FAILED;
          }
          if (s15 === peg$FAILED) {
            s15 = peg$parseliteral();
            if (s15 === peg$FAILED) {
              s15 = peg$parseexpr();
            }
          }
          if (s15 !== peg$FAILED) {
            s13 = [s13, s14, s15];
            s12 = s13;
          } else {
            peg$currPos = s12;
            s12 = peg$FAILED;
          }
          if (s12 === peg$FAILED) {
            s12 = null;
          }
          s13 = peg$parse__();
          s14 = peg$parseSEMICOLON();
          if (s14 === peg$FAILED) {
            s14 = null;
          }
          peg$savedPos = s0;
          s0 = peg$f23(s1, s4, s6, s8, s10, s12, s14);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedeclare_variables() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsedeclare_variable_item();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parsedeclare_variable_item();
      if (s5 !== peg$FAILED) {
        s4 = [s4, s5];
        s3 = s4;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parsedeclare_variable_item();
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f24(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedeclare_stmt() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c19) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e19);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsedeclare_variables();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f25(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_func_opt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8) === peg$c20) {
      s1 = peg$c20;
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e20);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseident_name();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        peg$savedPos = s0;
        s0 = peg$f26(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 8).toLowerCase() === peg$c21) {
        s1 = input.substr(peg$currPos, 8);
        peg$currPos += 8;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e21);
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$currPos;
        if (input.substr(peg$currPos, 3) === peg$c22) {
          s4 = peg$c22;
          peg$currPos += 3;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e22);
          }
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parse__();
          if (input.substr(peg$currPos, 4) === peg$c23) {
            s6 = peg$c23;
            peg$currPos += 4;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e23);
            }
          }
          if (s6 !== peg$FAILED) {
            s7 = peg$parse__();
            s8 = peg$parseident_name();
            if (s8 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7, s8];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        s4 = peg$parse__();
        peg$savedPos = s0;
        s0 = peg$f27(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 6).toLowerCase() === peg$c24) {
          s1 = input.substr(peg$currPos, 6);
          peg$currPos += 6;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e24);
          }
        }
        if (s1 === peg$FAILED) {
          if (input.substr(peg$currPos, 9).toLowerCase() === peg$c25) {
            s1 = input.substr(peg$currPos, 9);
            peg$currPos += 9;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e25);
            }
          }
          if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 6).toLowerCase() === peg$c26) {
              s1 = input.substr(peg$currPos, 6);
              peg$currPos += 6;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e26);
              }
            }
            if (s1 === peg$FAILED) {
              if (input.substr(peg$currPos, 8).toLowerCase() === peg$c27) {
                s1 = input.substr(peg$currPos, 8);
                peg$currPos += 8;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e27);
                }
              }
              if (s1 === peg$FAILED) {
                if (input.substr(peg$currPos, 6).toLowerCase() === peg$c28) {
                  s1 = input.substr(peg$currPos, 6);
                  peg$currPos += 6;
                } else {
                  s1 = peg$FAILED;
                  if (peg$silentFails === 0) {
                    peg$fail(peg$e28);
                  }
                }
              }
            }
          }
        }
        if (s1 !== peg$FAILED) {
          s2 = peg$parse__();
          peg$savedPos = s0;
          s0 = peg$f28(s1);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.substr(peg$currPos, 3).toLowerCase() === peg$c29) {
            s1 = input.substr(peg$currPos, 3);
            peg$currPos += 3;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e29);
            }
          }
          if (s1 === peg$FAILED) {
            s1 = null;
          }
          s2 = peg$parse__();
          if (input.substr(peg$currPos, 9).toLowerCase() === peg$c30) {
            s3 = input.substr(peg$currPos, 9);
            peg$currPos += 9;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e30);
            }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parse__();
            peg$savedPos = s0;
            s0 = peg$f29(s1);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 6).toLowerCase() === peg$c31) {
              s1 = input.substr(peg$currPos, 6);
              peg$currPos += 6;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e31);
              }
            }
            if (s1 === peg$FAILED) {
              s1 = peg$currPos;
              if (input.substr(peg$currPos, 7).toLowerCase() === peg$c14) {
                s2 = input.substr(peg$currPos, 7);
                peg$currPos += 7;
              } else {
                s2 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e14);
                }
              }
              if (s2 !== peg$FAILED) {
                s3 = peg$parse__();
                if (input.substr(peg$currPos, 4).toLowerCase() === peg$c32) {
                  s4 = input.substr(peg$currPos, 4);
                  peg$currPos += 4;
                } else {
                  s4 = peg$FAILED;
                  if (peg$silentFails === 0) {
                    peg$fail(peg$e32);
                  }
                }
                if (s4 !== peg$FAILED) {
                  s2 = [s2, s3, s4];
                  s1 = s2;
                } else {
                  peg$currPos = s1;
                  s1 = peg$FAILED;
                }
              } else {
                peg$currPos = s1;
                s1 = peg$FAILED;
              }
            }
            if (s1 === peg$FAILED) {
              s1 = null;
            }
            s2 = peg$parse__();
            if (input.substr(peg$currPos, 2).toLowerCase() === peg$c33) {
              s3 = input.substr(peg$currPos, 2);
              peg$currPos += 2;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e33);
              }
            }
            if (s3 !== peg$FAILED) {
              s4 = peg$parse__();
              if (input.substr(peg$currPos, 4).toLowerCase() === peg$c32) {
                s5 = input.substr(peg$currPos, 4);
                peg$currPos += 4;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e32);
                }
              }
              if (s5 !== peg$FAILED) {
                s6 = peg$parse__();
                if (input.substr(peg$currPos, 5).toLowerCase() === peg$c34) {
                  s7 = input.substr(peg$currPos, 5);
                  peg$currPos += 5;
                } else {
                  s7 = peg$FAILED;
                  if (peg$silentFails === 0) {
                    peg$fail(peg$e34);
                  }
                }
                if (s7 !== peg$FAILED) {
                  s8 = peg$parse__();
                  peg$savedPos = s0;
                  s0 = peg$f30(s1);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              if (input.substr(peg$currPos, 8).toLowerCase() === peg$c35) {
                s1 = input.substr(peg$currPos, 8);
                peg$currPos += 8;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e35);
                }
              }
              if (s1 === peg$FAILED) {
                s1 = null;
              }
              s2 = peg$parse__();
              if (input.substr(peg$currPos, 8).toLowerCase() === peg$c36) {
                s3 = input.substr(peg$currPos, 8);
                peg$currPos += 8;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e36);
                }
              }
              if (s3 !== peg$FAILED) {
                s4 = peg$parse__();
                if (input.substr(peg$currPos, 7).toLowerCase() === peg$c37) {
                  s5 = input.substr(peg$currPos, 7);
                  peg$currPos += 7;
                } else {
                  s5 = peg$FAILED;
                  if (peg$silentFails === 0) {
                    peg$fail(peg$e37);
                  }
                }
                if (s5 === peg$FAILED) {
                  if (input.substr(peg$currPos, 7).toLowerCase() === peg$c38) {
                    s5 = input.substr(peg$currPos, 7);
                    peg$currPos += 7;
                  } else {
                    s5 = peg$FAILED;
                    if (peg$silentFails === 0) {
                      peg$fail(peg$e38);
                    }
                  }
                }
                if (s5 !== peg$FAILED) {
                  s6 = peg$parse__();
                  peg$savedPos = s0;
                  s0 = peg$f31(s1, s5);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
              if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (input.substr(peg$currPos, 8).toLowerCase() === peg$c39) {
                  s1 = input.substr(peg$currPos, 8);
                  peg$currPos += 8;
                } else {
                  s1 = peg$FAILED;
                  if (peg$silentFails === 0) {
                    peg$fail(peg$e39);
                  }
                }
                if (s1 !== peg$FAILED) {
                  s2 = peg$parse__();
                  if (input.substr(peg$currPos, 6).toLowerCase() === peg$c40) {
                    s3 = input.substr(peg$currPos, 6);
                    peg$currPos += 6;
                  } else {
                    s3 = peg$FAILED;
                    if (peg$silentFails === 0) {
                      peg$fail(peg$e40);
                    }
                  }
                  if (s3 === peg$FAILED) {
                    if (input.substr(peg$currPos, 10).toLowerCase() === peg$c41) {
                      s3 = input.substr(peg$currPos, 10);
                      peg$currPos += 10;
                    } else {
                      s3 = peg$FAILED;
                      if (peg$silentFails === 0) {
                        peg$fail(peg$e41);
                      }
                    }
                    if (s3 === peg$FAILED) {
                      if (input.substr(peg$currPos, 4).toLowerCase() === peg$c42) {
                        s3 = input.substr(peg$currPos, 4);
                        peg$currPos += 4;
                      } else {
                        s3 = peg$FAILED;
                        if (peg$silentFails === 0) {
                          peg$fail(peg$e42);
                        }
                      }
                    }
                  }
                  if (s3 !== peg$FAILED) {
                    s4 = peg$parse__();
                    peg$savedPos = s0;
                    s0 = peg$f32(s3);
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
                if (s0 === peg$FAILED) {
                  s0 = peg$currPos;
                  s1 = peg$parseKW_AS();
                  if (s1 !== peg$FAILED) {
                    s2 = peg$parse__();
                    s3 = [];
                    if (peg$r0.test(input.charAt(peg$currPos))) {
                      s4 = input.charAt(peg$currPos);
                      peg$currPos++;
                    } else {
                      s4 = peg$FAILED;
                      if (peg$silentFails === 0) {
                        peg$fail(peg$e43);
                      }
                    }
                    if (s4 !== peg$FAILED) {
                      while (s4 !== peg$FAILED) {
                        s3.push(s4);
                        if (peg$r0.test(input.charAt(peg$currPos))) {
                          s4 = input.charAt(peg$currPos);
                          peg$currPos++;
                        } else {
                          s4 = peg$FAILED;
                          if (peg$silentFails === 0) {
                            peg$fail(peg$e43);
                          }
                        }
                      }
                    } else {
                      s3 = peg$FAILED;
                    }
                    if (s3 !== peg$FAILED) {
                      s4 = peg$parse__();
                      s5 = peg$parsedeclare_stmt();
                      if (s5 === peg$FAILED) {
                        s5 = null;
                      }
                      s6 = peg$parse__();
                      if (input.substr(peg$currPos, 5).toLowerCase() === peg$c18) {
                        s7 = input.substr(peg$currPos, 5);
                        peg$currPos += 5;
                      } else {
                        s7 = peg$FAILED;
                        if (peg$silentFails === 0) {
                          peg$fail(peg$e18);
                        }
                      }
                      if (s7 === peg$FAILED) {
                        s7 = null;
                      }
                      s8 = peg$parse__();
                      s9 = peg$parsemultiple_stmt();
                      if (s9 !== peg$FAILED) {
                        s10 = peg$parse__();
                        s11 = peg$parseKW_END();
                        if (s11 === peg$FAILED) {
                          s11 = null;
                        }
                        peg$savedPos = peg$currPos;
                        s12 = peg$f33(s3, s5, s7, s9, s11);
                        if (s12) {
                          s12 = undefined;
                        } else {
                          s12 = peg$FAILED;
                        }
                        if (s12 !== peg$FAILED) {
                          s13 = peg$parse__();
                          s14 = peg$parseSEMICOLON();
                          if (s14 === peg$FAILED) {
                            s14 = null;
                          }
                          s15 = peg$parse__();
                          s16 = [];
                          if (peg$r1.test(input.charAt(peg$currPos))) {
                            s17 = input.charAt(peg$currPos);
                            peg$currPos++;
                          } else {
                            s17 = peg$FAILED;
                            if (peg$silentFails === 0) {
                              peg$fail(peg$e44);
                            }
                          }
                          if (s17 !== peg$FAILED) {
                            while (s17 !== peg$FAILED) {
                              s16.push(s17);
                              if (peg$r1.test(input.charAt(peg$currPos))) {
                                s17 = input.charAt(peg$currPos);
                                peg$currPos++;
                              } else {
                                s17 = peg$FAILED;
                                if (peg$silentFails === 0) {
                                  peg$fail(peg$e44);
                                }
                              }
                            }
                          } else {
                            s16 = peg$FAILED;
                          }
                          if (s16 !== peg$FAILED) {
                            s17 = peg$parse__();
                            peg$savedPos = s0;
                            s0 = peg$f34(s3, s5, s7, s9, s11, s16);
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                  if (s0 === peg$FAILED) {
                    s0 = peg$currPos;
                    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c43) {
                      s1 = input.substr(peg$currPos, 4);
                      peg$currPos += 4;
                    } else {
                      s1 = peg$FAILED;
                      if (peg$silentFails === 0) {
                        peg$fail(peg$e45);
                      }
                    }
                    if (s1 === peg$FAILED) {
                      if (input.substr(peg$currPos, 4).toLowerCase() === peg$c44) {
                        s1 = input.substr(peg$currPos, 4);
                        peg$currPos += 4;
                      } else {
                        s1 = peg$FAILED;
                        if (peg$silentFails === 0) {
                          peg$fail(peg$e46);
                        }
                      }
                    }
                    if (s1 !== peg$FAILED) {
                      s2 = peg$parse__();
                      s3 = peg$parseliteral_numeric();
                      if (s3 !== peg$FAILED) {
                        s4 = peg$parse__();
                        peg$savedPos = s0;
                        s0 = peg$f35(s1, s3);
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                    if (s0 === peg$FAILED) {
                      s0 = peg$currPos;
                      if (input.substr(peg$currPos, 7).toLowerCase() === peg$c45) {
                        s1 = input.substr(peg$currPos, 7);
                        peg$currPos += 7;
                      } else {
                        s1 = peg$FAILED;
                        if (peg$silentFails === 0) {
                          peg$fail(peg$e47);
                        }
                      }
                      if (s1 !== peg$FAILED) {
                        s2 = peg$parse__();
                        s3 = peg$parseproc_func_name();
                        if (s3 !== peg$FAILED) {
                          s4 = peg$parse__();
                          peg$savedPos = s0;
                          s0 = peg$f36(s3);
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                      if (s0 === peg$FAILED) {
                        s0 = peg$currPos;
                        s1 = peg$parseKW_SET();
                        if (s1 !== peg$FAILED) {
                          s2 = peg$parse__();
                          s3 = peg$parseident_name();
                          if (s3 !== peg$FAILED) {
                            s4 = peg$parse__();
                            s5 = peg$currPos;
                            if (input.substr(peg$currPos, 2).toLowerCase() === peg$c46) {
                              s6 = input.substr(peg$currPos, 2);
                              peg$currPos += 2;
                            } else {
                              s6 = peg$FAILED;
                              if (peg$silentFails === 0) {
                                peg$fail(peg$e48);
                              }
                            }
                            if (s6 === peg$FAILED) {
                              if (input.charCodeAt(peg$currPos) === 61) {
                                s6 = peg$c47;
                                peg$currPos++;
                              } else {
                                s6 = peg$FAILED;
                                if (peg$silentFails === 0) {
                                  peg$fail(peg$e49);
                                }
                              }
                            }
                            if (s6 !== peg$FAILED) {
                              s7 = peg$parse__();
                              s8 = peg$parseident_list();
                              if (s8 !== peg$FAILED) {
                                s6 = [s6, s7, s8];
                                s5 = s6;
                              } else {
                                peg$currPos = s5;
                                s5 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s5;
                              s5 = peg$FAILED;
                            }
                            if (s5 === peg$FAILED) {
                              s5 = peg$currPos;
                              s6 = peg$parseKW_FROM();
                              if (s6 !== peg$FAILED) {
                                s7 = peg$parse__();
                                if (input.substr(peg$currPos, 7).toLowerCase() === peg$c48) {
                                  s8 = input.substr(peg$currPos, 7);
                                  peg$currPos += 7;
                                } else {
                                  s8 = peg$FAILED;
                                  if (peg$silentFails === 0) {
                                    peg$fail(peg$e50);
                                  }
                                }
                                if (s8 !== peg$FAILED) {
                                  s6 = [s6, s7, s8];
                                  s5 = s6;
                                } else {
                                  peg$currPos = s5;
                                  s5 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s5;
                                s5 = peg$FAILED;
                              }
                            }
                            if (s5 === peg$FAILED) {
                              s5 = null;
                            }
                            s6 = peg$parse__();
                            peg$savedPos = s0;
                            s0 = peg$f37(s3, s5);
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsecreate_function_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20;

    s0 = peg$currPos;
    s1 = peg$parseKW_CREATE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$currPos;
      s4 = peg$parseKW_OR();
      if (s4 !== peg$FAILED) {
        s5 = peg$parse__();
        s6 = peg$parseKW_REPLACE();
        if (s6 !== peg$FAILED) {
          s4 = [s4, s5, s6];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      if (input.substr(peg$currPos, 8).toLowerCase() === peg$c49) {
        s5 = input.substr(peg$currPos, 8);
        peg$currPos += 8;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e51);
        }
      }
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsetable_name();
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s9 = peg$parseLPAREN();
          if (s9 !== peg$FAILED) {
            s10 = peg$parse__();
            s11 = peg$parsealter_func_args();
            if (s11 === peg$FAILED) {
              s11 = null;
            }
            s12 = peg$parse__();
            s13 = peg$parseRPAREN();
            if (s13 !== peg$FAILED) {
              s14 = peg$parse__();
              s15 = peg$parsefunc_returns();
              if (s15 === peg$FAILED) {
                s15 = null;
              }
              s16 = peg$parse__();
              s17 = [];
              s18 = peg$parsecreate_func_opt();
              while (s18 !== peg$FAILED) {
                s17.push(s18);
                s18 = peg$parsecreate_func_opt();
              }
              s18 = peg$parse__();
              s19 = peg$parseSEMICOLON();
              if (s19 === peg$FAILED) {
                s19 = null;
              }
              s20 = peg$parse__();
              peg$savedPos = s0;
              s0 = peg$f38(s1, s3, s5, s7, s11, s15, s17);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_type_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15;

    s0 = peg$currPos;
    s1 = peg$parseKW_CREATE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 4).toLowerCase() === peg$c50) {
        s3 = input.substr(peg$currPos, 4);
        peg$currPos += 4;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e52);
        }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsetable_name();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseKW_AS();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseKW_ENUM();
            if (s9 !== peg$FAILED) {
              s10 = peg$parse__();
              s11 = peg$parseLPAREN();
              if (s11 !== peg$FAILED) {
                s12 = peg$parse__();
                s13 = peg$parseexpr_list();
                if (s13 === peg$FAILED) {
                  s13 = null;
                }
                s14 = peg$parse__();
                s15 = peg$parseRPAREN();
                if (s15 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s0 = peg$f39(s1, s3, s5, s7, s9, s13);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_CREATE();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        if (input.substr(peg$currPos, 4).toLowerCase() === peg$c50) {
          s3 = input.substr(peg$currPos, 4);
          peg$currPos += 4;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e52);
          }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parsetable_name();
          if (s5 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f40(s1, s3, s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsecreate_domain_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15;

    s0 = peg$currPos;
    s1 = peg$parseKW_CREATE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 6).toLowerCase() === peg$c51) {
        s3 = input.substr(peg$currPos, 6);
        peg$currPos += 6;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e53);
        }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsetable_name();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseKW_AS();
          if (s7 === peg$FAILED) {
            s7 = null;
          }
          s8 = peg$parse__();
          s9 = peg$parsedata_type();
          if (s9 !== peg$FAILED) {
            s10 = peg$parse__();
            s11 = peg$parsecollate_expr();
            if (s11 === peg$FAILED) {
              s11 = null;
            }
            s12 = peg$parse__();
            s13 = peg$parsedefault_expr();
            if (s13 === peg$FAILED) {
              s13 = null;
            }
            s14 = peg$parse__();
            s15 = peg$parsecreate_constraint_check();
            if (s15 === peg$FAILED) {
              s15 = null;
            }
            peg$savedPos = s0;
            s0 = peg$f41(s1, s3, s5, s7, s9, s11, s13, s15);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_table_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19;

    s0 = peg$currPos;
    s1 = peg$parseKW_CREATE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_TEMPORARY();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseKW_TABLE();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseif_not_exists_stmt();
        if (s7 === peg$FAILED) {
          s7 = null;
        }
        s8 = peg$parse__();
        s9 = peg$parsetable_ref_list();
        if (s9 !== peg$FAILED) {
          s10 = peg$parse__();
          s11 = peg$parsecreate_table_definition();
          if (s11 !== peg$FAILED) {
            s12 = peg$parse__();
            s13 = peg$parsetable_options();
            if (s13 === peg$FAILED) {
              s13 = null;
            }
            s14 = peg$parse__();
            s15 = peg$parseKW_IGNORE();
            if (s15 === peg$FAILED) {
              s15 = peg$parseKW_REPLACE();
            }
            if (s15 === peg$FAILED) {
              s15 = null;
            }
            s16 = peg$parse__();
            s17 = peg$parseKW_AS();
            if (s17 === peg$FAILED) {
              s17 = null;
            }
            s18 = peg$parse__();
            s19 = peg$parseunion_stmt();
            if (s19 === peg$FAILED) {
              s19 = null;
            }
            peg$savedPos = s0;
            s0 = peg$f42(s1, s3, s7, s9, s11, s13, s15, s17, s19);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_CREATE();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseKW_TEMPORARY();
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        s4 = peg$parse__();
        s5 = peg$parseKW_TABLE();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseif_not_exists_stmt();
          if (s7 === peg$FAILED) {
            s7 = null;
          }
          s8 = peg$parse__();
          s9 = peg$parsetable_ref_list();
          if (s9 !== peg$FAILED) {
            s10 = peg$parse__();
            s11 = peg$parsecreate_like_table();
            if (s11 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f43(s1, s3, s7, s9, s11);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsecreate_sequence() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14;

    s0 = peg$currPos;
    s1 = peg$parseKW_CREATE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_TEMPORARY();
      if (s3 === peg$FAILED) {
        s3 = peg$parseKW_TEMP();
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseKW_SEQUENCE();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseif_not_exists_stmt();
        if (s7 === peg$FAILED) {
          s7 = null;
        }
        s8 = peg$parse__();
        s9 = peg$parsetable_name();
        if (s9 !== peg$FAILED) {
          s10 = peg$parse__();
          s11 = peg$currPos;
          s12 = peg$parseKW_AS();
          if (s12 !== peg$FAILED) {
            s13 = peg$parse__();
            s14 = peg$parsealias_ident();
            if (s14 !== peg$FAILED) {
              s12 = [s12, s13, s14];
              s11 = s12;
            } else {
              peg$currPos = s11;
              s11 = peg$FAILED;
            }
          } else {
            peg$currPos = s11;
            s11 = peg$FAILED;
          }
          if (s11 === peg$FAILED) {
            s11 = null;
          }
          s12 = peg$parse__();
          s13 = peg$parsecreate_sequence_definition_list();
          if (s13 === peg$FAILED) {
            s13 = null;
          }
          peg$savedPos = s0;
          s0 = peg$f44(s1, s3, s7, s9, s11, s13);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsesequence_definition_increment() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c52) {
      s1 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e54);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_BY();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseliteral_numeric();
      if (s5 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f45(s1, s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsesequence_definition_minval() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c53) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e55);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseliteral_numeric();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f46(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 2).toLowerCase() === peg$c54) {
        s1 = input.substr(peg$currPos, 2);
        peg$currPos += 2;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e56);
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        if (input.substr(peg$currPos, 8).toLowerCase() === peg$c53) {
          s3 = input.substr(peg$currPos, 8);
          peg$currPos += 8;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e55);
          }
        }
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f47();
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsesequence_definition_maxval() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c55) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e57);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseliteral_numeric();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f48(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 2).toLowerCase() === peg$c54) {
        s1 = input.substr(peg$currPos, 2);
        peg$currPos += 2;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e56);
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        if (input.substr(peg$currPos, 8).toLowerCase() === peg$c55) {
          s3 = input.substr(peg$currPos, 8);
          peg$currPos += 8;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e57);
          }
        }
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f49();
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsesequence_definition_start() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c56) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e58);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_WITH();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseliteral_numeric();
      if (s5 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f50(s1, s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsesequence_definition_cache() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c57) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e59);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseliteral_numeric();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f51(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsesequence_definition_cycle() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c54) {
      s1 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e56);
      }
    }
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c58) {
      s3 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s3 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e60);
      }
    }
    if (s3 !== peg$FAILED) {
      peg$savedPos = s0;
      s0 = peg$f52(s1);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsesequence_definition_owned() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c59) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e61);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_BY();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        if (input.substr(peg$currPos, 4).toLowerCase() === peg$c60) {
          s5 = input.substr(peg$currPos, 4);
          peg$currPos += 4;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e62);
          }
        }
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f53();
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 5).toLowerCase() === peg$c59) {
        s1 = input.substr(peg$currPos, 5);
        peg$currPos += 5;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e61);
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseKW_BY();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parsecolumn_ref();
          if (s5 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f54(s1, s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsecreate_sequence_definition() {
    var s0;

    s0 = peg$parsesequence_definition_increment();
    if (s0 === peg$FAILED) {
      s0 = peg$parsesequence_definition_minval();
      if (s0 === peg$FAILED) {
        s0 = peg$parsesequence_definition_maxval();
        if (s0 === peg$FAILED) {
          s0 = peg$parsesequence_definition_start();
          if (s0 === peg$FAILED) {
            s0 = peg$parsesequence_definition_cache();
            if (s0 === peg$FAILED) {
              s0 = peg$parsesequence_definition_cycle();
              if (s0 === peg$FAILED) {
                s0 = peg$parsesequence_definition_owned();
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsecreate_sequence_definition_list() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsecreate_sequence_definition();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parsecreate_sequence_definition();
      if (s5 !== peg$FAILED) {
        s4 = [s4, s5];
        s3 = s4;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parsecreate_sequence_definition();
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f55(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_index_stmt() {
    var s0,
      s1,
      s2,
      s3,
      s4,
      s5,
      s6,
      s7,
      s8,
      s9,
      s10,
      s11,
      s12,
      s13,
      s14,
      s15,
      s16,
      s17,
      s18,
      s19,
      s20,
      s21,
      s22,
      s23,
      s24,
      s25,
      s26,
      s27,
      s28,
      s29,
      s30;

    s0 = peg$currPos;
    s1 = peg$parseKW_CREATE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_UNIQUE();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseKW_INDEX();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseKW_CONCURRENTLY();
        if (s7 === peg$FAILED) {
          s7 = null;
        }
        s8 = peg$parse__();
        s9 = peg$parseident();
        if (s9 === peg$FAILED) {
          s9 = null;
        }
        s10 = peg$parse__();
        s11 = peg$parseKW_ON();
        if (s11 !== peg$FAILED) {
          s12 = peg$parse__();
          s13 = peg$parsetable_name();
          if (s13 !== peg$FAILED) {
            s14 = peg$parse__();
            s15 = peg$parseindex_type();
            if (s15 === peg$FAILED) {
              s15 = null;
            }
            s16 = peg$parse__();
            s17 = peg$parseLPAREN();
            if (s17 !== peg$FAILED) {
              s18 = peg$parse__();
              s19 = peg$parsecolumn_order_list();
              if (s19 !== peg$FAILED) {
                s20 = peg$parse__();
                s21 = peg$parseRPAREN();
                if (s21 !== peg$FAILED) {
                  s22 = peg$parse__();
                  s23 = peg$currPos;
                  s24 = peg$parseKW_WITH();
                  if (s24 !== peg$FAILED) {
                    s25 = peg$parse__();
                    s26 = peg$parseLPAREN();
                    if (s26 !== peg$FAILED) {
                      s27 = peg$parse__();
                      s28 = peg$parseindex_options_list();
                      if (s28 !== peg$FAILED) {
                        s29 = peg$parse__();
                        s30 = peg$parseRPAREN();
                        if (s30 !== peg$FAILED) {
                          s24 = [s24, s25, s26, s27, s28, s29, s30];
                          s23 = s24;
                        } else {
                          peg$currPos = s23;
                          s23 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s23;
                        s23 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s23;
                      s23 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s23;
                    s23 = peg$FAILED;
                  }
                  if (s23 === peg$FAILED) {
                    s23 = null;
                  }
                  s24 = peg$parse__();
                  s25 = peg$currPos;
                  s26 = peg$parseKW_TABLESPACE();
                  if (s26 !== peg$FAILED) {
                    s27 = peg$parse__();
                    s28 = peg$parseident_name();
                    if (s28 !== peg$FAILED) {
                      s26 = [s26, s27, s28];
                      s25 = s26;
                    } else {
                      peg$currPos = s25;
                      s25 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s25;
                    s25 = peg$FAILED;
                  }
                  if (s25 === peg$FAILED) {
                    s25 = null;
                  }
                  s26 = peg$parse__();
                  s27 = peg$parsewhere_clause();
                  if (s27 === peg$FAILED) {
                    s27 = null;
                  }
                  s28 = peg$parse__();
                  peg$savedPos = s0;
                  s0 = peg$f56(s1, s3, s5, s7, s9, s11, s13, s15, s19, s23, s25, s27);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecolumn_order_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsecolumn_order();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsecolumn_order();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsecolumn_order();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f57(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecolumn_order() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12;

    s0 = peg$currPos;
    s1 = peg$parseexpr();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsecollate_expr();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseident();
      if (s5 === peg$FAILED) {
        s5 = null;
      }
      s6 = peg$parse__();
      s7 = peg$parseKW_ASC();
      if (s7 === peg$FAILED) {
        s7 = peg$parseKW_DESC();
      }
      if (s7 === peg$FAILED) {
        s7 = null;
      }
      s8 = peg$parse__();
      s9 = peg$currPos;
      if (input.substr(peg$currPos, 5).toLowerCase() === peg$c61) {
        s10 = input.substr(peg$currPos, 5);
        peg$currPos += 5;
      } else {
        s10 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e63);
        }
      }
      if (s10 !== peg$FAILED) {
        s11 = peg$parse__();
        if (input.substr(peg$currPos, 5).toLowerCase() === peg$c62) {
          s12 = input.substr(peg$currPos, 5);
          peg$currPos += 5;
        } else {
          s12 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e64);
          }
        }
        if (s12 === peg$FAILED) {
          if (input.substr(peg$currPos, 4).toLowerCase() === peg$c63) {
            s12 = input.substr(peg$currPos, 4);
            peg$currPos += 4;
          } else {
            s12 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e65);
            }
          }
        }
        if (s12 !== peg$FAILED) {
          s10 = [s10, s11, s12];
          s9 = s10;
        } else {
          peg$currPos = s9;
          s9 = peg$FAILED;
        }
      } else {
        peg$currPos = s9;
        s9 = peg$FAILED;
      }
      if (s9 === peg$FAILED) {
        s9 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f58(s1, s3, s5, s7, s9);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_like_table_simple() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_LIKE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsetable_ref_list();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f59(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_like_table() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$parsecreate_like_table_simple();
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseLPAREN();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parsecreate_like_table();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parseRPAREN();
          if (s5 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f60(s3);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsecreate_table_definition() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parseLPAREN();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsecreate_definition();
      if (s3 !== peg$FAILED) {
        s4 = [];
        s5 = peg$currPos;
        s6 = peg$parse__();
        s7 = peg$parseCOMMA();
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s9 = peg$parsecreate_definition();
          if (s9 !== peg$FAILED) {
            s6 = [s6, s7, s8, s9];
            s5 = s6;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$currPos;
          s6 = peg$parse__();
          s7 = peg$parseCOMMA();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parsecreate_definition();
            if (s9 !== peg$FAILED) {
              s6 = [s6, s7, s8, s9];
              s5 = s6;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        }
        s5 = peg$parse__();
        s6 = peg$parseRPAREN();
        if (s6 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f61(s3, s4);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_definition() {
    var s0;

    s0 = peg$parsecreate_column_definition();
    if (s0 === peg$FAILED) {
      s0 = peg$parsecreate_index_definition();
      if (s0 === peg$FAILED) {
        s0 = peg$parsecreate_fulltext_spatial_index_definition();
        if (s0 === peg$FAILED) {
          s0 = peg$parsecreate_constraint_definition();
        }
      }
    }

    return s0;
  }

  function peg$parsecolumn_definition_opt() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$parsecolumn_constraint();
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 14).toLowerCase() === peg$c64) {
        s1 = input.substr(peg$currPos, 14);
        peg$currPos += 14;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e66);
        }
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f62(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 6).toLowerCase() === peg$c65) {
          s1 = input.substr(peg$currPos, 6);
          peg$currPos += 6;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e67);
          }
        }
        if (s1 !== peg$FAILED) {
          s2 = peg$parse__();
          if (input.substr(peg$currPos, 3).toLowerCase() === peg$c66) {
            s3 = input.substr(peg$currPos, 3);
            peg$currPos += 3;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e68);
            }
          }
          if (s3 === peg$FAILED) {
            s3 = null;
          }
          peg$savedPos = s0;
          s0 = peg$f63(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.substr(peg$currPos, 7).toLowerCase() === peg$c67) {
            s1 = input.substr(peg$currPos, 7);
            peg$currPos += 7;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e69);
            }
          }
          if (s1 === peg$FAILED) {
            s1 = null;
          }
          s2 = peg$parse__();
          if (input.substr(peg$currPos, 3).toLowerCase() === peg$c66) {
            s3 = input.substr(peg$currPos, 3);
            peg$currPos += 3;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e68);
            }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f64(s1);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parsekeyword_comment();
            if (s1 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$f65(s1);
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              s1 = peg$parsecollate_expr();
              if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$f66(s1);
              }
              s0 = s1;
              if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                s1 = peg$parsecolumn_format();
                if (s1 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$f67(s1);
                }
                s0 = s1;
                if (s0 === peg$FAILED) {
                  s0 = peg$currPos;
                  s1 = peg$parsestorage();
                  if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$f68(s1);
                  }
                  s0 = s1;
                  if (s0 === peg$FAILED) {
                    s0 = peg$currPos;
                    s1 = peg$parsereference_definition();
                    if (s1 !== peg$FAILED) {
                      peg$savedPos = s0;
                      s1 = peg$f69(s1);
                    }
                    s0 = s1;
                    if (s0 === peg$FAILED) {
                      s0 = peg$currPos;
                      s1 = peg$parsecreate_option_character_set_kw();
                      if (s1 !== peg$FAILED) {
                        s2 = peg$parse__();
                        s3 = peg$parseKW_ASSIGIN_EQUAL();
                        if (s3 === peg$FAILED) {
                          s3 = null;
                        }
                        s4 = peg$parse__();
                        s5 = peg$parseident_name();
                        if (s5 !== peg$FAILED) {
                          peg$savedPos = s0;
                          s0 = peg$f70(s1, s3, s5);
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsecolumn_definition_opt_list() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$parsecolumn_definition_opt();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = [];
      s4 = peg$currPos;
      s5 = peg$parse__();
      s6 = peg$parsecolumn_definition_opt();
      if (s6 !== peg$FAILED) {
        s5 = [s5, s6];
        s4 = s5;
      } else {
        peg$currPos = s4;
        s4 = peg$FAILED;
      }
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        s4 = peg$currPos;
        s5 = peg$parse__();
        s6 = peg$parsecolumn_definition_opt();
        if (s6 !== peg$FAILED) {
          s5 = [s5, s6];
          s4 = s5;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f71(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_column_definition() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsecolumn_ref();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsedata_type();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsecolumn_definition_opt_list();
        if (s5 === peg$FAILED) {
          s5 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f72(s1, s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecolumn_constraint() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseliteral_not_null();
    if (s1 === peg$FAILED) {
      s1 = peg$parseliteral_null();
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsedefault_expr();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f73(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsedefault_expr();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseliteral_not_null();
        if (s3 === peg$FAILED) {
          s3 = peg$parseliteral_null();
        }
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f74(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsecollate_expr() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_COLLATE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_ASSIGIN_EQUAL();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseident();
      if (s5 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f75(s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecolumn_format() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 13).toLowerCase() === peg$c68) {
      s1 = input.substr(peg$currPos, 13);
      peg$currPos += 13;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e70);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 5).toLowerCase() === peg$c69) {
        s3 = input.substr(peg$currPos, 5);
        peg$currPos += 5;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e71);
        }
      }
      if (s3 === peg$FAILED) {
        if (input.substr(peg$currPos, 7).toLowerCase() === peg$c70) {
          s3 = input.substr(peg$currPos, 7);
          peg$currPos += 7;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e72);
          }
        }
        if (s3 === peg$FAILED) {
          if (input.substr(peg$currPos, 7).toLowerCase() === peg$c71) {
            s3 = input.substr(peg$currPos, 7);
            peg$currPos += 7;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e73);
            }
          }
        }
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f76(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsestorage() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c72) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e74);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 4).toLowerCase() === peg$c73) {
        s3 = input.substr(peg$currPos, 4);
        peg$currPos += 4;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e75);
        }
      }
      if (s3 === peg$FAILED) {
        if (input.substr(peg$currPos, 6).toLowerCase() === peg$c74) {
          s3 = input.substr(peg$currPos, 6);
          peg$currPos += 6;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e76);
          }
        }
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f77(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedefault_arg_expr() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_DEFAULT();
    if (s1 === peg$FAILED) {
      s1 = peg$parseKW_ASSIGIN_EQUAL();
    }
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    s3 = peg$parseliteral();
    if (s3 === peg$FAILED) {
      s3 = peg$parseexpr();
    }
    if (s3 !== peg$FAILED) {
      peg$savedPos = s0;
      s0 = peg$f78(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedefault_expr() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_DEFAULT();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseliteral();
      if (s3 === peg$FAILED) {
        s3 = peg$parseexpr();
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f79(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedrop_index_opt() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseALTER_ALGORITHM();
    if (s1 === peg$FAILED) {
      s1 = peg$parseALTER_LOCK();
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseALTER_ALGORITHM();
      if (s5 === peg$FAILED) {
        s5 = peg$parseALTER_LOCK();
      }
      if (s5 !== peg$FAILED) {
        s4 = [s4, s5];
        s3 = s4;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseALTER_ALGORITHM();
        if (s5 === peg$FAILED) {
          s5 = peg$parseALTER_LOCK();
        }
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f80(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedrop_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;

    s0 = peg$currPos;
    s1 = peg$parseKW_DROP();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_TABLE();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsetable_ref_list();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f81(s1, s3, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_DROP();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseKW_INDEX();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parseKW_CONCURRENTLY();
          if (s5 === peg$FAILED) {
            s5 = null;
          }
          s6 = peg$parse__();
          s7 = peg$currPos;
          if (input.substr(peg$currPos, 2).toLowerCase() === peg$c0) {
            s8 = input.substr(peg$currPos, 2);
            peg$currPos += 2;
          } else {
            s8 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e0);
            }
          }
          if (s8 !== peg$FAILED) {
            s9 = peg$parse__();
            s10 = peg$parseKW_EXISTS();
            if (s10 !== peg$FAILED) {
              s8 = [s8, s9, s10];
              s7 = s8;
            } else {
              peg$currPos = s7;
              s7 = peg$FAILED;
            }
          } else {
            peg$currPos = s7;
            s7 = peg$FAILED;
          }
          if (s7 === peg$FAILED) {
            s7 = null;
          }
          s8 = peg$parse__();
          s9 = peg$parsecolumn_ref();
          if (s9 !== peg$FAILED) {
            s10 = peg$parse__();
            if (input.substr(peg$currPos, 7).toLowerCase() === peg$c75) {
              s11 = input.substr(peg$currPos, 7);
              peg$currPos += 7;
            } else {
              s11 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e77);
              }
            }
            if (s11 === peg$FAILED) {
              if (input.substr(peg$currPos, 8).toLowerCase() === peg$c76) {
                s11 = input.substr(peg$currPos, 8);
                peg$currPos += 8;
              } else {
                s11 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e78);
                }
              }
            }
            if (s11 === peg$FAILED) {
              s11 = null;
            }
            peg$savedPos = s0;
            s0 = peg$f82(s1, s3, s5, s7, s9, s11);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsetruncate_stmt() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_TRUNCATE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_TABLE();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parsetable_ref_list();
      if (s5 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f83(s1, s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseuse_stmt() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_USE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseident();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f84(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseaggregate_signature() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseSTAR();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f85();
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsealter_func_args();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      s2 = peg$parse__();
      s3 = peg$parseKW_ORDER();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseKW_BY();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsealter_func_args();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f86(s1, s7);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$parsealter_func_args();
      }
    }

    return s0;
  }

  function peg$parsealter_func_argmode() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_IN();
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 3).toLowerCase() === peg$c77) {
        s1 = input.substr(peg$currPos, 3);
        peg$currPos += 3;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e79);
        }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 8).toLowerCase() === peg$c78) {
          s1 = input.substr(peg$currPos, 8);
          peg$currPos += 8;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e80);
          }
        }
        if (s1 === peg$FAILED) {
          if (input.substr(peg$currPos, 5).toLowerCase() === peg$c79) {
            s1 = input.substr(peg$currPos, 5);
            peg$currPos += 5;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e81);
            }
          }
        }
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f87(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsealter_func_arg_item() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsealter_func_argmode();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    s3 = peg$parsedata_type();
    if (s3 !== peg$FAILED) {
      s4 = peg$parse__();
      s5 = peg$parsedefault_arg_expr();
      if (s5 === peg$FAILED) {
        s5 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f88(s1, s3, s5);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsealter_func_argmode();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      s2 = peg$parse__();
      s3 = peg$parseident_name();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsedata_type();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsedefault_arg_expr();
          if (s7 === peg$FAILED) {
            s7 = null;
          }
          peg$savedPos = s0;
          s0 = peg$f89(s1, s3, s5, s7);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsealter_func_args() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsealter_func_arg_item();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsealter_func_arg_item();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsealter_func_arg_item();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f90(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsealter_aggregate_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13;

    s0 = peg$currPos;
    s1 = peg$parseKW_ALTER();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 9).toLowerCase() === peg$c13) {
        s3 = input.substr(peg$currPos, 9);
        peg$currPos += 9;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e13);
        }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsetable_name();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseLPAREN();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseaggregate_signature();
            if (s9 !== peg$FAILED) {
              s10 = peg$parse__();
              s11 = peg$parseRPAREN();
              if (s11 !== peg$FAILED) {
                s12 = peg$parse__();
                s13 = peg$parseALTER_RENAME();
                if (s13 === peg$FAILED) {
                  s13 = peg$parseALTER_OWNER_TO();
                  if (s13 === peg$FAILED) {
                    s13 = peg$parseALTER_SET_SCHEMA();
                  }
                }
                if (s13 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s0 = peg$f91(s3, s5, s9, s13);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsealter_function_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12;

    s0 = peg$currPos;
    s1 = peg$parseKW_ALTER();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 8).toLowerCase() === peg$c49) {
        s3 = input.substr(peg$currPos, 8);
        peg$currPos += 8;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e51);
        }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsetable_name();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$currPos;
          s8 = peg$parseLPAREN();
          if (s8 !== peg$FAILED) {
            s9 = peg$parse__();
            s10 = peg$parsealter_func_args();
            if (s10 === peg$FAILED) {
              s10 = null;
            }
            s11 = peg$parse__();
            s12 = peg$parseRPAREN();
            if (s12 !== peg$FAILED) {
              s8 = [s8, s9, s10, s11, s12];
              s7 = s8;
            } else {
              peg$currPos = s7;
              s7 = peg$FAILED;
            }
          } else {
            peg$currPos = s7;
            s7 = peg$FAILED;
          }
          if (s7 === peg$FAILED) {
            s7 = null;
          }
          s8 = peg$parse__();
          s9 = peg$parseALTER_RENAME();
          if (s9 === peg$FAILED) {
            s9 = peg$parseALTER_OWNER_TO();
            if (s9 === peg$FAILED) {
              s9 = peg$parseALTER_SET_SCHEMA();
            }
          }
          if (s9 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f92(s3, s5, s7, s9);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsealter_domain_type_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseKW_ALTER();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 6).toLowerCase() === peg$c51) {
        s3 = input.substr(peg$currPos, 6);
        peg$currPos += 6;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e53);
        }
      }
      if (s3 === peg$FAILED) {
        if (input.substr(peg$currPos, 4).toLowerCase() === peg$c50) {
          s3 = input.substr(peg$currPos, 4);
          peg$currPos += 4;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e52);
          }
        }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsetable_name();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseALTER_RENAME();
          if (s7 === peg$FAILED) {
            s7 = peg$parseALTER_OWNER_TO();
            if (s7 === peg$FAILED) {
              s7 = peg$parseALTER_SET_SCHEMA();
            }
          }
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f93(s3, s5, s7);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsealter_schema_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseKW_ALTER();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_SCHEMA();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseident_name();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseALTER_RENAME();
          if (s7 === peg$FAILED) {
            s7 = peg$parseALTER_OWNER_TO();
            if (s7 === peg$FAILED) {
              s7 = peg$parseALTER_SET_SCHEMA();
            }
          }
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f94(s3, s5, s7);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsealter_table_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseKW_ALTER();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_TABLE();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsetable_ref_list();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsealter_action_list();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f95(s5, s7);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsealter_action_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsealter_action();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsealter_action();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsealter_action();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f96(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsealter_action() {
    var s0;

    s0 = peg$parseALTER_ADD_COLUMN();
    if (s0 === peg$FAILED) {
      s0 = peg$parseALTER_ADD_CONSTRAINT();
      if (s0 === peg$FAILED) {
        s0 = peg$parseALTER_DROP_COLUMN();
        if (s0 === peg$FAILED) {
          s0 = peg$parseALTER_ADD_INDEX_OR_KEY();
          if (s0 === peg$FAILED) {
            s0 = peg$parseALTER_ADD_FULLETXT_SPARITAL_INDEX();
            if (s0 === peg$FAILED) {
              s0 = peg$parseALTER_RENAME();
              if (s0 === peg$FAILED) {
                s0 = peg$parseALTER_ALGORITHM();
                if (s0 === peg$FAILED) {
                  s0 = peg$parseALTER_LOCK();
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parseALTER_ADD_COLUMN() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_ADD();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_COLUMN();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parsecreate_column_definition();
      if (s5 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f97(s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseALTER_DROP_COLUMN() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_DROP();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_COLUMN();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parsecolumn_ref();
      if (s5 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f98(s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseALTER_ADD_CONSTRAINT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_ADD();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsecreate_constraint_definition();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f99(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseALTER_ADD_INDEX_OR_KEY() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_ADD();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsecreate_index_definition();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f100(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseALTER_RENAME() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_RENAME();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_TO();
      if (s3 === peg$FAILED) {
        s3 = peg$parseKW_AS();
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseident();
      if (s5 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f101(s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseALTER_OWNER_TO() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c80) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e82);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_TO();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseident();
        if (s5 === peg$FAILED) {
          if (input.substr(peg$currPos, 12).toLowerCase() === peg$c81) {
            s5 = input.substr(peg$currPos, 12);
            peg$currPos += 12;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e83);
            }
          }
          if (s5 === peg$FAILED) {
            if (input.substr(peg$currPos, 12).toLowerCase() === peg$c82) {
              s5 = input.substr(peg$currPos, 12);
              peg$currPos += 12;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e84);
              }
            }
            if (s5 === peg$FAILED) {
              if (input.substr(peg$currPos, 12).toLowerCase() === peg$c83) {
                s5 = input.substr(peg$currPos, 12);
                peg$currPos += 12;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e85);
                }
              }
            }
          }
        }
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f102(s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseALTER_SET_SCHEMA() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_SET();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_SCHEMA();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseident();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f103(s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseALTER_ALGORITHM() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c84) {
      s1 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e86);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_ASSIGIN_EQUAL();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      if (input.substr(peg$currPos, 7).toLowerCase() === peg$c71) {
        s5 = input.substr(peg$currPos, 7);
        peg$currPos += 7;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e73);
        }
      }
      if (s5 === peg$FAILED) {
        if (input.substr(peg$currPos, 7).toLowerCase() === peg$c85) {
          s5 = input.substr(peg$currPos, 7);
          peg$currPos += 7;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e87);
          }
        }
        if (s5 === peg$FAILED) {
          if (input.substr(peg$currPos, 7).toLowerCase() === peg$c86) {
            s5 = input.substr(peg$currPos, 7);
            peg$currPos += 7;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e88);
            }
          }
          if (s5 === peg$FAILED) {
            if (input.substr(peg$currPos, 4).toLowerCase() === peg$c87) {
              s5 = input.substr(peg$currPos, 4);
              peg$currPos += 4;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e89);
              }
            }
          }
        }
      }
      if (s5 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f104(s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseALTER_LOCK() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c88) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e90);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_ASSIGIN_EQUAL();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      if (input.substr(peg$currPos, 7).toLowerCase() === peg$c71) {
        s5 = input.substr(peg$currPos, 7);
        peg$currPos += 7;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e73);
        }
      }
      if (s5 === peg$FAILED) {
        if (input.substr(peg$currPos, 4).toLowerCase() === peg$c60) {
          s5 = input.substr(peg$currPos, 4);
          peg$currPos += 4;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e62);
          }
        }
        if (s5 === peg$FAILED) {
          if (input.substr(peg$currPos, 6).toLowerCase() === peg$c89) {
            s5 = input.substr(peg$currPos, 6);
            peg$currPos += 6;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e91);
            }
          }
          if (s5 === peg$FAILED) {
            if (input.substr(peg$currPos, 9).toLowerCase() === peg$c90) {
              s5 = input.substr(peg$currPos, 9);
              peg$currPos += 9;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e92);
              }
            }
          }
        }
      }
      if (s5 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f105(s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_index_definition() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10;

    s0 = peg$currPos;
    s1 = peg$parseKW_INDEX();
    if (s1 === peg$FAILED) {
      s1 = peg$parseKW_KEY();
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsecolumn();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseindex_type();
      if (s5 === peg$FAILED) {
        s5 = null;
      }
      s6 = peg$parse__();
      s7 = peg$parsecte_column_definition();
      if (s7 !== peg$FAILED) {
        s8 = peg$parse__();
        s9 = peg$parseindex_options();
        if (s9 === peg$FAILED) {
          s9 = null;
        }
        s10 = peg$parse__();
        peg$savedPos = s0;
        s0 = peg$f106(s1, s3, s5, s7, s9);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_fulltext_spatial_index_definition() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10;

    s0 = peg$currPos;
    s1 = peg$parseKW_FULLTEXT();
    if (s1 === peg$FAILED) {
      s1 = peg$parseKW_SPATIAL();
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_INDEX();
      if (s3 === peg$FAILED) {
        s3 = peg$parseKW_KEY();
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parsecolumn();
      if (s5 === peg$FAILED) {
        s5 = null;
      }
      s6 = peg$parse__();
      s7 = peg$parsecte_column_definition();
      if (s7 !== peg$FAILED) {
        s8 = peg$parse__();
        s9 = peg$parseindex_options();
        if (s9 === peg$FAILED) {
          s9 = null;
        }
        s10 = peg$parse__();
        peg$savedPos = s0;
        s0 = peg$f107(s1, s3, s5, s7, s9);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_constraint_definition() {
    var s0;

    s0 = peg$parsecreate_constraint_primary();
    if (s0 === peg$FAILED) {
      s0 = peg$parsecreate_constraint_unique();
      if (s0 === peg$FAILED) {
        s0 = peg$parsecreate_constraint_foreign();
        if (s0 === peg$FAILED) {
          s0 = peg$parsecreate_constraint_check();
        }
      }
    }

    return s0;
  }

  function peg$parseconstraint_name() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_CONSTRAINT();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseident();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f108(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_constraint_check() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parseconstraint_name();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c6) {
      s3 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s3 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e6);
      }
    }
    if (s3 !== peg$FAILED) {
      s4 = peg$parse__();
      s5 = peg$parseLPAREN();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseor_and_where_expr();
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s9 = peg$parseRPAREN();
          if (s9 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f109(s1, s3, s7);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_constraint_primary() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parseconstraint_name();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    if (input.substr(peg$currPos, 11).toLowerCase() === peg$c91) {
      s3 = input.substr(peg$currPos, 11);
      peg$currPos += 11;
    } else {
      s3 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e93);
      }
    }
    if (s3 !== peg$FAILED) {
      s4 = peg$parse__();
      s5 = peg$parseindex_type();
      if (s5 === peg$FAILED) {
        s5 = null;
      }
      s6 = peg$parse__();
      s7 = peg$parsecte_column_definition();
      if (s7 !== peg$FAILED) {
        s8 = peg$parse__();
        s9 = peg$parseindex_options();
        if (s9 === peg$FAILED) {
          s9 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f110(s1, s3, s5, s7, s9);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_constraint_unique() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13;

    s0 = peg$currPos;
    s1 = peg$parseconstraint_name();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    s3 = peg$parseKW_UNIQUE();
    if (s3 !== peg$FAILED) {
      s4 = peg$parse__();
      s5 = peg$parseKW_INDEX();
      if (s5 === peg$FAILED) {
        s5 = peg$parseKW_KEY();
      }
      if (s5 === peg$FAILED) {
        s5 = null;
      }
      s6 = peg$parse__();
      s7 = peg$parsecolumn();
      if (s7 === peg$FAILED) {
        s7 = null;
      }
      s8 = peg$parse__();
      s9 = peg$parseindex_type();
      if (s9 === peg$FAILED) {
        s9 = null;
      }
      s10 = peg$parse__();
      s11 = peg$parsecte_column_definition();
      if (s11 !== peg$FAILED) {
        s12 = peg$parse__();
        s13 = peg$parseindex_options();
        if (s13 === peg$FAILED) {
          s13 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f111(s1, s3, s5, s7, s9, s11, s13);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_constraint_foreign() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parseconstraint_name();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    if (input.substr(peg$currPos, 11).toLowerCase() === peg$c92) {
      s3 = input.substr(peg$currPos, 11);
      peg$currPos += 11;
    } else {
      s3 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e94);
      }
    }
    if (s3 !== peg$FAILED) {
      s4 = peg$parse__();
      s5 = peg$parsecolumn();
      if (s5 === peg$FAILED) {
        s5 = null;
      }
      s6 = peg$parse__();
      s7 = peg$parsecte_column_definition();
      if (s7 !== peg$FAILED) {
        s8 = peg$parse__();
        s9 = peg$parsereference_definition();
        if (s9 === peg$FAILED) {
          s9 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f112(s1, s3, s5, s7, s9);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsereference_definition() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;

    s0 = peg$currPos;
    s1 = peg$parseKW_REFERENCES();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsetable_name();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsecte_column_definition();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          if (input.substr(peg$currPos, 10).toLowerCase() === peg$c93) {
            s7 = input.substr(peg$currPos, 10);
            peg$currPos += 10;
          } else {
            s7 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e95);
            }
          }
          if (s7 === peg$FAILED) {
            if (input.substr(peg$currPos, 13).toLowerCase() === peg$c94) {
              s7 = input.substr(peg$currPos, 13);
              peg$currPos += 13;
            } else {
              s7 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e96);
              }
            }
            if (s7 === peg$FAILED) {
              if (input.substr(peg$currPos, 12).toLowerCase() === peg$c95) {
                s7 = input.substr(peg$currPos, 12);
                peg$currPos += 12;
              } else {
                s7 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e97);
                }
              }
            }
          }
          if (s7 === peg$FAILED) {
            s7 = null;
          }
          s8 = peg$parse__();
          s9 = peg$parseon_reference();
          if (s9 === peg$FAILED) {
            s9 = null;
          }
          s10 = peg$parse__();
          s11 = peg$parseon_reference();
          if (s11 === peg$FAILED) {
            s11 = null;
          }
          peg$savedPos = s0;
          s0 = peg$f113(s1, s3, s5, s7, s9, s11);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseon_reference();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f114(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parseon_reference() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_ON();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_DELETE();
      if (s3 === peg$FAILED) {
        s3 = peg$parseKW_UPDATE();
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsereference_option();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f115(s3, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsereference_option() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseKW_CURRENT_TIMESTAMP();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseexpr_list();
        if (s5 === peg$FAILED) {
          s5 = null;
        }
        s6 = peg$parse__();
        s7 = peg$parseRPAREN();
        if (s7 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f116(s1, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 8).toLowerCase() === peg$c76) {
        s1 = input.substr(peg$currPos, 8);
        peg$currPos += 8;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e78);
        }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 7).toLowerCase() === peg$c75) {
          s1 = input.substr(peg$currPos, 7);
          peg$currPos += 7;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e77);
          }
        }
        if (s1 === peg$FAILED) {
          if (input.substr(peg$currPos, 8).toLowerCase() === peg$c96) {
            s1 = input.substr(peg$currPos, 8);
            peg$currPos += 8;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e98);
            }
          }
          if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 9).toLowerCase() === peg$c97) {
              s1 = input.substr(peg$currPos, 9);
              peg$currPos += 9;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e99);
              }
            }
            if (s1 === peg$FAILED) {
              if (input.substr(peg$currPos, 11).toLowerCase() === peg$c98) {
                s1 = input.substr(peg$currPos, 11);
                peg$currPos += 11;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e100);
                }
              }
              if (s1 === peg$FAILED) {
                s1 = peg$parseKW_CURRENT_TIMESTAMP();
              }
            }
          }
        }
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f117(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parsecreate_constraint_trigger() {
    var s0,
      s1,
      s2,
      s3,
      s4,
      s5,
      s6,
      s7,
      s8,
      s9,
      s10,
      s11,
      s12,
      s13,
      s14,
      s15,
      s16,
      s17,
      s18,
      s19,
      s20,
      s21,
      s22,
      s23,
      s24,
      s25,
      s26,
      s27,
      s28,
      s29,
      s30,
      s31;

    s0 = peg$currPos;
    s1 = peg$parseKW_CREATE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$currPos;
      s4 = peg$parseKW_OR();
      if (s4 !== peg$FAILED) {
        s5 = peg$parse__();
        s6 = peg$parseKW_REPLACE();
        if (s6 !== peg$FAILED) {
          s4 = [s4, s5, s6];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseKW_CONSTRAINT();
      if (s5 === peg$FAILED) {
        s5 = null;
      }
      s6 = peg$parse__();
      if (input.substr(peg$currPos, 7).toLowerCase() === peg$c99) {
        s7 = input.substr(peg$currPos, 7);
        peg$currPos += 7;
      } else {
        s7 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e101);
        }
      }
      if (s7 !== peg$FAILED) {
        s8 = peg$parse__();
        s9 = peg$parseident_name();
        if (s9 !== peg$FAILED) {
          s10 = peg$parse__();
          if (input.substr(peg$currPos, 6).toLowerCase() === peg$c100) {
            s11 = input.substr(peg$currPos, 6);
            peg$currPos += 6;
          } else {
            s11 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e102);
            }
          }
          if (s11 === peg$FAILED) {
            if (input.substr(peg$currPos, 5).toLowerCase() === peg$c101) {
              s11 = input.substr(peg$currPos, 5);
              peg$currPos += 5;
            } else {
              s11 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e103);
              }
            }
            if (s11 === peg$FAILED) {
              if (input.substr(peg$currPos, 10).toLowerCase() === peg$c102) {
                s11 = input.substr(peg$currPos, 10);
                peg$currPos += 10;
              } else {
                s11 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e104);
                }
              }
            }
          }
          if (s11 !== peg$FAILED) {
            s12 = peg$parse__();
            s13 = peg$parsetrigger_event_list();
            if (s13 !== peg$FAILED) {
              s14 = peg$parse__();
              if (input.substr(peg$currPos, 2).toLowerCase() === peg$c33) {
                s15 = input.substr(peg$currPos, 2);
                peg$currPos += 2;
              } else {
                s15 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e33);
                }
              }
              if (s15 !== peg$FAILED) {
                s16 = peg$parse__();
                s17 = peg$parsetable_name();
                if (s17 !== peg$FAILED) {
                  s18 = peg$parse__();
                  s19 = peg$currPos;
                  s20 = peg$parseKW_FROM();
                  if (s20 !== peg$FAILED) {
                    s21 = peg$parse__();
                    s22 = peg$parsetable_name();
                    if (s22 !== peg$FAILED) {
                      s20 = [s20, s21, s22];
                      s19 = s20;
                    } else {
                      peg$currPos = s19;
                      s19 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s19;
                    s19 = peg$FAILED;
                  }
                  if (s19 === peg$FAILED) {
                    s19 = null;
                  }
                  s20 = peg$parse__();
                  s21 = peg$parsetrigger_deferrable();
                  if (s21 === peg$FAILED) {
                    s21 = null;
                  }
                  s22 = peg$parse__();
                  s23 = peg$parsetrigger_for_row();
                  if (s23 === peg$FAILED) {
                    s23 = null;
                  }
                  s24 = peg$parse__();
                  s25 = peg$parsetrigger_when();
                  if (s25 === peg$FAILED) {
                    s25 = null;
                  }
                  s26 = peg$parse__();
                  if (input.substr(peg$currPos, 7).toLowerCase() === peg$c103) {
                    s27 = input.substr(peg$currPos, 7);
                    peg$currPos += 7;
                  } else {
                    s27 = peg$FAILED;
                    if (peg$silentFails === 0) {
                      peg$fail(peg$e105);
                    }
                  }
                  if (s27 !== peg$FAILED) {
                    s28 = peg$parse__();
                    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c104) {
                      s29 = input.substr(peg$currPos, 9);
                      peg$currPos += 9;
                    } else {
                      s29 = peg$FAILED;
                      if (peg$silentFails === 0) {
                        peg$fail(peg$e106);
                      }
                    }
                    if (s29 === peg$FAILED) {
                      if (input.substr(peg$currPos, 8).toLowerCase() === peg$c49) {
                        s29 = input.substr(peg$currPos, 8);
                        peg$currPos += 8;
                      } else {
                        s29 = peg$FAILED;
                        if (peg$silentFails === 0) {
                          peg$fail(peg$e51);
                        }
                      }
                    }
                    if (s29 !== peg$FAILED) {
                      s30 = peg$parse__();
                      s31 = peg$parseproc_func_call();
                      if (s31 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s0 = peg$f118(s1, s3, s5, s7, s9, s11, s13, s15, s17, s19, s21, s23, s25, s27, s29, s31);
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetrigger_event() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$parseKW_INSERT();
    if (s1 === peg$FAILED) {
      s1 = peg$parseKW_DELETE();
      if (s1 === peg$FAILED) {
        s1 = peg$parseKW_TRUNCATE();
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f119(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_UPDATE();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$currPos;
        if (input.substr(peg$currPos, 2).toLowerCase() === peg$c105) {
          s4 = input.substr(peg$currPos, 2);
          peg$currPos += 2;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e107);
          }
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parse__();
          s6 = peg$parsecolumn_ref_list();
          if (s6 !== peg$FAILED) {
            s4 = [s4, s5, s6];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f120(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsetrigger_event_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsetrigger_event();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseKW_OR();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsetrigger_event();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseKW_OR();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsetrigger_event();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f121(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetrigger_deferrable() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c29) {
      s2 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e29);
      }
    }
    if (s2 === peg$FAILED) {
      s2 = null;
    }
    s3 = peg$parse__();
    if (input.substr(peg$currPos, 10).toLowerCase() === peg$c106) {
      s4 = input.substr(peg$currPos, 10);
      peg$currPos += 10;
    } else {
      s4 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e108);
      }
    }
    if (s4 !== peg$FAILED) {
      s2 = [s2, s3, s4];
      s1 = s2;
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 19).toLowerCase() === peg$c107) {
        s3 = input.substr(peg$currPos, 19);
        peg$currPos += 19;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e109);
        }
      }
      if (s3 === peg$FAILED) {
        if (input.substr(peg$currPos, 18).toLowerCase() === peg$c108) {
          s3 = input.substr(peg$currPos, 18);
          peg$currPos += 18;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e110);
          }
        }
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f122(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetrigger_for_row() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c109) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e111);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 4).toLowerCase() === peg$c110) {
        s3 = input.substr(peg$currPos, 4);
        peg$currPos += 4;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e112);
        }
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      if (input.substr(peg$currPos, 3).toLowerCase() === peg$c111) {
        s5 = input.substr(peg$currPos, 3);
        peg$currPos += 3;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e113);
        }
      }
      if (s5 === peg$FAILED) {
        if (input.substr(peg$currPos, 9).toLowerCase() === peg$c112) {
          s5 = input.substr(peg$currPos, 9);
          peg$currPos += 9;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e114);
          }
        }
      }
      if (s5 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f123(s1, s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetrigger_when() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseKW_WHEN();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseexpr();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseRPAREN();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f124(s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetable_options() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsetable_option();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 === peg$FAILED) {
        s5 = null;
      }
      s6 = peg$parse__();
      s7 = peg$parsetable_option();
      if (s7 !== peg$FAILED) {
        s4 = [s4, s5, s6, s7];
        s3 = s4;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 === peg$FAILED) {
          s5 = null;
        }
        s6 = peg$parse__();
        s7 = peg$parsetable_option();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f125(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_option_character_set_kw() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c113) {
      s1 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e115);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 3).toLowerCase() === peg$c114) {
        s3 = input.substr(peg$currPos, 3);
        peg$currPos += 3;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e116);
        }
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f126();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_option_character_set() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseKW_DEFAULT();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    s3 = peg$parsecreate_option_character_set_kw();
    if (s3 === peg$FAILED) {
      if (input.substr(peg$currPos, 7).toLowerCase() === peg$c115) {
        s3 = input.substr(peg$currPos, 7);
        peg$currPos += 7;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e117);
        }
      }
      if (s3 === peg$FAILED) {
        if (input.substr(peg$currPos, 7).toLowerCase() === peg$c116) {
          s3 = input.substr(peg$currPos, 7);
          peg$currPos += 7;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e118);
          }
        }
      }
    }
    if (s3 !== peg$FAILED) {
      s4 = peg$parse__();
      s5 = peg$parseKW_ASSIGIN_EQUAL();
      if (s5 === peg$FAILED) {
        s5 = null;
      }
      s6 = peg$parse__();
      s7 = peg$parseident_name();
      if (s7 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f127(s1, s3, s5, s7);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetable_option() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 14).toLowerCase() === peg$c64) {
      s1 = input.substr(peg$currPos, 14);
      peg$currPos += 14;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e66);
      }
    }
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 14).toLowerCase() === peg$c117) {
        s1 = input.substr(peg$currPos, 14);
        peg$currPos += 14;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e119);
        }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 14).toLowerCase() === peg$c118) {
          s1 = input.substr(peg$currPos, 14);
          peg$currPos += 14;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e120);
          }
        }
        if (s1 === peg$FAILED) {
          if (input.substr(peg$currPos, 8).toLowerCase() === peg$c119) {
            s1 = input.substr(peg$currPos, 8);
            peg$currPos += 8;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e121);
            }
          }
          if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 8).toLowerCase() === peg$c120) {
              s1 = input.substr(peg$currPos, 8);
              peg$currPos += 8;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e122);
              }
            }
            if (s1 === peg$FAILED) {
              if (input.substr(peg$currPos, 18).toLowerCase() === peg$c121) {
                s1 = input.substr(peg$currPos, 18);
                peg$currPos += 18;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e123);
                }
              }
            }
          }
        }
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_ASSIGIN_EQUAL();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseliteral_numeric();
      if (s5 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f128(s1, s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parsecreate_option_character_set();
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseKW_COMMENT();
        if (s1 === peg$FAILED) {
          if (input.substr(peg$currPos, 10).toLowerCase() === peg$c122) {
            s1 = input.substr(peg$currPos, 10);
            peg$currPos += 10;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e124);
            }
          }
        }
        if (s1 !== peg$FAILED) {
          s2 = peg$parse__();
          s3 = peg$parseKW_ASSIGIN_EQUAL();
          if (s3 === peg$FAILED) {
            s3 = null;
          }
          s4 = peg$parse__();
          s5 = peg$parseliteral_string();
          if (s5 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f129(s1, s3, s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.substr(peg$currPos, 11).toLowerCase() === peg$c123) {
            s1 = input.substr(peg$currPos, 11);
            peg$currPos += 11;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e125);
            }
          }
          if (s1 !== peg$FAILED) {
            s2 = peg$parse__();
            s3 = peg$parseKW_ASSIGIN_EQUAL();
            if (s3 === peg$FAILED) {
              s3 = null;
            }
            s4 = peg$parse__();
            s5 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 39) {
              s6 = peg$c124;
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e126);
              }
            }
            if (s6 !== peg$FAILED) {
              if (input.substr(peg$currPos, 4).toLowerCase() === peg$c125) {
                s7 = input.substr(peg$currPos, 4);
                peg$currPos += 4;
              } else {
                s7 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e127);
                }
              }
              if (s7 === peg$FAILED) {
                if (input.substr(peg$currPos, 3).toLowerCase() === peg$c126) {
                  s7 = input.substr(peg$currPos, 3);
                  peg$currPos += 3;
                } else {
                  s7 = peg$FAILED;
                  if (peg$silentFails === 0) {
                    peg$fail(peg$e128);
                  }
                }
                if (s7 === peg$FAILED) {
                  if (input.substr(peg$currPos, 4).toLowerCase() === peg$c60) {
                    s7 = input.substr(peg$currPos, 4);
                    peg$currPos += 4;
                  } else {
                    s7 = peg$FAILED;
                    if (peg$silentFails === 0) {
                      peg$fail(peg$e62);
                    }
                  }
                }
              }
              if (s7 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 39) {
                  s8 = peg$c124;
                  peg$currPos++;
                } else {
                  s8 = peg$FAILED;
                  if (peg$silentFails === 0) {
                    peg$fail(peg$e126);
                  }
                }
                if (s8 !== peg$FAILED) {
                  s6 = [s6, s7, s8];
                  s5 = s6;
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            if (s5 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f130(s1, s3, s5);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 6).toLowerCase() === peg$c127) {
              s1 = input.substr(peg$currPos, 6);
              peg$currPos += 6;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e129);
              }
            }
            if (s1 !== peg$FAILED) {
              s2 = peg$parse__();
              s3 = peg$parseKW_ASSIGIN_EQUAL();
              if (s3 === peg$FAILED) {
                s3 = null;
              }
              s4 = peg$parse__();
              s5 = peg$parseident_name();
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s0 = peg$f131(s1, s3, s5);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parseALTER_ADD_FULLETXT_SPARITAL_INDEX() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_ADD();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsecreate_fulltext_spatial_index_definition();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f132(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parserename_stmt() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_RENAME();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_TABLE();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsetable_to_list();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f133(s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseset_stmt() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_SET();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_GLOBAL();
      if (s3 === peg$FAILED) {
        s3 = peg$parseKW_SESSION();
        if (s3 === peg$FAILED) {
          s3 = peg$parseKW_LOCAL();
          if (s3 === peg$FAILED) {
            s3 = peg$parseKW_PERSIST();
            if (s3 === peg$FAILED) {
              s3 = peg$parseKW_PERSIST_ONLY();
            }
          }
        }
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseassign_stmt();
      if (s5 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f134(s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parselock_mode() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c128) {
      s1 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e130);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 12).toLowerCase() === peg$c129) {
        s3 = input.substr(peg$currPos, 12);
        peg$currPos += 12;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e131);
        }
      }
      if (s3 === peg$FAILED) {
        if (input.substr(peg$currPos, 9).toLowerCase() === peg$c130) {
          s3 = input.substr(peg$currPos, 9);
          peg$currPos += 9;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e132);
          }
        }
        if (s3 === peg$FAILED) {
          if (input.substr(peg$currPos, 13).toLowerCase() === peg$c131) {
            s3 = input.substr(peg$currPos, 13);
            peg$currPos += 13;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e133);
            }
          }
          if (s3 === peg$FAILED) {
            if (input.substr(peg$currPos, 22).toLowerCase() === peg$c132) {
              s3 = input.substr(peg$currPos, 22);
              peg$currPos += 22;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e134);
              }
            }
            if (s3 === peg$FAILED) {
              if (input.substr(peg$currPos, 19).toLowerCase() === peg$c133) {
                s3 = input.substr(peg$currPos, 19);
                peg$currPos += 19;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e135);
                }
              }
              if (s3 === peg$FAILED) {
                if (input.substr(peg$currPos, 9).toLowerCase() === peg$c90) {
                  s3 = input.substr(peg$currPos, 9);
                  peg$currPos += 9;
                } else {
                  s3 = peg$FAILED;
                  if (peg$silentFails === 0) {
                    peg$fail(peg$e92);
                  }
                }
                if (s3 === peg$FAILED) {
                  if (input.substr(peg$currPos, 16).toLowerCase() === peg$c134) {
                    s3 = input.substr(peg$currPos, 16);
                    peg$currPos += 16;
                  } else {
                    s3 = peg$FAILED;
                    if (peg$silentFails === 0) {
                      peg$fail(peg$e136);
                    }
                  }
                  if (s3 === peg$FAILED) {
                    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c135) {
                      s3 = input.substr(peg$currPos, 5);
                      peg$currPos += 5;
                    } else {
                      s3 = peg$FAILED;
                      if (peg$silentFails === 0) {
                        peg$fail(peg$e137);
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        if (input.substr(peg$currPos, 4).toLowerCase() === peg$c136) {
          s5 = input.substr(peg$currPos, 4);
          peg$currPos += 4;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e138);
          }
        }
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f135(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parselock_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parseKW_LOCK();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_TABLE();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parsetable_ref_list();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parselock_mode();
        if (s7 === peg$FAILED) {
          s7 = null;
        }
        s8 = peg$parse__();
        if (input.substr(peg$currPos, 6).toLowerCase() === peg$c137) {
          s9 = input.substr(peg$currPos, 6);
          peg$currPos += 6;
        } else {
          s9 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e139);
          }
        }
        if (s9 === peg$FAILED) {
          s9 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f136(s3, s5, s7, s9);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecall_stmt() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_CALL();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseproc_func_call();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f137(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseshow_stmt() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_SHOW();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 6).toLowerCase() === peg$c138) {
        s3 = input.substr(peg$currPos, 6);
        peg$currPos += 6;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e140);
        }
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f138();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_SHOW();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parsewithout_prefix_var_decl();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f139(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsedeallocate_stmt() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_DEALLOCATE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 7).toLowerCase() === peg$c139) {
        s3 = input.substr(peg$currPos, 7);
        peg$currPos += 7;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e141);
        }
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseident_name();
      if (s5 === peg$FAILED) {
        s5 = peg$parseKW_ALL();
      }
      if (s5 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f140(s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsepriv_type_table() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_SELECT();
    if (s1 === peg$FAILED) {
      s1 = peg$parseKW_INSERT();
      if (s1 === peg$FAILED) {
        s1 = peg$parseKW_UPDATE();
        if (s1 === peg$FAILED) {
          s1 = peg$parseKW_DELETE();
          if (s1 === peg$FAILED) {
            s1 = peg$parseKW_TRUNCATE();
            if (s1 === peg$FAILED) {
              s1 = peg$parseKW_REFERENCES();
              if (s1 === peg$FAILED) {
                if (input.substr(peg$currPos, 7).toLowerCase() === peg$c99) {
                  s1 = input.substr(peg$currPos, 7);
                  peg$currPos += 7;
                } else {
                  s1 = peg$FAILED;
                  if (peg$silentFails === 0) {
                    peg$fail(peg$e101);
                  }
                }
              }
            }
          }
        }
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f141(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsepriv_type_sequence() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c140) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e142);
      }
    }
    if (s1 === peg$FAILED) {
      s1 = peg$parseKW_SELECT();
      if (s1 === peg$FAILED) {
        s1 = peg$parseKW_UPDATE();
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f142(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsepriv_type_database() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_CREATE();
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 7).toLowerCase() === peg$c141) {
        s1 = input.substr(peg$currPos, 7);
        peg$currPos += 7;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e143);
        }
      }
      if (s1 === peg$FAILED) {
        s1 = peg$parseKW_TEMPORARY();
        if (s1 === peg$FAILED) {
          s1 = peg$parseKW_TEMP();
        }
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f143(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parseprive_type_all() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$parseKW_ALL();
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$parse__();
      if (input.substr(peg$currPos, 10).toLowerCase() === peg$c142) {
        s4 = input.substr(peg$currPos, 10);
        peg$currPos += 10;
      } else {
        s4 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e144);
        }
      }
      if (s4 !== peg$FAILED) {
        s3 = [s3, s4];
        s2 = s3;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f144(s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseprive_type_usage() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c140) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e142);
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f145(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$parseprive_type_all();
    }

    return s0;
  }

  function peg$parseprive_type_execute() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c103) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e105);
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f146(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$parseprive_type_all();
    }

    return s0;
  }

  function peg$parsepriv_type() {
    var s0;

    s0 = peg$parsepriv_type_table();
    if (s0 === peg$FAILED) {
      s0 = peg$parsepriv_type_sequence();
      if (s0 === peg$FAILED) {
        s0 = peg$parsepriv_type_database();
        if (s0 === peg$FAILED) {
          s0 = peg$parseprive_type_usage();
          if (s0 === peg$FAILED) {
            s0 = peg$parseprive_type_execute();
          }
        }
      }
    }

    return s0;
  }

  function peg$parsepriv_item() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8;

    s0 = peg$currPos;
    s1 = peg$parsepriv_type();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$currPos;
      s4 = peg$parseLPAREN();
      if (s4 !== peg$FAILED) {
        s5 = peg$parse__();
        s6 = peg$parsecolumn_ref_list();
        if (s6 !== peg$FAILED) {
          s7 = peg$parse__();
          s8 = peg$parseRPAREN();
          if (s8 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7, s8];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f147(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsepriv_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsepriv_item();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsepriv_item();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsepriv_item();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f148(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseobject_type() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseKW_TABLE();
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 8).toLowerCase() === peg$c143) {
        s1 = input.substr(peg$currPos, 8);
        peg$currPos += 8;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e145);
        }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 8).toLowerCase() === peg$c144) {
          s1 = input.substr(peg$currPos, 8);
          peg$currPos += 8;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e146);
          }
        }
        if (s1 === peg$FAILED) {
          if (input.substr(peg$currPos, 6) === peg$c145) {
            s1 = peg$c145;
            peg$currPos += 6;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e147);
            }
          }
          if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 8) === peg$c146) {
              s1 = peg$c146;
              peg$currPos += 8;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e148);
              }
            }
            if (s1 === peg$FAILED) {
              if (input.substr(peg$currPos, 9).toLowerCase() === peg$c104) {
                s1 = input.substr(peg$currPos, 9);
                peg$currPos += 9;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e106);
                }
              }
              if (s1 === peg$FAILED) {
                if (input.substr(peg$currPos, 7).toLowerCase() === peg$c147) {
                  s1 = input.substr(peg$currPos, 7);
                  peg$currPos += 7;
                } else {
                  s1 = peg$FAILED;
                  if (peg$silentFails === 0) {
                    peg$fail(peg$e149);
                  }
                }
                if (s1 === peg$FAILED) {
                  if (input.substr(peg$currPos, 8).toLowerCase() === peg$c148) {
                    s1 = input.substr(peg$currPos, 8);
                    peg$currPos += 8;
                  } else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                      peg$fail(peg$e150);
                    }
                  }
                  if (s1 === peg$FAILED) {
                    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c149) {
                      s1 = input.substr(peg$currPos, 5);
                      peg$currPos += 5;
                    } else {
                      s1 = peg$FAILED;
                      if (peg$silentFails === 0) {
                        peg$fail(peg$e151);
                      }
                    }
                    if (s1 === peg$FAILED) {
                      if (input.substr(peg$currPos, 6) === peg$c150) {
                        s1 = peg$c150;
                        peg$currPos += 6;
                      } else {
                        s1 = peg$FAILED;
                        if (peg$silentFails === 0) {
                          peg$fail(peg$e152);
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f149(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_ALL();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        if (input.substr(peg$currPos, 6).toLowerCase() === peg$c138) {
          s3 = input.substr(peg$currPos, 6);
          peg$currPos += 6;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e140);
          }
        }
        if (s3 === peg$FAILED) {
          if (input.substr(peg$currPos, 8).toLowerCase() === peg$c143) {
            s3 = input.substr(peg$currPos, 8);
            peg$currPos += 8;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e145);
            }
          }
          if (s3 === peg$FAILED) {
            if (input.substr(peg$currPos, 9).toLowerCase() === peg$c151) {
              s3 = input.substr(peg$currPos, 9);
              peg$currPos += 9;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e153);
              }
            }
            if (s3 === peg$FAILED) {
              if (input.substr(peg$currPos, 10).toLowerCase() === peg$c152) {
                s3 = input.substr(peg$currPos, 10);
                peg$currPos += 10;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e154);
                }
              }
              if (s3 === peg$FAILED) {
                if (input.substr(peg$currPos, 8).toLowerCase() === peg$c153) {
                  s3 = input.substr(peg$currPos, 8);
                  peg$currPos += 8;
                } else {
                  s3 = peg$FAILED;
                  if (peg$silentFails === 0) {
                    peg$fail(peg$e155);
                  }
                }
              }
            }
          }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parseKW_IN();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse__();
            s7 = peg$parseKW_SCHEMA();
            if (s7 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f150(s3);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsepriv_level() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseident();
    if (s2 !== peg$FAILED) {
      s3 = peg$parse__();
      s4 = peg$parseDOT();
      if (s4 !== peg$FAILED) {
        s2 = [s2, s3, s4];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    s3 = peg$parseident();
    if (s3 === peg$FAILED) {
      s3 = peg$parseSTAR();
    }
    if (s3 !== peg$FAILED) {
      peg$savedPos = s0;
      s0 = peg$f151(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsepriv_level_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsepriv_level();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsepriv_level();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsepriv_level();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f152(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseuser_or_role() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_GROUP();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    s3 = peg$parseident();
    if (s3 !== peg$FAILED) {
      peg$savedPos = s0;
      s0 = peg$f153(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 6).toLowerCase() === peg$c154) {
        s1 = input.substr(peg$currPos, 6);
        peg$currPos += 6;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e156);
        }
      }
      if (s1 === peg$FAILED) {
        s1 = peg$parseKW_CURRENT_ROLE();
        if (s1 === peg$FAILED) {
          s1 = peg$parseKW_CURRENT_USER();
          if (s1 === peg$FAILED) {
            s1 = peg$parseKW_SESSION_USER();
          }
        }
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f154(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parseuser_or_role_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseuser_or_role();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseuser_or_role();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseuser_or_role();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f155(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsewith_grant_option() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_WITH();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 5).toLowerCase() === peg$c155) {
        s3 = input.substr(peg$currPos, 5);
        peg$currPos += 5;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e157);
        }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        if (input.substr(peg$currPos, 6).toLowerCase() === peg$c156) {
          s5 = input.substr(peg$currPos, 6);
          peg$currPos += 6;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e158);
          }
        }
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f156();
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsewith_admin_option() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_WITH();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 5).toLowerCase() === peg$c157) {
        s3 = input.substr(peg$currPos, 5);
        peg$currPos += 5;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e159);
        }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        if (input.substr(peg$currPos, 6).toLowerCase() === peg$c156) {
          s5 = input.substr(peg$currPos, 6);
          peg$currPos += 6;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e158);
          }
        }
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f157();
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsegrant_revoke_keyword() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c155) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e157);
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f158();
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 6).toLowerCase() === peg$c158) {
        s1 = input.substr(peg$currPos, 6);
        peg$currPos += 6;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e160);
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$currPos;
        if (input.substr(peg$currPos, 5).toLowerCase() === peg$c155) {
          s4 = input.substr(peg$currPos, 5);
          peg$currPos += 5;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e157);
          }
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parse__();
          if (input.substr(peg$currPos, 6).toLowerCase() === peg$c156) {
            s6 = input.substr(peg$currPos, 6);
            peg$currPos += 6;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e158);
            }
          }
          if (s6 !== peg$FAILED) {
            s7 = peg$parse__();
            if (input.substr(peg$currPos, 3).toLowerCase() === peg$c109) {
              s8 = input.substr(peg$currPos, 3);
              peg$currPos += 3;
            } else {
              s8 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e111);
              }
            }
            if (s8 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7, s8];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f159(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsegrant_revoke_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16;

    s0 = peg$currPos;
    s1 = peg$parsegrant_revoke_keyword();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsepriv_list();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseKW_ON();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseobject_type();
          if (s7 === peg$FAILED) {
            s7 = null;
          }
          s8 = peg$parse__();
          s9 = peg$parsepriv_level_list();
          if (s9 !== peg$FAILED) {
            s10 = peg$parse__();
            s11 = peg$parseKW_TO();
            if (s11 === peg$FAILED) {
              s11 = peg$parseKW_FROM();
            }
            if (s11 !== peg$FAILED) {
              peg$savedPos = peg$currPos;
              s12 = peg$f160(s1, s3, s7, s9, s11);
              if (s12) {
                s12 = undefined;
              } else {
                s12 = peg$FAILED;
              }
              if (s12 !== peg$FAILED) {
                s13 = peg$parse__();
                s14 = peg$parseuser_or_role_list();
                if (s14 !== peg$FAILED) {
                  s15 = peg$parse__();
                  s16 = peg$parsewith_grant_option();
                  if (s16 === peg$FAILED) {
                    s16 = null;
                  }
                  peg$savedPos = s0;
                  s0 = peg$f161(s1, s3, s7, s9, s11, s14, s16);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsegrant_revoke_keyword();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseident_list();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parseKW_TO();
          if (s5 === peg$FAILED) {
            s5 = peg$parseKW_FROM();
          }
          if (s5 !== peg$FAILED) {
            peg$savedPos = peg$currPos;
            s6 = peg$f162(s1, s3, s5);
            if (s6) {
              s6 = undefined;
            } else {
              s6 = peg$FAILED;
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parse__();
              s8 = peg$parseuser_or_role_list();
              if (s8 !== peg$FAILED) {
                s9 = peg$parse__();
                s10 = peg$parsewith_admin_option();
                if (s10 === peg$FAILED) {
                  s10 = null;
                }
                peg$savedPos = s0;
                s0 = peg$f163(s1, s3, s5, s8, s10);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseelseif_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c159) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e161);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseexpr();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        if (input.substr(peg$currPos, 4).toLowerCase() === peg$c160) {
          s5 = input.substr(peg$currPos, 4);
          peg$currPos += 4;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e162);
          }
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsecrud_stmt();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseSEMICOLON();
            if (s9 === peg$FAILED) {
              s9 = null;
            }
            peg$savedPos = s0;
            s0 = peg$f164(s3, s7, s9);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseelseif_stmt_list() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseelseif_stmt();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseelseif_stmt();
      if (s5 !== peg$FAILED) {
        s4 = [s4, s5];
        s3 = s4;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseelseif_stmt();
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f165(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseif_else_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c0) {
      s1 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e0);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseexpr();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        if (input.substr(peg$currPos, 4).toLowerCase() === peg$c160) {
          s5 = input.substr(peg$currPos, 4);
          peg$currPos += 4;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e162);
          }
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsecrud_stmt();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseSEMICOLON();
            if (s9 === peg$FAILED) {
              s9 = null;
            }
            s10 = peg$parse__();
            s11 = peg$parseelseif_stmt_list();
            if (s11 === peg$FAILED) {
              s11 = null;
            }
            s12 = peg$parse__();
            s13 = peg$currPos;
            s14 = peg$parseKW_ELSE();
            if (s14 !== peg$FAILED) {
              s15 = peg$parse__();
              s16 = peg$parsecrud_stmt();
              if (s16 !== peg$FAILED) {
                s14 = [s14, s15, s16];
                s13 = s14;
              } else {
                peg$currPos = s13;
                s13 = peg$FAILED;
              }
            } else {
              peg$currPos = s13;
              s13 = peg$FAILED;
            }
            if (s13 === peg$FAILED) {
              s13 = null;
            }
            s14 = peg$parse__();
            s15 = peg$parseSEMICOLON();
            if (s15 === peg$FAILED) {
              s15 = null;
            }
            s16 = peg$parse__();
            if (input.substr(peg$currPos, 3).toLowerCase() === peg$c161) {
              s17 = input.substr(peg$currPos, 3);
              peg$currPos += 3;
            } else {
              s17 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e163);
              }
            }
            if (s17 !== peg$FAILED) {
              s18 = peg$parse__();
              if (input.substr(peg$currPos, 2).toLowerCase() === peg$c0) {
                s19 = input.substr(peg$currPos, 2);
                peg$currPos += 2;
              } else {
                s19 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e0);
                }
              }
              if (s19 !== peg$FAILED) {
                peg$savedPos = s0;
                s0 = peg$f166(s3, s7, s9, s11, s13, s15);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseraise_level() {
    var s0;

    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c162) {
      s0 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e164);
      }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 3).toLowerCase() === peg$c163) {
        s0 = input.substr(peg$currPos, 3);
        peg$currPos += 3;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e165);
        }
      }
      if (s0 === peg$FAILED) {
        if (input.substr(peg$currPos, 4).toLowerCase() === peg$c164) {
          s0 = input.substr(peg$currPos, 4);
          peg$currPos += 4;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e166);
          }
        }
        if (s0 === peg$FAILED) {
          if (input.substr(peg$currPos, 6).toLowerCase() === peg$c165) {
            s0 = input.substr(peg$currPos, 6);
            peg$currPos += 6;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e167);
            }
          }
          if (s0 === peg$FAILED) {
            if (input.substr(peg$currPos, 7).toLowerCase() === peg$c166) {
              s0 = input.substr(peg$currPos, 7);
              peg$currPos += 7;
            } else {
              s0 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e168);
              }
            }
            if (s0 === peg$FAILED) {
              if (input.substr(peg$currPos, 9).toLowerCase() === peg$c167) {
                s0 = input.substr(peg$currPos, 9);
                peg$currPos += 9;
              } else {
                s0 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e169);
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parseraise_opt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13;

    s0 = peg$currPos;
    s1 = peg$parseKW_USING();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 7).toLowerCase() === peg$c168) {
        s3 = input.substr(peg$currPos, 7);
        peg$currPos += 7;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e170);
        }
      }
      if (s3 === peg$FAILED) {
        if (input.substr(peg$currPos, 6).toLowerCase() === peg$c169) {
          s3 = input.substr(peg$currPos, 6);
          peg$currPos += 6;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e171);
          }
        }
        if (s3 === peg$FAILED) {
          if (input.substr(peg$currPos, 4).toLowerCase() === peg$c170) {
            s3 = input.substr(peg$currPos, 4);
            peg$currPos += 4;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e172);
            }
          }
          if (s3 === peg$FAILED) {
            if (input.substr(peg$currPos, 7).toLowerCase() === peg$c171) {
              s3 = input.substr(peg$currPos, 7);
              peg$currPos += 7;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e173);
              }
            }
            if (s3 === peg$FAILED) {
              if (input.substr(peg$currPos, 6).toLowerCase() === peg$c172) {
                s3 = input.substr(peg$currPos, 6);
                peg$currPos += 6;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e174);
                }
              }
              if (s3 === peg$FAILED) {
                if (input.substr(peg$currPos, 10).toLowerCase() === peg$c173) {
                  s3 = input.substr(peg$currPos, 10);
                  peg$currPos += 10;
                } else {
                  s3 = peg$FAILED;
                  if (peg$silentFails === 0) {
                    peg$fail(peg$e175);
                  }
                }
                if (s3 === peg$FAILED) {
                  if (input.substr(peg$currPos, 8).toLowerCase() === peg$c174) {
                    s3 = input.substr(peg$currPos, 8);
                    peg$currPos += 8;
                  } else {
                    s3 = peg$FAILED;
                    if (peg$silentFails === 0) {
                      peg$fail(peg$e176);
                    }
                  }
                  if (s3 === peg$FAILED) {
                    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c175) {
                      s3 = input.substr(peg$currPos, 5);
                      peg$currPos += 5;
                    } else {
                      s3 = peg$FAILED;
                      if (peg$silentFails === 0) {
                        peg$fail(peg$e177);
                      }
                    }
                    if (s3 === peg$FAILED) {
                      if (input.substr(peg$currPos, 6).toLowerCase() === peg$c2) {
                        s3 = input.substr(peg$currPos, 6);
                        peg$currPos += 6;
                      } else {
                        s3 = peg$FAILED;
                        if (peg$silentFails === 0) {
                          peg$fail(peg$e2);
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseKW_ASSIGIN_EQUAL();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseexpr();
          if (s7 !== peg$FAILED) {
            s8 = [];
            s9 = peg$currPos;
            s10 = peg$parse__();
            s11 = peg$parseCOMMA();
            if (s11 !== peg$FAILED) {
              s12 = peg$parse__();
              s13 = peg$parseexpr();
              if (s13 !== peg$FAILED) {
                s10 = [s10, s11, s12, s13];
                s9 = s10;
              } else {
                peg$currPos = s9;
                s9 = peg$FAILED;
              }
            } else {
              peg$currPos = s9;
              s9 = peg$FAILED;
            }
            while (s9 !== peg$FAILED) {
              s8.push(s9);
              s9 = peg$currPos;
              s10 = peg$parse__();
              s11 = peg$parseCOMMA();
              if (s11 !== peg$FAILED) {
                s12 = peg$parse__();
                s13 = peg$parseexpr();
                if (s13 !== peg$FAILED) {
                  s10 = [s10, s11, s12, s13];
                  s9 = s10;
                } else {
                  peg$currPos = s9;
                  s9 = peg$FAILED;
                }
              } else {
                peg$currPos = s9;
                s9 = peg$FAILED;
              }
            }
            peg$savedPos = s0;
            s0 = peg$f167(s3, s7, s8);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseraise_item() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseliteral_string();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseproc_primary();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseproc_primary();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f168(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 8).toLowerCase() === peg$c176) {
        s1 = input.substr(peg$currPos, 8);
        peg$currPos += 8;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e178);
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseliteral_string();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f169(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseident();
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$f170(s1);
        }
        s0 = s1;
      }
    }

    return s0;
  }

  function peg$parseraise_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c177) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e179);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseraise_level();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseraise_item();
      if (s5 === peg$FAILED) {
        s5 = null;
      }
      s6 = peg$parse__();
      s7 = peg$parseraise_opt();
      if (s7 === peg$FAILED) {
        s7 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f171(s3, s5, s7);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseexecute_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c103) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e105);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseident();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$currPos;
        s6 = peg$parseLPAREN();
        if (s6 !== peg$FAILED) {
          s7 = peg$parse__();
          s8 = peg$parseproc_primary_list();
          if (s8 !== peg$FAILED) {
            s9 = peg$parse__();
            s10 = peg$parseRPAREN();
            if (s10 !== peg$FAILED) {
              s6 = [s6, s7, s8, s9, s10];
              s5 = s6;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        if (s5 === peg$FAILED) {
          s5 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f172(s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsefor_label() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c109) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e111);
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f173();
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseident();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        if (input.substr(peg$currPos, 3).toLowerCase() === peg$c109) {
          s3 = input.substr(peg$currPos, 3);
          peg$currPos += 3;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e111);
          }
        }
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f174(s1);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsefor_loop_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18;

    s0 = peg$currPos;
    s1 = peg$parsefor_label();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseident();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseKW_IN();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseselect_stmt();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            if (input.substr(peg$currPos, 4).toLowerCase() === peg$c178) {
              s9 = input.substr(peg$currPos, 4);
              peg$currPos += 4;
            } else {
              s9 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e180);
              }
            }
            if (s9 !== peg$FAILED) {
              s10 = peg$parse__();
              s11 = peg$parsemultiple_stmt();
              if (s11 !== peg$FAILED) {
                s12 = peg$parse__();
                s13 = peg$parseKW_END();
                if (s13 !== peg$FAILED) {
                  s14 = peg$parse__();
                  if (input.substr(peg$currPos, 4).toLowerCase() === peg$c178) {
                    s15 = input.substr(peg$currPos, 4);
                    peg$currPos += 4;
                  } else {
                    s15 = peg$FAILED;
                    if (peg$silentFails === 0) {
                      peg$fail(peg$e180);
                    }
                  }
                  if (s15 !== peg$FAILED) {
                    s16 = peg$parse__();
                    s17 = peg$parseident();
                    if (s17 === peg$FAILED) {
                      s17 = null;
                    }
                    peg$savedPos = peg$currPos;
                    s18 = peg$f175(s1, s3, s7, s11, s17);
                    if (s18) {
                      s18 = undefined;
                    } else {
                      s18 = peg$FAILED;
                    }
                    if (s18 !== peg$FAILED) {
                      peg$savedPos = s0;
                      s0 = peg$f176(s1, s3, s7, s11, s17);
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseselect_stmt() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$parseKW_SELECT();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.charCodeAt(peg$currPos) === 59) {
        s3 = peg$c179;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e181);
        }
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f177();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseselect_stmt_nake();
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 40) {
          s2 = peg$c180;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e182);
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parse__();
          s4 = peg$parseselect_stmt();
          if (s4 !== peg$FAILED) {
            s5 = peg$parse__();
            if (input.charCodeAt(peg$currPos) === 41) {
              s6 = peg$c181;
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e183);
              }
            }
            if (s6 !== peg$FAILED) {
              s2 = [s2, s3, s4, s5, s6];
              s1 = s2;
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$f178(s1);
        }
        s0 = s1;
      }
    }

    return s0;
  }

  function peg$parsewith_clause() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parseKW_WITH();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsecte_definition();
      if (s3 !== peg$FAILED) {
        s4 = [];
        s5 = peg$currPos;
        s6 = peg$parse__();
        s7 = peg$parseCOMMA();
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s9 = peg$parsecte_definition();
          if (s9 !== peg$FAILED) {
            s6 = [s6, s7, s8, s9];
            s5 = s6;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$currPos;
          s6 = peg$parse__();
          s7 = peg$parseCOMMA();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parsecte_definition();
            if (s9 !== peg$FAILED) {
              s6 = [s6, s7, s8, s9];
              s5 = s6;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        }
        peg$savedPos = s0;
        s0 = peg$f179(s3, s4);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parse__();
      s2 = peg$parseKW_WITH();
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        s4 = peg$parseKW_RECURSIVE();
        if (s4 !== peg$FAILED) {
          s5 = peg$parse__();
          s6 = peg$parsecte_definition();
          if (s6 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f180(s6);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsecte_definition() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;

    s0 = peg$currPos;
    s1 = peg$parseliteral_string();
    if (s1 === peg$FAILED) {
      s1 = peg$parseident_name();
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsecte_column_definition();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseKW_AS();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseLPAREN();
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s9 = peg$parsecrud_stmt();
          if (s9 !== peg$FAILED) {
            s10 = peg$parse__();
            s11 = peg$parseRPAREN();
            if (s11 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f181(s1, s3, s9);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecte_column_definition() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseLPAREN();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsecolumn_ref_list();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseRPAREN();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f182(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedistinct_on() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parseKW_DISTINCT();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_ON();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseLPAREN();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsecolumn_ref_list();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseRPAREN();
            if (s9 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f183(s1, s3, s7);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_DISTINCT();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      peg$savedPos = s0;
      s1 = peg$f184(s1);
      s0 = s1;
    }

    return s0;
  }

  function peg$parseselect_stmt_nake() {
    var s0,
      s1,
      s2,
      s3,
      s4,
      s5,
      s6,
      s7,
      s8,
      s9,
      s10,
      s11,
      s12,
      s13,
      s14,
      s15,
      s16,
      s17,
      s18,
      s19,
      s20,
      s21,
      s22,
      s23,
      s24,
      s25,
      s26,
      s27,
      s28,
      s29,
      s30;

    s0 = peg$currPos;
    s1 = peg$parse__();
    s2 = peg$parsewith_clause();
    if (s2 === peg$FAILED) {
      s2 = null;
    }
    s3 = peg$parse__();
    s4 = peg$parseKW_SELECT();
    if (s4 !== peg$FAILED) {
      s5 = peg$parse___();
      if (s5 !== peg$FAILED) {
        s6 = peg$parseoption_clause();
        if (s6 === peg$FAILED) {
          s6 = null;
        }
        s7 = peg$parse__();
        s8 = peg$parsedistinct_on();
        if (s8 === peg$FAILED) {
          s8 = null;
        }
        s9 = peg$parse__();
        s10 = peg$parsecolumn_clause();
        if (s10 !== peg$FAILED) {
          s11 = peg$parse__();
          s12 = peg$parseinto_clause();
          if (s12 === peg$FAILED) {
            s12 = null;
          }
          s13 = peg$parse__();
          s14 = peg$parsefrom_clause();
          if (s14 === peg$FAILED) {
            s14 = null;
          }
          s15 = peg$parse__();
          s16 = peg$parseinto_clause();
          if (s16 === peg$FAILED) {
            s16 = null;
          }
          s17 = peg$parse__();
          s18 = peg$parsewhere_clause();
          if (s18 === peg$FAILED) {
            s18 = null;
          }
          s19 = peg$parse__();
          s20 = peg$parsegroup_by_clause();
          if (s20 === peg$FAILED) {
            s20 = null;
          }
          s21 = peg$parse__();
          s22 = peg$parsehaving_clause();
          if (s22 === peg$FAILED) {
            s22 = null;
          }
          s23 = peg$parse__();
          s24 = peg$parseorder_by_clause();
          if (s24 === peg$FAILED) {
            s24 = null;
          }
          s25 = peg$parse__();
          s26 = peg$parselimit_clause();
          s27 = peg$parse__();
          s28 = peg$parsewindow_clause();
          if (s28 === peg$FAILED) {
            s28 = null;
          }
          s29 = peg$parse__();
          s30 = peg$parseinto_clause();
          if (s30 === peg$FAILED) {
            s30 = null;
          }
          peg$savedPos = s0;
          s0 = peg$f185(s2, s6, s8, s10, s12, s14, s16, s18, s20, s22, s24, s26, s28, s30);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseoption_clause() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsequery_option();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parsequery_option();
      if (s5 !== peg$FAILED) {
        s4 = [s4, s5];
        s3 = s4;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parsequery_option();
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f186(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsequery_option() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseOPT_SQL_CALC_FOUND_ROWS();
    if (s1 === peg$FAILED) {
      s1 = peg$parseOPT_SQL_CACHE();
      if (s1 === peg$FAILED) {
        s1 = peg$parseOPT_SQL_NO_CACHE();
      }
      if (s1 === peg$FAILED) {
        s1 = peg$parseOPT_SQL_BIG_RESULT();
        if (s1 === peg$FAILED) {
          s1 = peg$parseOPT_SQL_SMALL_RESULT();
          if (s1 === peg$FAILED) {
            s1 = peg$parseOPT_SQL_BUFFER_RESULT();
          }
        }
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f187(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsecolumn_clause() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseKW_ALL();
    if (s1 === peg$FAILED) {
      s1 = peg$currPos;
      s2 = peg$parseSTAR();
      if (s2 !== peg$FAILED) {
        s3 = peg$currPos;
        peg$silentFails++;
        s4 = peg$parseident_start();
        peg$silentFails--;
        if (s4 === peg$FAILED) {
          s3 = undefined;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          s2 = [s2, s3];
          s1 = s2;
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
      if (s1 === peg$FAILED) {
        s1 = peg$parseSTAR();
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsecolumn_list_item();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsecolumn_list_item();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f188(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsecolumn_list_item();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsecolumn_list_item();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          s4 = peg$parse__();
          s5 = peg$parseCOMMA();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse__();
            s7 = peg$parsecolumn_list_item();
            if (s7 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
        peg$savedPos = s0;
        s0 = peg$f189(s1, s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsearray_index() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseLBRAKE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseliteral_numeric();
      if (s3 === peg$FAILED) {
        s3 = peg$parseliteral_string();
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseRBRAKE();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f190(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseexpr_item() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsebinary_column_expr();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsearray_index();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f191(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecast_data_type() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 34) {
      s1 = peg$c182;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e184);
      }
    }
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parsedata_type();
    if (s2 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 34) {
        s3 = peg$c182;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e184);
        }
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f192(s1, s2, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecolumn_list_item() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14;

    s0 = peg$currPos;
    s1 = peg$parsestring_constants_escape();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f193(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseexpr_item();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseKW_DOUBLE_COLON();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parsecast_data_type();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse__();
            s7 = [];
            s8 = peg$currPos;
            s9 = peg$parseDOUBLE_ARROW();
            if (s9 === peg$FAILED) {
              s9 = peg$parseSINGLE_ARROW();
            }
            if (s9 !== peg$FAILED) {
              s10 = peg$parse__();
              s11 = peg$parseliteral_string();
              if (s11 === peg$FAILED) {
                s11 = peg$parseliteral_numeric();
              }
              if (s11 !== peg$FAILED) {
                s9 = [s9, s10, s11];
                s8 = s9;
              } else {
                peg$currPos = s8;
                s8 = peg$FAILED;
              }
            } else {
              peg$currPos = s8;
              s8 = peg$FAILED;
            }
            while (s8 !== peg$FAILED) {
              s7.push(s8);
              s8 = peg$currPos;
              s9 = peg$parseDOUBLE_ARROW();
              if (s9 === peg$FAILED) {
                s9 = peg$parseSINGLE_ARROW();
              }
              if (s9 !== peg$FAILED) {
                s10 = peg$parse__();
                s11 = peg$parseliteral_string();
                if (s11 === peg$FAILED) {
                  s11 = peg$parseliteral_numeric();
                }
                if (s11 !== peg$FAILED) {
                  s9 = [s9, s10, s11];
                  s8 = s9;
                } else {
                  peg$currPos = s8;
                  s8 = peg$FAILED;
                }
              } else {
                peg$currPos = s8;
                s8 = peg$FAILED;
              }
            }
            s8 = peg$parse__();
            s9 = [];
            s10 = peg$currPos;
            s11 = peg$parse__();
            s12 = peg$parseadditive_operator();
            if (s12 === peg$FAILED) {
              s12 = peg$parsemultiplicative_operator();
            }
            if (s12 !== peg$FAILED) {
              s13 = peg$parse__();
              s14 = peg$parseexpr_item();
              if (s14 !== peg$FAILED) {
                s11 = [s11, s12, s13, s14];
                s10 = s11;
              } else {
                peg$currPos = s10;
                s10 = peg$FAILED;
              }
            } else {
              peg$currPos = s10;
              s10 = peg$FAILED;
            }
            while (s10 !== peg$FAILED) {
              s9.push(s10);
              s10 = peg$currPos;
              s11 = peg$parse__();
              s12 = peg$parseadditive_operator();
              if (s12 === peg$FAILED) {
                s12 = peg$parsemultiplicative_operator();
              }
              if (s12 !== peg$FAILED) {
                s13 = peg$parse__();
                s14 = peg$parseexpr_item();
                if (s14 !== peg$FAILED) {
                  s11 = [s11, s12, s13, s14];
                  s10 = s11;
                } else {
                  peg$currPos = s10;
                  s10 = peg$FAILED;
                }
              } else {
                peg$currPos = s10;
                s10 = peg$FAILED;
              }
            }
            s10 = peg$parse__();
            s11 = peg$parsealias_clause();
            if (s11 === peg$FAILED) {
              s11 = null;
            }
            peg$savedPos = s0;
            s0 = peg$f194(s1, s3, s5, s7, s9, s11);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseident();
        if (s1 !== peg$FAILED) {
          s2 = peg$parse__();
          s3 = peg$parseDOT();
          if (s3 !== peg$FAILED) {
            s4 = peg$currPos;
            s5 = peg$parseident();
            if (s5 !== peg$FAILED) {
              s6 = peg$parse__();
              s7 = peg$parseDOT();
              if (s7 !== peg$FAILED) {
                s5 = [s5, s6, s7];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
            if (s4 === peg$FAILED) {
              s4 = null;
            }
            s5 = peg$parse__();
            s6 = peg$parseSTAR();
            if (s6 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f195(s1, s4);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$currPos;
          s2 = peg$parseident();
          if (s2 !== peg$FAILED) {
            s3 = peg$parse__();
            s4 = peg$parseDOT();
            if (s4 !== peg$FAILED) {
              s2 = [s2, s3, s4];
              s1 = s2;
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
          if (s1 === peg$FAILED) {
            s1 = null;
          }
          s2 = peg$parse__();
          s3 = peg$parseSTAR();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f196(s1);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parsedouble_quoted_ident();
            if (s1 !== peg$FAILED) {
              s2 = peg$parse__();
              s3 = peg$parseDOT();
              if (s3 === peg$FAILED) {
                s3 = null;
              }
              peg$savedPos = peg$currPos;
              s4 = peg$f197(s1, s3);
              if (s4) {
                s4 = peg$FAILED;
              } else {
                s4 = undefined;
              }
              if (s4 !== peg$FAILED) {
                s5 = peg$parse__();
                s6 = peg$parsealias_clause();
                if (s6 === peg$FAILED) {
                  s6 = null;
                }
                peg$savedPos = s0;
                s0 = peg$f198(s1, s3, s6);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              s1 = peg$parseexpr_item();
              if (s1 !== peg$FAILED) {
                s2 = peg$parse__();
                s3 = peg$parsealias_clause();
                if (s3 === peg$FAILED) {
                  s3 = null;
                }
                peg$savedPos = s0;
                s0 = peg$f199(s1, s3);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsevalue_alias_clause() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_AS();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    s3 = peg$parsealias_ident();
    if (s3 !== peg$FAILED) {
      peg$savedPos = s0;
      s0 = peg$f200(s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsealias_clause() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_AS();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsealias_ident();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f201(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_AS();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      s2 = peg$parse__();
      s3 = peg$parseident();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f202(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseinto_clause() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_INTO();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsevar_decl_list();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f203(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_INTO();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        if (input.substr(peg$currPos, 7).toLowerCase() === peg$c183) {
          s3 = input.substr(peg$currPos, 7);
          peg$currPos += 7;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e185);
          }
        }
        if (s3 === peg$FAILED) {
          if (input.substr(peg$currPos, 8).toLowerCase() === peg$c184) {
            s3 = input.substr(peg$currPos, 8);
            peg$currPos += 8;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e186);
            }
          }
        }
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        s4 = peg$parse__();
        s5 = peg$parseliteral_string();
        if (s5 === peg$FAILED) {
          s5 = peg$parseident();
        }
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f204(s3, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsefrom_clause() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_FROM();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsetable_ref_list();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f205(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetable_to_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsetable_to_item();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsetable_to_item();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsetable_to_item();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f206(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetable_to_item() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsetable_name();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_TO();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsetable_name();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f207(s1, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseindex_type() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_USING();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 5).toLowerCase() === peg$c185) {
        s3 = input.substr(peg$currPos, 5);
        peg$currPos += 5;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e187);
        }
      }
      if (s3 === peg$FAILED) {
        if (input.substr(peg$currPos, 4).toLowerCase() === peg$c186) {
          s3 = input.substr(peg$currPos, 4);
          peg$currPos += 4;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e188);
          }
        }
        if (s3 === peg$FAILED) {
          if (input.substr(peg$currPos, 4).toLowerCase() === peg$c187) {
            s3 = input.substr(peg$currPos, 4);
            peg$currPos += 4;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e189);
            }
          }
          if (s3 === peg$FAILED) {
            if (input.substr(peg$currPos, 3).toLowerCase() === peg$c188) {
              s3 = input.substr(peg$currPos, 3);
              peg$currPos += 3;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e190);
              }
            }
          }
        }
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f208(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseindex_options_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseindex_option();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseindex_option();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseindex_option();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f209(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseindex_options() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseindex_option();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseindex_option();
      if (s5 !== peg$FAILED) {
        s4 = [s4, s5];
        s3 = s4;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseindex_option();
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f210(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseindex_option() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_KEY_BLOCK_SIZE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_ASSIGIN_EQUAL();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseliteral_numeric();
      if (s5 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f211(s1, s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseident_name();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseKW_ASSIGIN_EQUAL();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parseliteral_numeric();
          if (s5 === peg$FAILED) {
            s5 = peg$parseident();
          }
          if (s5 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f212(s1, s3, s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$parseindex_type();
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.substr(peg$currPos, 4).toLowerCase() === peg$c189) {
            s1 = input.substr(peg$currPos, 4);
            peg$currPos += 4;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e191);
            }
          }
          if (s1 !== peg$FAILED) {
            s2 = peg$parse__();
            if (input.substr(peg$currPos, 6).toLowerCase() === peg$c190) {
              s3 = input.substr(peg$currPos, 6);
              peg$currPos += 6;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e192);
              }
            }
            if (s3 !== peg$FAILED) {
              s4 = peg$parse__();
              s5 = peg$parseident_name();
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s0 = peg$f213(s5);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 7).toLowerCase() === peg$c191) {
              s1 = input.substr(peg$currPos, 7);
              peg$currPos += 7;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e193);
              }
            }
            if (s1 === peg$FAILED) {
              if (input.substr(peg$currPos, 9).toLowerCase() === peg$c192) {
                s1 = input.substr(peg$currPos, 9);
                peg$currPos += 9;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e194);
                }
              }
            }
            if (s1 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$f214(s1);
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
              s0 = peg$parsekeyword_comment();
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsetable_ref_list() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsetable_base();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsetable_ref();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parsetable_ref();
      }
      peg$savedPos = s0;
      s0 = peg$f215(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetable_ref() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$parse__();
    s2 = peg$parseCOMMA();
    if (s2 !== peg$FAILED) {
      s3 = peg$parse__();
      s4 = peg$parsetable_base();
      if (s4 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f216(s4);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parse__();
      s2 = peg$parsetable_join();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f217(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsetable_join() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15;

    s0 = peg$currPos;
    s1 = peg$parsejoin_op();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsetable_base();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseKW_USING();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseLPAREN();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseident_without_kw();
            if (s9 !== peg$FAILED) {
              s10 = [];
              s11 = peg$currPos;
              s12 = peg$parse__();
              s13 = peg$parseCOMMA();
              if (s13 !== peg$FAILED) {
                s14 = peg$parse__();
                s15 = peg$parseident_name();
                if (s15 !== peg$FAILED) {
                  s12 = [s12, s13, s14, s15];
                  s11 = s12;
                } else {
                  peg$currPos = s11;
                  s11 = peg$FAILED;
                }
              } else {
                peg$currPos = s11;
                s11 = peg$FAILED;
              }
              while (s11 !== peg$FAILED) {
                s10.push(s11);
                s11 = peg$currPos;
                s12 = peg$parse__();
                s13 = peg$parseCOMMA();
                if (s13 !== peg$FAILED) {
                  s14 = peg$parse__();
                  s15 = peg$parseident_name();
                  if (s15 !== peg$FAILED) {
                    s12 = [s12, s13, s14, s15];
                    s11 = s12;
                  } else {
                    peg$currPos = s11;
                    s11 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s11;
                  s11 = peg$FAILED;
                }
              }
              s11 = peg$parse__();
              s12 = peg$parseRPAREN();
              if (s12 !== peg$FAILED) {
                peg$savedPos = s0;
                s0 = peg$f218(s1, s3, s9, s10);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsejoin_op();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parsetable_base();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parseon_clause();
          if (s5 === peg$FAILED) {
            s5 = null;
          }
          peg$savedPos = s0;
          s0 = peg$f219(s1, s3, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parsejoin_op();
        if (s1 !== peg$FAILED) {
          s2 = peg$parse__();
          s3 = peg$parseLPAREN();
          if (s3 !== peg$FAILED) {
            s4 = peg$parse__();
            s5 = peg$parseunion_stmt();
            if (s5 === peg$FAILED) {
              s5 = peg$parsetable_ref_list();
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parse__();
              s7 = peg$parseRPAREN();
              if (s7 !== peg$FAILED) {
                s8 = peg$parse__();
                s9 = peg$parsealias_clause();
                if (s9 === peg$FAILED) {
                  s9 = null;
                }
                s10 = peg$parse__();
                s11 = peg$parseon_clause();
                if (s11 === peg$FAILED) {
                  s11 = null;
                }
                peg$savedPos = s0;
                s0 = peg$f220(s1, s5, s9, s11);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    return s0;
  }

  function peg$parsetable_base() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14;

    s0 = peg$currPos;
    s1 = peg$parseKW_DUAL();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f221();
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsevalue_clause();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parsevalue_alias_clause();
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f222(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 7).toLowerCase() === peg$c193) {
          s1 = input.substr(peg$currPos, 7);
          peg$currPos += 7;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e195);
          }
        }
        if (s1 === peg$FAILED) {
          s1 = null;
        }
        s2 = peg$parse__();
        s3 = peg$parseLPAREN();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parseunion_stmt();
          if (s5 === peg$FAILED) {
            s5 = peg$parsevalue_clause();
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parse__();
            s7 = peg$parseRPAREN();
            if (s7 !== peg$FAILED) {
              s8 = peg$parse__();
              s9 = peg$parsevalue_alias_clause();
              if (s9 === peg$FAILED) {
                s9 = null;
              }
              peg$savedPos = s0;
              s0 = peg$f223(s1, s5, s9);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.substr(peg$currPos, 7).toLowerCase() === peg$c193) {
            s1 = input.substr(peg$currPos, 7);
            peg$currPos += 7;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e195);
            }
          }
          if (s1 === peg$FAILED) {
            s1 = null;
          }
          s2 = peg$parse__();
          s3 = peg$parseLPAREN();
          if (s3 !== peg$FAILED) {
            s4 = peg$parse__();
            s5 = peg$parsetable_ref_list();
            if (s5 !== peg$FAILED) {
              s6 = peg$parse__();
              s7 = peg$parseRPAREN();
              if (s7 !== peg$FAILED) {
                s8 = peg$parse__();
                s9 = peg$parsevalue_alias_clause();
                if (s9 === peg$FAILED) {
                  s9 = null;
                }
                peg$savedPos = s0;
                s0 = peg$f224(s1, s5, s9);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 7).toLowerCase() === peg$c193) {
              s1 = input.substr(peg$currPos, 7);
              peg$currPos += 7;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e195);
              }
            }
            if (s1 === peg$FAILED) {
              s1 = null;
            }
            s2 = peg$parse__();
            s3 = peg$parsefunc_call();
            if (s3 !== peg$FAILED) {
              s4 = peg$parse__();
              s5 = peg$parsealias_clause();
              if (s5 === peg$FAILED) {
                s5 = null;
              }
              peg$savedPos = s0;
              s0 = peg$f225(s1, s3, s5);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              s1 = peg$parsetable_name();
              if (s1 !== peg$FAILED) {
                s2 = peg$parse__();
                if (input.substr(peg$currPos, 11).toLowerCase() === peg$c194) {
                  s3 = input.substr(peg$currPos, 11);
                  peg$currPos += 11;
                } else {
                  s3 = peg$FAILED;
                  if (peg$silentFails === 0) {
                    peg$fail(peg$e196);
                  }
                }
                if (s3 !== peg$FAILED) {
                  s4 = peg$parse__();
                  s5 = peg$parsefunc_call();
                  if (s5 !== peg$FAILED) {
                    s6 = peg$parse__();
                    s7 = peg$currPos;
                    if (input.substr(peg$currPos, 10).toLowerCase() === peg$c195) {
                      s8 = input.substr(peg$currPos, 10);
                      peg$currPos += 10;
                    } else {
                      s8 = peg$FAILED;
                      if (peg$silentFails === 0) {
                        peg$fail(peg$e197);
                      }
                    }
                    if (s8 !== peg$FAILED) {
                      s9 = peg$parse__();
                      s10 = peg$parseLPAREN();
                      if (s10 !== peg$FAILED) {
                        s11 = peg$parse__();
                        s12 = peg$parseliteral_numeric();
                        if (s12 !== peg$FAILED) {
                          s13 = peg$parse__();
                          s14 = peg$parseRPAREN();
                          if (s14 !== peg$FAILED) {
                            s8 = [s8, s9, s10, s11, s12, s13, s14];
                            s7 = s8;
                          } else {
                            peg$currPos = s7;
                            s7 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s7;
                          s7 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s7;
                        s7 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s7;
                      s7 = peg$FAILED;
                    }
                    if (s7 === peg$FAILED) {
                      s7 = null;
                    }
                    s8 = peg$parse__();
                    s9 = peg$parsealias_clause();
                    if (s9 === peg$FAILED) {
                      s9 = null;
                    }
                    peg$savedPos = s0;
                    s0 = peg$f226(s1, s5, s7, s9);
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
              if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                s1 = peg$parsetable_name();
                if (s1 !== peg$FAILED) {
                  s2 = peg$parse__();
                  s3 = peg$parsealias_clause();
                  if (s3 === peg$FAILED) {
                    s3 = null;
                  }
                  peg$savedPos = s0;
                  s0 = peg$f227(s1, s3);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsejoin_op() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_LEFT();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_OUTER();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseKW_JOIN();
      if (s5 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f228();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_RIGHT();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseKW_OUTER();
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        s4 = peg$parse__();
        s5 = peg$parseKW_JOIN();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f229();
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseKW_FULL();
        if (s1 !== peg$FAILED) {
          s2 = peg$parse__();
          s3 = peg$parseKW_OUTER();
          if (s3 === peg$FAILED) {
            s3 = null;
          }
          s4 = peg$parse__();
          s5 = peg$parseKW_JOIN();
          if (s5 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f230();
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.substr(peg$currPos, 5).toLowerCase() === peg$c196) {
            s1 = input.substr(peg$currPos, 5);
            peg$currPos += 5;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e198);
            }
          }
          if (s1 !== peg$FAILED) {
            s2 = peg$parse__();
            s3 = peg$parseKW_JOIN();
            if (s3 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f231();
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$currPos;
            s2 = peg$parseKW_INNER();
            if (s2 !== peg$FAILED) {
              s3 = peg$parse__();
              s2 = [s2, s3];
              s1 = s2;
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
            if (s1 === peg$FAILED) {
              s1 = null;
            }
            s2 = peg$parseKW_JOIN();
            if (s2 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f232();
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsetable_name() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseident();
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$parse__();
      s4 = peg$parseDOT();
      if (s4 !== peg$FAILED) {
        s5 = peg$parse__();
        s6 = peg$parseident();
        if (s6 === peg$FAILED) {
          s6 = peg$parseSTAR();
        }
        if (s6 !== peg$FAILED) {
          s3 = [s3, s4, s5, s6];
          s2 = s3;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseDOT();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseident();
        if (s7 === peg$FAILED) {
          s7 = peg$parseSTAR();
        }
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f233(s1, s2, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsevar_decl();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f234(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parseon_clause() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_ON();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseor_and_where_expr();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f235(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsewhere_clause() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_WHERE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseor_and_where_expr();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f236(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsegroup_by_clause() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_GROUP();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_BY();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseexpr_list();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f237(s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecolumn_ref_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsecolumn_ref();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsecolumn_ref();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsecolumn_ref();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f238(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsehaving_clause() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_HAVING();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseor_and_where_expr();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f239(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsewindow_clause() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_WINDOW();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsenamed_window_expr_list();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f240(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsenamed_window_expr_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsenamed_window_expr();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsenamed_window_expr();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsenamed_window_expr();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f241(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsenamed_window_expr() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseident_name();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_AS();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseas_window_specification();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f242(s1, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseas_window_specification() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$parseident_name();
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseLPAREN();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parsewindow_specification();
        s4 = peg$parse__();
        s5 = peg$parseRPAREN();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f243(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsewindow_specification() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsepartition_by_clause();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    s3 = peg$parseorder_by_clause();
    if (s3 === peg$FAILED) {
      s3 = null;
    }
    s4 = peg$parse__();
    s5 = peg$parsewindow_frame_clause();
    if (s5 === peg$FAILED) {
      s5 = null;
    }
    peg$savedPos = s0;
    s0 = peg$f244(s1, s3, s5);

    return s0;
  }

  function peg$parsewindow_specification_frameless() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsepartition_by_clause();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    s3 = peg$parseorder_by_clause();
    if (s3 === peg$FAILED) {
      s3 = null;
    }
    peg$savedPos = s0;
    s0 = peg$f245(s1, s3);

    return s0;
  }

  function peg$parsewindow_frame_clause() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parseKW_ROWS();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsewindow_frame_following();
      if (s3 === peg$FAILED) {
        s3 = peg$parsewindow_frame_preceding();
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f246(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_ROWS();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseKW_BETWEEN();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parsewindow_frame_preceding();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse__();
            s7 = peg$parseKW_AND();
            if (s7 !== peg$FAILED) {
              s8 = peg$parse__();
              s9 = peg$parsewindow_frame_following();
              if (s9 !== peg$FAILED) {
                peg$savedPos = s0;
                s0 = peg$f247(s5, s9);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsewindow_frame_following() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsewindow_frame_value();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 9).toLowerCase() === peg$c197) {
        s3 = input.substr(peg$currPos, 9);
        peg$currPos += 9;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e199);
        }
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f248(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parsewindow_frame_current_row();
    }

    return s0;
  }

  function peg$parsewindow_frame_preceding() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsewindow_frame_value();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 9).toLowerCase() === peg$c198) {
        s3 = input.substr(peg$currPos, 9);
        peg$currPos += 9;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e200);
        }
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f249(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parsewindow_frame_current_row();
    }

    return s0;
  }

  function peg$parsewindow_frame_current_row() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c48) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e50);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 3).toLowerCase() === peg$c111) {
        s3 = input.substr(peg$currPos, 3);
        peg$currPos += 3;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e113);
        }
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f250();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsewindow_frame_value() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c199) {
      s1 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e201);
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f251(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$parseliteral_numeric();
    }

    return s0;
  }

  function peg$parsepartition_by_clause() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_PARTITION();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_BY();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsecolumn_clause();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f252(s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseorder_by_clause() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_ORDER();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_BY();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseorder_by_list();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f253(s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseorder_by_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseorder_by_element();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseorder_by_element();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseorder_by_element();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f254(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseorder_by_element() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8;

    s0 = peg$currPos;
    s1 = peg$parseexpr();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_DESC();
      if (s3 === peg$FAILED) {
        s3 = peg$parseKW_ASC();
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$currPos;
      if (input.substr(peg$currPos, 5).toLowerCase() === peg$c61) {
        s6 = input.substr(peg$currPos, 5);
        peg$currPos += 5;
      } else {
        s6 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e63);
        }
      }
      if (s6 !== peg$FAILED) {
        s7 = peg$parse__();
        if (input.substr(peg$currPos, 5).toLowerCase() === peg$c62) {
          s8 = input.substr(peg$currPos, 5);
          peg$currPos += 5;
        } else {
          s8 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e64);
          }
        }
        if (s8 === peg$FAILED) {
          if (input.substr(peg$currPos, 4).toLowerCase() === peg$c63) {
            s8 = input.substr(peg$currPos, 4);
            peg$currPos += 4;
          } else {
            s8 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e65);
            }
          }
        }
        if (s8 === peg$FAILED) {
          s8 = null;
        }
        s6 = [s6, s7, s8];
        s5 = s6;
      } else {
        peg$currPos = s5;
        s5 = peg$FAILED;
      }
      if (s5 === peg$FAILED) {
        s5 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f255(s1, s3, s5);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsenumber_or_param() {
    var s0;

    s0 = peg$parseliteral_numeric();
    if (s0 === peg$FAILED) {
      s0 = peg$parsevar_decl();
      if (s0 === peg$FAILED) {
        s0 = peg$parseparam();
      }
    }

    return s0;
  }

  function peg$parselimit_clause() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseKW_LIMIT();
    if (s2 !== peg$FAILED) {
      s3 = peg$parse__();
      s4 = peg$parsenumber_or_param();
      if (s4 === peg$FAILED) {
        s4 = peg$parseKW_ALL();
      }
      if (s4 !== peg$FAILED) {
        s2 = [s2, s3, s4];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    s3 = peg$currPos;
    s4 = peg$parseKW_OFFSET();
    if (s4 !== peg$FAILED) {
      s5 = peg$parse__();
      s6 = peg$parsenumber_or_param();
      if (s6 !== peg$FAILED) {
        s4 = [s4, s5, s6];
        s3 = s4;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
    } else {
      peg$currPos = s3;
      s3 = peg$FAILED;
    }
    if (s3 === peg$FAILED) {
      s3 = null;
    }
    peg$savedPos = s0;
    s0 = peg$f256(s1, s3);

    return s0;
  }

  function peg$parseupdate_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16;

    s0 = peg$currPos;
    s1 = peg$parse__();
    s2 = peg$parsewith_clause();
    if (s2 === peg$FAILED) {
      s2 = null;
    }
    s3 = peg$parse__();
    s4 = peg$parseKW_UPDATE();
    if (s4 !== peg$FAILED) {
      s5 = peg$parse__();
      s6 = peg$parsetable_ref_list();
      if (s6 !== peg$FAILED) {
        s7 = peg$parse__();
        s8 = peg$parseKW_SET();
        if (s8 !== peg$FAILED) {
          s9 = peg$parse__();
          s10 = peg$parseset_list();
          if (s10 !== peg$FAILED) {
            s11 = peg$parse__();
            s12 = peg$parsefrom_clause();
            if (s12 === peg$FAILED) {
              s12 = null;
            }
            s13 = peg$parse__();
            s14 = peg$parsewhere_clause();
            if (s14 === peg$FAILED) {
              s14 = null;
            }
            s15 = peg$parse__();
            s16 = peg$parsereturning_stmt();
            if (s16 === peg$FAILED) {
              s16 = null;
            }
            peg$savedPos = s0;
            s0 = peg$f257(s2, s6, s10, s12, s14, s16);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedelete_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseKW_DELETE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsetable_ref_list();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parsefrom_clause();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsewhere_clause();
        if (s7 === peg$FAILED) {
          s7 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f258(s3, s5, s7);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseset_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseset_item();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseset_item();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseset_item();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f259(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseset_item() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseident();
    if (s2 !== peg$FAILED) {
      s3 = peg$parse__();
      s4 = peg$parseDOT();
      if (s4 !== peg$FAILED) {
        s2 = [s2, s3, s4];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    s3 = peg$parsecolumn();
    if (s3 !== peg$FAILED) {
      s4 = peg$parse__();
      if (input.charCodeAt(peg$currPos) === 61) {
        s5 = peg$c47;
        peg$currPos++;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e49);
        }
      }
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseadditive_expr();
        if (s7 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f260(s1, s3, s7);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$currPos;
      s2 = peg$parseident();
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        s4 = peg$parseDOT();
        if (s4 !== peg$FAILED) {
          s2 = [s2, s3, s4];
          s1 = s2;
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      s2 = peg$parse__();
      s3 = peg$parsecolumn();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        if (input.charCodeAt(peg$currPos) === 61) {
          s5 = peg$c47;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e49);
          }
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseKW_VALUES();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseLPAREN();
            if (s9 !== peg$FAILED) {
              s10 = peg$parse__();
              s11 = peg$parsecolumn_ref();
              if (s11 !== peg$FAILED) {
                s12 = peg$parse__();
                s13 = peg$parseRPAREN();
                if (s13 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s0 = peg$f261(s1, s3, s11);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsereturning_stmt() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_RETURNING();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsecolumn_clause();
      if (s3 === peg$FAILED) {
        s3 = peg$parseselect_stmt();
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f262(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseinsert_value_clause() {
    var s0;

    s0 = peg$parsevalue_clause();
    if (s0 === peg$FAILED) {
      s0 = peg$parseselect_stmt_nake();
    }

    return s0;
  }

  function peg$parseinsert_partition() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;

    s0 = peg$currPos;
    s1 = peg$parseKW_PARTITION();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseident_name();
        if (s5 !== peg$FAILED) {
          s6 = [];
          s7 = peg$currPos;
          s8 = peg$parse__();
          s9 = peg$parseCOMMA();
          if (s9 !== peg$FAILED) {
            s10 = peg$parse__();
            s11 = peg$parseident_name();
            if (s11 !== peg$FAILED) {
              s8 = [s8, s9, s10, s11];
              s7 = s8;
            } else {
              peg$currPos = s7;
              s7 = peg$FAILED;
            }
          } else {
            peg$currPos = s7;
            s7 = peg$FAILED;
          }
          while (s7 !== peg$FAILED) {
            s6.push(s7);
            s7 = peg$currPos;
            s8 = peg$parse__();
            s9 = peg$parseCOMMA();
            if (s9 !== peg$FAILED) {
              s10 = peg$parse__();
              s11 = peg$parseident_name();
              if (s11 !== peg$FAILED) {
                s8 = [s8, s9, s10, s11];
                s7 = s8;
              } else {
                peg$currPos = s7;
                s7 = peg$FAILED;
              }
            } else {
              peg$currPos = s7;
              s7 = peg$FAILED;
            }
          }
          s7 = peg$parse__();
          s8 = peg$parseRPAREN();
          if (s8 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f263(s5, s6);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_PARTITION();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parsevalue_item();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f264(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseconflict_target() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseLPAREN();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsecolumn_ref_list();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseRPAREN();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f265(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseconflict_action() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c200) {
      s1 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e202);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 7).toLowerCase() === peg$c201) {
        s3 = input.substr(peg$currPos, 7);
        peg$currPos += 7;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e203);
        }
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f266();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 2).toLowerCase() === peg$c200) {
        s1 = input.substr(peg$currPos, 2);
        peg$currPos += 2;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e202);
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseKW_UPDATE();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parseKW_SET();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse__();
            s7 = peg$parseset_list();
            if (s7 !== peg$FAILED) {
              s8 = peg$parse__();
              s9 = peg$parsewhere_clause();
              if (s9 === peg$FAILED) {
                s9 = null;
              }
              peg$savedPos = s0;
              s0 = peg$f267(s7, s9);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseon_conflict() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseKW_ON();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 8).toLowerCase() === peg$c202) {
        s3 = input.substr(peg$currPos, 8);
        peg$currPos += 8;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e204);
        }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseconflict_target();
        if (s5 === peg$FAILED) {
          s5 = null;
        }
        s6 = peg$parse__();
        s7 = peg$parseconflict_action();
        if (s7 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f268(s5, s7);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsereplace_insert_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19;

    s0 = peg$currPos;
    s1 = peg$parsereplace_insert();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_INTO();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parsetable_name();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseinsert_partition();
        if (s7 === peg$FAILED) {
          s7 = null;
        }
        s8 = peg$parse__();
        s9 = peg$parseLPAREN();
        if (s9 !== peg$FAILED) {
          s10 = peg$parse__();
          s11 = peg$parsecolumn_list();
          if (s11 !== peg$FAILED) {
            s12 = peg$parse__();
            s13 = peg$parseRPAREN();
            if (s13 !== peg$FAILED) {
              s14 = peg$parse__();
              s15 = peg$parseinsert_value_clause();
              if (s15 !== peg$FAILED) {
                s16 = peg$parse__();
                s17 = peg$parseon_conflict();
                if (s17 === peg$FAILED) {
                  s17 = null;
                }
                s18 = peg$parse__();
                s19 = peg$parsereturning_stmt();
                if (s19 === peg$FAILED) {
                  s19 = null;
                }
                peg$savedPos = s0;
                s0 = peg$f269(s1, s5, s7, s11, s15, s17, s19);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseinsert_no_columns_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13;

    s0 = peg$currPos;
    s1 = peg$parsereplace_insert();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_IGNORE();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseKW_INTO();
      if (s5 === peg$FAILED) {
        s5 = null;
      }
      s6 = peg$parse__();
      s7 = peg$parsetable_name();
      if (s7 !== peg$FAILED) {
        s8 = peg$parse__();
        s9 = peg$parseinsert_partition();
        if (s9 === peg$FAILED) {
          s9 = null;
        }
        s10 = peg$parse__();
        s11 = peg$parseinsert_value_clause();
        if (s11 !== peg$FAILED) {
          s12 = peg$parse__();
          s13 = peg$parsereturning_stmt();
          if (s13 === peg$FAILED) {
            s13 = null;
          }
          peg$savedPos = s0;
          s0 = peg$f270(s1, s3, s5, s7, s9, s11, s13);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsereplace_insert() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_INSERT();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f271();
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_REPLACE();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f272();
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parsevalue_clause() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_VALUES();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsevalue_list();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f273(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsevalue_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsevalue_item();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsevalue_item();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsevalue_item();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f274(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsevalue_item() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseLPAREN();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseexpr_list();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseRPAREN();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f275(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseexpr_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseexpr();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseexpr();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseexpr();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f276(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseinterval_expr() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_INTERVAL();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseexpr();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseinterval_unit();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f277(s3, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_INTERVAL();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseliteral_string();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f278(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsecase_expr() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;

    s0 = peg$currPos;
    s1 = peg$parseKW_CASE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsecase_when_then_list();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsecase_else();
        if (s5 === peg$FAILED) {
          s5 = null;
        }
        s6 = peg$parse__();
        s7 = peg$parseKW_END();
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s9 = peg$parseKW_CASE();
          if (s9 === peg$FAILED) {
            s9 = null;
          }
          peg$savedPos = s0;
          s0 = peg$f279(s3, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_CASE();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseexpr();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parsecase_when_then_list();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse__();
            s7 = peg$parsecase_else();
            if (s7 === peg$FAILED) {
              s7 = null;
            }
            s8 = peg$parse__();
            s9 = peg$parseKW_END();
            if (s9 !== peg$FAILED) {
              s10 = peg$parse__();
              s11 = peg$parseKW_CASE();
              if (s11 === peg$FAILED) {
                s11 = null;
              }
              peg$savedPos = s0;
              s0 = peg$f280(s3, s5, s7);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsecase_when_then_list() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$parsecase_when_then();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = [];
      s4 = peg$currPos;
      s5 = peg$parse__();
      s6 = peg$parsecase_when_then();
      if (s6 !== peg$FAILED) {
        s5 = [s5, s6];
        s4 = s5;
      } else {
        peg$currPos = s4;
        s4 = peg$FAILED;
      }
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        s4 = peg$currPos;
        s5 = peg$parse__();
        s6 = peg$parsecase_when_then();
        if (s6 !== peg$FAILED) {
          s5 = [s5, s6];
          s4 = s5;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f281(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecase_when_then() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseKW_WHEN();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseor_and_where_expr();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseKW_THEN();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseexpr();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f282(s3, s7);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecase_else() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_ELSE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseexpr();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f283(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parse_expr() {
    var s0;

    s0 = peg$parselogic_operator_expr();
    if (s0 === peg$FAILED) {
      s0 = peg$parseor_expr();
      if (s0 === peg$FAILED) {
        s0 = peg$parseunary_expr();
      }
    }

    return s0;
  }

  function peg$parseexpr() {
    var s0;

    s0 = peg$parse_expr();
    if (s0 === peg$FAILED) {
      s0 = peg$parseunion_stmt();
    }

    return s0;
  }

  function peg$parselogic_operator_expr() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseprimary();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseLOGIC_OPERATOR();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseprimary();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          s4 = peg$parse__();
          s5 = peg$parseLOGIC_OPERATOR();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse__();
            s7 = peg$parseprimary();
            if (s7 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        s4 = peg$parsecomparison_op_right();
        if (s4 === peg$FAILED) {
          s4 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f284(s1, s2, s4);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseunary_expr() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseadditive_operator();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseprimary();
      if (s5 !== peg$FAILED) {
        s4 = [s4, s5];
        s3 = s4;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          s4 = peg$parse__();
          s5 = peg$parseprimary();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f285(s1, s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsebinary_column_expr() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseexpr();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseKW_AND();
      if (s5 === peg$FAILED) {
        s5 = peg$parseKW_OR();
        if (s5 === peg$FAILED) {
          s5 = peg$parseLOGIC_OPERATOR();
        }
      }
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseexpr();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseKW_AND();
        if (s5 === peg$FAILED) {
          s5 = peg$parseKW_OR();
          if (s5 === peg$FAILED) {
            s5 = peg$parseLOGIC_OPERATOR();
          }
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseexpr();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f286(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseor_and_where_expr() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseexpr();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseKW_AND();
      if (s5 === peg$FAILED) {
        s5 = peg$parseKW_OR();
        if (s5 === peg$FAILED) {
          s5 = peg$parseCOMMA();
        }
      }
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseexpr();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseKW_AND();
        if (s5 === peg$FAILED) {
          s5 = peg$parseKW_OR();
          if (s5 === peg$FAILED) {
            s5 = peg$parseCOMMA();
          }
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseexpr();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f287(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseor_expr() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseand_expr();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse___();
      if (s4 !== peg$FAILED) {
        s5 = peg$parseKW_OR();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseand_expr();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse___();
        if (s4 !== peg$FAILED) {
          s5 = peg$parseKW_OR();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse__();
            s7 = peg$parseand_expr();
            if (s7 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f288(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseand_expr() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsenot_expr();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse___();
      if (s4 !== peg$FAILED) {
        s5 = peg$parseKW_AND();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsenot_expr();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse___();
        if (s4 !== peg$FAILED) {
          s5 = peg$parseKW_AND();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse__();
            s7 = peg$parsenot_expr();
            if (s7 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f289(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsenot_expr() {
    var s0, s1, s2, s3, s4;

    s0 = peg$parsecomparison_expr();
    if (s0 === peg$FAILED) {
      s0 = peg$parseexists_expr();
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseKW_NOT();
        if (s1 === peg$FAILED) {
          s1 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 33) {
            s2 = peg$c203;
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e205);
            }
          }
          if (s2 !== peg$FAILED) {
            s3 = peg$currPos;
            peg$silentFails++;
            if (input.charCodeAt(peg$currPos) === 61) {
              s4 = peg$c47;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e49);
              }
            }
            peg$silentFails--;
            if (s4 === peg$FAILED) {
              s3 = undefined;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
            if (s3 !== peg$FAILED) {
              s2 = [s2, s3];
              s1 = s2;
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        }
        if (s1 !== peg$FAILED) {
          s2 = peg$parse__();
          s3 = peg$parsenot_expr();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f290(s3);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    return s0;
  }

  function peg$parsecomparison_expr() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseadditive_expr();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsecomparison_op_right();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f291(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseliteral_string();
      if (s0 === peg$FAILED) {
        s0 = peg$parsecolumn_ref();
      }
    }

    return s0;
  }

  function peg$parseexists_expr() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseexists_op();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseunion_stmt();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseRPAREN();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f292(s1, s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseexists_op() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseKW_NOT();
    if (s2 !== peg$FAILED) {
      s3 = peg$parse__();
      s4 = peg$parseKW_EXISTS();
      if (s4 !== peg$FAILED) {
        s2 = [s2, s3, s4];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f293(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$parseKW_EXISTS();
    }

    return s0;
  }

  function peg$parsecomparison_op_right() {
    var s0;

    s0 = peg$parsearithmetic_op_right();
    if (s0 === peg$FAILED) {
      s0 = peg$parsein_op_right();
      if (s0 === peg$FAILED) {
        s0 = peg$parsebetween_op_right();
        if (s0 === peg$FAILED) {
          s0 = peg$parseis_op_right();
          if (s0 === peg$FAILED) {
            s0 = peg$parselike_op_right();
            if (s0 === peg$FAILED) {
              s0 = peg$parsejsonb_op_right();
              if (s0 === peg$FAILED) {
                s0 = peg$parseregex_op_right();
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsearithmetic_op_right() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$currPos;
    s3 = peg$parse__();
    s4 = peg$parsearithmetic_comparison_operator();
    if (s4 !== peg$FAILED) {
      s5 = peg$parse__();
      s6 = peg$parseadditive_expr();
      if (s6 !== peg$FAILED) {
        s3 = [s3, s4, s5, s6];
        s2 = s3;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
    } else {
      peg$currPos = s2;
      s2 = peg$FAILED;
    }
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$currPos;
        s3 = peg$parse__();
        s4 = peg$parsearithmetic_comparison_operator();
        if (s4 !== peg$FAILED) {
          s5 = peg$parse__();
          s6 = peg$parseadditive_expr();
          if (s6 !== peg$FAILED) {
            s3 = [s3, s4, s5, s6];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f294(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsearithmetic_comparison_operator() {
    var s0;

    if (input.substr(peg$currPos, 2) === peg$c204) {
      s0 = peg$c204;
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e206);
      }
    }
    if (s0 === peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 62) {
        s0 = peg$c205;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e207);
        }
      }
      if (s0 === peg$FAILED) {
        if (input.substr(peg$currPos, 2) === peg$c206) {
          s0 = peg$c206;
          peg$currPos += 2;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e208);
          }
        }
        if (s0 === peg$FAILED) {
          if (input.substr(peg$currPos, 2) === peg$c207) {
            s0 = peg$c207;
            peg$currPos += 2;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e209);
            }
          }
          if (s0 === peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 60) {
              s0 = peg$c208;
              peg$currPos++;
            } else {
              s0 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e210);
              }
            }
            if (s0 === peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 61) {
                s0 = peg$c47;
                peg$currPos++;
              } else {
                s0 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e49);
                }
              }
              if (s0 === peg$FAILED) {
                if (input.substr(peg$currPos, 2) === peg$c209) {
                  s0 = peg$c209;
                  peg$currPos += 2;
                } else {
                  s0 = peg$FAILED;
                  if (peg$silentFails === 0) {
                    peg$fail(peg$e211);
                  }
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parseis_op_right() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8;

    s0 = peg$currPos;
    s1 = peg$parseKW_IS();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseadditive_expr();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f295(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_IS();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$currPos;
        s4 = peg$parseKW_DISTINCT();
        if (s4 !== peg$FAILED) {
          s5 = peg$parse__();
          s6 = peg$parseKW_FROM();
          if (s6 !== peg$FAILED) {
            s7 = peg$parse__();
            s8 = peg$parsetable_name();
            if (s8 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7, s8];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f296(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$currPos;
        s2 = peg$parseKW_IS();
        if (s2 !== peg$FAILED) {
          s3 = peg$parse__();
          s4 = peg$parseKW_NOT();
          if (s4 !== peg$FAILED) {
            s2 = [s2, s3, s4];
            s1 = s2;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
        if (s1 !== peg$FAILED) {
          s2 = peg$parse__();
          s3 = peg$parseadditive_expr();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f297(s3);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    return s0;
  }

  function peg$parsebetween_op_right() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsebetween_or_not_between_op();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseadditive_expr();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseKW_AND();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseadditive_expr();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f298(s1, s3, s7);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsebetween_or_not_between_op() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseKW_NOT();
    if (s2 !== peg$FAILED) {
      s3 = peg$parse__();
      s4 = peg$parseKW_BETWEEN();
      if (s4 !== peg$FAILED) {
        s2 = [s2, s3, s4];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f299(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$parseKW_BETWEEN();
    }

    return s0;
  }

  function peg$parselike_op() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseKW_NOT();
    if (s2 !== peg$FAILED) {
      s3 = peg$parse__();
      s4 = peg$parseKW_LIKE();
      if (s4 === peg$FAILED) {
        s4 = peg$parseKW_ILIKE();
      }
      if (s4 !== peg$FAILED) {
        s2 = [s2, s3, s4];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f300(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$parseKW_LIKE();
      if (s0 === peg$FAILED) {
        s0 = peg$parseKW_ILIKE();
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.substr(peg$currPos, 7).toLowerCase() === peg$c210) {
            s1 = input.substr(peg$currPos, 7);
            peg$currPos += 7;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e212);
            }
          }
          if (s1 !== peg$FAILED) {
            s2 = peg$parse__();
            s3 = peg$parseKW_TO();
            if (s3 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f301();
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parseKW_NOT();
            if (s1 !== peg$FAILED) {
              s2 = peg$parse__();
              if (input.substr(peg$currPos, 7).toLowerCase() === peg$c210) {
                s3 = input.substr(peg$currPos, 7);
                peg$currPos += 7;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e212);
                }
              }
              if (s3 !== peg$FAILED) {
                s4 = peg$parse__();
                s5 = peg$parseKW_TO();
                if (s5 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s0 = peg$f302();
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parseregex_op() {
    var s0;

    if (input.substr(peg$currPos, 3) === peg$c211) {
      s0 = peg$c211;
      peg$currPos += 3;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e213);
      }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 2) === peg$c212) {
        s0 = peg$c212;
        peg$currPos += 2;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e214);
        }
      }
      if (s0 === peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 126) {
          s0 = peg$c213;
          peg$currPos++;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e215);
          }
        }
        if (s0 === peg$FAILED) {
          if (input.substr(peg$currPos, 2) === peg$c214) {
            s0 = peg$c214;
            peg$currPos += 2;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e216);
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parseregex_op_right() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseregex_op();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseliteral();
      if (s3 === peg$FAILED) {
        s3 = peg$parsecomparison_expr();
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f303(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseescape_op() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c215) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e217);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseliteral_string();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f304(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsein_op() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseKW_NOT();
    if (s2 !== peg$FAILED) {
      s3 = peg$parse__();
      s4 = peg$parseKW_IN();
      if (s4 !== peg$FAILED) {
        s2 = [s2, s3, s4];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f305(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$parseKW_IN();
    }

    return s0;
  }

  function peg$parselike_op_right() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parselike_op();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseliteral();
      if (s3 === peg$FAILED) {
        s3 = peg$parsecomparison_expr();
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseescape_op();
        if (s5 === peg$FAILED) {
          s5 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f306(s1, s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsein_op_right() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsein_op();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseexpr_list();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseRPAREN();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f307(s1, s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsein_op();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parsevar_decl();
        if (s3 === peg$FAILED) {
          s3 = peg$parseliteral_string();
        }
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f308(s1, s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsejsonb_op_right() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2) === peg$c216) {
      s1 = peg$c216;
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e218);
      }
    }
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 2) === peg$c217) {
        s1 = peg$c217;
        peg$currPos += 2;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e219);
        }
      }
      if (s1 === peg$FAILED) {
        s1 = peg$parseOPERATOR_CONCATENATION();
        if (s1 === peg$FAILED) {
          s1 = peg$parseDOUBLE_WELL_ARROW();
          if (s1 === peg$FAILED) {
            s1 = peg$parseWELL_ARROW();
            if (s1 === peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 63) {
                s1 = peg$c218;
                peg$currPos++;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e220);
                }
              }
              if (s1 === peg$FAILED) {
                if (input.substr(peg$currPos, 2) === peg$c219) {
                  s1 = peg$c219;
                  peg$currPos += 2;
                } else {
                  s1 = peg$FAILED;
                  if (peg$silentFails === 0) {
                    peg$fail(peg$e221);
                  }
                }
                if (s1 === peg$FAILED) {
                  if (input.substr(peg$currPos, 2) === peg$c220) {
                    s1 = peg$c220;
                    peg$currPos += 2;
                  } else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                      peg$fail(peg$e222);
                    }
                  }
                  if (s1 === peg$FAILED) {
                    if (input.substr(peg$currPos, 2) === peg$c221) {
                      s1 = peg$c221;
                      peg$currPos += 2;
                    } else {
                      s1 = peg$FAILED;
                      if (peg$silentFails === 0) {
                        peg$fail(peg$e223);
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsecolumn_list_item();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f309(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseadditive_expr() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsemultiplicative_expr();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseadditive_operator();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsemultiplicative_expr();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseadditive_operator();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsemultiplicative_expr();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f310(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseadditive_operator() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 43) {
      s0 = peg$c222;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e224);
      }
    }
    if (s0 === peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 45) {
        s0 = peg$c223;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e225);
        }
      }
    }

    return s0;
  }

  function peg$parsemultiplicative_expr() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseprimary();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parsemultiplicative_operator();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseprimary();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parsemultiplicative_operator();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseprimary();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f311(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsemultiplicative_operator() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 42) {
      s0 = peg$c224;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e226);
      }
    }
    if (s0 === peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 47) {
        s0 = peg$c225;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e227);
        }
      }
      if (s0 === peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 37) {
          s0 = peg$c226;
          peg$currPos++;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e228);
          }
        }
        if (s0 === peg$FAILED) {
          if (input.substr(peg$currPos, 2) === peg$c227) {
            s0 = peg$c227;
            peg$currPos += 2;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e229);
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsecolumn_ref_array_index() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsecolumn_ref();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsearray_index();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f312(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseprimary() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$parsecast_expr();
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseLPAREN();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseor_and_where_expr();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parseRPAREN();
          if (s5 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f313(s3);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$parsevar_decl();
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$parse__();
          if (input.charCodeAt(peg$currPos) === 36) {
            s2 = peg$c228;
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e230);
            }
          }
          if (s2 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 60) {
              s3 = peg$c208;
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e210);
              }
            }
            if (s3 !== peg$FAILED) {
              s4 = peg$parseliteral_numeric();
              if (s4 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 62) {
                  s5 = peg$c205;
                  peg$currPos++;
                } else {
                  s5 = peg$FAILED;
                  if (peg$silentFails === 0) {
                    peg$fail(peg$e207);
                  }
                }
                if (s5 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s0 = peg$f314(s2, s4);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        }
      }
    }

    return s0;
  }

  function peg$parsestring_constants_escape() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 1).toLowerCase() === peg$c229) {
      s1 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e231);
      }
    }
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 39) {
        s2 = peg$c124;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e126);
        }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        s4 = [];
        s5 = peg$parsesingle_char();
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$parsesingle_char();
        }
        s5 = peg$parse__();
        if (input.charCodeAt(peg$currPos) === 39) {
          s6 = peg$c124;
          peg$currPos++;
        } else {
          s6 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e126);
          }
        }
        if (s6 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f315(s4);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecolumn_ref() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$parsestring_constants_escape();
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$currPos;
      s2 = peg$parseident();
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        s4 = peg$parseDOT();
        if (s4 !== peg$FAILED) {
          s2 = [s2, s3, s4];
          s1 = s2;
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      s2 = peg$parse__();
      s3 = peg$parseSTAR();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f316(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$currPos;
        s2 = peg$parseident();
        if (s2 !== peg$FAILED) {
          s3 = peg$parse__();
          s4 = peg$parseDOT();
          if (s4 !== peg$FAILED) {
            s2 = [s2, s3, s4];
            s1 = s2;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
        if (s1 === peg$FAILED) {
          s1 = null;
        }
        s2 = peg$parse__();
        s3 = peg$parsecolumn();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = [];
          s6 = peg$currPos;
          s7 = peg$parseDOUBLE_ARROW();
          if (s7 === peg$FAILED) {
            s7 = peg$parseSINGLE_ARROW();
          }
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseliteral_string();
            if (s9 === peg$FAILED) {
              s9 = peg$parseliteral_numeric();
            }
            if (s9 !== peg$FAILED) {
              s7 = [s7, s8, s9];
              s6 = s7;
            } else {
              peg$currPos = s6;
              s6 = peg$FAILED;
            }
          } else {
            peg$currPos = s6;
            s6 = peg$FAILED;
          }
          if (s6 !== peg$FAILED) {
            while (s6 !== peg$FAILED) {
              s5.push(s6);
              s6 = peg$currPos;
              s7 = peg$parseDOUBLE_ARROW();
              if (s7 === peg$FAILED) {
                s7 = peg$parseSINGLE_ARROW();
              }
              if (s7 !== peg$FAILED) {
                s8 = peg$parse__();
                s9 = peg$parseliteral_string();
                if (s9 === peg$FAILED) {
                  s9 = peg$parseliteral_numeric();
                }
                if (s9 !== peg$FAILED) {
                  s7 = [s7, s8, s9];
                  s6 = s7;
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
            }
          } else {
            s5 = peg$FAILED;
          }
          if (s5 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f317(s1, s3, s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$parseident();
          if (s1 !== peg$FAILED) {
            s2 = peg$currPos;
            s3 = peg$parse__();
            s4 = peg$parseDOT();
            if (s4 !== peg$FAILED) {
              s5 = peg$parse__();
              s6 = peg$parseident();
              if (s6 !== peg$FAILED) {
                s3 = [s3, s4, s5, s6];
                s2 = s3;
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
            if (s2 !== peg$FAILED) {
              s3 = peg$currPos;
              s4 = peg$parse__();
              s5 = peg$parseDOT();
              if (s5 !== peg$FAILED) {
                s6 = peg$parse__();
                s7 = peg$parsecolumn();
                if (s7 !== peg$FAILED) {
                  s4 = [s4, s5, s6, s7];
                  s3 = s4;
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
              if (s3 !== peg$FAILED) {
                peg$savedPos = s0;
                s0 = peg$f318(s1, s2, s3);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parseident();
            if (s1 !== peg$FAILED) {
              s2 = peg$parse__();
              s3 = peg$parseDOT();
              if (s3 !== peg$FAILED) {
                s4 = peg$parse__();
                s5 = peg$parsecolumn();
                if (s5 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s0 = peg$f319(s1, s5);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              s1 = peg$parsecolumn();
              if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$f320(s1);
              }
              s0 = s1;
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsecolumn_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsecolumn();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsecolumn();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsecolumn();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f321(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseident() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = peg$parseident_name();
    if (s1 !== peg$FAILED) {
      peg$savedPos = peg$currPos;
      s2 = peg$f322(s1);
      if (s2) {
        s2 = peg$FAILED;
      } else {
        s2 = undefined;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f323(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsequoted_ident();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f324(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parseident_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseident();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseident();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseident();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f325(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsealias_ident() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parseident_name();
    if (s1 !== peg$FAILED) {
      peg$savedPos = peg$currPos;
      s2 = peg$f326(s1);
      if (s2) {
        s2 = peg$FAILED;
      } else {
        s2 = undefined;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseLPAREN();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsecolumn_list();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseRPAREN();
            if (s9 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7, s8, s9];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f327(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsequoted_ident();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f328(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parsequoted_ident() {
    var s0;

    s0 = peg$parsedouble_quoted_ident();
    if (s0 === peg$FAILED) {
      s0 = peg$parsesingle_quoted_ident();
      if (s0 === peg$FAILED) {
        s0 = peg$parsebackticks_quoted_ident();
      }
    }

    return s0;
  }

  function peg$parsedouble_quoted_ident() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 34) {
      s1 = peg$c182;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e184);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      if (peg$r2.test(input.charAt(peg$currPos))) {
        s3 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e232);
        }
      }
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          if (peg$r2.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e232);
            }
          }
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 34) {
          s3 = peg$c182;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e184);
          }
        }
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f329(s2);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsesingle_quoted_ident() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 39) {
      s1 = peg$c124;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e126);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      if (peg$r3.test(input.charAt(peg$currPos))) {
        s3 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e233);
        }
      }
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          if (peg$r3.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e233);
            }
          }
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 39) {
          s3 = peg$c124;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e126);
          }
        }
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f330(s2);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsebackticks_quoted_ident() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 96) {
      s1 = peg$c230;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e234);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      if (peg$r4.test(input.charAt(peg$currPos))) {
        s3 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e235);
        }
      }
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          if (peg$r4.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e235);
            }
          }
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 96) {
          s3 = peg$c230;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e234);
          }
        }
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f331(s2);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseident_without_kw() {
    var s0;

    s0 = peg$parseident_name();
    if (s0 === peg$FAILED) {
      s0 = peg$parsequoted_ident();
    }

    return s0;
  }

  function peg$parsecolumn() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = peg$parsecolumn_name();
    if (s1 !== peg$FAILED) {
      peg$savedPos = peg$currPos;
      s2 = peg$f332(s1);
      if (s2) {
        s2 = peg$FAILED;
      } else {
        s2 = undefined;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f333(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parsequoted_ident();
    }

    return s0;
  }

  function peg$parsecolumn_name() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseident_start();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsecolumn_part();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parsecolumn_part();
      }
      peg$savedPos = s0;
      s0 = peg$f334(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseident_name() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseident_start();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parseident_part();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseident_part();
      }
      peg$savedPos = s0;
      s0 = peg$f335(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseident_start() {
    var s0;

    if (peg$r5.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e236);
      }
    }

    return s0;
  }

  function peg$parseident_part() {
    var s0;

    if (peg$r6.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e237);
      }
    }

    return s0;
  }

  function peg$parsecolumn_part() {
    var s0;

    if (peg$r7.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e238);
      }
    }

    return s0;
  }

  function peg$parseparam() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 58) {
      s2 = peg$c231;
      peg$currPos++;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e239);
      }
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$parseident_name();
      if (s3 !== peg$FAILED) {
        s2 = [s2, s3];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f336(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parseon_update_current_timestamp() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;

    s0 = peg$currPos;
    s1 = peg$parseKW_ON();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_UPDATE();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseKW_CURRENT_TIMESTAMP();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseLPAREN();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseexpr_list();
            if (s9 === peg$FAILED) {
              s9 = null;
            }
            s10 = peg$parse__();
            s11 = peg$parseRPAREN();
            if (s11 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f337(s5, s9);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_ON();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseKW_UPDATE();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parseKW_CURRENT_TIMESTAMP();
          if (s5 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f338(s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseover_partition() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c232) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e240);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseas_window_specification();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f339(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 4).toLowerCase() === peg$c232) {
        s1 = input.substr(peg$currPos, 4);
        peg$currPos += 4;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e240);
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseLPAREN();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parsepartition_by_clause();
          if (s5 === peg$FAILED) {
            s5 = null;
          }
          s6 = peg$parse__();
          s7 = peg$parseorder_by_clause();
          if (s7 === peg$FAILED) {
            s7 = null;
          }
          s8 = peg$parse__();
          s9 = peg$parseRPAREN();
          if (s9 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f340(s5, s7);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$parseon_update_current_timestamp();
      }
    }

    return s0;
  }

  function peg$parseaggr_filter() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c233) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e241);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsewhere_clause();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseRPAREN();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f341(s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseaggr_func() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseaggr_fun_count();
    if (s1 === peg$FAILED) {
      s1 = peg$parseaggr_fun_smma();
      if (s1 === peg$FAILED) {
        s1 = peg$parseaggr_array_agg();
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseaggr_filter();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f342(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsewindow_func() {
    var s0;

    s0 = peg$parsewindow_fun_rank();
    if (s0 === peg$FAILED) {
      s0 = peg$parsewindow_fun_laglead();
      if (s0 === peg$FAILED) {
        s0 = peg$parsewindow_fun_firstlast();
      }
    }

    return s0;
  }

  function peg$parsewindow_fun_rank() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseKW_WIN_FNS_RANK();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseRPAREN();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseover_partition();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f343(s1, s7);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsewindow_fun_laglead() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;

    s0 = peg$currPos;
    s1 = peg$parseKW_LAG_LEAD();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseexpr_list();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseRPAREN();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseconsider_nulls_clause();
            if (s9 === peg$FAILED) {
              s9 = null;
            }
            s10 = peg$parse__();
            s11 = peg$parseover_partition();
            if (s11 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f344(s1, s5, s9, s11);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsewindow_fun_firstlast() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;

    s0 = peg$currPos;
    s1 = peg$parseKW_FIRST_LAST_VALUE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseexpr();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseconsider_nulls_clause();
          if (s7 === peg$FAILED) {
            s7 = null;
          }
          s8 = peg$parse__();
          s9 = peg$parseRPAREN();
          if (s9 !== peg$FAILED) {
            s10 = peg$parse__();
            s11 = peg$parseover_partition();
            if (s11 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f345(s1, s5, s7, s11);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_FIRST_LAST_VALUE() {
    var s0;

    if (input.substr(peg$currPos, 11).toLowerCase() === peg$c234) {
      s0 = input.substr(peg$currPos, 11);
      peg$currPos += 11;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e242);
      }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 10).toLowerCase() === peg$c235) {
        s0 = input.substr(peg$currPos, 10);
        peg$currPos += 10;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e243);
        }
      }
    }

    return s0;
  }

  function peg$parseKW_WIN_FNS_RANK() {
    var s0;

    if (input.substr(peg$currPos, 10).toLowerCase() === peg$c236) {
      s0 = input.substr(peg$currPos, 10);
      peg$currPos += 10;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e244);
      }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 10).toLowerCase() === peg$c237) {
        s0 = input.substr(peg$currPos, 10);
        peg$currPos += 10;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e245);
        }
      }
      if (s0 === peg$FAILED) {
        if (input.substr(peg$currPos, 4).toLowerCase() === peg$c238) {
          s0 = input.substr(peg$currPos, 4);
          peg$currPos += 4;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e246);
          }
        }
      }
    }

    return s0;
  }

  function peg$parseKW_LAG_LEAD() {
    var s0;

    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c239) {
      s0 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e247);
      }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 4).toLowerCase() === peg$c240) {
        s0 = input.substr(peg$currPos, 4);
        peg$currPos += 4;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e248);
        }
      }
      if (s0 === peg$FAILED) {
        if (input.substr(peg$currPos, 9).toLowerCase() === peg$c241) {
          s0 = input.substr(peg$currPos, 9);
          peg$currPos += 9;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e249);
          }
        }
      }
    }

    return s0;
  }

  function peg$parseconsider_nulls_clause() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c242) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e250);
      }
    }
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 7).toLowerCase() === peg$c243) {
        s1 = input.substr(peg$currPos, 7);
        peg$currPos += 7;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e251);
        }
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 5).toLowerCase() === peg$c61) {
        s3 = input.substr(peg$currPos, 5);
        peg$currPos += 5;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e63);
        }
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f346(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseaggr_fun_smma() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parseKW_SUM_MAX_MIN_AVG();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseadditive_expr();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseRPAREN();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseover_partition();
            if (s9 === peg$FAILED) {
              s9 = null;
            }
            peg$savedPos = s0;
            s0 = peg$f347(s1, s5, s9);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_SUM_MAX_MIN_AVG() {
    var s0;

    s0 = peg$parseKW_SUM();
    if (s0 === peg$FAILED) {
      s0 = peg$parseKW_MAX();
      if (s0 === peg$FAILED) {
        s0 = peg$parseKW_MIN();
        if (s0 === peg$FAILED) {
          s0 = peg$parseKW_AVG();
        }
      }
    }

    return s0;
  }

  function peg$parseaggr_fun_count() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19;

    s0 = peg$currPos;
    s1 = peg$parseKW_COUNT();
    if (s1 === peg$FAILED) {
      s1 = peg$parseKW_GROUP_CONCAT();
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsecount_arg();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseRPAREN();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseover_partition();
            if (s9 === peg$FAILED) {
              s9 = null;
            }
            peg$savedPos = s0;
            s0 = peg$f348(s1, s5, s9);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 15).toLowerCase() === peg$c244) {
        s1 = input.substr(peg$currPos, 15);
        peg$currPos += 15;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e252);
        }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 15).toLowerCase() === peg$c245) {
          s1 = input.substr(peg$currPos, 15);
          peg$currPos += 15;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e253);
          }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseLPAREN();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parseliteral_numeric();
          if (s5 === peg$FAILED) {
            s5 = peg$parseliteral_array();
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parse__();
            s7 = peg$parseRPAREN();
            if (s7 !== peg$FAILED) {
              s8 = peg$parse__();
              if (input.substr(peg$currPos, 6).toLowerCase() === peg$c246) {
                s9 = input.substr(peg$currPos, 6);
                peg$currPos += 6;
              } else {
                s9 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e254);
                }
              }
              if (s9 !== peg$FAILED) {
                s10 = peg$parse__();
                s11 = peg$parseKW_GROUP();
                if (s11 !== peg$FAILED) {
                  s12 = peg$parse__();
                  s13 = peg$parseLPAREN();
                  if (s13 !== peg$FAILED) {
                    s14 = peg$parse__();
                    s15 = peg$parseorder_by_clause();
                    if (s15 !== peg$FAILED) {
                      s16 = peg$parse__();
                      s17 = peg$parseRPAREN();
                      if (s17 !== peg$FAILED) {
                        s18 = peg$parse__();
                        s19 = peg$parseover_partition();
                        if (s19 === peg$FAILED) {
                          s19 = null;
                        }
                        peg$savedPos = s0;
                        s0 = peg$f349(s1, s5, s15, s19);
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 4).toLowerCase() === peg$c136) {
          s1 = input.substr(peg$currPos, 4);
          peg$currPos += 4;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e255);
          }
        }
        if (s1 !== peg$FAILED) {
          s2 = peg$parse__();
          s3 = peg$parseLPAREN();
          if (s3 !== peg$FAILED) {
            s4 = peg$parse__();
            s5 = peg$parseRPAREN();
            if (s5 !== peg$FAILED) {
              s6 = peg$parse__();
              if (input.substr(peg$currPos, 6).toLowerCase() === peg$c246) {
                s7 = input.substr(peg$currPos, 6);
                peg$currPos += 6;
              } else {
                s7 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e254);
                }
              }
              if (s7 !== peg$FAILED) {
                s8 = peg$parse__();
                s9 = peg$parseKW_GROUP();
                if (s9 !== peg$FAILED) {
                  s10 = peg$parse__();
                  s11 = peg$parseLPAREN();
                  if (s11 !== peg$FAILED) {
                    s12 = peg$parse__();
                    s13 = peg$parseorder_by_clause();
                    if (s13 !== peg$FAILED) {
                      s14 = peg$parse__();
                      s15 = peg$parseRPAREN();
                      if (s15 !== peg$FAILED) {
                        s16 = peg$parse__();
                        s17 = peg$parseover_partition();
                        if (s17 === peg$FAILED) {
                          s17 = null;
                        }
                        peg$savedPos = s0;
                        s0 = peg$f350(s1, s13, s17);
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    return s0;
  }

  function peg$parseconcat_separator() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c247) {
      s1 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e256);
      }
    }
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    s3 = peg$parseliteral_string();
    if (s3 !== peg$FAILED) {
      peg$savedPos = s0;
      s0 = peg$f351(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedistinct_args() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;

    s0 = peg$currPos;
    s1 = peg$parseKW_DISTINCT();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    s3 = peg$parseLPAREN();
    if (s3 !== peg$FAILED) {
      s4 = peg$parse__();
      s5 = peg$parseexpr();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseRPAREN();
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s9 = peg$parseorder_by_clause();
          if (s9 === peg$FAILED) {
            s9 = null;
          }
          s10 = peg$parse__();
          s11 = peg$parseconcat_separator();
          if (s11 === peg$FAILED) {
            s11 = null;
          }
          peg$savedPos = s0;
          s0 = peg$f352(s1, s5, s9, s11);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_DISTINCT();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      s2 = peg$parse__();
      s3 = peg$parseexpr();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseorder_by_clause();
        if (s5 === peg$FAILED) {
          s5 = null;
        }
        s6 = peg$parse__();
        s7 = peg$parseconcat_separator();
        if (s7 === peg$FAILED) {
          s7 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f353(s1, s3, s5, s7);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsecount_arg() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parsestar_expr();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f354(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$parsedistinct_args();
    }

    return s0;
  }

  function peg$parseaggr_array_agg() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseident();
    if (s2 !== peg$FAILED) {
      s3 = peg$parse__();
      s4 = peg$parseDOT();
      if (s4 !== peg$FAILED) {
        s2 = [s2, s3, s4];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    s3 = peg$parseKW_ARRAY_AGG();
    if (s3 !== peg$FAILED) {
      s4 = peg$parse__();
      s5 = peg$parseLPAREN();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsedistinct_args();
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s9 = peg$parseorder_by_clause();
          if (s9 === peg$FAILED) {
            s9 = null;
          }
          s10 = peg$parse__();
          s11 = peg$parseRPAREN();
          if (s11 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f355(s1, s3, s7, s9);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsestar_expr() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 42) {
      s1 = peg$c224;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e226);
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f356();
    }
    s0 = s1;

    return s0;
  }

  function peg$parsetrim_position() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c248) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e257);
      }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 7).toLowerCase() === peg$c249) {
        s0 = input.substr(peg$currPos, 7);
        peg$currPos += 7;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e258);
        }
      }
      if (s0 === peg$FAILED) {
        if (input.substr(peg$currPos, 8).toLowerCase() === peg$c250) {
          s0 = input.substr(peg$currPos, 8);
          peg$currPos += 8;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e259);
          }
        }
      }
    }

    return s0;
  }

  function peg$parsetrim_rem() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsetrim_position();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    s3 = peg$parseliteral_string();
    if (s3 === peg$FAILED) {
      s3 = null;
    }
    s4 = peg$parse__();
    s5 = peg$parseKW_FROM();
    if (s5 !== peg$FAILED) {
      peg$savedPos = s0;
      s0 = peg$f357(s1, s3, s5);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetrim_func_clause() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c251) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e260);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsetrim_rem();
        if (s5 === peg$FAILED) {
          s5 = null;
        }
        s6 = peg$parse__();
        s7 = peg$parseexpr();
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s9 = peg$parseRPAREN();
          if (s9 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f358(s5, s7);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsefunc_call() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15;

    s0 = peg$parsetrim_func_clause();
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 3).toLowerCase() === peg$c252) {
        s1 = input.substr(peg$currPos, 3);
        peg$currPos += 3;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e261);
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseLPAREN();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parseexpr_list();
          if (s5 === peg$FAILED) {
            s5 = null;
          }
          s6 = peg$parse__();
          s7 = peg$parseRPAREN();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            if (input.substr(peg$currPos, 2).toLowerCase() === peg$c253) {
              s9 = input.substr(peg$currPos, 2);
              peg$currPos += 2;
            } else {
              s9 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e262);
              }
            }
            if (s9 !== peg$FAILED) {
              s10 = peg$parse__();
              s11 = peg$parseKW_TIME();
              if (s11 !== peg$FAILED) {
                s12 = peg$parse__();
                if (input.substr(peg$currPos, 4).toLowerCase() === peg$c254) {
                  s13 = input.substr(peg$currPos, 4);
                  peg$currPos += 4;
                } else {
                  s13 = peg$FAILED;
                  if (peg$silentFails === 0) {
                    peg$fail(peg$e263);
                  }
                }
                if (s13 !== peg$FAILED) {
                  s14 = peg$parse__();
                  s15 = peg$parseliteral_string();
                  if (s15 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s0 = peg$f359(s1, s5, s15);
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parsescalar_func();
        if (s1 !== peg$FAILED) {
          s2 = peg$parse__();
          s3 = peg$parseLPAREN();
          if (s3 !== peg$FAILED) {
            s4 = peg$parse__();
            s5 = peg$parseexpr_list();
            if (s5 === peg$FAILED) {
              s5 = null;
            }
            s6 = peg$parse__();
            s7 = peg$parseRPAREN();
            if (s7 !== peg$FAILED) {
              s8 = peg$parse__();
              s9 = peg$parseover_partition();
              if (s9 === peg$FAILED) {
                s9 = null;
              }
              peg$savedPos = s0;
              s0 = peg$f360(s1, s5, s9);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$parseextract_func();
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parsescalar_time_func();
            if (s1 !== peg$FAILED) {
              s2 = peg$parse__();
              s3 = peg$parseon_update_current_timestamp();
              if (s3 === peg$FAILED) {
                s3 = null;
              }
              peg$savedPos = s0;
              s0 = peg$f361(s1, s3);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              s1 = peg$parseproc_func_name();
              if (s1 !== peg$FAILED) {
                s2 = peg$parse__();
                s3 = peg$parseLPAREN();
                if (s3 !== peg$FAILED) {
                  s4 = peg$parse__();
                  s5 = peg$parseor_and_where_expr();
                  if (s5 === peg$FAILED) {
                    s5 = null;
                  }
                  s6 = peg$parse__();
                  s7 = peg$parseRPAREN();
                  if (s7 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s0 = peg$f362(s1, s5);
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parseextract_filed() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c255) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e264);
      }
    }
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 3).toLowerCase() === peg$c256) {
        s1 = input.substr(peg$currPos, 3);
        peg$currPos += 3;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e265);
        }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 4).toLowerCase() === peg$c257) {
          s1 = input.substr(peg$currPos, 4);
          peg$currPos += 4;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e266);
          }
        }
        if (s1 === peg$FAILED) {
          if (input.substr(peg$currPos, 6).toLowerCase() === peg$c258) {
            s1 = input.substr(peg$currPos, 6);
            peg$currPos += 6;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e267);
            }
          }
          if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 3).toLowerCase() === peg$c259) {
              s1 = input.substr(peg$currPos, 3);
              peg$currPos += 3;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e268);
              }
            }
            if (s1 === peg$FAILED) {
              if (input.substr(peg$currPos, 3).toLowerCase() === peg$c260) {
                s1 = input.substr(peg$currPos, 3);
                peg$currPos += 3;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e269);
                }
              }
              if (s1 === peg$FAILED) {
                if (input.substr(peg$currPos, 5).toLowerCase() === peg$c261) {
                  s1 = input.substr(peg$currPos, 5);
                  peg$currPos += 5;
                } else {
                  s1 = peg$FAILED;
                  if (peg$silentFails === 0) {
                    peg$fail(peg$e270);
                  }
                }
                if (s1 === peg$FAILED) {
                  if (input.substr(peg$currPos, 4).toLowerCase() === peg$c262) {
                    s1 = input.substr(peg$currPos, 4);
                    peg$currPos += 4;
                  } else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                      peg$fail(peg$e271);
                    }
                  }
                  if (s1 === peg$FAILED) {
                    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c263) {
                      s1 = input.substr(peg$currPos, 6);
                      peg$currPos += 6;
                    } else {
                      s1 = peg$FAILED;
                      if (peg$silentFails === 0) {
                        peg$fail(peg$e272);
                      }
                    }
                    if (s1 === peg$FAILED) {
                      if (input.substr(peg$currPos, 7).toLowerCase() === peg$c264) {
                        s1 = input.substr(peg$currPos, 7);
                        peg$currPos += 7;
                      } else {
                        s1 = peg$FAILED;
                        if (peg$silentFails === 0) {
                          peg$fail(peg$e273);
                        }
                      }
                      if (s1 === peg$FAILED) {
                        if (input.substr(peg$currPos, 12).toLowerCase() === peg$c265) {
                          s1 = input.substr(peg$currPos, 12);
                          peg$currPos += 12;
                        } else {
                          s1 = peg$FAILED;
                          if (peg$silentFails === 0) {
                            peg$fail(peg$e274);
                          }
                        }
                        if (s1 === peg$FAILED) {
                          if (input.substr(peg$currPos, 10).toLowerCase() === peg$c266) {
                            s1 = input.substr(peg$currPos, 10);
                            peg$currPos += 10;
                          } else {
                            s1 = peg$FAILED;
                            if (peg$silentFails === 0) {
                              peg$fail(peg$e275);
                            }
                          }
                          if (s1 === peg$FAILED) {
                            if (input.substr(peg$currPos, 12).toLowerCase() === peg$c267) {
                              s1 = input.substr(peg$currPos, 12);
                              peg$currPos += 12;
                            } else {
                              s1 = peg$FAILED;
                              if (peg$silentFails === 0) {
                                peg$fail(peg$e276);
                              }
                            }
                            if (s1 === peg$FAILED) {
                              if (input.substr(peg$currPos, 6).toLowerCase() === peg$c268) {
                                s1 = input.substr(peg$currPos, 6);
                                peg$currPos += 6;
                              } else {
                                s1 = peg$FAILED;
                                if (peg$silentFails === 0) {
                                  peg$fail(peg$e277);
                                }
                              }
                              if (s1 === peg$FAILED) {
                                if (input.substr(peg$currPos, 5).toLowerCase() === peg$c269) {
                                  s1 = input.substr(peg$currPos, 5);
                                  peg$currPos += 5;
                                } else {
                                  s1 = peg$FAILED;
                                  if (peg$silentFails === 0) {
                                    peg$fail(peg$e278);
                                  }
                                }
                                if (s1 === peg$FAILED) {
                                  if (input.substr(peg$currPos, 7).toLowerCase() === peg$c270) {
                                    s1 = input.substr(peg$currPos, 7);
                                    peg$currPos += 7;
                                  } else {
                                    s1 = peg$FAILED;
                                    if (peg$silentFails === 0) {
                                      peg$fail(peg$e279);
                                    }
                                  }
                                  if (s1 === peg$FAILED) {
                                    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c271) {
                                      s1 = input.substr(peg$currPos, 6);
                                      peg$currPos += 6;
                                    } else {
                                      s1 = peg$FAILED;
                                      if (peg$silentFails === 0) {
                                        peg$fail(peg$e280);
                                      }
                                    }
                                    if (s1 === peg$FAILED) {
                                      if (input.substr(peg$currPos, 8).toLowerCase() === peg$c272) {
                                        s1 = input.substr(peg$currPos, 8);
                                        peg$currPos += 8;
                                      } else {
                                        s1 = peg$FAILED;
                                        if (peg$silentFails === 0) {
                                          peg$fail(peg$e281);
                                        }
                                      }
                                      if (s1 === peg$FAILED) {
                                        if (input.substr(peg$currPos, 13).toLowerCase() === peg$c273) {
                                          s1 = input.substr(peg$currPos, 13);
                                          peg$currPos += 13;
                                        } else {
                                          s1 = peg$FAILED;
                                          if (peg$silentFails === 0) {
                                            peg$fail(peg$e282);
                                          }
                                        }
                                        if (s1 === peg$FAILED) {
                                          if (input.substr(peg$currPos, 15).toLowerCase() === peg$c274) {
                                            s1 = input.substr(peg$currPos, 15);
                                            peg$currPos += 15;
                                          } else {
                                            s1 = peg$FAILED;
                                            if (peg$silentFails === 0) {
                                              peg$fail(peg$e283);
                                            }
                                          }
                                          if (s1 === peg$FAILED) {
                                            if (input.substr(peg$currPos, 4).toLowerCase() === peg$c275) {
                                              s1 = input.substr(peg$currPos, 4);
                                              peg$currPos += 4;
                                            } else {
                                              s1 = peg$FAILED;
                                              if (peg$silentFails === 0) {
                                                peg$fail(peg$e284);
                                              }
                                            }
                                            if (s1 === peg$FAILED) {
                                              if (input.substr(peg$currPos, 4).toLowerCase() === peg$c276) {
                                                s1 = input.substr(peg$currPos, 4);
                                                peg$currPos += 4;
                                              } else {
                                                s1 = peg$FAILED;
                                                if (peg$silentFails === 0) {
                                                  peg$fail(peg$e285);
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f363(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parseextract_func() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13;

    s0 = peg$currPos;
    s1 = peg$parseKW_EXTRACT();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseextract_filed();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseKW_FROM();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseKW_TIMESTAMP();
            if (s9 === peg$FAILED) {
              s9 = peg$parseKW_INTERVAL();
              if (s9 === peg$FAILED) {
                s9 = peg$parseKW_TIME();
                if (s9 === peg$FAILED) {
                  s9 = peg$parseKW_DATE();
                }
              }
            }
            if (s9 === peg$FAILED) {
              s9 = null;
            }
            s10 = peg$parse__();
            s11 = peg$parseexpr();
            if (s11 !== peg$FAILED) {
              s12 = peg$parse__();
              s13 = peg$parseRPAREN();
              if (s13 !== peg$FAILED) {
                peg$savedPos = s0;
                s0 = peg$f364(s1, s5, s9, s11);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_EXTRACT();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseLPAREN();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parseextract_filed();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse__();
            s7 = peg$parseKW_FROM();
            if (s7 !== peg$FAILED) {
              s8 = peg$parse__();
              s9 = peg$parseexpr();
              if (s9 !== peg$FAILED) {
                s10 = peg$parse__();
                s11 = peg$parseRPAREN();
                if (s11 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s0 = peg$f365(s1, s5, s9);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsescalar_time_func() {
    var s0;

    s0 = peg$parseKW_CURRENT_DATE();
    if (s0 === peg$FAILED) {
      s0 = peg$parseKW_CURRENT_TIME();
      if (s0 === peg$FAILED) {
        s0 = peg$parseKW_CURRENT_TIMESTAMP();
      }
    }

    return s0;
  }

  function peg$parsescalar_func() {
    var s0;

    s0 = peg$parsescalar_time_func();
    if (s0 === peg$FAILED) {
      s0 = peg$parseKW_CURRENT_USER();
      if (s0 === peg$FAILED) {
        s0 = peg$parseKW_USER();
        if (s0 === peg$FAILED) {
          s0 = peg$parseKW_SESSION_USER();
          if (s0 === peg$FAILED) {
            s0 = peg$parseKW_SYSTEM_USER();
            if (s0 === peg$FAILED) {
              if (input.substr(peg$currPos, 5).toLowerCase() === peg$c277) {
                s0 = input.substr(peg$currPos, 5);
                peg$currPos += 5;
              } else {
                s0 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e286);
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsecast_double_colon() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parseKW_DOUBLE_COLON();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsedata_type();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = [];
        s6 = peg$currPos;
        s7 = peg$parseDOUBLE_ARROW();
        if (s7 === peg$FAILED) {
          s7 = peg$parseSINGLE_ARROW();
        }
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s9 = peg$parseliteral_string();
          if (s9 === peg$FAILED) {
            s9 = peg$parseliteral_numeric();
          }
          if (s9 !== peg$FAILED) {
            s7 = [s7, s8, s9];
            s6 = s7;
          } else {
            peg$currPos = s6;
            s6 = peg$FAILED;
          }
        } else {
          peg$currPos = s6;
          s6 = peg$FAILED;
        }
        while (s6 !== peg$FAILED) {
          s5.push(s6);
          s6 = peg$currPos;
          s7 = peg$parseDOUBLE_ARROW();
          if (s7 === peg$FAILED) {
            s7 = peg$parseSINGLE_ARROW();
          }
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseliteral_string();
            if (s9 === peg$FAILED) {
              s9 = peg$parseliteral_numeric();
            }
            if (s9 !== peg$FAILED) {
              s7 = [s7, s8, s9];
              s6 = s7;
            } else {
              peg$currPos = s6;
              s6 = peg$FAILED;
            }
          } else {
            peg$currPos = s6;
            s6 = peg$FAILED;
          }
        }
        s6 = peg$parse__();
        s7 = peg$parsealias_clause();
        if (s7 === peg$FAILED) {
          s7 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f366(s1, s3, s5, s7);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecast_expr() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20, s21;

    s0 = peg$currPos;
    s1 = peg$parseKW_CAST();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseexpr();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseKW_AS();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parsedata_type();
            if (s9 !== peg$FAILED) {
              s10 = peg$parse__();
              s11 = peg$parseRPAREN();
              if (s11 !== peg$FAILED) {
                s12 = peg$parse__();
                s13 = [];
                s14 = peg$currPos;
                s15 = peg$parseDOUBLE_ARROW();
                if (s15 === peg$FAILED) {
                  s15 = peg$parseSINGLE_ARROW();
                }
                if (s15 !== peg$FAILED) {
                  s16 = peg$parse__();
                  s17 = peg$parseliteral_string();
                  if (s17 === peg$FAILED) {
                    s17 = peg$parseliteral_numeric();
                  }
                  if (s17 !== peg$FAILED) {
                    s15 = [s15, s16, s17];
                    s14 = s15;
                  } else {
                    peg$currPos = s14;
                    s14 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s14;
                  s14 = peg$FAILED;
                }
                while (s14 !== peg$FAILED) {
                  s13.push(s14);
                  s14 = peg$currPos;
                  s15 = peg$parseDOUBLE_ARROW();
                  if (s15 === peg$FAILED) {
                    s15 = peg$parseSINGLE_ARROW();
                  }
                  if (s15 !== peg$FAILED) {
                    s16 = peg$parse__();
                    s17 = peg$parseliteral_string();
                    if (s17 === peg$FAILED) {
                      s17 = peg$parseliteral_numeric();
                    }
                    if (s17 !== peg$FAILED) {
                      s15 = [s15, s16, s17];
                      s14 = s15;
                    } else {
                      peg$currPos = s14;
                      s14 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s14;
                    s14 = peg$FAILED;
                  }
                }
                peg$savedPos = s0;
                s0 = peg$f367(s1, s5, s9, s13);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_CAST();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseLPAREN();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parseexpr();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse__();
            s7 = peg$parseKW_AS();
            if (s7 !== peg$FAILED) {
              s8 = peg$parse__();
              s9 = peg$parseKW_DECIMAL();
              if (s9 !== peg$FAILED) {
                s10 = peg$parse__();
                s11 = peg$parseLPAREN();
                if (s11 !== peg$FAILED) {
                  s12 = peg$parse__();
                  s13 = peg$parseint();
                  if (s13 !== peg$FAILED) {
                    s14 = peg$parse__();
                    s15 = peg$parseRPAREN();
                    if (s15 !== peg$FAILED) {
                      s16 = peg$parse__();
                      s17 = peg$parseRPAREN();
                      if (s17 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s0 = peg$f368(s1, s5, s13);
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseKW_CAST();
        if (s1 !== peg$FAILED) {
          s2 = peg$parse__();
          s3 = peg$parseLPAREN();
          if (s3 !== peg$FAILED) {
            s4 = peg$parse__();
            s5 = peg$parseexpr();
            if (s5 !== peg$FAILED) {
              s6 = peg$parse__();
              s7 = peg$parseKW_AS();
              if (s7 !== peg$FAILED) {
                s8 = peg$parse__();
                s9 = peg$parseKW_DECIMAL();
                if (s9 !== peg$FAILED) {
                  s10 = peg$parse__();
                  s11 = peg$parseLPAREN();
                  if (s11 !== peg$FAILED) {
                    s12 = peg$parse__();
                    s13 = peg$parseint();
                    if (s13 !== peg$FAILED) {
                      s14 = peg$parse__();
                      s15 = peg$parseCOMMA();
                      if (s15 !== peg$FAILED) {
                        s16 = peg$parse__();
                        s17 = peg$parseint();
                        if (s17 !== peg$FAILED) {
                          s18 = peg$parse__();
                          s19 = peg$parseRPAREN();
                          if (s19 !== peg$FAILED) {
                            s20 = peg$parse__();
                            s21 = peg$parseRPAREN();
                            if (s21 !== peg$FAILED) {
                              peg$savedPos = s0;
                              s0 = peg$f369(s1, s5, s13, s17);
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$parseKW_CAST();
          if (s1 !== peg$FAILED) {
            s2 = peg$parse__();
            s3 = peg$parseLPAREN();
            if (s3 !== peg$FAILED) {
              s4 = peg$parse__();
              s5 = peg$parseexpr();
              if (s5 !== peg$FAILED) {
                s6 = peg$parse__();
                s7 = peg$parseKW_AS();
                if (s7 !== peg$FAILED) {
                  s8 = peg$parse__();
                  s9 = peg$parsesignedness();
                  if (s9 !== peg$FAILED) {
                    s10 = peg$parse__();
                    s11 = peg$parseKW_INTEGER();
                    if (s11 === peg$FAILED) {
                      s11 = null;
                    }
                    s12 = peg$parse__();
                    s13 = peg$parseRPAREN();
                    if (s13 !== peg$FAILED) {
                      peg$savedPos = s0;
                      s0 = peg$f370(s1, s5, s9, s11);
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parseLPAREN();
            if (s1 !== peg$FAILED) {
              s2 = peg$parse__();
              s3 = peg$parseliteral();
              if (s3 === peg$FAILED) {
                s3 = peg$parseaggr_func();
                if (s3 === peg$FAILED) {
                  s3 = peg$parsewindow_func();
                  if (s3 === peg$FAILED) {
                    s3 = peg$parsefunc_call();
                    if (s3 === peg$FAILED) {
                      s3 = peg$parsecase_expr();
                      if (s3 === peg$FAILED) {
                        s3 = peg$parseinterval_expr();
                        if (s3 === peg$FAILED) {
                          s3 = peg$parsecolumn_ref_array_index();
                          if (s3 === peg$FAILED) {
                            s3 = peg$parseparam();
                          }
                        }
                      }
                    }
                  }
                }
              }
              if (s3 !== peg$FAILED) {
                s4 = peg$parse__();
                s5 = peg$parseRPAREN();
                if (s5 !== peg$FAILED) {
                  s6 = peg$parse__();
                  s7 = peg$parsecast_double_colon();
                  if (s7 === peg$FAILED) {
                    s7 = null;
                  }
                  peg$savedPos = s0;
                  s0 = peg$f371(s3, s7);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              s1 = peg$parseliteral();
              if (s1 === peg$FAILED) {
                s1 = peg$parseaggr_func();
                if (s1 === peg$FAILED) {
                  s1 = peg$parsewindow_func();
                  if (s1 === peg$FAILED) {
                    s1 = peg$parsefunc_call();
                    if (s1 === peg$FAILED) {
                      s1 = peg$parsecase_expr();
                      if (s1 === peg$FAILED) {
                        s1 = peg$parseinterval_expr();
                        if (s1 === peg$FAILED) {
                          s1 = peg$parsecolumn_ref_array_index();
                          if (s1 === peg$FAILED) {
                            s1 = peg$parseparam();
                          }
                        }
                      }
                    }
                  }
                }
              }
              if (s1 !== peg$FAILED) {
                s2 = peg$parse__();
                s3 = peg$parsecast_double_colon();
                if (s3 === peg$FAILED) {
                  s3 = null;
                }
                peg$savedPos = s0;
                s0 = peg$f372(s1, s3);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsesignedness() {
    var s0;

    s0 = peg$parseKW_SIGNED();
    if (s0 === peg$FAILED) {
      s0 = peg$parseKW_UNSIGNED();
    }

    return s0;
  }

  function peg$parseliteral() {
    var s0;

    s0 = peg$parseliteral_string();
    if (s0 === peg$FAILED) {
      s0 = peg$parseliteral_numeric();
      if (s0 === peg$FAILED) {
        s0 = peg$parseliteral_bool();
        if (s0 === peg$FAILED) {
          s0 = peg$parseliteral_null();
          if (s0 === peg$FAILED) {
            s0 = peg$parseliteral_datetime();
            if (s0 === peg$FAILED) {
              s0 = peg$parseliteral_array();
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parseliteral_array() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseKW_ARRAY();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLBRAKE();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseexpr_list();
        if (s5 === peg$FAILED) {
          s5 = null;
        }
        s6 = peg$parse__();
        s7 = peg$parseRBRAKE();
        if (s7 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f373(s1, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseliteral_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseliteral();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseliteral();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseliteral();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f374(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseliteral_null() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_NULL();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f375();
    }
    s0 = s1;

    return s0;
  }

  function peg$parseliteral_not_null() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_NOT_NULL();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f376();
    }
    s0 = s1;

    return s0;
  }

  function peg$parseliteral_bool() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_TRUE();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f377();
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_FALSE();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f378();
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parseliteral_string() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 39) {
      s2 = peg$c124;
      peg$currPos++;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e126);
      }
    }
    if (s2 !== peg$FAILED) {
      s3 = [];
      s4 = peg$parsesingle_char();
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        s4 = peg$parsesingle_char();
      }
      if (input.charCodeAt(peg$currPos) === 39) {
        s4 = peg$c124;
        peg$currPos++;
      } else {
        s4 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e126);
        }
      }
      if (s4 !== peg$FAILED) {
        s2 = [s2, s3, s4];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      if (peg$r8.test(input.charAt(peg$currPos))) {
        s3 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e287);
        }
      }
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          if (peg$r8.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e287);
            }
          }
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        s4 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 39) {
          s5 = peg$c124;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e126);
          }
        }
        if (s5 !== peg$FAILED) {
          s6 = [];
          s7 = peg$parsesingle_char();
          while (s7 !== peg$FAILED) {
            s6.push(s7);
            s7 = peg$parsesingle_char();
          }
          if (input.charCodeAt(peg$currPos) === 39) {
            s7 = peg$c124;
            peg$currPos++;
          } else {
            s7 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e126);
            }
          }
          if (s7 !== peg$FAILED) {
            s5 = [s5, s6, s7];
            s4 = s5;
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f379(s1, s4);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 39) {
        s2 = peg$c124;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e126);
        }
      }
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$parsesingle_char();
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$parsesingle_char();
        }
        if (input.charCodeAt(peg$currPos) === 39) {
          s4 = peg$c124;
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e126);
          }
        }
        if (s4 !== peg$FAILED) {
          s2 = [s2, s3, s4];
          s1 = s2;
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f380(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 34) {
          s2 = peg$c182;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e184);
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parsesingle_quote_char();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parsesingle_quote_char();
          }
          if (input.charCodeAt(peg$currPos) === 34) {
            s4 = peg$c182;
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e184);
            }
          }
          if (s4 !== peg$FAILED) {
            s2 = [s2, s3, s4];
            s1 = s2;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
        if (s1 !== peg$FAILED) {
          s2 = peg$currPos;
          peg$silentFails++;
          s3 = peg$parseDOT();
          peg$silentFails--;
          if (s3 === peg$FAILED) {
            s2 = undefined;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
          if (s2 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f381(s1);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    return s0;
  }

  function peg$parseliteral_datetime() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$parseKW_TIME();
    if (s1 === peg$FAILED) {
      s1 = peg$parseKW_DATE();
      if (s1 === peg$FAILED) {
        s1 = peg$parseKW_TIMESTAMP();
        if (s1 === peg$FAILED) {
          s1 = peg$parseKW_DATETIME();
        }
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 39) {
        s4 = peg$c124;
        peg$currPos++;
      } else {
        s4 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e126);
        }
      }
      if (s4 !== peg$FAILED) {
        s5 = [];
        s6 = peg$parsesingle_char();
        while (s6 !== peg$FAILED) {
          s5.push(s6);
          s6 = peg$parsesingle_char();
        }
        if (input.charCodeAt(peg$currPos) === 39) {
          s6 = peg$c124;
          peg$currPos++;
        } else {
          s6 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e126);
          }
        }
        if (s6 !== peg$FAILED) {
          s4 = [s4, s5, s6];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f382(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_TIME();
      if (s1 === peg$FAILED) {
        s1 = peg$parseKW_DATE();
        if (s1 === peg$FAILED) {
          s1 = peg$parseKW_TIMESTAMP();
          if (s1 === peg$FAILED) {
            s1 = peg$parseKW_DATETIME();
          }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 34) {
          s4 = peg$c182;
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e184);
          }
        }
        if (s4 !== peg$FAILED) {
          s5 = [];
          s6 = peg$parsesingle_quote_char();
          while (s6 !== peg$FAILED) {
            s5.push(s6);
            s6 = peg$parsesingle_quote_char();
          }
          if (input.charCodeAt(peg$currPos) === 34) {
            s6 = peg$c182;
            peg$currPos++;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e184);
            }
          }
          if (s6 !== peg$FAILED) {
            s4 = [s4, s5, s6];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f383(s1, s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsesingle_quote_char() {
    var s0;

    if (peg$r9.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e288);
      }
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseescape_char();
    }

    return s0;
  }

  function peg$parsesingle_char() {
    var s0;

    if (peg$r10.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e289);
      }
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseescape_char();
    }

    return s0;
  }

  function peg$parseescape_char() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2) === peg$c278) {
      s1 = peg$c278;
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e290);
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f384();
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 2) === peg$c279) {
        s1 = peg$c279;
        peg$currPos += 2;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e291);
        }
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f385();
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c280) {
          s1 = peg$c280;
          peg$currPos += 2;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e292);
          }
        }
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$f386();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.substr(peg$currPos, 2) === peg$c281) {
            s1 = peg$c281;
            peg$currPos += 2;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e293);
            }
          }
          if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$f387();
          }
          s0 = s1;
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 2) === peg$c282) {
              s1 = peg$c282;
              peg$currPos += 2;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e294);
              }
            }
            if (s1 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$f388();
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              if (input.substr(peg$currPos, 2) === peg$c283) {
                s1 = peg$c283;
                peg$currPos += 2;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e295);
                }
              }
              if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$f389();
              }
              s0 = s1;
              if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (input.substr(peg$currPos, 2) === peg$c284) {
                  s1 = peg$c284;
                  peg$currPos += 2;
                } else {
                  s1 = peg$FAILED;
                  if (peg$silentFails === 0) {
                    peg$fail(peg$e296);
                  }
                }
                if (s1 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$f390();
                }
                s0 = s1;
                if (s0 === peg$FAILED) {
                  s0 = peg$currPos;
                  if (input.substr(peg$currPos, 2) === peg$c285) {
                    s1 = peg$c285;
                    peg$currPos += 2;
                  } else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                      peg$fail(peg$e297);
                    }
                  }
                  if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$f391();
                  }
                  s0 = s1;
                  if (s0 === peg$FAILED) {
                    s0 = peg$currPos;
                    if (input.substr(peg$currPos, 2) === peg$c286) {
                      s1 = peg$c286;
                      peg$currPos += 2;
                    } else {
                      s1 = peg$FAILED;
                      if (peg$silentFails === 0) {
                        peg$fail(peg$e298);
                      }
                    }
                    if (s1 !== peg$FAILED) {
                      peg$savedPos = s0;
                      s1 = peg$f392();
                    }
                    s0 = s1;
                    if (s0 === peg$FAILED) {
                      s0 = peg$currPos;
                      if (input.substr(peg$currPos, 2) === peg$c287) {
                        s1 = peg$c287;
                        peg$currPos += 2;
                      } else {
                        s1 = peg$FAILED;
                        if (peg$silentFails === 0) {
                          peg$fail(peg$e299);
                        }
                      }
                      if (s1 !== peg$FAILED) {
                        s2 = peg$parsehexDigit();
                        if (s2 !== peg$FAILED) {
                          s3 = peg$parsehexDigit();
                          if (s3 !== peg$FAILED) {
                            s4 = peg$parsehexDigit();
                            if (s4 !== peg$FAILED) {
                              s5 = peg$parsehexDigit();
                              if (s5 !== peg$FAILED) {
                                peg$savedPos = s0;
                                s0 = peg$f393(s2, s3, s4, s5);
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                      if (s0 === peg$FAILED) {
                        s0 = peg$currPos;
                        if (input.charCodeAt(peg$currPos) === 92) {
                          s1 = peg$c288;
                          peg$currPos++;
                        } else {
                          s1 = peg$FAILED;
                          if (peg$silentFails === 0) {
                            peg$fail(peg$e300);
                          }
                        }
                        if (s1 !== peg$FAILED) {
                          peg$savedPos = s0;
                          s1 = peg$f394();
                        }
                        s0 = s1;
                        if (s0 === peg$FAILED) {
                          s0 = peg$currPos;
                          if (input.substr(peg$currPos, 2) === peg$c289) {
                            s1 = peg$c289;
                            peg$currPos += 2;
                          } else {
                            s1 = peg$FAILED;
                            if (peg$silentFails === 0) {
                              peg$fail(peg$e301);
                            }
                          }
                          if (s1 !== peg$FAILED) {
                            peg$savedPos = s0;
                            s1 = peg$f395();
                          }
                          s0 = s1;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parseline_terminator() {
    var s0;

    if (peg$r11.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e302);
      }
    }

    return s0;
  }

  function peg$parseliteral_numeric() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parsenumber();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f396(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsenumber() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseint();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parsefrac();
    if (s2 !== peg$FAILED) {
      s3 = peg$parseexp();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f397(s1, s2, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseint();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      s2 = peg$parsefrac();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f398(s1, s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseint();
        if (s1 !== peg$FAILED) {
          s2 = peg$parseexp();
          if (s2 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f399(s1, s2);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$parseint();
          if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$f400(s1);
          }
          s0 = s1;
        }
      }
    }

    return s0;
  }

  function peg$parseint() {
    var s0, s1, s2;

    s0 = peg$parsedigits();
    if (s0 === peg$FAILED) {
      s0 = peg$parsedigit();
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 45) {
          s1 = peg$c223;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e225);
          }
        }
        if (s1 === peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 43) {
            s1 = peg$c222;
            peg$currPos++;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e224);
            }
          }
        }
        if (s1 !== peg$FAILED) {
          s2 = peg$parsedigits();
          if (s2 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f401(s1, s2);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 45) {
            s1 = peg$c223;
            peg$currPos++;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e225);
            }
          }
          if (s1 === peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 43) {
              s1 = peg$c222;
              peg$currPos++;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e224);
              }
            }
          }
          if (s1 !== peg$FAILED) {
            s2 = peg$parsedigit();
            if (s2 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f402(s1, s2);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        }
      }
    }

    return s0;
  }

  function peg$parsefrac() {
    var s0, s1, s2;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 46) {
      s1 = peg$c290;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e303);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parsedigits();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f403(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseexp() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = peg$parsee();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsedigits();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f404(s1, s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedigits() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parsedigit();
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parsedigit();
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f405(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsedigit() {
    var s0;

    if (peg$r12.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e304);
      }
    }

    return s0;
  }

  function peg$parsehexDigit() {
    var s0;

    if (peg$r13.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e305);
      }
    }

    return s0;
  }

  function peg$parsee() {
    var s0, s1, s2;

    s0 = peg$currPos;
    if (peg$r14.test(input.charAt(peg$currPos))) {
      s1 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e306);
      }
    }
    if (s1 !== peg$FAILED) {
      if (peg$r15.test(input.charAt(peg$currPos))) {
        s2 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e307);
        }
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f406(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_NULL() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c32) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e32);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_DEFAULT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c71) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e73);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_NOT_NULL() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c291) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e308);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_TRUE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c292) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e309);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_TO() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c46) {
      s1 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e48);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_FALSE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c293) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e310);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_SHOW() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c294) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e311);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_DROP() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c295) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e312);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f407();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_USE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c296) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e313);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_ALTER() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c297) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e314);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_SELECT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c298) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e315);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_UPDATE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c299) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e316);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_CREATE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c300) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e317);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_TEMPORARY() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c301) {
      s1 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e318);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f408();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_TEMP() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c302) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e319);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f409();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_DELETE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c303) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e320);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_INSERT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c304) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e321);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_RECURSIVE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9) === peg$c305) {
      s1 = peg$c305;
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e322);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f410();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_REPLACE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c306) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e323);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_RETURNING() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c307) {
      s1 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e324);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f411();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_RENAME() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c308) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e325);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_IGNORE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c242) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e250);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_EXPLAIN() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c309) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e326);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_PARTITION() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c310) {
      s1 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e327);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f412();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_INTO() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c311) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e328);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_FROM() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c312) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e329);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_SET() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c114) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e116);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f413();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_LOCK() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c88) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e90);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_AS() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c313) {
      s1 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e330);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_TABLE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c175) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e177);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f414();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_DATABASE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c144) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e146);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f415();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_SCHEMA() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c2) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e2);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f416();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_SEQUENCE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c143) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e145);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f417();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_TABLESPACE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 10).toLowerCase() === peg$c314) {
      s1 = input.substr(peg$currPos, 10);
      peg$currPos += 10;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e331);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f418();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_COLLATE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c116) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e118);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f419();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_DEALLOCATE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 10).toLowerCase() === peg$c315) {
      s1 = input.substr(peg$currPos, 10);
      peg$currPos += 10;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e332);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f420();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_ON() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c33) {
      s1 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e33);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_LEFT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c316) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e333);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_RIGHT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c317) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e334);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_FULL() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c318) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e335);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_INNER() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c319) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e336);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_JOIN() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c320) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e337);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_OUTER() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c321) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e338);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_UNION() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c322) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e339);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_VALUES() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c323) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e340);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_USING() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c324) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e341);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_WHERE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c325) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e342);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_WITH() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c189) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e191);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_GROUP() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c326) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e343);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_BY() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c327) {
      s1 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e344);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_ORDER() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c328) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e345);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_HAVING() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c329) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e346);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_WINDOW() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c24) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e24);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_LIMIT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c330) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e347);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_OFFSET() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c331) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e348);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f421();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_ASC() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c332) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e349);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f422();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_DESC() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c333) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e350);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f423();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_ALL() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c334) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e351);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f424();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_DISTINCT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c335) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e352);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f425();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_BETWEEN() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c336) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e353);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f426();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_IN() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c128) {
      s1 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e130);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f427();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_IS() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c337) {
      s1 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e354);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f428();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_LIKE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c338) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e355);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f429();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_ILIKE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c339) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e356);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f430();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_EXISTS() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c340) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e357);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f431();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_NOT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c29) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e29);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f432();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_AND() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c341) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e358);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f433();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_OR() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c342) {
      s1 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e359);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f434();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_ARRAY() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c343) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e360);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f435();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_ARRAY_AGG() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c344) {
      s1 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e361);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f436();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_COUNT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c345) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e362);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f437();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_GROUP_CONCAT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 12).toLowerCase() === peg$c346) {
      s1 = input.substr(peg$currPos, 12);
      peg$currPos += 12;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e363);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f438();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_MAX() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c347) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e364);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f439();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_MIN() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c348) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e365);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f440();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_SUM() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c349) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e366);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f441();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_AVG() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c350) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e367);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f442();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_EXTRACT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c351) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e368);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f443();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_CALL() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c352) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e369);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f444();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_CASE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c353) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e370);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_WHEN() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c354) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e371);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_THEN() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c160) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e162);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_ELSE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c355) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e372);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_END() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c161) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e163);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_CAST() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c356) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e373);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f445();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_BOOL() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c357) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e374);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f446();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_BOOLEAN() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c358) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e375);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f447();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_CHAR() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c359) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e376);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f448();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_CHARACTER() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c113) {
      s1 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e115);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f449();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_VARCHAR() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c360) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e377);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f450();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_NUMERIC() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c361) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e378);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f451();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_DECIMAL() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c362) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e379);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f452();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_SIGNED() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c363) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e380);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f453();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_UNSIGNED() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c364) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e381);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f454();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_INT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c365) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e382);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f455();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_ZEROFILL() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c366) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e383);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f456();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_INTEGER() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c367) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e384);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f457();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_JSON() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c368) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e385);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f458();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_JSONB() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c369) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e386);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f459();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_GEOMETRY() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c370) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e387);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f460();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_SMALLINT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c371) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e388);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f461();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_SERIAL() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c372) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e389);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f462();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_TINYINT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c373) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e390);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f463();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_TINYTEXT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c374) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e391);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f464();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_TEXT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c375) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e392);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f465();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_MEDIUMTEXT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 10).toLowerCase() === peg$c376) {
      s1 = input.substr(peg$currPos, 10);
      peg$currPos += 10;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e393);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f466();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_LONGTEXT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c377) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e394);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f467();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_BIGINT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c378) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e395);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f468();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_ENUM() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c379) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e396);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f469();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_FLOAT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c380) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e397);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f470();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_DOUBLE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 16).toLowerCase() === peg$c381) {
      s1 = input.substr(peg$currPos, 16);
      peg$currPos += 16;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e398);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f471();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_BIGSERIAL() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c382) {
      s1 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e399);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f472();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_REAL() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c383) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e400);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f473();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_DATE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c257) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e266);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f474();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_DATETIME() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c384) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e401);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f475();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_ROWS() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c44) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e46);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f476();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_TIME() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c385) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e402);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f477();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_TIMESTAMP() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c386) {
      s1 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e403);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f478();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_TRUNCATE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c387) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e404);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f479();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_USER() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c388) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e405);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f480();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_UUID() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c389) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e406);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f481();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_OID() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c390) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e407);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f482();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_REGCLASS() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c391) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e408);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f483();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_REGCOLLATION() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 12).toLowerCase() === peg$c392) {
      s1 = input.substr(peg$currPos, 12);
      peg$currPos += 12;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e409);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f484();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_REGCONFIG() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c393) {
      s1 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e410);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f485();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_REGDICTIONARY() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 13).toLowerCase() === peg$c394) {
      s1 = input.substr(peg$currPos, 13);
      peg$currPos += 13;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e411);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f486();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_REGNAMESPACE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 12).toLowerCase() === peg$c395) {
      s1 = input.substr(peg$currPos, 12);
      peg$currPos += 12;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e412);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f487();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_REGOPER() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c396) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e413);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f488();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_REGOPERATOR() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 11).toLowerCase() === peg$c397) {
      s1 = input.substr(peg$currPos, 11);
      peg$currPos += 11;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e414);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f489();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_REGPROC() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c398) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e415);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f490();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_REGPROCEDURE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 12).toLowerCase() === peg$c399) {
      s1 = input.substr(peg$currPos, 12);
      peg$currPos += 12;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e416);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f491();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_REGROLE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c400) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e417);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f492();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_REGTYPE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c401) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e418);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f493();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_CURRENT_DATE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 12).toLowerCase() === peg$c402) {
      s1 = input.substr(peg$currPos, 12);
      peg$currPos += 12;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e419);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f494();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_ADD_DATE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c403) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e420);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f495();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_INTERVAL() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c404) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e421);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f496();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_UNIT_YEAR() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c276) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e285);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f497();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_UNIT_MONTH() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c269) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e278);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f498();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_UNIT_DAY() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c256) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e265);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f499();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_UNIT_HOUR() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c262) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e271);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f500();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_UNIT_MINUTE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c268) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e277);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f501();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_UNIT_SECOND() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c271) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e280);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f502();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_CURRENT_TIME() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 12).toLowerCase() === peg$c405) {
      s1 = input.substr(peg$currPos, 12);
      peg$currPos += 12;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e422);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f503();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_CURRENT_TIMESTAMP() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 17).toLowerCase() === peg$c406) {
      s1 = input.substr(peg$currPos, 17);
      peg$currPos += 17;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e423);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f504();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_CURRENT_USER() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 12).toLowerCase() === peg$c82) {
      s1 = input.substr(peg$currPos, 12);
      peg$currPos += 12;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e84);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f505();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_CURRENT_ROLE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 12).toLowerCase() === peg$c81) {
      s1 = input.substr(peg$currPos, 12);
      peg$currPos += 12;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e83);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f506();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_SESSION_USER() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 12).toLowerCase() === peg$c83) {
      s1 = input.substr(peg$currPos, 12);
      peg$currPos += 12;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e85);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f507();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_SYSTEM_USER() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 11).toLowerCase() === peg$c407) {
      s1 = input.substr(peg$currPos, 11);
      peg$currPos += 11;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e424);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f508();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_GLOBAL() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c408) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e425);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f509();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_SESSION() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c409) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e426);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f510();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_LOCAL() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c5) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e5);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f511();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_PERSIST() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c410) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e427);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f512();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_PERSIST_ONLY() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 12).toLowerCase() === peg$c411) {
      s1 = input.substr(peg$currPos, 12);
      peg$currPos += 12;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e428);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f513();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_VIEW() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c412) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e429);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f514();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_VAR__PRE_AT() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 64) {
      s0 = peg$c413;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e430);
      }
    }

    return s0;
  }

  function peg$parseKW_VAR__PRE_AT_AT() {
    var s0;

    if (input.substr(peg$currPos, 2) === peg$c414) {
      s0 = peg$c414;
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e431);
      }
    }

    return s0;
  }

  function peg$parseKW_VAR_PRE_DOLLAR() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 36) {
      s0 = peg$c228;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e230);
      }
    }

    return s0;
  }

  function peg$parseKW_VAR_PRE_DOLLAR_DOUBLE() {
    var s0;

    if (input.substr(peg$currPos, 2) === peg$c415) {
      s0 = peg$c415;
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e432);
      }
    }

    return s0;
  }

  function peg$parseKW_VAR_PRE() {
    var s0;

    s0 = peg$parseKW_VAR__PRE_AT_AT();
    if (s0 === peg$FAILED) {
      s0 = peg$parseKW_VAR__PRE_AT();
      if (s0 === peg$FAILED) {
        s0 = peg$parseKW_VAR_PRE_DOLLAR();
        if (s0 === peg$FAILED) {
          s0 = peg$parseKW_VAR_PRE_DOLLAR();
        }
      }
    }

    return s0;
  }

  function peg$parseKW_RETURN() {
    var s0;

    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c416) {
      s0 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e433);
      }
    }

    return s0;
  }

  function peg$parseKW_ASSIGN() {
    var s0;

    if (input.substr(peg$currPos, 2) === peg$c17) {
      s0 = peg$c17;
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e17);
      }
    }

    return s0;
  }

  function peg$parseKW_DOUBLE_COLON() {
    var s0;

    if (input.substr(peg$currPos, 2) === peg$c417) {
      s0 = peg$c417;
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e434);
      }
    }

    return s0;
  }

  function peg$parseKW_ASSIGIN_EQUAL() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 61) {
      s0 = peg$c47;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e49);
      }
    }

    return s0;
  }

  function peg$parseKW_DUAL() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c418) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e435);
      }
    }

    return s0;
  }

  function peg$parseKW_ADD() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c419) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e436);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f515();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_COLUMN() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c172) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e174);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f516();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_INDEX() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c420) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e437);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f517();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_KEY() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c66) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e68);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f518();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_FULLTEXT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c421) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e438);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f519();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_SPATIAL() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c422) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e439);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f520();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_UNIQUE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c65) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e67);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f521();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_KEY_BLOCK_SIZE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 14).toLowerCase() === peg$c118) {
      s1 = input.substr(peg$currPos, 14);
      peg$currPos += 14;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e120);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f522();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_COMMENT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c423) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e440);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f523();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_CONSTRAINT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 10).toLowerCase() === peg$c173) {
      s1 = input.substr(peg$currPos, 10);
      peg$currPos += 10;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e175);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f524();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_CONCURRENTLY() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 12).toLowerCase() === peg$c424) {
      s1 = input.substr(peg$currPos, 12);
      peg$currPos += 12;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e441);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f525();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_REFERENCES() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 10).toLowerCase() === peg$c425) {
      s1 = input.substr(peg$currPos, 10);
      peg$currPos += 10;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e442);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f526();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseOPT_SQL_CALC_FOUND_ROWS() {
    var s0;

    if (input.substr(peg$currPos, 19).toLowerCase() === peg$c426) {
      s0 = input.substr(peg$currPos, 19);
      peg$currPos += 19;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e443);
      }
    }

    return s0;
  }

  function peg$parseOPT_SQL_CACHE() {
    var s0;

    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c427) {
      s0 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e444);
      }
    }

    return s0;
  }

  function peg$parseOPT_SQL_NO_CACHE() {
    var s0;

    if (input.substr(peg$currPos, 12).toLowerCase() === peg$c428) {
      s0 = input.substr(peg$currPos, 12);
      peg$currPos += 12;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e445);
      }
    }

    return s0;
  }

  function peg$parseOPT_SQL_SMALL_RESULT() {
    var s0;

    if (input.substr(peg$currPos, 16).toLowerCase() === peg$c429) {
      s0 = input.substr(peg$currPos, 16);
      peg$currPos += 16;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e446);
      }
    }

    return s0;
  }

  function peg$parseOPT_SQL_BIG_RESULT() {
    var s0;

    if (input.substr(peg$currPos, 14).toLowerCase() === peg$c430) {
      s0 = input.substr(peg$currPos, 14);
      peg$currPos += 14;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e447);
      }
    }

    return s0;
  }

  function peg$parseOPT_SQL_BUFFER_RESULT() {
    var s0;

    if (input.substr(peg$currPos, 17).toLowerCase() === peg$c431) {
      s0 = input.substr(peg$currPos, 17);
      peg$currPos += 17;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e448);
      }
    }

    return s0;
  }

  function peg$parseDOT() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 46) {
      s0 = peg$c290;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e303);
      }
    }

    return s0;
  }

  function peg$parseCOMMA() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 44) {
      s0 = peg$c432;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e449);
      }
    }

    return s0;
  }

  function peg$parseSTAR() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 42) {
      s0 = peg$c224;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e226);
      }
    }

    return s0;
  }

  function peg$parseLPAREN() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 40) {
      s0 = peg$c180;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e182);
      }
    }

    return s0;
  }

  function peg$parseRPAREN() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 41) {
      s0 = peg$c181;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e183);
      }
    }

    return s0;
  }

  function peg$parseLBRAKE() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 91) {
      s0 = peg$c433;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e450);
      }
    }

    return s0;
  }

  function peg$parseRBRAKE() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 93) {
      s0 = peg$c434;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e451);
      }
    }

    return s0;
  }

  function peg$parseSEMICOLON() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 59) {
      s0 = peg$c179;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e181);
      }
    }

    return s0;
  }

  function peg$parseSINGLE_ARROW() {
    var s0;

    if (input.substr(peg$currPos, 2) === peg$c435) {
      s0 = peg$c435;
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e452);
      }
    }

    return s0;
  }

  function peg$parseDOUBLE_ARROW() {
    var s0;

    if (input.substr(peg$currPos, 3) === peg$c436) {
      s0 = peg$c436;
      peg$currPos += 3;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e453);
      }
    }

    return s0;
  }

  function peg$parseWELL_ARROW() {
    var s0;

    if (input.substr(peg$currPos, 2) === peg$c437) {
      s0 = peg$c437;
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e454);
      }
    }

    return s0;
  }

  function peg$parseDOUBLE_WELL_ARROW() {
    var s0;

    if (input.substr(peg$currPos, 3) === peg$c438) {
      s0 = peg$c438;
      peg$currPos += 3;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e455);
      }
    }

    return s0;
  }

  function peg$parseOPERATOR_CONCATENATION() {
    var s0;

    if (input.substr(peg$currPos, 2) === peg$c227) {
      s0 = peg$c227;
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e229);
      }
    }

    return s0;
  }

  function peg$parseOPERATOR_AND() {
    var s0;

    if (input.substr(peg$currPos, 2) === peg$c439) {
      s0 = peg$c439;
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e456);
      }
    }

    return s0;
  }

  function peg$parseLOGIC_OPERATOR() {
    var s0;

    s0 = peg$parseOPERATOR_CONCATENATION();
    if (s0 === peg$FAILED) {
      s0 = peg$parseOPERATOR_AND();
    }

    return s0;
  }

  function peg$parse__() {
    var s0, s1;

    s0 = [];
    s1 = peg$parsewhitespace();
    if (s1 === peg$FAILED) {
      s1 = peg$parsecomment();
    }
    while (s1 !== peg$FAILED) {
      s0.push(s1);
      s1 = peg$parsewhitespace();
      if (s1 === peg$FAILED) {
        s1 = peg$parsecomment();
      }
    }

    return s0;
  }

  function peg$parse___() {
    var s0, s1;

    s0 = [];
    s1 = peg$parsewhitespace();
    if (s1 === peg$FAILED) {
      s1 = peg$parsecomment();
    }
    if (s1 !== peg$FAILED) {
      while (s1 !== peg$FAILED) {
        s0.push(s1);
        s1 = peg$parsewhitespace();
        if (s1 === peg$FAILED) {
          s1 = peg$parsecomment();
        }
      }
    } else {
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecomment() {
    var s0;

    s0 = peg$parseblock_comment();
    if (s0 === peg$FAILED) {
      s0 = peg$parseline_comment();
    }

    return s0;
  }

  function peg$parseblock_comment() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2) === peg$c440) {
      s1 = peg$c440;
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e457);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$currPos;
      peg$silentFails++;
      if (input.substr(peg$currPos, 2) === peg$c441) {
        s5 = peg$c441;
        peg$currPos += 2;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e458);
        }
      }
      peg$silentFails--;
      if (s5 === peg$FAILED) {
        s4 = undefined;
      } else {
        peg$currPos = s4;
        s4 = peg$FAILED;
      }
      if (s4 !== peg$FAILED) {
        s5 = peg$currPos;
        peg$silentFails++;
        if (input.substr(peg$currPos, 2) === peg$c440) {
          s6 = peg$c440;
          peg$currPos += 2;
        } else {
          s6 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e457);
          }
        }
        peg$silentFails--;
        if (s6 === peg$FAILED) {
          s5 = undefined;
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parsechar();
          if (s6 !== peg$FAILED) {
            s4 = [s4, s5, s6];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 === peg$FAILED) {
        s3 = peg$parseblock_comment();
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$currPos;
        peg$silentFails++;
        if (input.substr(peg$currPos, 2) === peg$c441) {
          s5 = peg$c441;
          peg$currPos += 2;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e458);
          }
        }
        peg$silentFails--;
        if (s5 === peg$FAILED) {
          s4 = undefined;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$currPos;
          peg$silentFails++;
          if (input.substr(peg$currPos, 2) === peg$c440) {
            s6 = peg$c440;
            peg$currPos += 2;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e457);
            }
          }
          peg$silentFails--;
          if (s6 === peg$FAILED) {
            s5 = undefined;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parsechar();
            if (s6 !== peg$FAILED) {
              s4 = [s4, s5, s6];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = peg$parseblock_comment();
        }
      }
      if (input.substr(peg$currPos, 2) === peg$c441) {
        s3 = peg$c441;
        peg$currPos += 2;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e458);
        }
      }
      if (s3 !== peg$FAILED) {
        s1 = [s1, s2, s3];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseline_comment() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2) === peg$c442) {
      s1 = peg$c442;
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e459);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$currPos;
      peg$silentFails++;
      s5 = peg$parseEOL();
      peg$silentFails--;
      if (s5 === peg$FAILED) {
        s4 = undefined;
      } else {
        peg$currPos = s4;
        s4 = peg$FAILED;
      }
      if (s4 !== peg$FAILED) {
        s5 = peg$parsechar();
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$currPos;
        peg$silentFails++;
        s5 = peg$parseEOL();
        peg$silentFails--;
        if (s5 === peg$FAILED) {
          s4 = undefined;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parsechar();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      s1 = [s1, s2];
      s0 = s1;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsepound_sign_comment() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 35) {
      s1 = peg$c443;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e460);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$currPos;
      peg$silentFails++;
      s5 = peg$parseEOL();
      peg$silentFails--;
      if (s5 === peg$FAILED) {
        s4 = undefined;
      } else {
        peg$currPos = s4;
        s4 = peg$FAILED;
      }
      if (s4 !== peg$FAILED) {
        s5 = peg$parsechar();
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$currPos;
        peg$silentFails++;
        s5 = peg$parseEOL();
        peg$silentFails--;
        if (s5 === peg$FAILED) {
          s4 = undefined;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parsechar();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      s1 = [s1, s2];
      s0 = s1;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsekeyword_comment() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_COMMENT();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_ASSIGIN_EQUAL();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseliteral_string();
      if (s5 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f527(s1, s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsechar() {
    var s0;

    if (input.length > peg$currPos) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e461);
      }
    }

    return s0;
  }

  function peg$parseinterval_unit() {
    var s0;

    s0 = peg$parseKW_UNIT_YEAR();
    if (s0 === peg$FAILED) {
      s0 = peg$parseKW_UNIT_MONTH();
      if (s0 === peg$FAILED) {
        s0 = peg$parseKW_UNIT_DAY();
        if (s0 === peg$FAILED) {
          s0 = peg$parseKW_UNIT_HOUR();
          if (s0 === peg$FAILED) {
            s0 = peg$parseKW_UNIT_MINUTE();
            if (s0 === peg$FAILED) {
              s0 = peg$parseKW_UNIT_SECOND();
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsewhitespace() {
    var s0;

    if (peg$r16.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e462);
      }
    }

    return s0;
  }

  function peg$parseEOL() {
    var s0, s1;

    s0 = peg$parseEOF();
    if (s0 === peg$FAILED) {
      s0 = [];
      if (peg$r11.test(input.charAt(peg$currPos))) {
        s1 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e302);
        }
      }
      if (s1 !== peg$FAILED) {
        while (s1 !== peg$FAILED) {
          s0.push(s1);
          if (peg$r11.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e302);
            }
          }
        }
      } else {
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseEOF() {
    var s0, s1;

    s0 = peg$currPos;
    peg$silentFails++;
    if (input.length > peg$currPos) {
      s1 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e461);
      }
    }
    peg$silentFails--;
    if (s1 === peg$FAILED) {
      s0 = undefined;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseproc_stmts() {
    var s0, s1;

    s0 = [];
    s1 = peg$parseproc_stmt();
    while (s1 !== peg$FAILED) {
      s0.push(s1);
      s1 = peg$parseproc_stmt();
    }

    return s0;
  }

  function peg$parseproc_stmt() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    peg$savedPos = peg$currPos;
    s1 = peg$f528();
    if (s1) {
      s1 = undefined;
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseassign_stmt();
      if (s3 === peg$FAILED) {
        s3 = peg$parsereturn_stmt();
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f529(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseassign_stmt() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsevar_decl();
    if (s1 === peg$FAILED) {
      s1 = peg$parsewithout_prefix_var_decl();
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_ASSIGN();
      if (s3 === peg$FAILED) {
        s3 = peg$parseKW_ASSIGIN_EQUAL();
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseproc_expr();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f530(s1, s3, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsereturn_stmt() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_RETURN();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseproc_expr();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f531(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseproc_expr() {
    var s0;

    s0 = peg$parseselect_stmt();
    if (s0 === peg$FAILED) {
      s0 = peg$parseproc_join();
      if (s0 === peg$FAILED) {
        s0 = peg$parseproc_additive_expr();
        if (s0 === peg$FAILED) {
          s0 = peg$parseproc_array();
        }
      }
    }

    return s0;
  }

  function peg$parseproc_additive_expr() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseproc_multiplicative_expr();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseadditive_operator();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseproc_multiplicative_expr();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseadditive_operator();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseproc_multiplicative_expr();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f532(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseproc_multiplicative_expr() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseproc_primary();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parsemultiplicative_operator();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseproc_primary();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parsemultiplicative_operator();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseproc_primary();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f533(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseproc_join() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsevar_decl();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsejoin_op();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsevar_decl();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseon_clause();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f534(s1, s3, s5, s7);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseproc_primary() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$parseliteral();
    if (s0 === peg$FAILED) {
      s0 = peg$parsevar_decl();
      if (s0 === peg$FAILED) {
        s0 = peg$parseproc_func_call();
        if (s0 === peg$FAILED) {
          s0 = peg$parseparam();
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parseLPAREN();
            if (s1 !== peg$FAILED) {
              s2 = peg$parse__();
              s3 = peg$parseproc_additive_expr();
              if (s3 !== peg$FAILED) {
                s4 = peg$parse__();
                s5 = peg$parseRPAREN();
                if (s5 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s0 = peg$f535(s3);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              s1 = peg$parseident_name();
              if (s1 !== peg$FAILED) {
                s2 = peg$currPos;
                s3 = peg$parseDOT();
                if (s3 !== peg$FAILED) {
                  s4 = peg$parse__();
                  s5 = peg$parseident_name();
                  if (s5 !== peg$FAILED) {
                    s3 = [s3, s4, s5];
                    s2 = s3;
                  } else {
                    peg$currPos = s2;
                    s2 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }
                if (s2 === peg$FAILED) {
                  s2 = null;
                }
                peg$savedPos = s0;
                s0 = peg$f536(s1, s2);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parseproc_func_name() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$parseident_name();
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$parse__();
      s4 = peg$parseDOT();
      if (s4 !== peg$FAILED) {
        s5 = peg$parse__();
        s6 = peg$parseident_name();
        if (s6 !== peg$FAILED) {
          s3 = [s3, s4, s5, s6];
          s2 = s3;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f537(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseproc_func_call() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseproc_func_name();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseproc_primary_list();
        if (s5 === peg$FAILED) {
          s5 = null;
        }
        s6 = peg$parse__();
        s7 = peg$parseRPAREN();
        if (s7 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f538(s1, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseproc_primary_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseproc_primary();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseproc_primary();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseproc_primary();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f539(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseproc_array() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseLBRAKE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseproc_primary_list();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseRBRAKE();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f540(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsevar_decl_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsevar_decl();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsevar_decl();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsevar_decl();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f541(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsevar_decl() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8;

    s0 = peg$currPos;
    s1 = peg$parseKW_VAR_PRE_DOLLAR_DOUBLE();
    if (s1 !== peg$FAILED) {
      s2 = [];
      if (peg$r17.test(input.charAt(peg$currPos))) {
        s3 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e463);
        }
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        if (peg$r17.test(input.charAt(peg$currPos))) {
          s3 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e463);
          }
        }
      }
      s3 = peg$parseKW_VAR_PRE_DOLLAR_DOUBLE();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f542(s1, s2, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_VAR_PRE_DOLLAR();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsecolumn();
        if (s2 !== peg$FAILED) {
          s3 = peg$parseKW_VAR_PRE_DOLLAR();
          if (s3 !== peg$FAILED) {
            s4 = [];
            if (peg$r17.test(input.charAt(peg$currPos))) {
              s5 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e463);
              }
            }
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              if (peg$r17.test(input.charAt(peg$currPos))) {
                s5 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$e463);
                }
              }
            }
            s5 = peg$parseKW_VAR_PRE_DOLLAR();
            if (s5 !== peg$FAILED) {
              s6 = peg$parsecolumn();
              if (s6 !== peg$FAILED) {
                peg$savedPos = peg$currPos;
                s7 = peg$f543(s2, s4, s6);
                if (s7) {
                  s7 = peg$FAILED;
                } else {
                  s7 = undefined;
                }
                if (s7 !== peg$FAILED) {
                  s8 = peg$parseKW_VAR_PRE_DOLLAR();
                  if (s8 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s0 = peg$f544(s2, s4, s6);
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseKW_VAR_PRE();
        if (s1 !== peg$FAILED) {
          s2 = peg$parsewithout_prefix_var_decl();
          if (s2 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f545(s1, s2);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    return s0;
  }

  function peg$parsewithout_prefix_var_decl() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 34) {
      s1 = peg$c182;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e184);
      }
    }
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parseident_name();
    if (s2 !== peg$FAILED) {
      s3 = peg$parsemem_chain();
      if (input.charCodeAt(peg$currPos) === 34) {
        s4 = peg$c182;
        peg$currPos++;
      } else {
        s4 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e184);
        }
      }
      if (s4 === peg$FAILED) {
        s4 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f546(s1, s2, s3, s4);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseliteral_numeric();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f547(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parsemem_chain() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 46) {
      s3 = peg$c290;
      peg$currPos++;
    } else {
      s3 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e303);
      }
    }
    if (s3 !== peg$FAILED) {
      s4 = peg$parseident_name();
      if (s4 !== peg$FAILED) {
        s3 = [s3, s4];
        s2 = s3;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
    } else {
      peg$currPos = s2;
      s2 = peg$FAILED;
    }
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 46) {
        s3 = peg$c290;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e303);
        }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parseident_name();
        if (s4 !== peg$FAILED) {
          s3 = [s3, s4];
          s2 = s3;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
    }
    peg$savedPos = s0;
    s1 = peg$f548(s1);
    s0 = s1;

    return s0;
  }

  function peg$parsedata_type() {
    var s0;

    s0 = peg$parsearray_type();
    if (s0 === peg$FAILED) {
      s0 = peg$parsecharacter_string_type();
      if (s0 === peg$FAILED) {
        s0 = peg$parsenumeric_type();
        if (s0 === peg$FAILED) {
          s0 = peg$parsedatetime_type();
          if (s0 === peg$FAILED) {
            s0 = peg$parsejson_type();
            if (s0 === peg$FAILED) {
              s0 = peg$parsegeometry_type();
              if (s0 === peg$FAILED) {
                s0 = peg$parsetext_type();
                if (s0 === peg$FAILED) {
                  s0 = peg$parseuuid_type();
                  if (s0 === peg$FAILED) {
                    s0 = peg$parseboolean_type();
                    if (s0 === peg$FAILED) {
                      s0 = peg$parseenum_type();
                      if (s0 === peg$FAILED) {
                        s0 = peg$parseserial_interval_type();
                        if (s0 === peg$FAILED) {
                          s0 = peg$parsebinary_type();
                          if (s0 === peg$FAILED) {
                            s0 = peg$parseoid_type();
                            if (s0 === peg$FAILED) {
                              s0 = peg$parserecord_type();
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsearray_type() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parsenumeric_type();
    if (s1 === peg$FAILED) {
      s1 = peg$parsecharacter_string_type();
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLBRAKE();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseRBRAKE();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseLBRAKE();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseRBRAKE();
            if (s9 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f549(s1);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsenumeric_type();
      if (s1 === peg$FAILED) {
        s1 = peg$parsecharacter_string_type();
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseLBRAKE();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parseRBRAKE();
          if (s5 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f550(s1);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseboolean_type() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_BOOL();
    if (s1 === peg$FAILED) {
      s1 = peg$parseKW_BOOLEAN();
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f551(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsebinary_type() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c444) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e464);
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f552();
    }
    s0 = s1;

    return s0;
  }

  function peg$parsecharacter_varying() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_CHARACTER();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.substr(peg$currPos, 7).toLowerCase() === peg$c445) {
        s3 = input.substr(peg$currPos, 7);
        peg$currPos += 7;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e465);
        }
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f553();
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecharacter_string_type() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseKW_CHAR();
    if (s1 === peg$FAILED) {
      s1 = peg$parseKW_VARCHAR();
      if (s1 === peg$FAILED) {
        s1 = peg$parsecharacter_varying();
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = [];
        if (peg$r12.test(input.charAt(peg$currPos))) {
          s6 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s6 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e304);
          }
        }
        if (s6 !== peg$FAILED) {
          while (s6 !== peg$FAILED) {
            s5.push(s6);
            if (peg$r12.test(input.charAt(peg$currPos))) {
              s6 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e304);
              }
            }
          }
        } else {
          s5 = peg$FAILED;
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseRPAREN();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f554(s1, s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_CHAR();
      if (s1 === peg$FAILED) {
        s1 = peg$parsecharacter_varying();
        if (s1 === peg$FAILED) {
          s1 = peg$parseKW_VARCHAR();
        }
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f555(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parsenumeric_type_suffix() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_UNSIGNED();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    s3 = peg$parseKW_ZEROFILL();
    if (s3 === peg$FAILED) {
      s3 = null;
    }
    peg$savedPos = s0;
    s0 = peg$f556(s1, s3);

    return s0;
  }

  function peg$parsenumeric_type() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;

    s0 = peg$currPos;
    s1 = peg$parseKW_NUMERIC();
    if (s1 === peg$FAILED) {
      s1 = peg$parseKW_DECIMAL();
      if (s1 === peg$FAILED) {
        s1 = peg$parseKW_INT();
        if (s1 === peg$FAILED) {
          s1 = peg$parseKW_INTEGER();
          if (s1 === peg$FAILED) {
            s1 = peg$parseKW_SMALLINT();
            if (s1 === peg$FAILED) {
              s1 = peg$parseKW_TINYINT();
              if (s1 === peg$FAILED) {
                s1 = peg$parseKW_BIGINT();
                if (s1 === peg$FAILED) {
                  s1 = peg$parseKW_FLOAT();
                  if (s1 === peg$FAILED) {
                    s1 = peg$parseKW_DOUBLE();
                    if (s1 === peg$FAILED) {
                      s1 = peg$parseKW_SERIAL();
                      if (s1 === peg$FAILED) {
                        s1 = peg$parseKW_BIGSERIAL();
                        if (s1 === peg$FAILED) {
                          s1 = peg$parseKW_REAL();
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = [];
        if (peg$r12.test(input.charAt(peg$currPos))) {
          s6 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s6 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e304);
          }
        }
        if (s6 !== peg$FAILED) {
          while (s6 !== peg$FAILED) {
            s5.push(s6);
            if (peg$r12.test(input.charAt(peg$currPos))) {
              s6 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e304);
              }
            }
          }
        } else {
          s5 = peg$FAILED;
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$currPos;
          s8 = peg$parseCOMMA();
          if (s8 !== peg$FAILED) {
            s9 = peg$parse__();
            s10 = [];
            if (peg$r12.test(input.charAt(peg$currPos))) {
              s11 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s11 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e304);
              }
            }
            if (s11 !== peg$FAILED) {
              while (s11 !== peg$FAILED) {
                s10.push(s11);
                if (peg$r12.test(input.charAt(peg$currPos))) {
                  s11 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s11 = peg$FAILED;
                  if (peg$silentFails === 0) {
                    peg$fail(peg$e304);
                  }
                }
              }
            } else {
              s10 = peg$FAILED;
            }
            if (s10 !== peg$FAILED) {
              s8 = [s8, s9, s10];
              s7 = s8;
            } else {
              peg$currPos = s7;
              s7 = peg$FAILED;
            }
          } else {
            peg$currPos = s7;
            s7 = peg$FAILED;
          }
          if (s7 === peg$FAILED) {
            s7 = null;
          }
          s8 = peg$parse__();
          s9 = peg$parseRPAREN();
          if (s9 !== peg$FAILED) {
            s10 = peg$parse__();
            s11 = peg$parsenumeric_type_suffix();
            peg$savedPos = s0;
            s0 = peg$f557(s1, s5, s7, s11);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_NUMERIC();
      if (s1 === peg$FAILED) {
        s1 = peg$parseKW_DECIMAL();
        if (s1 === peg$FAILED) {
          s1 = peg$parseKW_INT();
          if (s1 === peg$FAILED) {
            s1 = peg$parseKW_INTEGER();
            if (s1 === peg$FAILED) {
              s1 = peg$parseKW_SMALLINT();
              if (s1 === peg$FAILED) {
                s1 = peg$parseKW_TINYINT();
                if (s1 === peg$FAILED) {
                  s1 = peg$parseKW_BIGINT();
                  if (s1 === peg$FAILED) {
                    s1 = peg$parseKW_FLOAT();
                    if (s1 === peg$FAILED) {
                      s1 = peg$parseKW_DOUBLE();
                      if (s1 === peg$FAILED) {
                        s1 = peg$parseKW_SERIAL();
                        if (s1 === peg$FAILED) {
                          s1 = peg$parseKW_BIGSERIAL();
                          if (s1 === peg$FAILED) {
                            s1 = peg$parseKW_REAL();
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        if (peg$r12.test(input.charAt(peg$currPos))) {
          s3 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e304);
          }
        }
        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            if (peg$r12.test(input.charAt(peg$currPos))) {
              s3 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e304);
              }
            }
          }
        } else {
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parse__();
          s4 = peg$parsenumeric_type_suffix();
          peg$savedPos = s0;
          s0 = peg$f558(s1, s2, s4);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseKW_NUMERIC();
        if (s1 === peg$FAILED) {
          s1 = peg$parseKW_DECIMAL();
          if (s1 === peg$FAILED) {
            s1 = peg$parseKW_INT();
            if (s1 === peg$FAILED) {
              s1 = peg$parseKW_INTEGER();
              if (s1 === peg$FAILED) {
                s1 = peg$parseKW_SMALLINT();
                if (s1 === peg$FAILED) {
                  s1 = peg$parseKW_TINYINT();
                  if (s1 === peg$FAILED) {
                    s1 = peg$parseKW_BIGINT();
                    if (s1 === peg$FAILED) {
                      s1 = peg$parseKW_FLOAT();
                      if (s1 === peg$FAILED) {
                        s1 = peg$parseKW_DOUBLE();
                        if (s1 === peg$FAILED) {
                          s1 = peg$parseKW_SERIAL();
                          if (s1 === peg$FAILED) {
                            s1 = peg$parseKW_BIGSERIAL();
                            if (s1 === peg$FAILED) {
                              s1 = peg$parseKW_REAL();
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
        if (s1 !== peg$FAILED) {
          s2 = peg$parse__();
          s3 = peg$parsenumeric_type_suffix();
          s4 = peg$parse__();
          peg$savedPos = s0;
          s0 = peg$f559(s1, s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    return s0;
  }

  function peg$parseoid_type() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_OID();
    if (s1 === peg$FAILED) {
      s1 = peg$parseKW_REGCLASS();
      if (s1 === peg$FAILED) {
        s1 = peg$parseKW_REGCOLLATION();
        if (s1 === peg$FAILED) {
          s1 = peg$parseKW_REGCONFIG();
          if (s1 === peg$FAILED) {
            s1 = peg$parseKW_REGDICTIONARY();
            if (s1 === peg$FAILED) {
              s1 = peg$parseKW_REGNAMESPACE();
              if (s1 === peg$FAILED) {
                s1 = peg$parseKW_REGOPER();
                if (s1 === peg$FAILED) {
                  s1 = peg$parseKW_REGOPERATOR();
                  if (s1 === peg$FAILED) {
                    s1 = peg$parseKW_REGPROC();
                    if (s1 === peg$FAILED) {
                      s1 = peg$parseKW_REGPROCEDURE();
                      if (s1 === peg$FAILED) {
                        s1 = peg$parseKW_REGROLE();
                        if (s1 === peg$FAILED) {
                          s1 = peg$parseKW_REGTYPE();
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f560(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsetimezone() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c446) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e466);
      }
    }
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 4).toLowerCase() === peg$c189) {
        s1 = input.substr(peg$currPos, 4);
        peg$currPos += 4;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e191);
        }
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_TIME();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        if (input.substr(peg$currPos, 4).toLowerCase() === peg$c254) {
          s5 = input.substr(peg$currPos, 4);
          peg$currPos += 4;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e467);
          }
        }
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f561(s1);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetime_type() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parseKW_TIME();
    if (s1 === peg$FAILED) {
      s1 = peg$parseKW_TIMESTAMP();
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = [];
        if (peg$r12.test(input.charAt(peg$currPos))) {
          s6 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s6 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e304);
          }
        }
        if (s6 !== peg$FAILED) {
          while (s6 !== peg$FAILED) {
            s5.push(s6);
            if (peg$r12.test(input.charAt(peg$currPos))) {
              s6 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e304);
              }
            }
          }
        } else {
          s5 = peg$FAILED;
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseRPAREN();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parsetimezone();
            if (s9 === peg$FAILED) {
              s9 = null;
            }
            peg$savedPos = s0;
            s0 = peg$f562(s1, s5, s9);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_TIME();
      if (s1 === peg$FAILED) {
        s1 = peg$parseKW_TIMESTAMP();
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parsetimezone();
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f563(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsedatetime_type() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseKW_DATE();
    if (s1 === peg$FAILED) {
      s1 = peg$parseKW_DATETIME();
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = [];
        if (peg$r12.test(input.charAt(peg$currPos))) {
          s6 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s6 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e304);
          }
        }
        if (s6 !== peg$FAILED) {
          while (s6 !== peg$FAILED) {
            s5.push(s6);
            if (peg$r12.test(input.charAt(peg$currPos))) {
              s6 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$e304);
              }
            }
          }
        } else {
          s5 = peg$FAILED;
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseRPAREN();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f564(s1, s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_DATE();
      if (s1 === peg$FAILED) {
        s1 = peg$parseKW_DATETIME();
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f565(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$parsetime_type();
      }
    }

    return s0;
  }

  function peg$parseenum_type() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_ENUM();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsevalue_item();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f566(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsejson_type() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_JSON();
    if (s1 === peg$FAILED) {
      s1 = peg$parseKW_JSONB();
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f567(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsegeometry_type() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_GEOMETRY();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f568(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parseserial_interval_type() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_SERIAL();
    if (s1 === peg$FAILED) {
      s1 = peg$parseKW_INTERVAL();
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f569(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsetext_type() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$parseKW_TINYTEXT();
    if (s1 === peg$FAILED) {
      s1 = peg$parseKW_TEXT();
      if (s1 === peg$FAILED) {
        s1 = peg$parseKW_MEDIUMTEXT();
        if (s1 === peg$FAILED) {
          s1 = peg$parseKW_LONGTEXT();
        }
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parseLBRAKE();
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        s4 = peg$parseRBRAKE();
        if (s4 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f570(s1);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_TINYTEXT();
      if (s1 === peg$FAILED) {
        s1 = peg$parseKW_TEXT();
        if (s1 === peg$FAILED) {
          s1 = peg$parseKW_MEDIUMTEXT();
          if (s1 === peg$FAILED) {
            s1 = peg$parseKW_LONGTEXT();
          }
        }
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f571(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parseuuid_type() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_UUID();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f572(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parserecord_type() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c447) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e468);
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f573();
    }
    s0 = s1;

    return s0;
  }

  const reservedMap = {
    ALTER: true,
    ALL: true,
    ADD: true,
    AND: true,
    AS: true,
    ASC: true,

    BETWEEN: true,
    BY: true,

    CALL: true,
    CASE: true,
    CREATE: true,
    CONTAINS: true,
    CURRENT_DATE: true,
    CURRENT_TIME: true,
    CURRENT_TIMESTAMP: true,
    CURRENT_USER: true,

    DELETE: true,
    DESC: true,
    DISTINCT: true,
    DROP: true,

    ELSE: true,
    END: true,
    EXISTS: true,
    EXPLAIN: true,

    FALSE: true,
    FROM: true,
    FULL: true,

    GROUP: true,

    HAVING: true,

    IN: true,
    INNER: true,
    INSERT: true,
    INTO: true,
    IS: true,

    JOIN: true,
    JSON: true,

    // 'KEY': true,

    LEFT: true,
    LIKE: true,
    LIMIT: true,

    NOT: true,
    NULL: true,
    NULLS: true,

    OFFSET: true,
    ON: true,
    OR: true,
    ORDER: true,
    OUTER: true,

    RECURSIVE: true,
    RENAME: true,
    // 'REPLACE': true,
    RIGHT: true,

    SELECT: true,
    SESSION_USER: true,
    SET: true,
    SHOW: true,
    SYSTEM_USER: true,

    TABLE: true,
    THEN: true,
    TRUE: true,
    TRUNCATE: true,

    UNION: true,
    UPDATE: true,
    USING: true,

    // 'VALUES': true,

    WITH: true,
    WHEN: true,
    WHERE: true,
    WINDOW: true,

    GLOBAL: true,
    SESSION: true,
    LOCAL: true,
    PERSIST: true,
    PERSIST_ONLY: true,
  };

  function createUnaryExpr(op, e) {
    return {
      type: 'unary_expr',
      operator: op,
      expr: e,
    };
  }

  function createBinaryExpr(op, left, right) {
    return {
      type: 'binary_expr',
      operator: op,
      left: left,
      right: right,
    };
  }

  function isBigInt(numberStr) {
    const previousMaxSafe = BigInt(Number.MAX_SAFE_INTEGER);
    const num = BigInt(numberStr);
    if (num < previousMaxSafe) return false;
    return true;
  }

  function createList(head, tail, po = 3) {
    const result = Array.isArray(head) ? head : [head];
    for (let i = 0; i < tail.length; i++) {
      delete tail[i][po].tableList;
      delete tail[i][po].columnList;
      result.push(tail[i][po]);
    }
    return result;
  }

  function createBinaryExprChain(head, tail) {
    let result = head;
    for (let i = 0; i < tail.length; i++) {
      result = createBinaryExpr(tail[i][1], result, tail[i][3]);
    }
    return result;
  }

  function queryTableAlias(tableName) {
    const alias = tableAlias[tableName];
    if (alias) return alias;
    if (tableName) return tableName;
    return null;
  }

  function columnListTableAlias(columnList) {
    const newColumnsList = new Set();
    const symbolChar = '::';
    for (let column of columnList.keys()) {
      const columnInfo = column.split(symbolChar);
      if (!columnInfo) {
        newColumnsList.add(column);
        break;
      }
      if (columnInfo && columnInfo[1]) columnInfo[1] = queryTableAlias(columnInfo[1]);
      newColumnsList.add(columnInfo.join(symbolChar));
    }
    return Array.from(newColumnsList);
  }

  function refreshColumnList(columnList) {
    const columns = columnListTableAlias(columnList);
    columnList.clear();
    columns.forEach((col) => columnList.add(col));
  }

  function commonStrToLiteral(strOrLiteral) {
    return typeof strOrLiteral === 'string' ? { type: 'same', value: strOrLiteral } : strOrLiteral;
  }

  const cmpPrefixMap = {
    '+': true,
    '-': true,
    '*': true,
    '/': true,
    '>': true,
    '<': true,
    '!': true,
    '=': true,

    //between
    B: true,
    b: true,
    //for is or in
    I: true,
    i: true,
    //for like
    L: true,
    l: true,
    //for not
    N: true,
    n: true,
  };

  // used for dependency analysis
  let varList = [];
  const tableList = new Set();
  const columnList = new Set();
  const tableAlias = {};

  peg$result = peg$startRuleFunction();

  if (peg$result !== peg$FAILED && peg$currPos === input.length) {
    return peg$result;
  } else {
    if (peg$result !== peg$FAILED && peg$currPos < input.length) {
      peg$fail(peg$endExpectation());
    }

    throw peg$buildStructuredError(
      peg$maxFailExpected,
      peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null,
      peg$maxFailPos < input.length
        ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
        : peg$computeLocation(peg$maxFailPos, peg$maxFailPos),
    );
  }
}

module.exports = {
  SyntaxError: peg$SyntaxError,
  parse: peg$parse,
};
