import React, { FC } from 'react';
import { ArrayItems } from '@tachybase/components';
import { useField, useFieldSchema } from '@tachybase/schema';

import _ from 'lodash';
import { useTranslation } from 'react-i18next';

import { useCollectionRecord, useDesignable } from '../../../';
import { useSchemaToolbar } from '../../../application';
import { SchemaSettings } from '../../../application/schema-settings/SchemaSettings';
import { useCollection_deprecated } from '../../../collection-manager';
import { ButtonEditor, RemoveButton } from '../../../schema-component/antd/action/Action.Designer';
import { SchemaSettingsLinkageRules, SchemaSettingsModalItem } from '../../../schema-settings';
import { useURLAndHTMLSchema } from './hooks';

export const SchemaSettingsActionLinkItem: FC = () => {
  const field = useField();
  const fieldSchema = useFieldSchema();
  const { dn } = useDesignable();
  const { t } = useTranslation();
  const { urlSchema, paramsSchema, openInNewWindowSchema } = useURLAndHTMLSchema();
  const componentProps = fieldSchema['x-component-props'] || {};
  const initialValues = {
    url: componentProps.url,
    params: componentProps.params || [{}],
    openInNewWindow: componentProps.openInNewWindow,
  };

  return (
    <SchemaSettingsModalItem
      title={t('Edit link')}
      components={{ ArrayItems }}
      schema={{
        type: 'object',
        title: t('Edit link'),
        properties: {
          url: {
            ...urlSchema,
            required: true,
          },
          params: paramsSchema,
          openInNewWindow: openInNewWindowSchema,
        },
      }}
      onSubmit={({ url, params, openInNewWindow }) => {
        componentProps.url = url;
        componentProps.params = params;
        componentProps.openInNewWindow = openInNewWindow;

        fieldSchema['x-component-props'] = componentProps;

        field.componentProps.url = url;
        field.componentProps.params = params;
        field.componentProps.openInNewWindow = openInNewWindow;

        dn.emit('patch', {
          schema: {
            ['x-uid']: fieldSchema['x-uid'],
            'x-component-props': componentProps,
          },
        });
        dn.refresh();
      }}
      initialValues={initialValues}
    />
  );
};

export const customizeLinkActionSettings = new SchemaSettings({
  name: 'actionSettings:link',
  items: [
    {
      name: 'editButton',
      Component: ButtonEditor,
      useComponentProps() {
        const { buttonEditorProps } = useSchemaToolbar();
        return buttonEditorProps;
      },
    },
    {
      name: 'editLink',
      Component: SchemaSettingsActionLinkItem,
    },
    {
      name: 'linkageRules',
      Component: SchemaSettingsLinkageRules,
      useVisible() {
        const record = useCollectionRecord();
        return !_.isEmpty(record?.data);
      },
      useComponentProps() {
        const { name } = useCollection_deprecated();
        const { linkageRulesProps } = useSchemaToolbar();
        return {
          ...linkageRulesProps,
          collectionName: name,
        };
      },
    },
    {
      name: 'remove',
      sort: 100,
      Component: RemoveButton as any,
      useComponentProps() {
        const { removeButtonProps } = useSchemaToolbar();
        return removeButtonProps;
      },
    },
  ],
});
