Configuration Options
---------------------

Ever wondered what configuration options you have available to you in
``config/packages/*.yaml`` files? In this section, all the available
configuration is broken down by the key (e.g. ``framework``) that defines
each possible section of your Symfony configuration.

* :doc:`framework </reference/configuration/framework>`
* :doc:`doctrine </reference/configuration/doctrine>`
* :doc:`security </reference/configuration/security>`
* :doc:`twig </reference/configuration/twig>`
* :doc:`monolog </reference/configuration/monolog>`
* :doc:`web_profiler </reference/configuration/web_profiler>`
* :doc:`debug </reference/configuration/debug>`

Forms and Validation
--------------------

* :doc:`Form Field Type Reference </reference/forms/types>`
* :doc:`Validation Constraints Reference </reference/constraints>`
* :ref:`Twig Template Function and Variable Reference <reference-form-twig-functions-variables>`

Format Specifications
---------------------

* :doc:`YAML </reference/formats/yaml>`
* :doc:`XLIFF </reference/formats/xliff>`
* :doc:`ICU MessageFormat </reference/formats/message_format>`
* :doc:`Expression Language </reference/formats/expression_language>`

Others
------

* :doc:`Configuring the Kernel </reference/configuration/kernel>`
* :doc:`Twig Extensions (forms, filters, tags, etc) Reference </reference/twig_reference>`
* :doc:`/reference/dic_tags`
* :doc:`Symfony Attributes Overview </reference/attributes>`
* :doc:`/reference/events`
