Basic Constraints
~~~~~~~~~~~~~~~~~

These are the basic constraints: use them to assert very basic things about
the value of properties or the return value of methods on your object.

.. class:: ui-list-two-columns

* :doc:`Blank </reference/constraints/Blank>`
* :doc:`IsFalse </reference/constraints/IsFalse>`
* :doc:`IsNull </reference/constraints/IsNull>`
* :doc:`IsTrue </reference/constraints/IsTrue>`
* :doc:`NotBlank </reference/constraints/NotBlank>`
* :doc:`NotNull </reference/constraints/NotNull>`
* :doc:`Type </reference/constraints/Type>`

String Constraints
~~~~~~~~~~~~~~~~~~

.. class:: ui-list-three-columns

* :doc:`Charset </reference/constraints/Charset>`
* :doc:`Cidr </reference/constraints/Cidr>`
* :doc:`CssColor </reference/constraints/CssColor>`
* :doc:`Email </reference/constraints/Email>`
* :doc:`ExpressionSyntax </reference/constraints/ExpressionSyntax>`
* :doc:`Hostname </reference/constraints/Hostname>`
* :doc:`Ip </reference/constraints/Ip>`
* :doc:`Json </reference/constraints/Json>`
* :doc:`Length </reference/constraints/Length>`
* :doc:`MacAddress </reference/constraints/MacAddress>`
* :doc:`NoSuspiciousCharacters </reference/constraints/NoSuspiciousCharacters>`
* :doc:`NotCompromisedPassword </reference/constraints/NotCompromisedPassword>`
* :doc:`PasswordStrength </reference/constraints/PasswordStrength>`
* :doc:`Regex </reference/constraints/Regex>`
* :doc:`Ulid </reference/constraints/Ulid>`
* :doc:`Url </reference/constraints/Url>`
* :doc:`UserPassword </reference/constraints/UserPassword>`
* :doc:`Uuid </reference/constraints/Uuid>`

Comparison Constraints
~~~~~~~~~~~~~~~~~~~~~~

.. class:: ui-list-three-columns

* :doc:`DivisibleBy </reference/constraints/DivisibleBy>`
* :doc:`EqualTo </reference/constraints/EqualTo>`
* :doc:`GreaterThan </reference/constraints/GreaterThan>`
* :doc:`GreaterThanOrEqual </reference/constraints/GreaterThanOrEqual>`
* :doc:`IdenticalTo </reference/constraints/IdenticalTo>`
* :doc:`LessThan </reference/constraints/LessThan>`
* :doc:`LessThanOrEqual </reference/constraints/LessThanOrEqual>`
* :doc:`NotEqualTo </reference/constraints/NotEqualTo>`
* :doc:`NotIdenticalTo </reference/constraints/NotIdenticalTo>`
* :doc:`Range </reference/constraints/Range>`
* :doc:`Unique </reference/constraints/Unique>`

Number Constraints
~~~~~~~~~~~~~~~~~~

* :doc:`Negative </reference/constraints/Negative>`
* :doc:`NegativeOrZero </reference/constraints/NegativeOrZero>`
* :doc:`Positive </reference/constraints/Positive>`
* :doc:`PositiveOrZero </reference/constraints/PositiveOrZero>`

Date Constraints
~~~~~~~~~~~~~~~~

* :doc:`Date </reference/constraints/Date>`
* :doc:`DateTime </reference/constraints/DateTime>`
* :doc:`Time </reference/constraints/Time>`
* :doc:`Timezone </reference/constraints/Timezone>`

Choice Constraints
~~~~~~~~~~~~~~~~~~

* :doc:`Choice </reference/constraints/Choice>`
* :doc:`Country </reference/constraints/Country>`
* :doc:`Language </reference/constraints/Language>`
* :doc:`Locale </reference/constraints/Locale>`

File Constraints
~~~~~~~~~~~~~~~~

* :doc:`File </reference/constraints/File>`
* :doc:`Image </reference/constraints/Image>`

Financial and other Number Constraints
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

.. class:: ui-list-two-columns

* :doc:`Bic </reference/constraints/Bic>`
* :doc:`CardScheme </reference/constraints/CardScheme>`
* :doc:`Currency </reference/constraints/Currency>`
* :doc:`Iban </reference/constraints/Iban>`
* :doc:`Isbn </reference/constraints/Isbn>`
* :doc:`Isin </reference/constraints/Isin>`
* :doc:`Issn </reference/constraints/Issn>`
* :doc:`Luhn </reference/constraints/Luhn>`

Doctrine Constraints
~~~~~~~~~~~~~~~~~~~~

* :doc:`DisableAutoMapping </reference/constraints/DisableAutoMapping>`
* :doc:`EnableAutoMapping </reference/constraints/EnableAutoMapping>`
* :doc:`UniqueEntity </reference/constraints/UniqueEntity>`

Other Constraints
~~~~~~~~~~~~~~~~~

.. class:: ui-list-three-columns

* :doc:`All </reference/constraints/All>`
* :doc:`AtLeastOneOf </reference/constraints/AtLeastOneOf>`
* :doc:`Callback </reference/constraints/Callback>`
* :doc:`Cascade </reference/constraints/Cascade>`
* :doc:`Collection </reference/constraints/Collection>`
* :doc:`Compound </reference/constraints/Compound>`
* :doc:`Count </reference/constraints/Count>`
* :doc:`Expression </reference/constraints/Expression>`
* :doc:`GroupSequence </validation/sequence_provider>`
* :doc:`Sequentially </reference/constraints/Sequentially>`
* :doc:`Traverse </reference/constraints/Traverse>`
* :doc:`Valid </reference/constraints/Valid>`
* :doc:`When </reference/constraints/When>`
