#!/usr/bin/env sh
case "$1" in
    ''|help|-h)
        echo "ansi-render.sh RECORDING [options]"
        echo ""
        echo "  RECORDING: path to the .cast file generated by asciinema"
        echo "  [options]: optional options to be passed to agg"
        ;;
    *)
        recording=$1
        extra_options=
        if [ $# -gt 1 ]; then
            shift
            extra_options=$@
        fi

        # optionally, use this green color:     1f4631
        ${AGG_PATH:-agg} \
            --theme 18202a,f9fafb,f9fafb,ff7b72,7ee787,ffa657,79c0ff,d2a8ff,a5d6ff,f9fafb,8b949e,ff7b72,00c300,ffa657,79c0ff,d2a8ff,a5d6ff,f9fafb --line-height 1.6 \
            --font-family 'JetBrains Mono' \
            $extra_options \
            $recording $(echo $recording | sed "s/cast/gif/")
        ;;
esac
